#include "chartdir.h"

int main(int argc, char *argv[])
{
	//The data for the area chart
	double data[] = {25, 18, 9, 4, 5, 8, 14, 20, 40, 92, 75, 88, 75, 
		58, 90, 95, 83, 75, 70, 66, 46, 38, 28, 15, 22};

	//The labels for the area chart
	const char *labels[] = {"0", "", "", "3", "", "", "6", "", "", "9", "", "", 
		"12", "", "", "15", "", "", "18", "", "", "21", "", "", "24"};
	
	//First, create a XYChart of size 250 pixels x 250 pixels
	XYChart *c = XYChart::create(250, 250);

	//Set the plotarea at (30, 20) and of 200 pixel (w) x 200 pixels (h)
	c->setPlotArea(30, 20, 200, 200);

	//Add an area chart layer using the supplied data
	c->addAreaLayer(sizeof(data) / sizeof(data[0]), data);

	//Set the x axis labels using the supplied labels
	c->xAxis()->setLabels(sizeof(labels) / sizeof(labels[0]), labels);

	//output the chart as a PNG file
	c->makeChart("simplearea.png");

	//destroy the chart to free up resources
	c->destroy();

	return 0;
}
