<?php
include("phpchartdir.php");

#The data for the combo chart
$data0 = array(25, 18, 9, 4, 5, 8, 14, 20, 40, 92, 75, 88, 75, 
	58, 90, 95, 83, 75, 70, 66, 46, 38, 28, 15, 22);
$data1 = array(36, 28, 25, 33, 38, 42, 44, 36, 50, 68, 60, 50, 55, 
	67, 58, 52, 57, 46, 33, 38, 25, 33, 42, 37, 30);
$data2 = array(88, 70, 43, 55, 35, 28, 17, 25, 30, 33, 36, 45, 28, 
	45, 60, 47, 25, 30, 41, 49, 67, 82, 88, 95, 98);

#The labels for the combo chart
$labels = array("0", "", "", "3", "", "", "6", "", "", "9", "", "", 
	"12", "", "", "15", "", "", "18", "", "", "21", "", "", "24");

#First, create a XYChart of size 500 pixels x 320 pixels
$c = new XYChart(500, 320);

#the plotarea rectangle to start at (100, 40) and of 
#280 pixels in width and 240 in height
$c->setPlotArea(100, 40, 280, 240);

#Add a legend box at (400, 100)
$c->addLegend(400, 100);

#Add a title to the chart
$c->addTitle("Daily Network Load");

#Add a multiline title to the y axis. draw the title upright by setting the 
#font angle 0 (the default is to draw the title sideways for y axis)
$textBox = $c->yAxis->setTitle("Average\nThroughput\n(MBytes\nPer Hour)");
$textBox->setFontAngle(0);

#the labels on the x axis
$c->xAxis->setLabels($labels);

#Add a flat line layer for the 1st data set, with a line width of 3 pixels
$lineLayer = $c->addLineLayer($data0, 0x4040ff, "Server #1");
$lineLayer->setLineWidth(3);

#Add a 3D bar layer for the 2st data set, with a depth of 5 pixels. Use a
#semi-Transparent color so that layers at the back can be seen
$c->addBarLayer($data1, 0x80ff0000, "Server #2", 5);

#Add a flat area layer for the 3rd data set
$c->addAreaLayer($data2, 0x80ff80, "Server #3");

#output the chart
header("Content-type: image/png");
print($c->makeChart2(PNG));
?>