<?php
include("phpchartdir.php");

#The data for the chart
$data = array(25, 18, 9, 4, 5, 8, 14, 20, 40, 92, 75, 88, 75, 
	58, 90, 95, 83, 75, 70, 66, 46, 38, 28, 15, 22);

#The labels for the bottom x axis. Note the "-" means a minor tick.
$label0 = array("0\nJun 4", "-", "-", "3", "-", "-", 
	"6", "-", "-", "9", "-", "-", "12", "-", "-", "15", "-", "-", 
	"18", "-", "-", "21", "-", "-", "0\nJun 5");

#The labels for the top x axis. Note that "-" means a minor tick.
$label1 = array("Jun 3\n12", "-", "-", "15", "-", "-", 
	"18", "-", "-", "21", "-", "-", "Jun 4\n0", "-", 
	"-", "3", "-", "-", "6", "-", "-", "9", "-", "-", "12");

#First, create a XYChart of size 300 pixels x 320 pixels
$c = new XYChart(320, 320);

#the plotarea at (60, 50) and of 200 pixel (w) x 200 pixels (h)
$c->setPlotArea(60, 50, 200, 200);

#Add a title to the primary (left) y-axis
$c->yAxis->setTitle("Server Load (%)");

#the tick length to -4 pixels (-ve means ticks inside the plot area)
$c->yAxis->setTickLength(-4);

#Add a title to the secondary (right) y-axis
$c->yAxis2->setTitle("Transactions per hour");

#the tick length to -4 pixels (-ve means ticks inside the plot area)
$c->yAxis2->setTickLength(-4);

#y2 = 300 x y1 (that means 1% load = 300 transactions per hour)
$c->syncYAxis(300);

#Add a title to the bottom x-axis
$c->xAxis->setTitle("Hong Kong Time");

#the x axis labels using the supplied labels
$c->xAxis->setLabels($label0);

#the major tick length to -4 pixels and minor tick length to -2 pixels
#(-ve means ticks inside the plot area)
$c->xAxis->setTickLength(-4, -2);

#Add a title to the top x-axis
$c->xAxis2->setTitle("New York Time");

#the x axis labels using the supplied labels
$c->xAxis2->setLabels($label1);

#the major tick length to -4 pixels and minor tick length to -2 pixels
#(-ve means ticks inside the plot area)
$c->xAxis2->setTickLength(-4, -2);

$c->xAxis2->setColors(0, 0);

#Add an line layer to the chart
$c->addLineLayer($data, 0x0000ff);

#output the chart
header("Content-type: image/png");
print($c->makeChart2(PNG));
?>