<?php
include("phpchartdir.php");

#data for the chart
$data0 = array(100, 125, 245.78, 147, 67);
$data1 = array(85, 156, 179.5, 211, 123);
$data2 = array(97, 87, 56, 267, 157);
$labels = array("Mon Jun 4", "Tue Jun 5", "Wed Jun 6", "Thu Jun 7", 
	"Fri Jun 8");

#First, create a XYChart of size 540 pixels x 350 pixels
$c = new XYChart(540, 350);

#the plot area to start at (120, 40) and of size 280(w) x 240(h)
$c->setPlotArea(120, 40, 280, 240);

#Add a title to the chart using 20 point Monotype Corsiva (mtcorsva.ttf)
#font and using a deep blue color (0x000080)
$c->addTitle("Weekly Server Load", "mtcorsva.ttf", 20, 0x000080);

#Add a legend box at (420, 100) using 12 point Times New Roman Bold 
#(timesbd.ttf) font. Sets the background of the legend box to light grey
#color (0xd0d0d0) and the border to blue color (0x0000ff)
$legendBox = $c->addLegend(420, 100, 1, "timesbd.ttf", 12);
$legendBox->setBackground(0xd0d0d0, 0x0000ff);
	
#Add a title to the y-axis using 12 point Arial Bold (arialbd.ttf)
#font and using a deep blue color (0x000080). Sets the background box
#of the title to yellow (0xffff00) and the border to black (0x0)
$textBox = $c->yAxis->setTitle("Throughput (per hour)", 
	"arialbd.ttf", 12, 0x000080);
$textBox->setBackground(0xffff00, 0);

#Use 10 point Impact (impact.ttf) font as the y-axis label font and
#deep blue (0x000080) as the font color
$c->yAxis->setLabelStyle("impact.ttf", 10, 0x000080);

#the axis label format to append "MBytes" to the numeric y value
$c->yAxis->setLabelFormat("&value& MBytes");

#Use 10 point Impact (impact.ttf) font as the x-axis label font and
#deep green (0x008000) as the font color. Sets the label angle to 45 deg.
$textBox = $c->xAxis->setLabelStyle("impact.ttf", 10, 0x008000);
$textBox->setFontAngle(45);

#the x axis labels using the supplied labels
$c->xAxis->setLabels($labels);

#Add a stack bar layer
$layer = $c->addBarLayer2(Stack, 5);

#Use Arial Italic (ariali.ttf) as the default data label font in the bar	
$layer->setDataLabelStyle("ariali.ttf");

#Use 10 point Times Bold Italic (timesbi.ttf) as the aggregate label font
$layer->setAggregateLabelStyle("timesbi.ttf", 10);

#Add the three data sets using the supplied data. For the last data set,
#set the data label font to Arial Bold (arialbd.ttf) with yellow color
#to override the default data label font.
$layer->addDataSet($data0, -1, "Server #1");
$layer->addDataSet($data1, -1, "Server #2");
$dataSet = $layer->addDataSet($data2, -1, "Server #3");
$textBox = $dataSet->setDataLabelStyle("arialbd.ttf");
$textBox->setFontColor(0xffff00);

#output the chart
header("Content-type: image/png");
print($c->makeChart2(PNG));
?>