#include <stdio.h>
#include <ctype.h>
#include <limits.h>

static long __xstrtol(const char *s, char **endptr, int radix, long max,long min)
{
   int sign = 0,any = 0;
   const char *old = s ;
   unsigned long val = 0;
   unsigned long imax ;
   int lim ;
   
	while (isspace(*s)) s++;

	if (*s == '-') {
		sign++;
		s++;
	}
	else if (*s == '+') 
		s++;
   if (*s == '0') {
      if (!radix) {
        radix = 8;
        s++;
        if (*s == 'x' || *s == 'X') {
           radix = 16;
           s++;
        }
      } else if (radix == 16 && (*(s+1) == 'x' || *(s+1) == 'X'))
         s+=2 ;

	}
   if (!radix)
      radix = 10 ;
   imax = sign ? min : max ;
   lim = (imax % radix) ;
   imax = imax / radix ;
	while(isalnum(*s)) {
      unsigned temp = toupper(*s++)- '0';
		if (temp >= 10)
			temp -= 7;
      if (temp >=radix || val > imax || val == imax && temp > lim) {
			s--;
			break;
		}
      any = 1 ;
		val*= radix;
		val += temp;
	}
	if (sign)
		val = -val;
   if (!any)
      s = old ;
	if (endptr)
		*endptr = s;
	return val;
}
long atol(const char *s)
{
   return __xstrtol(s,0,10,LONG_MAX,-LONG_MIN);
}
int atoi(const char *s)
{
   return (int)__xstrtol(s,0,10,INT_MAX,-INT_MIN);
}
long strtol(const char *s, char **endptr , int radix)
{
   return __xstrtol(s,endptr,radix,LONG_MAX,-LONG_MIN) ;
}
long strtoul(const char *s, char **endptr , int radix)
{
   return __xstrtol(s,endptr,radix,ULONG_MAX,ULONG_MAX) ;
}