#ifndef __NUMERIC_HPP
#define __NUMERIC_HPP

#include <math.h>

template <class T> int sign(const T& value) {
	return value == 0 ? 0 : (value < 0 ? -1 : 1);
}

template <int dec, class value_type> class round_to {
private:
	static bool clipper;

	long double p;

public:
	round_to() : p(::pow10l(dec + 1)) {}

	value_type __fastcall operator()(const value_type& value) {
		long double mv = (clipper) ? 0.0 : (value >= value_type(0.0)) ? 1e-10 : -1e-10;
		long double f = ::floorl((p * value + 5.0l) / 10.0l + mv);
		return value_type((f * 10.0l) / p);
	}

	static void AsClipper(bool mode) { clipper = mode; }
	static bool AsClipper(void) { return clipper; }    
};

typedef round_to<2, double> Round2;
extern Round2 Round;

class int32_image {
private:
	char image[5];
	int value;

	void initialize() {
		::memset(image, 0, sizeof(image));
		value = 0;
	}

public:
	int32_image(const char* _image);
	int32_image(int _value);

	operator int() const { return value; }
	operator char*() const { return (char*)image; }
};

char* get_value(double amnt, char* buffer, char delimiter = ',');

#endif // __NUMERIC_HPP
