/*************************************************************************
** interpcom-2.3   (command interpreter)                                 **
** interp.c : Commands interpreter ,functions related to the             **
**            Expression Evaluator and threads                           **
**                                                                       **
** Copyright (C) 2001  Jean-Marc Drezet                                  **
**                                                                       **
**  This library is free software; you can redistribute it and/or        **
**  modify it under the terms of the GNU Library General Public          **
**  License as published by the Free Software Foundation; either         **
**  version 2 of the License, or (at your option) any later version.     **
**                                                                       **
**  This library is distributed in the hope that it will be useful,      **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
**  Library General Public License for more details.                     **
**                                                                       **
**  You should have received a copy of the GNU Library General Public    **
**  License along with this library; if not, write to the Free           **
**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
**                                                                       **
** Please mail any bug reports/fixes/enhancements to me at:              **
**      drezet@math.jussieu.fr                                           **
** or                                                                    **
**      Jean-Marc Drezet                                                 **
**      Institut de Mathematiques                                        **
**      Aile 45-55                                                       **
**      2, place Jussieu                                                 **
**      75251 Paris Cedex 05                                             **
**      France                                                           **
**                                                                       **
 *************************************************************************/

#include "interp.h"
#ifdef __WITH_LIBTECLA
#include <libtecla.h>
static char        *line_read = (char *)NULL;
#else
#ifdef __WITH_READLINE
#include <readline/history.h>
#include <readline/readline.h>

/* A static variable for holding the line. */
static char        *line_read = (char *)NULL;

/* Read a string, and return a pointer to it.  Returns NULL on EOF. */
/* Taken from the readline manual, with modifications               */
char *
rl_gets(char *pt)
{
  /* If the buffer has already been allocated, return the memory
     to the free pool. pt is the prompt                             */
    if (line_read)
        {
            free(line_read);
            line_read = (char *)NULL;
        }

  /* Get a line from the user. */
    line_read = readline(pt);

  /* If the line has any text in it, save it on the history.        */
    if (line_read && *line_read)
        add_history(line_read);

    return(line_read);
}
#endif
#endif

/*---------------------------------------
 Structure used in functions
 thread_interp_create and thread_exec.
 The first one is the command that creates
 a thread, and the second is the function
 associated to the thread. A pointer to
 such a structure is the argument of
 thread_exec.
---------------------------------------*/
typedef struct _THREAD_PAR {
    flow_data      *thr_i;
    int             argc_l;
    char          **argv_l;
    FILE           *s;
    int             mode_fonc;
} thread_par;
/*-------------------------------------*/

char *version = "interpcom-2.3     (2001)";

#define isnum(c)  (c >= '0' && c <= '9')

extern   char      *esp_decalage;


        

/*--------------------------------------------------------------------
    Initialization of the command interpreter
    (see the documentation , chapt. 13, for a description of
    the arguments)
--------------------------------------------------------------------*/
void
prog_c(int argc, char *argv[], char *int_ini, char int_ini_c[], int nb_ini,
char *pr, int cas)
{
    int             i;
    char            h_init[1000];
    FILE           *s;
    flow_data      *flow_interp;

/*--------------------------------------------------------------------
    Initializations
--------------------------------------------------------------------*/
#ifdef _HAVE_THREADS
    /* Definition of mutexes if the library is built
       with thread support */
    pthread_mutex_init(&mutex_ev, NULL);
    pthread_mutex_init(&mutex_obj, NULL);
    pthread_mutex_init(&mutex_thread, NULL);
    pthread_mutex_init(&mutex_string, NULL);
    pthread_mutex_init(&mutex_cond, NULL);
    pthread_mutex_init(&mutex_file, NULL);
    pthread_mutex_init(&mutex_quest, NULL);
#endif
#ifdef __WITH_READLINE
    using_history();
#endif

/* flow_interp is here the flow_data structure associated to
   the main thread */
    flow_interp = (flow_data *) malloc((size_t) sizeof(flow_data));
    init_VARS(VArs_global);
    init_VARS_C(VArs_global_C);
    init_flow_param(flow_interp);
    nb_com = 0;        /* Number of programs             */
    nb_typ = 0;        /* Number of object types         */
    nb_struc = 0;      /* Number of structure types      */
    __nbtypmax = 0;    /* Maximal number of object types */
    nb_mode_fonc = -1; /* Number of running modes        */
    ind_greet_x = 0;
    nb_commandes = -1;
    i_message = -1;
    i_func_ind = -1;
    __nbargmax = 10;
    flow_interp->IND_COM = 0;
    i_init_interp = 0;
    i_greet = -1;
    ind_x_mode = 0;
    ind_x_func = 0;
    ind_x_param = 0;
    ind_x_rep = 0;
    ind_run = 0;
    func_init = 0;
    Init_File_Line = 0;
    argc_init_interp = 0;
    s = NULL;
    NB_expr_eval = 2;

    if (User_Init_File != NULL && int_ini == NULL) {
        memset(h_init, 0, 1000);
        sprintf(h_init, "%s/%s", getenv("HOME"), User_Init_File);
        s = fopen(h_init, "r");
        if (s != NULL) {
            int_ini = h_init;
            fclose(s);
            s = NULL;
        }
        else {
            s = fopen(h_init, "w");
        }
    }

    charge_com(int_ini, int_ini_c, nb_ini, 0, flow_interp, s, 0);
                                 /* Reading the initialization file */

    default_Subst_Pat();  /* definition of the default substitution
                             patterns */
    init_expr_GEN(flow_interp);
    init_expr_eval(&VArs_global_Gen, MAXXVARS);
    init_flow_param_b(flow_interp);
    flow_interp->name = ch_copy("main");
    func_init = 1;
    flow_interp->I_SPEED = 0;
    flow_interp->_I_TIME_X = 0;
    if (ind_x_mode == 0 || ind_x_param == 0 || ind_x_rep == 0)
        exit_interp(NULL);
    flow_interp->IND_COM = 1;
    flow_interp->I__COM_CUR = -1;
    flow_interp->PR_COM = 0;
    flow_interp->MODE_FONCT_ = 0;
    flow_interp->IX_COM = 0;
    flow_interp->HORLOGE = 0;
    flow_interp->parse_com = 0;
    flow_interp->MON_FILE = NULL;
    flow_I[0] = *flow_interp;
    flow_I[0].num = 0;
    free(flow_interp);
    flow_interp = &flow_I[0];

    traite_label(flow_interp);   /* treatment of 'goto', 'if', 'do' in the
                                    programs of the initialization file */

    flow_interp->CURVOICE = 0;          /* voice 0 = stdin */
    flow_interp->INP[0] = stdin;
    flow_interp->PRLEVEL = 0;
    flow_interp->I_COM = -1;
    num_thread_run = 0;
    if (argc > 1) {
        flow_interp->INP[0] = fopen(argv[1], "r");
        if (flow_interp->INP[0] == NULL)
            exit(0);
        flow_interp->PRLEVEL = 1;
        ind_run = 1;
    }
    if (cas == 1) {
        if (pr != NULL)
            flow_interp->INP[0] = fmemopen_((void *) pr, strlen(pr), "r", NULL);
        if (flow_interp->INP[0] == NULL)
            return;
        flow_interp->PRLEVEL = 1;
        ind_run = 1;
    }

    flow_interp->IS_COM = 0;

    init_prog(flow_interp);     /* initializations of the program
                                   (function supplied by the user) */

    if (flow_interp->PRLEVEL <= 0) {
        printf("\n");
        printf("%s\n", version);
    }
    if (i_init_interp != 0 && argc_init_interp > 0) {
        if (sil_init_interp == 0)
            flow_interp->PRLEVEL++;
        shell_c(argc_init_interp, argv_init_interp, flow_interp);
        if (sil_init_interp == 0)
            flow_interp->PRLEVEL--;
    }
/*------------------------------------------------------------------*/


/*----------------------------------------------
    Printing the greeting message
----------------------------------------------*/
    if (i_init_interp == 0 && cas == 0) {
        for (i = 0; i < i_greet; i++)
             if (flow_interp->PRLEVEL <= 0)
                 printf("%s\n", greet[i]);
    }

/*----------------------------------------------
   The function that reads the instructions is executed
----------------------------------------------*/
    if (cas == 0 || pr != NULL)
        lect_com(flow_interp);  /* loop reading the instructions */
    if (argc > 1 && pr == NULL) {
        flow_interp->INP[0] = stdin;
        flow_interp->PRLEVEL = 0;
        ind_run = 0;
        lect_com(flow_interp);
    }

}
/*------------------------------------------------------------------*/





/*--------------------------------------------------------------------
    Loop reading the instructions
    The argument is the thread from which the function is
    called (only the main one for this function)
    This function is only called by prog_c
--------------------------------------------------------------------*/
void
lect_com(flow_data *flow_interp)
{
    int             i,
                    j;
    char           *c;
#ifdef __WITH_READLINE
    int             jj;
#else
#ifdef __WITH_LIBTECLA
    GetLine        *gl;
    
    gl = new_GetLine(1024, 2048);
#else
    if (flow_interp->PRLEVEL <= 0)
        print(flow_interp, "%s", prompt_mode[flow_interp->MODE_FONCT_]);
                /* Printing the  prompt,
                   flow_interp->MODE_FONCT_ = number of
                   the current running mode */
#endif
#endif
/*-----------------------------------------------------------------
    The command line is read in voice 'flow_interp->CURVOICE', voice 0 is stdin
    and the others are the command files successively called
-----------------------------------------------------------------*/
#ifdef __WITH_LIBTECLA
xxx:  while (1)  {
        if (flow_interp->CURVOICE > 0 || ind_run == 1) {
            if (fgets(flow_interp->_H_LIGNE, 299,
                 flow_interp->INP[flow_interp->CURVOICE]) == NULL)
                     break;
        }
        else {
            line_read = gl_get_line(gl, prompt_mode[flow_interp->MODE_FONCT_],
                NULL, -1);  
            memcpy(flow_interp->_H_LIGNE, line_read, strlen(line_read));
        }
#else
#ifdef __WITH_READLINE
xxx:  while (1)  {
        if (flow_interp->CURVOICE > 0 || ind_run == 1) {
            if (fgets(flow_interp->_H_LIGNE, 299,
                 flow_interp->INP[flow_interp->CURVOICE]) == NULL)
                     break;
        }
        else {
            line_read = rl_gets(prompt_mode[flow_interp->MODE_FONCT_]);
            jj = strlen(line_read);
            memcpy(flow_interp->_H_LIGNE, line_read, jj);
            flow_interp->_H_LIGNE[jj] = '\n';
        }
#else
xxx:  while (fgets(flow_interp->_H_LIGNE, 299,
                 flow_interp->INP[flow_interp->CURVOICE]) != NULL) {
#endif
#endif
        flow_interp->n_instr++;
        if (flow_interp->CURVOICE == 0 && flow_interp->MON_FILE != NULL)
            fprintf(flow_interp->MON_FILE, "%s", flow_interp->_H_LIGNE);

/*---------------------------------------------------------*/
        if (flow_interp->_H_LIGNE[0] == '!') {    /* Detection of a call for
                                                     preceeding command  */
            c = flow_interp->_H_LIGNE + 1;
            nettoie(c);
            i = convert_int(c, flow_interp) + 1;
            if (i >= 0 && i <= flow_interp->IX_COM && i > flow_interp->IX_COM -
                __n_com_prec) {
                i = flow_interp->I_COM - flow_interp->IX_COM + i;
                if (i < 0)
                    i += abs(i) * __n_com_prec;
                i = i - (i / __n_com_prec) *
                    __n_com_prec;
                memset(flow_interp->_H_LIGNE, 0, 300);
                for (j = 0; j < (int) strlen(flow_interp->COM_PREC[i]); j++)
                    flow_interp->_H_LIGNE[j] = flow_interp->COM_PREC[i][j];
                flow_interp->_H_LIGNE[strlen(flow_interp->COM_PREC[i])] = '\n';
                if (flow_interp->PRLEVEL <= 0) {
                    print(flow_interp, "%s", flow_interp->_H_LIGNE);
                }
            }
        }
/*---------------------------------------------------------*/

        extrait_arg(flow_interp);             /* Extraction of the arguments
                                                 of the command line */
        if (flow_interp->CURVOICE == 0)
            flow_interp->IX_COM++;
        if (flow_interp->_ARGV_C[0] == NULL) {
            if (flow_interp->PRLEVEL <= 0 && flow_interp->CURVOICE == 0) {
                if (flow_interp->PR_COM == 0)
                    print(flow_interp, "%s",
                        prompt_mode[flow_interp->MODE_FONCT_]);
                else
                    print(flow_interp, "%d %s", flow_interp->IX_COM,
                        prompt_mode[flow_interp->MODE_FONCT_]);
            }
            continue;
        }

        flow_interp->I_COM++;     /* The command is saved because
                                     it can be recalled later */
        if (flow_interp->I_COM == __n_com_prec)
            flow_interp->I_COM = 0;
        if (flow_interp->COM_PREC[flow_interp->I_COM] != NULL)
            free(flow_interp->COM_PREC[flow_interp->I_COM]);
        flow_interp->COM_PREC[flow_interp->I_COM] =
            ch_copy(flow_interp->_H_LIGNE);

        /* One detects here if the subsequent commands will be
           sent directly to the expression evaluator
           (instruction '[' ) */
        if (flow_interp->_ARGV_C[0][0] == '[') {
            flow_interp->I_SPEED = 1;
            flow_interp->_ARGC_C = 0;
            if (strlen(flow_interp->_ARGV_C[0]) > 1) {
                if (flow_interp->_ARGV_C[0][1] == '0')
                    flow_interp->parse_com = 1;
                if (flow_interp->_ARGV_C[0][1] == '1')
                    flow_interp->parse_com = 1;
            }
        }


        /* One detects here if the subsequent commands will no
           longer be sent directly to the expression evaluator
           (instruction ']' ) */
        if (flow_interp->_ARGV_C[0][0] == ']') {
            flow_interp->I_SPEED = 0;
            flow_interp->_ARGC_C = 0;
            flow_interp->parse_com = 0;
        }

        if (flow_interp->_ARGC_C > 0) {
            if (flow_interp->_ARGV_C[0][0] != ';') {     /* Detection of
                                                            comments */

                substit(flow_interp);         /* substitution of #1,.. and
                                                 other patterns in the
                                                 arguments      */

                                   /* The command line is printed if it
                                      comes from a command file */
                if (flow_interp->CURVOICE > 0 && flow_interp->PRLEVEL <= 0) {
                    for (i = 0; i < flow_interp->_ARGC_C; i++) {
                        print(flow_interp, "%s ", flow_interp->_ARGV_C[i]);
                    }

                    print(flow_interp, "\n");
                }

                substit2(flow_interp); /* substitution of { (cf. doc 4.2) */

                if (change_lev(flow_interp) == 0) /* detection and execution
                                                     of a change of voice  */

                        shell_c(flow_interp->_ARGC_C, flow_interp->_ARGV_C,
                            flow_interp);
                                 /* execution of the command  */

#ifndef __WITH_LIBTECLA
#ifndef __WITH_READLINE
                if (flow_interp->PRLEVEL <= 0) {
                    if (flow_interp->PR_COM == 0)
                        print(flow_interp, "%s",
                            prompt_mode[flow_interp->MODE_FONCT_]);
                    else
                        print(flow_interp, "%d %s", flow_interp->IX_COM,
                            prompt_mode[flow_interp->MODE_FONCT_]);
                }
#endif
#endif
                memset(flow_interp->_H_LIGNE, 0, 300);
            }
#ifndef __WITH_LIBTECLA
#ifndef __WITH_READLINE
            else
                if (flow_interp->PRLEVEL <= 0 && flow_interp->CURVOICE == 0) {
                    if (flow_interp->PR_COM == 0)
                        print(flow_interp, "%s",
                            prompt_mode[flow_interp->MODE_FONCT_]);
                    else
                        print(flow_interp, "%d %s", flow_interp->IX_COM,
                            prompt_mode[flow_interp->MODE_FONCT_]);
                }
#endif
#endif
        }
        else
            if (flow_interp->PRLEVEL <= 0 && flow_interp->CURVOICE == 0) {
#ifndef __WITH_LIBTECLA
#ifndef __WITH_READLINE
                if (flow_interp->PR_COM == 0)
                    print(flow_interp, "%s",
                        prompt_mode[flow_interp->MODE_FONCT_]);
                else
                    print(flow_interp, "%d %s", flow_interp->IX_COM,
                        prompt_mode[flow_interp->MODE_FONCT_]);
#endif
#endif
            }
    }

/*--------------------------------------
    Detection of the end of a
    command file
--------------------------------------*/
    if (flow_interp->CURVOICE > 0) {
        fclose(flow_interp->INP[flow_interp->CURVOICE]);
        flow_interp->CURVOICE--;
        goto xxx;
    }
}
/*------------------------------------------------------------------*/





/*--------------------------------------------------------------------
    Extraction of the arguments of the command line 'flow_interp->_H_LIGNE'.
    The number of arguments is placed in 'argc' and the arguments
    in 'flow_interp->_ARGV_C'
    Function called by lect_com (the function that reads the instructions
    interactively) and Run_interp (to use the interpreter in a
    non-interactive way)
--------------------------------------------------------------------*/
void
extrait_arg(flow_data *flow_interp)
{
    int             i,
                    ind,
                    j,
                    argn;
    char            argtemp[300];

    nettoie(flow_interp->_H_LIGNE);
    argn = -1;
    i = 0;
    ind = 0;
    j = 0;
    flow_interp->_ARGV_C[-1] = (char *) flow_interp;

    while (flow_interp->_H_LIGNE[i] != 0) {
        if (isspace(flow_interp->_H_LIGNE[i]) == 0) {
            ind = 1;
            argn++;
            j = 0;
            argtemp[j] = flow_interp->_H_LIGNE[i++];

            while (isspace(flow_interp->_H_LIGNE[i]) == 0 &&
                flow_interp->_H_LIGNE[i] != 0) {
                argtemp[++j] = flow_interp->_H_LIGNE[i++];
            }
        }
        i++;
        if (ind == 1) {
            if (flow_interp->_ARGV_C[argn] != NULL)
                free(flow_interp->_ARGV_C[argn]);
            flow_interp->_ARGV_C[argn] = (char *) malloc((size_t) (j + 2) *
                sizeof(char));
            memcpy(flow_interp->_ARGV_C[argn], argtemp, j + 1);
            flow_interp->_ARGV_C[argn][j + 1] = 0;
            memset(argtemp, 0, 300);
        }
        ind = 0;
    }

    flow_interp->_ARGC_C = argn + 1;
}
/*------------------------------------------------------------------*/





/*--------------------------------------------------------------------
    Detection and execution of a change of voice. A 'voice' can
    be stdin or command files (not programs).
--------------------------------------------------------------------*/
int
change_lev(flow_data *flow_interp)
{
    int             i,
                    j;
    char            h[300];

    if (flow_interp->_ARGV_C[0] != NULL) {
        if (flow_interp->_ARGV_C[0][0] == '<') {   /* If the first character
                                                      is '<' a new command file
                                                      is opened */
            if (flow_interp->CURVOICE == __maxvoice - 1)
                return 0;
            flow_interp->CURVOICE++;

/*------------------------------------- Determination of the name of
                                        the command file and opening */
            j = 0;
            while (command_rep[j] != 0) {
                h[j] = command_rep[j];
                j++;
            }
            i = 1;
            while (flow_interp->_ARGV_C[0][i] != 0) {
                h[j++] = flow_interp->_ARGV_C[0][i++];
            }
            for (i = j; i < 300; i++)
                h[i] = 0;
            flow_interp->INP[flow_interp->CURVOICE] = fopen(h, "r");
            if (flow_interp->INP[flow_interp->CURVOICE] == NULL) {
                err_mess(20);
                flow_interp->ARGC_X[--flow_interp->CURVOICE] = 0;
                return 2;
            }
/*----------------------------------------------------------------*/


/*------------------------------------- The other arguments are kept to
                                        be used as arguments for the
                                        command file */
            for (i = 1; i < flow_interp->ARGC_X[flow_interp->CURVOICE - 1];
                i++) {
                free(flow_interp->ARGV_X[flow_interp->CURVOICE - 1][i]);
                flow_interp->ARGV_X[flow_interp->CURVOICE - 1][i] = NULL;
            }

            flow_interp->ARGC_X[flow_interp->CURVOICE - 1] =
                flow_interp->_ARGC_C;

            for (i = 1; i < flow_interp->_ARGC_C; i++) {
                flow_interp->ARGV_X[flow_interp->CURVOICE - 1][i] =
                    (char *) malloc((size_t) strlen(flow_interp->_ARGV_C[i]));
                strcpy(flow_interp->ARGV_X[flow_interp->CURVOICE - 1][i],
                    flow_interp->_ARGV_C[i]);
            }
        }
        else
            return 0;
    }
    return 1;
}
/*------------------------------------------------------------------*/





/*--------------------------------------------------------------------
    Default substitution patterns
    Called by prog_c when the command interpreter begins
--------------------------------------------------------------------*/
void
default_Subst_Pat(void)
{
    n_subst_pat = 5;

/*-----------------------------------
    Delimiters
-----------------------------------*/
    Subst_Delim[0].begin = '(';
    Subst_Delim[0].end = ')';
    Subst_Delim[1].begin = '[';
    Subst_Delim[1].end = ']';

/*-----------------------------------
    Patterns
-----------------------------------*/
    Subst_Pat[0].orig = '#';
    Subst_Pat[0].delim = Subst_Delim[0];
    Subst_Pat[0].F = Subst_Pat_act0;
    Subst_Pat[1].orig = '%';
    Subst_Pat[1].delim = Subst_Delim[0];
    Subst_Pat[1].F = Subst_Pat_act1;
    Subst_Pat[2].orig = '!';
    Subst_Pat[2].delim = Subst_Delim[0];
    Subst_Pat[2].F = Subst_Pat_act2;
    Subst_Pat[3].orig = '$';
    Subst_Pat[3].delim = Subst_Delim[0];
    Subst_Pat[3].F = Subst_Pat_act3;
    Subst_Pat[4].orig = '$';
    Subst_Pat[4].delim = Subst_Delim[1];
    Subst_Pat[4].F = Subst_Pat_act4;
}
/*------------------------------------------------------------------*/





/*--------------------------------------------------------------------
    First substitution pattern :    #(...)
--------------------------------------------------------------------*/
void
Subst_Pat_act0(char *inxx, char **outxx, flow_data *flow_interp)
{
    int             i,
                   *n;

    outxx[0] = NULL;
    i = convert_int(inxx, flow_interp);
    if (flow_interp->CURVOICE != 0 || flow_interp->IS_COM == 1) {
        if (flow_interp->IS_COM == 0) {
            if (i >= 0 && i < flow_interp->ARGC_X[flow_interp->CURVOICE - 1])
                outxx[0] = ch_copy(flow_interp->ARGV_X
                    [flow_interp->CURVOICE - 1][i]);
        }
        else {
            n = (int *) flow_interp->h[1];
            if (i > 0 && i < *n) {
                outxx[0] = ch_copy(flow_interp->h[i + 2]);
            }
        }
    }
}
/*------------------------------------------------------------------*/





/*--------------------------------------------------------------------
    Second substitution pattern :    %(...)
--------------------------------------------------------------------*/
void
Subst_Pat_act1(char *inxx, char **outxx, flow_data *flow_interp)
{
    outxx[0] = ch_copy_float(convert_float(inxx, flow_interp));
}
/*------------------------------------------------------------------*/





/*--------------------------------------------------------------------
    Third substitution pattern :    !(...)
--------------------------------------------------------------------*/
void
Subst_Pat_act2(char *inxx, char **outxx, flow_data *flow_interp)
{
    outxx[0] = ch_copy_int(convert_int(inxx, flow_interp));
}
/*------------------------------------------------------------------*/





/*--------------------------------------------------------------------
    Fourth substitution pattern :    $(...)
--------------------------------------------------------------------*/
void
Subst_Pat_act3(char *inxx, char **outxx, flow_data *flow_interp)
{
    int             i;

    outxx[0] = NULL;
    i = convert_int(inxx, flow_interp);
#ifdef _HAVE_THREADS
    pthread_mutex_lock(&mutex_quest);
#endif
    if (i >= 0 && i <= __max_quest)
        outxx[0] = ch_copy(ques[i]);
#ifdef _HAVE_THREADS
    pthread_mutex_unlock(&mutex_quest);
#endif
}
/*------------------------------------------------------------------*/





/*--------------------------------------------------------------------
    Fifth substitution pattern :    $[...]
--------------------------------------------------------------------*/
void
Subst_Pat_act4(char *inxx, char **outxx, flow_data *flow_interp)
{
    int             i;
    char           *h;

    outxx[0] = NULL;
    if (comp(inxx, "RESDIR") == 1) {
        outxx[0] = ch_copy(result_rep);
        return;
    }
    if (comp(inxx, "COMDIR") == 1) {
        outxx[0] = ch_copy(command_rep);
        return;
    }
    if (comp(inxx, "DATADIR") == 1) {
        outxx[0] = ch_copy(data_rep);
        return;
    }
    if (comp(inxx, "DATA2DIR") == 1) {
        outxx[0] = ch_copy(data_rep2);
        return;
    }
    if (comp(inxx, "THREAD") == 1) {
        outxx[0] = ch_copy(flow_interp->name);
        return;
    }
    if (comp(inxx, "PWD") == 1) {
        h = getcwd(NULL, 0);
        if (h != NULL) {
            outxx[0] = ch_copy(h);
            free(h);
        }
        else
            outxx[0] = NULL;
        return;
    }

#ifdef _HAVE_THREADS
    pthread_mutex_lock(&mutex_string);
#endif
    for (i = 0; i < __max_Env_st; i++) {
        if (Env_string[i] != NULL)
            if (comp(inxx, Env_string[i]) == 1) {
                break;
            }
     }

     if (i < __max_Env_st)
     outxx[0] = ch_copy(Env_string2[i]);
#ifdef _HAVE_THREADS
    pthread_mutex_unlock(&mutex_string);
#endif
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Substitutions in arguments
    Function called by lect_com (the function that reads the instructions
    interactively) and Run_interp (to use the interpreter in a
    non-interactive way)
--------------------------------------------------------------------*/
void
substit(flow_data *flow_interp)
{
    int             i,
                    k;
    char           *h;

    h = NULL;

    for (i = 1; i < flow_interp->_ARGC_C; i++) {
        substit_argc_c2(flow_interp->_ARGV_C[i], &h, flow_interp, &k);
        free(flow_interp->_ARGV_C[i]);
        flow_interp->_ARGV_C[i] = (char *) malloc((size_t) (k + 2) * sizeof(char));
        strcpy(flow_interp->_ARGV_C[i], h);
        flow_interp->_ARGV_C[i][k + 1] = 0;
        free(h);
    }
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function making substitutions in W (result in h[0])
    Called by substit
--------------------------------------------------------------------*/
void
substit_argc_c2(char *W, char **h, flow_data *flow_interp, int *kk)
{
    int             i,
                    k,
                    j,
                    k0,
                    k1,
                    l,
                   *n,
                    indw,
                    len,
                    n_com,
                    xlen,
                    ipar;
    char            h1[200],
                   *hc,
                   *hd;

    k = -1;
    k0 = 0;
    j = 0;
    h[0] = (char *) calloc(sizeof(char), 200);
    xlen = 200;
    hc = NULL;
    hd = NULL;
    len = strlen(W);

    while(j < len - 1) {
        indw = -1;

        for (i = 0; i < n_subst_pat; i++) {
            if (W[j] == Subst_Pat[i].orig && W[j + 1] ==
                Subst_Pat[i].delim.begin) {
                indw = i;
                break;
            }
        }

        if (indw == -1) {
            if (W[j] == '#' && (flow_interp->CURVOICE != 0 ||
                flow_interp->IS_COM == 1)) {
                j++;
                l = -1;
                memset(h1, 0, 200);
                while (isnum(W[j]) && l < 199) {
                    h1[++l] = W[j++];
                }
                if (l >= 0) {
                    n_com = convert_int(h1, flow_interp);

                    if (flow_interp->IS_COM == 0) {
                        if (n_com > 0 && n_com <=
                            (flow_interp->ARGC_X
                                [flow_interp->CURVOICE - 1] - 1)) {
                            k1 = k;
                            k += strlen(flow_interp->ARGV_X
                                [flow_interp->CURVOICE - 1][n_com]);
                            if (k > xlen) {
                                xlen = k + 200;
                                h[0] = (char *) realloc(h[0], xlen);
                                for (i = k1; i < xlen; i++)
                                    h[0][i] = 0;
                            }
                            strcat(h[0],
                                flow_interp->ARGV_X[flow_interp->CURVOICE - 1]
                                    [n_com]);
                        }
                    }
                    else {
                        n = (int *) h[1];
                        if (n_com > 0 && n_com < *n) {
                            k1 = k;
                            k += strlen(h[n_com + 2]);
                            if (k > xlen) {
                                xlen = k + 200;
                                h[0] = (char *) realloc(h[0], xlen);
                                for (i = k1; i < xlen; i++)
                                    h[0][i] = 0;
                            }
                        strcat(h[0], h[n_com + 2]);
                        }
                    }
                }
            }
            else
              h[0][++k] = W[j++];
        }
        else {
            j += 2;
            l = -1;
            memset(h1, 0, 200);
            ipar = 0;

            while ((j < len && W[j] != Subst_Pat[indw].delim.end && l < 199) ||
                ipar > 0) {
                h1[++l] = W[j++];
                if (W[j] == Subst_Pat[indw].delim.begin)
                    ipar++;
                if (W[j - 1] == Subst_Pat[indw].delim.end)
                    ipar--;
            }

            hc = h[0];
            h[0] = NULL;
            substit_argc_c2(h1, h, flow_interp, &k0);
            flow_interp->h = h;
            Subst_Pat[indw].F(h[0], &hd, flow_interp);
            free(h[0]);
            h[0] = hc;
            if (hd != NULL) {
                k1 = k;
                k += strlen(hd);
                if (k > xlen) {
                    xlen = k + 200;
                    h[0] = (char *) realloc(h[0], xlen);
                    for (i = k1; i < xlen; i++)
                        h[0][i] = 0;
                }
                if (hd != NULL) {
                    strcat(h[0], hd);
                    free(hd);
                }
            }
            j++;
        }
    }

    if (j < len) {
        k++;
        if (k + 1 > xlen)
            h[0] = (char *) realloc(h[0], k + 2);
        h[0][k] = W[len - 1];
        h[0][k + 1] = 0;
    }
    *kk = k;
}
/*------------------------------------------------------------------*/





/*--------------------------------------------------------------------
    Substitution of '{'
    Called by lect_com and Run_interp
--------------------------------------------------------------------*/
void
substit2(flow_data *flow_interp)
{
    int             i,
                    j;

    for (i = 1; i < flow_interp->_ARGC_C; i++) {
        j = 0;

        while (flow_interp->_ARGV_C[i][j] != 0) {
            if (flow_interp->_ARGV_C[i][j] == '{')
                flow_interp->_ARGV_C[i][j] = '#';
            j++;
        }
    }
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Execution of a command. The number of arguments is 'argc', the
    arguments is in 'argv'
--------------------------------------------------------------------*/
void
shell_c(int argc, char *argv[], flow_data *flow_interp)
{
    int             i,
                    j,
                    l,
                    k,
                    o,
                    i_comb,
                    i_cond,
                    Er,
                    dum;
    double          x;
    dcomplex        z;
    char            hc[300],
                   *pr_gen;
    void           *res_Gen;
    Misc_Func      *Mi;

    while (flow_interp->pause > 0) {
        if (flow_interp->pause == 2) {
            if (convert_int(flow_interp->var, flow_interp) > 0)
                flow_interp->pause = 0;
        }
    }
    Mi = (Misc_Func *) flow_interp->extra[0];
    if (flow_interp->PRLEVEL <= 0)
        time(&flow_interp->I_TIME_X);
    if (flow_interp->I_SPEED == 0 && argv[0][0] != '%') {
        i = lookup_c(names, argv[0]);
                           /* i contains the number of the command
                              if it exists, -1 otherwise */

/*----------------------------------------
    Conditions
----------------------------------------*/
        i_cond = -1;
#ifdef _HAVE_THREADS
        pthread_mutex_lock(&mutex_cond);
#endif
        if (n_cond >= 0) {
            for (j = 0; j <= n_cond; j++) {
                if (s_cond[j] == 1 && convert_float(v_cond[j], flow_interp)
                    <= 0)
                    i_cond = 0;
                if (s_cond[j] == -1 && convert_float(v_cond[j], flow_interp)
                    > 0)
                    i_cond = 0;
            }
        }
#ifdef _HAVE_THREADS
        pthread_mutex_unlock(&mutex_cond);
#endif
/*--------------------------------------*/


        if (i_cond < 0 || comp("is", argv[0]) == 1) {

/*-----------------------
     Execution of the command
-----------------------*/
            if (i >= 0) {
                if (mode_com[i][flow_interp->MODE_FONCT_] == 1) {
                    if (test_param(argc, i) == 1)
                        (*(procw[i])) (argc, argv);  /* execution */
                    else
                        err_mess(0);
                }
                else
                    err_mess(25);
            }
/*--------------------*/


            else {
/*----------------------
    Detection and execution of programs
----------------------*/
                i = lookup_b(argv[0], flow_interp);
                if (i >= 0) {
                     i_comb = flow_interp->I__COM_CUR;
                     execute(i, argc, argv, flow_interp);
                     flow_interp->I__COM_CUR = i_comb;
                }
/*--------------------*/


                else {
/*----------------------
    The instructions that are not commands
    or programs are sent to the expression
    evaluator
----------------------*/
                    j = 0;
                    o = 0;
                    while (j < argc && o < 298) {
                        l = strlen(argv[j]);
                        k = 0;
                        while (k < l) {
                            flow_interp->CMDX[o++] = argv[j][k++];
                        }
                        j++;
                    }
                    flow_interp->CMDX[o] = 0;
                    hc[0] = 0;
                    if (parse_com(flow_interp->CMDX, hc, flow_interp) != 0) {
                        if (flow_interp->expr_ev == 0) {
                            Er = Evaluate(hc, &x, &dum, flow_interp);
                            if (flow_interp->PRLEVEL <= 0 &&
                                flow_interp->IS_COM == 0) {
                                print(flow_interp, "%s%f\n", esp_decalage, x);
                                print_ev_error(Er, flow_interp);
                            }
                        }
                        else {
                            if (flow_interp->expr_ev == 1) {
                                Er = Evaluate_C(hc, &z, &dum, flow_interp);
                                if (flow_interp->PRLEVEL <= 0 &&
                                    flow_interp->IS_COM == 0) {
                                    print(flow_interp, "%s%f+%f.I\n", 
                                        esp_decalage, z.r, z.i);
                                    print_ev_error(Er, flow_interp);
                                }
                            }
                            else {
                                res_Gen = NULL;
                                Er = Evaluate_Gen(flow_interp->expr_ev - 2, hc,
                                    &res_Gen, &dum, flow_interp);
                                if (res_Gen != NULL) {
                                    if (flow_interp->PRLEVEL <= 0 &&
                                        flow_interp->IS_COM == 0) {
                                        pr_gen = Expreval_ops
                                            [flow_interp->expr_ev - 2].print(
                                                res_Gen);
                                        print(flow_interp, "%s\n", pr_gen);
                                        free(pr_gen);
                                        print_ev_error(Er, flow_interp);
                                    }
                                    Expreval_ops[flow_interp->expr_ev - 2].
                                        clear(res_Gen);
                                }
                            }                           
                        }
                    }
                    else {
                        if (flow_interp->PRLEVEL <= 0 &&
                            flow_interp->IS_COM == 0)
                            err_mess(2);
                    }
                }
            }
        }
        prTime(flow_interp);
    }
    else {
        if (argv[0][0] == '%') {
            l = strlen(argv[0]);
            j = 0;
            while (j < l - 1) {
                argv[0][j] = argv[0][++j];
            }
            argv[0][j] = 0;
        }
        memset(flow_interp->CMDX, 0, 200);
        for (j = 0; j < argc; j++)
            strcat(flow_interp->CMDX, argv[j]);
        (Mi->Conv)(flow_interp->CMDX, flow_interp);
    }
}
/*------------------------------------------------------------------*/





/*--------------------------------------------------------------------
    Function returning i if s=names[i], -1 otherwise
--------------------------------------------------------------------*/
int
lookup_c(char *names[], char *s)
{
    int             i,
                    i0;

    i0 = (int) s[0];
    if (fin_nom[i0] == -1)
        return -1;
    for (i = deb_nom[i0]; i <= fin_nom[i0]; i++)
        if (comp(names[i], s) == 1)
            return i;

    return -1;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function printing the execution time of a command
--------------------------------------------------------------------*/
void
prTime(flow_data *flow_interp)
{
    long            J;
    int             i,
                    k,
                    h;

    if (flow_interp->HORLOGE == 1) {
        time(&J);
        i = J - flow_interp->I_TIME_X;
        if (i >= 2) {
            k = i / 60;
            h = k / 60;
            i -= 60 * k;
            k -= 60 * h;

            if (h != 0 && flow_interp->PRLEVEL <= 0) {
#ifdef _ENG_LANG
                print(flow_interp, " ; execution time : %d h  %d mn  %d s\n",
                    h, k, i);
#else
                print(flow_interp,
                    " ; temps d'execution : %d h  %d mn %d s\n", h, k, i);
#endif
                return;
            }
            if (k != 0 && flow_interp->PRLEVEL <= 0) {
#ifdef _ENG_LANG
                print(flow_interp, " ; execution time : %d mn  %d s\n", k, i);
#else
                print(flow_interp, " ; temps d'execution : %d mn  %d s\n", k,
                    i);
#endif
                return;
            }
            if (i != 0 && flow_interp->PRLEVEL <=0) {
#ifdef _ENG_LANG
                print(flow_interp, " ; execution time : %d s\n", i);
#else
                print(flow_interp, " ; temps d'execution : %d s\n", i);
#endif
            }
        }
    }
}
/*------------------------------------------------------------------*/





char            hlec[100];


/*--------------------------------------------------------------------
    This function sends the expression 'arg' to the expression
    evaluator. The result of the evaluation is converted to an
    integer and returned
--------------------------------------------------------------------*/
int
convert_int(char *arg, flow_data *flow_interp)
{
      return (int)floor(convert_float(arg, flow_interp));
}
/*------------------------------------------------------------------*/





/*--------------------------------------------------------------------
    This function adds the non printable character in the beginning
    of 'arg' and sends this to the expression evaluator. The result
    of the evaluation is converted to an integer which is returned.
    This is used to determine or fix the value of hidden variables
--------------------------------------------------------------------*/
int
S_convert_int(char *arg, flow_data *flow_interp)
{
    int             i;
    char            h[100];

    memset(h, 0, 100);
    h[0] = 127;
    for (i = 0; i < (int) strlen(arg); i++)
        h[i + 1] = arg[i];
    return convert_int(h, flow_interp);
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    This function sends the expression 'arg' to the expression
    evaluator and returns the result of the evaluation
--------------------------------------------------------------------*/
double
convert_float(char *arg, flow_data *flow_interp)
{
    double          res;
    int             dum;
    char            hc[250];
    Misc_Func      *Mi;

    if (parse_com(arg, hc, flow_interp) == 0) {
        err_mess(2);
        return 0;
    }
    Mi = (Misc_Func *) flow_interp->extra[0];

    if ((Mi->Ev)(hc, &res, &dum, flow_interp) == E_OK)
        return res;
    return 0.0;
}
/*------------------------------------------------------------------*/





/*--------------------------------------------------------------------
    This function adds the non printable character in the beginning
    of 'arg' and sends this to the expression evaluator. The result
    of the evaluation is returned. This is used to determine or fix
    the value of hidden variables
--------------------------------------------------------------------*/
double
S_convert_float(char *arg, flow_data *flow_interp)
{
    int             i;
    char            h[100];

    memset(h, 0, 100);
    h[0] = 127;
    for (i = 0; i < (int) strlen(arg); i++)
        h[i + 1] = arg[i];
    return convert_float(h, flow_interp);
}
/*------------------------------------------------------------------*/





/*--------------------------------------------------------------------
    Function associated to the command 'eval'
--------------------------------------------------------------------*/
int
eval_cmd(int argc, char *argv[])
{
    double          x;
    int             i,
                    Er,
                    dum;
    char            h[100],
                    k[250],
                    hc[250];
    void           *res_Gen;
    dcomplex        z;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);

    if (argc < 2) {
        err_mess(0);
        return 0;
        }
    memset(h, 0, 100);
    memset(k, 0, 300);
    for (i = 1; i < argc; i++)
        strcat(k, argv[i]);
    memset(hc, 0, 250);
    if (parse_com(k, hc, flow_interp) == 0) {
        err_mess(2);
        return 0;
    }
    
    if (flow_interp->expr_ev == 0) {
        Er = Evaluate(hc, &x, &dum, flow_interp);
        sprintf(h, "curvar=%f", (float)x);
        convert_float(h, flow_interp);
        if (flow_interp->PRLEVEL <= 0) {
            print(flow_interp, "                      %f\n", x);
            print_ev_error(Er, flow_interp);
        }
    }
    else {
        if (flow_interp->expr_ev == 1) {
        z.r = 0.;
        z.i = 0.;
            Er = Evaluate_C(hc, &z, &dum, flow_interp);
        SetValue_C("curvar", &z, flow_interp);
            if (flow_interp->PRLEVEL <= 0) {
                print(flow_interp, "             %f+%f.I\n", z.r, z.i);
                print_ev_error(Er, flow_interp);
            }
    }
    else {
            res_Gen = NULL;
            Er = Evaluate_Gen(flow_interp->expr_ev - 2, hc, &res_Gen, &dum,
        flow_interp);
            if (flow_interp->PRLEVEL <= 0) {
        print(flow_interp,"%s\n",
                    Expreval_ops[flow_interp->expr_ev - 2].print(res_Gen));
                print_ev_error(Er, flow_interp);
            }
            SetValue_Gen(flow_interp->expr_ev - 2, "curvar", &res_Gen,
            flow_interp);
            Expreval_ops[flow_interp->expr_ev - 2].clear(res_Gen);
    }
    }
    return 0;
}
/*------------------------------------------------------------------*/



/*--------------------------------------------------------------------
    Functions used to see if a character string is "alphanumeric"
--------------------------------------------------------------------*/
int
is_alphab(char s)
{
    if ((s >= 'A' && s <= 'Z') || (s >= 'a' && s <= 'z') || s == '_')
        return 1;
    else
        return 0;
}

int
is_alphab_or_num(char s)
{
    if (is_alphab(s) == 1 || (s >= '0' && s <= '9'))
        return 1;
    else
        return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function used to read real numbers from standard input or
    programs
--------------------------------------------------------------------*/
void
read_float(float *x, flow_data *flow_interp)
{
    memset(hlec, 0, 100);
    if (flow_interp->I__COM_CUR == -1) {
        fgets(hlec, 99, flow_interp->INP[flow_interp->CURVOICE]);
        nettoie(hlec);
    }
    else {
        if (flow_interp->I_LIGNE_CUR < nb_lignes[flow_interp->I__COM_CUR]) {
            flow_interp->I_LIGNE_CUR++;
            flow_interp->I_LEC_CUR++;
            strcpy(hlec, ligne_com[flow_interp->I__COM_CUR]
                [flow_interp->I_LIGNE_CUR]);
        }
    }
    x[0] = (float) convert_float(hlec, flow_interp);
    if (flow_interp->PRLEVEL <= 0) {
        if (flow_interp->MON_FILE != NULL)
            fprintf(flow_interp->MON_FILE, "%f\n", x[0]);
        if (flow_interp->I__COM_CUR != -1)
            print(flow_interp, "%f\n", x[0]);
    }
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function used to read integers from standard input or programs
---------------------------------------------------------------------*/
void
read_int(int *n, flow_data *flow_interp)
{
    memset(hlec, 0, 100);
    if (flow_interp->I__COM_CUR == -1) {
        fgets(hlec, 99, flow_interp->INP[flow_interp->CURVOICE]);
        nettoie(hlec);
    }
    else {
        if (flow_interp->I_LIGNE_CUR < nb_lignes[flow_interp->I__COM_CUR]) {
            flow_interp->I_LIGNE_CUR++;
            flow_interp->I_LEC_CUR++;
            strcpy(hlec, ligne_com[flow_interp->I__COM_CUR]
                [flow_interp->I_LIGNE_CUR]);
        }
    }
    n[0] = (int) convert_float(hlec, flow_interp);
    if (flow_interp->PRLEVEL <= 0) {
        if (flow_interp->MON_FILE != NULL)
            fprintf(flow_interp->MON_FILE, "%d\n", n[0]);
        if (flow_interp->I__COM_CUR != -1)
            print(flow_interp, "%d\n", n[0]);
    }
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function used to read character strings from standard input or
    programs
--------------------------------------------------------------------*/
void
read_char(char *st, flow_data *flow_interp)
{
    memset(hlec, 0, 100);
    if (flow_interp->I__COM_CUR == -1) {
        fgets(hlec, 99, flow_interp->INP[flow_interp->CURVOICE]);
        nettoie(hlec);
    }
    else {
        if (flow_interp->I_LIGNE_CUR < nb_lignes[flow_interp->I__COM_CUR]) {
            flow_interp->I_LIGNE_CUR++;
            flow_interp->I_LEC_CUR++;
            strcpy(hlec, ligne_com[flow_interp->I__COM_CUR]
                [flow_interp->I_LIGNE_CUR]);
        }
    }
    strcpy(st, hlec);
    if (flow_interp->PRLEVEL <= 0) {
        if (flow_interp->MON_FILE != NULL)
            fprintf(flow_interp->MON_FILE, "%s\n", hlec);
        if (flow_interp->I__COM_CUR != -1)
            print(flow_interp, "%s\n", hlec);
    }
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function that interprets an expression "name[expression]" or
    "name" in 'ent', puts the integral value of "expression" in 'nb'
    and "name" in 'nm'. The function returns 0 if 'ent' was incorrect
    or *nb<=0, 2 if "[expression]" is missing in 'ent' and 1 otherwise.
    This function is used in objdef.c (functions 'obj_create' and '
    struc_create) to interpret a command of type
        defobj f0[5]
    The objects f0[1], f0[2], f0[3], f0[4], f0[5] are then defined.
--------------------------------------------------------------------*/
int
parse_def(char *ent, int *nb, char *nm, flow_data *flow_interp)
{
    int             i,
                    j,
                    slen,
                    ind,
                    re;
    char            nbx[50];

    memset(nbx, 0, 50);
    i = 0;
    j = -1;
    ind = 0;
    re = 0;
    slen = (int) strlen(ent);

    while (i < slen) {
        if (ind == 0) {
            if (ent[i] == ']')
                return 0;
            if (ent[i] == '[')
                ind = 1;
            else
                nm[i] = ent[i];
        }
        else {
            if (ent[i] == ']') {
                if (i != slen - 1)
                    return 0;
            }
            else {
                if (i == slen)
                    return 0;
                j++;
                if (j >= 50)
                    return 0;
                nbx[j] = ent[i];
            }
        }
        i++;
    }

    if (ind == 0)
        return 2;
    nb[0] = convert_int(nbx, flow_interp);
    if (nb[0] <= 0)
        return 0;
    return 1;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function that replaces the references to an object in an
    expression (the string 'g') and replaces them by their value.
    This function returns 0 if an incorrect expression is detected
    and 1 otherwise. The modified string is put in 'w'. This
    function is used in function 'convert_float'
--------------------------------------------------------------------*/
int
parse_com(char *g, char *w, flow_data *flow_interp)
{
    int             i,
                    j,
                    k,
                    len,
                    nb,
                    cas,
                    icpt;
    char            nom_o[100],
                    x_arg[100],
                    ch[30];
    double         *x,
                    val_r;
    dcomplex        val;

    if (flow_interp->parse_com != 0) {
        strcpy(w, g);
        return 1;
    }
    x = (double *) malloc((size_t) (__nbargmax + 2) * sizeof(double));
    i = 0;
    j = -1;
    len = strlen(g);
    memset(nom_o, 0, 100);
    memset(x_arg, 0, 100);
    memset(w, 0, 250);
    nb = 0;

    while (g[i] != 0) {
        if (g[i] != '&' && g[i] != '!' && j < 298) {
            w[++j] = g[i++];
        }
        else {
            cas = 0;
            if (g[i] == '!')
                cas = 1;
            icpt = 0;
            i++;
            k = -1;

            while(g[i] != '(') {
                if (i == len)
                    return 0;
                nom_o[++k] = g[i++];
            }

            i++;
            k = -1;

            while(g[i] != ')' || icpt != 0) {
                if (i == len)
                    return 0;
                k++;
                x_arg[k] = g[i];
                if (g[i] == ')')
                    icpt++;
                if (g[i] == '(')
                    icpt--;
                i++;
            }

            i++;
            extrait_arg_s(x_arg, x, &nb, flow_interp);
            val = calc_val_obj(nb, x, nom_o, cas, flow_interp);
            k = i;
            if (g[i] == '.') {
                if (g[i + 1] == 'i') {
                    val_r = val.i;
                    k += 2;
                }
                else {
                    val_r = val.r;
                    if (g[i + 1] == 'r')
                        k += 2;
                }
            }
            else
                val_r = val.r;
            i = k;
            if (j < 299) {
                memset(ch, 0, 30);
                sprintf(ch, "%.16f", val_r);
                strcat(w, ch);
                j += strlen(ch);
            }
        }
    }

    free(x);
    w[++j] = 0;
    return 1;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
--------------------------------------------------------------------*/
void
extrait_arg_s(char *h, double *x, int *nb, flow_data *flow_interp)
{
    int             i,
                    icpt,
                    j;
    char            k[100];

    memset(k, 0, 100);
    nb[0] = -1;
    x[0] = 0.0;
    i = 0;
    j = -1;
    icpt = 0;

    while (h[i] != 0) {
        if (h[i] != ',' || icpt != 0) {
            k[++j] = h[i];
            if (h[i] == '(')
                icpt++;
            if (h[i] == ')')
                icpt--;
            i++;
        }
        else {
            nb[0]++;
            i++;
            if (nb[0] > __nbargmax)
                return;
            x[nb[0]] = convert_float(k, flow_interp);
            memset(k, 0, strlen(k));
            j = -1;
        }
    }

    nb[0]++;
    if (nb[0] > __nbargmax)
        return;
    x[nb[0]] = convert_float(k, flow_interp);
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
--------------------------------------------------------------------*/
dcomplex
calc_val_obj(int nb, double *x, char *nom_o, int cas, flow_data *flow_interp)
{
    int             iw,
                    i0,
                    i,
                    j,
                    p,
                    q,
                   *xi;
    float          *xf;
    double         *xd;
    fcomplex       *xfc;
    dcomplex       *xdc,
                    z;
    fpolaire       *xfp;
    dpolaire       *xdp;
    char           *c;

    if (cas != 0)
        return dComplex(0.0, 0.0);
    iw = sketch_obj(nom_o, &i0, flow_interp);

    if (iw == 0)
        return dComplex(0.0, 0.0);
    iw--;
    if (Obj_typ[iw].nbdim != nb + 1)
        return dComplex(0.0, 0.0);
    p = 0;
    q = 1;

    for (i = nb; i  >= 0; i--) {
        j = (int) x[i];
        if (j < 0 || j > (Obj[iw][i0].dim)[i])
            return dComplex(0.0, 0.0);
        p += j * q;
        if (i > 0)
            q *= (Obj[iw][i0].dim)[i] + 1;
    }

    c = addr_eff_b(_M((char **) Obj[iw][i0].adresse));

    switch(Obj_typ[iw].type) {
        case 0 :
            xi = (int *) c;
            z = dComplex((double) xi[p], 0.0);
            break;
        case 1 :
            xf = (float *) c;
            z = dComplex((double) xf[p], 0.0);
            break;
        case 2 :
            xd = (double *) c;
            z = dComplex(xd[p], 0.0);
            break;
        case 3 :
            xfc = (fcomplex *) c;
            z = dComplex((double) xfc[p].r, (double) xfc[p].i);
            break;
        case 4 :
            xdc = (dcomplex *) c;
            z = xdc[p];
            break;
        case 5 :
            xfp = (fpolaire *) c;
            z = dConv_ptc(dPolaire((double) xfp[p].rm, (double) xfp[p].th));
            break;
        case 6 :
            xdp = (dpolaire *) c;
            z = dConv_ptc(xdp[p]);
            break;
    }

    return z;
}
/*------------------------------------------------------------------*/



/*--------------------------------------------------------------------
    Prints error messages returned by the expression evaluator
--------------------------------------------------------------------*/
void
print_ev_error(int i0, flow_data *flow_interp)
{
#ifdef _ENG_LANG
    switch(i0) {
        case 1 :
            print(flow_interp, "%s\n", "Syntax error");
            break;
        case 2 :
            print(flow_interp, "%s\n", "Unbalanced parenthesis");
            break;
        case 3 :
            print(flow_interp, "%s\n", "Division by zero");
            break;
        case 4 :
            print(flow_interp, "%s\n", "Unknown variable");
            break;
        case 5 :
            print(flow_interp, "%s\n", "Too many variables");
            break;
        case 6 :
            print(flow_interp, "%s\n", "Unknown function");
            break;
        case 7 :
            print(flow_interp, "%s\n", "Wrong number of arguments");
            break;
        case 8 :
            print(flow_interp, "%s\n", "Missing argument");
            break;
        default :
            break;
    }
#else
    switch(i0) {
        case 1 :
            print(flow_interp, "%s\n", "Erreur de syntaxe");
            break;
        case 2 :
            print(flow_interp, "%s\n", "Probleme de parenthese");
            break;
        case 3 :
            print(flow_interp, "%s\n", "Division par zero");
            break;
        case 4 :
            print(flow_interp, "%s\n", "Variable inconnue");
            break;
        case 5 :
            print(flow_interp, "%s\n", "Trop de variables");
            break;
        case 6 :
            print(flow_interp, "%s\n", "Fonction inconnue");
            break;
        case 7 :
            print(flow_interp, "%s\n", "Nombre d'arguments incorrect");
            break;
        case 8 :
            print(flow_interp, "%s\n", "Argument manquant");
            break;
        default :
            break;
    }
#endif
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Initialization of exp. eval. variables arrays
--------------------------------------------------------------------*/
void
init_VARS(XVARIABLE *Va)
{
    int             i,
                    j;

    for (i = 0; i < MAXXVARS; i++) {
        Va[i].value = 0.;
        Va[i].name = (char *) malloc((size_t)(XVARLEN + 1) * sizeof(char));
        for (j = 0; j <= XVARLEN; j++)
                Va[i].name[j] = 0;
    }
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Initialization of complex exp. eval. variables arrays
--------------------------------------------------------------------*/
void
init_VARS_C(XVARIABLE_C *Va)
{
    int             i,
                    j;

    for (i = 0; i < MAXXVARS; i++) {
        (Va[i].value).r = 0.;
        (Va[i].value).i = 0.;
        Va[i].name = (char *) malloc((size_t)(XVARLEN + 1) * sizeof(char));
        for (j = 0; j <= XVARLEN; j++)
                Va[i].name[j] = 0;
    }
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Initialization of a flow_data structure 1)
--------------------------------------------------------------------*/
void
init_flow_param(flow_data *flow_interp)
{
    int             j;
    char          **c;
    Misc_Func      *Mi;

    flow_interp->HCOM = (char *) malloc(1000 * sizeof(char));
    flow_interp->IS_COM = 1;
    flow_interp->_H_LIGNE = (char *) malloc(300 * sizeof(char));
    c = (char **) malloc(21 * sizeof(char *));
    flow_interp->_ARGV_C = c + 1;
    for (j = 0; j < 20; j++)
       flow_interp->_ARGV_C[j] = NULL;
    flow_interp->CMDX = (char *) malloc(300 * sizeof(char));
    flow_interp->VARS = (XVARIABLE *) malloc((size_t) MAXXVARS *
        sizeof(XVARIABLE));
    flow_interp->VARS2 = (double *) malloc((size_t) 52 *
        sizeof(double));
    for (j = 0; j < 52; j++)
        flow_interp->VARS2[j] = 0.;
    init_VARS(flow_interp->VARS);
    flow_interp->VARS_C = (XVARIABLE_C *) malloc((size_t) MAXXVARS *
        sizeof(XVARIABLE_C));
    flow_interp->VARS2_C = (dcomplex *) malloc((size_t) 52 *
        sizeof(dcomplex));

    for (j = 0; j < 52; j++) {
        flow_interp->VARS2_C[j].r = 0.;
        flow_interp->VARS2_C[j].i = 0.;
    }

    init_VARS_C(flow_interp->VARS_C);
    flow_interp->used = 1;
    flow_interp->extra = (char **) malloc(__EXTRA_PARAM * sizeof(char *));
    for (j = 0; j < __EXTRA_PARAM; j++)
        flow_interp->extra[j] = NULL;
    flow_interp->pause = 0;
    flow_interp->mutex_obj = 0;
    Mi = (Misc_Func *) malloc((size_t) sizeof(Misc_Func));
    Mi->Print = NULL;
    Mi->Ev = Evaluate;
    Mi->Conv = convert_float;
    flow_interp->extra[0] = (char *) Mi;
    flow_interp->var = NULL;
    flow_interp->kill = 0;
    flow_interp->n_instr = 0;
    flow_interp->expr_ev = 0;
    init_thread_param(flow_interp);
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Initialization of a flow_data structure 2)
--------------------------------------------------------------------*/
void
init_flow_param_b(flow_data *flow_interp)
{
    int             i;
    subst_pat      *S;

    flow_interp->INP = (FILE **) malloc((size_t) __maxvoice * sizeof(FILE *));
    for (i = 0; i < __maxvoice; i++)
        flow_interp->INP[i] = NULL;
    flow_interp->ARGV_X = (argv_t *) malloc((size_t) __maxvoice *
        sizeof(argv_t));
    flow_interp->ARGC_X = (int *) malloc((size_t) __maxvoice * sizeof(int));
    for (i = 0; i < __maxvoice; i++)
        flow_interp->ARGC_X[i] = 0;
    flow_interp->COM_PREC = (char **) malloc((size_t)
        __n_com_prec * sizeof(char *));
    for (i = 0; i < __n_com_prec; i++)
        flow_interp->COM_PREC[i] = NULL;
    S = (subst_pat *) malloc((size_t) __max_subst_pat * sizeof(subst_pat));
    for (i = 0; i < __max_subst_pat; i++)
        S[i] = Subst_Pat[i];
    flow_interp->extra[1] = (char *) S;
    if (NB_expr_eval <= 2)
        return;
    init_expr_eval(&flow_interp->VARS_Gen, MAXXVARS);
    init_expr_eval(&flow_interp->VARS2_Gen, 52);
    flow_interp->VARSX_Gen = (void ***) malloc((size_t) (NB_expr_eval - 2) *
        sizeof(void **));
    for (i = 0; i < NB_expr_eval - 2; i++)
        flow_interp->VARSX_Gen[i] = (void **) malloc((size_t) 
            Expreval_ops[i].n_var);
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Initialization of generic exp. eval. variables arrays
--------------------------------------------------------------------*/
void
init_expr_eval(Vars_Gen ***VV, int n)
{
    int             i,
                    j,
                    k;

    if (NB_expr_eval <= 2)
        return;
    VV[0] = (Vars_Gen **) malloc((size_t) (NB_expr_eval - 2) * 
        sizeof(Vars_Gen *));

    for (i = 0; i < NB_expr_eval - 2; i++) {
        VV[0][i] = (Vars_Gen *) malloc((size_t) n * sizeof(Vars_Gen));

        for (j = 0; j < n; j++) {
            VV[0][i][j].name = (char *) malloc((size_t)(XVARLEN + 1) * 
                sizeof(char));
            for (k = 0; k <= XVARLEN; k++)
                (VV[0][i][j].name)[k] = 0;
            VV[0][i][j].value = (void **) malloc((size_t) sizeof(void *));
            Expreval_ops[i].Init(VV[0][i][j].value);
            Expreval_ops[i].Zero((VV[0][i][j].value)[0]);
        }
    }
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Destruction of a flow_data structure
--------------------------------------------------------------------*/
void
clean_flow_param(flow_data *flow_interp)
{
    char          **c;
    int             i,
                    j;
    Misc_Func      *Mi;
    subst_pat      *S;

    clean_thread_param(flow_interp);
    free(flow_interp->HCOM);
    free(flow_interp->_H_LIGNE);
    free(flow_interp->INP);
    for (i = 0; i < 20; i++)
        if (flow_interp->_ARGV_C[i] != NULL)
            free(flow_interp->_ARGV_C[i]);
    c = flow_interp->_ARGV_C - 1;
    free(c);
    free(flow_interp->CMDX);
    free(flow_interp->ARGV_X);
    free(flow_interp->ARGC_X);
    for (i = 0; i < __n_com_prec; i++)
        if (flow_interp->COM_PREC[i] != NULL)
            free(flow_interp->COM_PREC[i]);
    free(flow_interp->COM_PREC);

    for (i = 0; i < MAXXVARS; i++) {
        free(flow_interp->VARS[i].name);
        free(flow_interp->VARS_C[i].name);
    }

    free(flow_interp->VARS);
    free(flow_interp->VARS2);
    free(flow_interp->VARS_C);
    free(flow_interp->VARS2_C);
    flow_interp->used = 0;
    if (flow_interp->name != NULL) {
        free(flow_interp->name);
        flow_interp->name = NULL;
    }
    Mi = (Misc_Func *) flow_interp->extra[0];
    free(Mi);
    if (flow_interp->var != NULL)
        free(flow_interp->var);
    S = (subst_pat *) flow_interp->extra[1];
    free(S);
    free(flow_interp->extra);
    
    if (NB_expr_eval > 2) {
        for (i = 0; i < NB_expr_eval - 2; i++) {
            for (j = 0; j < MAXXVARS; j++) {
                free(flow_interp->VARS_Gen[i][j].name);
                Expreval_ops[i].clear(flow_interp->VARS_Gen[i][j].value[0]);
                free(flow_interp->VARS_Gen[i][j].value);
            }

            for (j = 0; j < 52; j++) {
                free(flow_interp->VARS2_Gen[i][j].name);
                Expreval_ops[i].clear(flow_interp->VARS2_Gen[i][j].value[0]);
                free(flow_interp->VARS2_Gen[i][j].value);
            }
            
            free(flow_interp->VARSX_Gen[i]);
            free(flow_interp->VARS_Gen[i]);
            free(flow_interp->VARS2_Gen[i]);
        }
        
        free(flow_interp->VARSX_Gen);
        free(flow_interp->VARS_Gen);
        free(flow_interp->VARS2_Gen);
    }
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
--------------------------------------------------------------------*/
void
Run_interp(flow_data *flow_interp)
{
    int             i;

    if (flow_interp == NULL) {
        flow_interp = &flow_I[0];
        flow_interp->PRLEVEL = 1;
    }
    if (flow_interp->MON_FILE != NULL)
        fprintf(flow_interp->MON_FILE, "%s", flow_interp->_H_LIGNE);
    extrait_arg(flow_interp);             /* Extraction of the arguments
                                      of the command line */
    if (flow_interp->_ARGV_C[0][0] == '[') {
        flow_interp->I_SPEED = 1;
        flow_interp->_ARGC_C = 0;
        if (strlen(flow_interp->_ARGV_C[0]) > 1) {
            if (flow_interp->_ARGV_C[0][1] == '0')
                flow_interp->parse_com = 1;
            if (flow_interp->_ARGV_C[0][1] == '1')
                flow_interp->parse_com = 1;
            }
    }
    if (flow_interp->_ARGV_C[0][0] == ']') {
        flow_interp->I_SPEED = 0;
        flow_interp->_ARGC_C = 0;
        flow_interp->parse_com = 0;
    }
    if (flow_interp->_ARGC_C > 0) {
        if (flow_interp->_ARGV_C[0][0] != ';') {  /* Detection of comments */
        substit(flow_interp);         /* substitution of #1,..
                                           in the arguments         */
        if (flow_interp->PRLEVEL <= 0) {   /* The command line is printed  */
            for (i = 0; i < flow_interp->_ARGC_C; i++)
                 print(flow_interp, "%s ", flow_interp->_ARGV_C[i]);
            print(flow_interp, "\n");
        }
        substit2(flow_interp);
        if (change_lev(flow_interp) == 0) /* detection and execution
                                                     of a change of voice  */
            shell_c(flow_interp->_ARGC_C, flow_interp->_ARGV_C, flow_interp);
                                 /* execution of the command  */
            if (flow_interp->PRLEVEL <= 0)
                print(flow_interp, "%s",
                    prompt_mode[flow_interp->MODE_FONCT_]);
        }
    }
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    For non-interactive use of the command interpreter
    Runs the instruction contained in W
--------------------------------------------------------------------*/
void
Exec_interp_command(char *W)
{
    memset(flow_I[0]._H_LIGNE, 0, 300);
    strcat(flow_I[0]._H_LIGNE, W);
    Run_interp(&flow_I[0]);
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Called by the command 'exit'
--------------------------------------------------------------------*/
void
clean_exit_interp(flow_data * flow_interp)
{
    int             i,
                    j,
                    k;

    for (i = 0; i < nb_typ; i++) {
        init_obj(i, flow_interp);
        for (j = 0; j < Obj_typ[i].nbdim; j++)
            free((Obj_typ[i].nom_dim)[j]);
        free(Obj_typ[i].nom);
        free(Obj_typ[i].nom_dim);
        free(Obj_typ[i].comment);
        free(Obj[i]);
    }

    XFREE(mode_com_obj);
    XFREE(Obj_alias);
    free(Obj_typ);
    free(Obj);

    for (i = 0; i < nb_struc; i++) {
        init_str(i, flow_interp);
        XFREE(Struc_typ[i].type_mb);
        for (j = 0; j < Struc_typ[i].nb_membres; j++)
            free((Struc_typ[i].membre_id)[j]);
        free(Struc_typ[i].nom);
        free(Struc_typ[i].comment);
        free(Struc[i]);
        free(Struc_typ[i].membre_id);
    }

    XFREE(mode_com_str);
    free(Struc_typ);
    free(Struc);

    for (i = 0; i < MAXXVARS; i++) {
        free(VArs_global[i].name);
        free(VArs_global_C[i].name);
    }

    clean_flow_param(flow_interp);
    free(Subst_Delim);
    free(Subst_Pat);

    for (i = 0; i < __max_Env_st; i++)
        if (Env_string[i] != NULL) {
            free(Env_string[i]);
            free(Env_string2[i]);
        }

    free(Env_string2);
    free(Env_string);
    for (i = 0; i < __n_max_threads; i++)
        if (flow_I[i].used != 0)
            clean_flow_param(&flow_I[i]);
    free(flow_I);
    for (i = 0; i < __max_quest; i++)
        free(ques[i]);
    free(ques);

    for (i = 0; i < nb_com; i++) {
        for (j = 0; j < nb_lignes[i]; j++) {
            for (k = 0; k < __nbargmax + 2; k++)
                if (Argv_com[i][j][k] != NULL)
                    free(Argv_com[i][j][k]);
            free(Argv_com[i][j]);
            if (Is_subst_arg[i][j] != NULL)
                free(Is_subst_arg[i][j]);
            free(ligne_com[i][j]);
        }

        free(ligne_com[i]);
        free(Argv_com[i]);
        free(Argc_com[i]);
        free(Is_subst_ligne[i]);
        free(Is_subst_arg[i]);
        free(nom_com[i]);
        if (num_label[i] != NULL)
            free(num_label[i]);
    }

    for (i = nb_com; i < __nbcom; i++) {
        free(ligne_com[i]);
        free(Argv_com[i]);
        free(Argc_com[i]);
        free(Is_subst_ligne[i]);
        free(Is_subst_arg[i]);
        if (nom_com[i] != NULL)
            free(nom_com[i]);
        if (num_label[i] != NULL)
            free(num_label[i]);
    }

    free(tr_label);
    free(nb_par);
    free(sil_com);
    free(nb_lignes);
    free(nom_com);
    free(ligne_com);
    free(nb_label);
    free(num_label);
    free(Argc_com);
    free(Argv_com);
    free(Is_subst_ligne);
    free(Is_subst_arg);
    free(Is_Del_prog);
    free(Is_visible_prog);
    free(s_cond);
    free(v_cond);
    for (i = 0; i < argc_init_interp; i++)
        free(argv_init_interp[i]);
    for (i = 0; i < __nmode_fonc; i++)
        if (prompt_mode[i] != NULL)
            free(prompt_mode[i]);
    free(prompt_mode);

    for (i = 0; i < __com_max; i++)
        free(mode_com[i]);
    for (j = 0; j < __nbcom; j++)
        free(mode_com_int[j]);
    free(mode_com);
    free(mode_com_int);
    for (i = 0; i < __nss; i++)
        if (sS[i] != NULL)
            fclose(sS[i]);
    free(sS);
    free(sS_cmpt);
    free(sS_i_o);
    for (i = 0; i < __nss; i++)
        if (sS_nom[i] != NULL)
            free(sS_nom[i]);
    free(sS_nom);
    for (i = 0; i < __mess_max; i++)
        if (mess[i] != NULL)
            free(mess[i]);
    free(mess);
    for (i = 0; i < __greet_max; i++)
        if (greet[i] != NULL)
            free(greet[i]);
    free(greet);
    for (i = 0; i <= nb_commandes; i++)
        free(names[i]);
    free(names);
    free(par_com);
    free(len_n);
    free(deb_nom);
    free(fin_nom);
    free(procw);
    if (NB_expr_eval > 2) {
        for (i = 0; i < NB_expr_eval - 2; i++) {
            for (j = 0; j < MAXXVARS; j++) {
                free(VArs_global_Gen[i][j].name);
                Expreval_ops[i].clear(VArs_global_Gen[i][j].value[0]);
                free(VArs_global_Gen[i][j].value);
            }
            
            free(VArs_global_Gen[i]);
        }
        
        free(VArs_global_Gen);
    }
    free(_NBFONC_Gen);
    free(Expreval_ops);
}
/*------------------------------------------------------------------*/





#ifdef _HAVE_THREADS
/*--------------------------------------------------------------------
    Command executing a thread
--------------------------------------------------------------------*/
int
thread_interp_create(int argc, char *argv[])
{
    int             i;
    flow_data      *flow_interp2;
    flow_data      *flow_interp;
    pthread_t       thread0;
    pthread_attr_t  attr;
    thread_par     *thread_param;   /* thread_par is defined in the
                               beginning of this file */

    pthread_mutex_lock(&mutex_thread);

    for (i = 1; i < __n_max_threads; i++) {
         if (flow_I[i].used != 0) {
             if (comp(flow_I[i].name, argv[1]) == 1) {
                 pthread_mutex_unlock(&mutex_thread);
                 err_mess(32);
                 return 1;
             }
         }
    }

    flow_interp = (flow_data *) argv[-1];
    flow_interp2 = NULL;

    for (i = 1; i < __n_max_threads; i++) {
        if (flow_I[i].used == 0) {
            flow_interp2 = flow_I + i;
            flow_interp2->num = i;
            break;
        }
    }

    pthread_mutex_unlock(&mutex_thread);
    if (flow_interp2 == NULL) {
        err_mess(31);
        return 1;
    }
    flow_interp2->name = ch_copy(argv[1]);
    flow_interp2->thread = (int) thread0;
    thread_param = (thread_par *) malloc((size_t) sizeof(thread_par));
    init_flow_param(flow_interp2);
    init_flow_param_b(flow_interp2);
    thread_param->thr_i = flow_interp2;
    thread_param->argc_l = argc - 2;
    thread_param->argv_l = (char **) malloc((size_t) (argc + 1) *
        sizeof(char *));
    thread_param->argv_l[0] = (char *) flow_interp;
    thread_param->s = flow_interp->INP[flow_interp->CURVOICE];
    thread_param->mode_fonc = flow_interp->MODE_FONCT_;

    for (i = 1; i < argc - 1; i++)
        thread_param->argv_l[i] = ch_copy(argv[i + 1]);

    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
    pthread_create(&thread0, &attr, thread_exec, (void *)thread_param);
/*    pthread_create(&thread0, NULL, thread_exec, (void *)thread_param);*/
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    thread function
--------------------------------------------------------------------*/
void
*thread_exec(void *adx)
{
    flow_data      *flow_interp;
    thread_par     *thread_par_ad;
    int             i;

    num_thread_run++;
    thread_par_ad = (thread_par *)adx;
    flow_interp = (flow_data *)thread_par_ad->thr_i;
    flow_interp->I_SPEED = 0;
    flow_interp->_I_TIME_X = 0;
    flow_interp->IND_COM = 1;
    flow_interp->I__COM_CUR = -1;
    flow_interp->HORLOGE = 0;
    flow_interp->parse_com = 0;
    flow_interp->MON_FILE = NULL;
    flow_interp->PRLEVEL = 0;
    flow_interp->CURVOICE = 1;
    flow_interp->MODE_FONCT_ = thread_par_ad->mode_fonc;
    flow_interp->INP[flow_interp->CURVOICE] = thread_par_ad->s;
    memset(flow_interp->_H_LIGNE, 0, 300);

    for (i = 1; i<=thread_par_ad->argc_l;i++) {
        strcat(flow_interp->_H_LIGNE, thread_par_ad->argv_l[i]);
        strcat(flow_interp->_H_LIGNE, " ");
    }

    Run_interp(flow_interp);
    print(flow_interp, "End of thread %s ,   %d instructions\n",
        flow_interp->name, flow_interp->n_instr);
    clean_flow_param(flow_interp);
    for (i = 1; i<=thread_par_ad->argc_l;i++)
        free(thread_par_ad->argv_l[i]);
    free(thread_par_ad->argv_l);
    free(thread_par_ad);
    num_thread_run--;
/*    pthread_exit(&i);*/
    return NULL;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Command listing threads
--------------------------------------------------------------------*/
int
list_threads(int argc, char *argv[])
{
    int             i;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    pthread_mutex_lock(&mutex_thread);
    for (i = 0; i < __n_max_threads; i++)
        if (flow_I[i].used == 1)
            print(flow_interp, "%d ------| %s\n", i, flow_I[i].name);
    pthread_mutex_unlock(&mutex_thread);

    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Command pausing a thread
--------------------------------------------------------------------*/
int
pause_thread(int argc, char *argv[])
{
    int             i,
                    j,
                    n_used_threads;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    n_used_threads = 0;
    pthread_mutex_lock(&mutex_thread);
    for (i = 0; i < __n_max_threads; i++)
          n_used_threads += flow_I[i].used;
    if (n_used_threads == 1) {
        err_mess(36);
        pthread_mutex_unlock(&mutex_thread);
        return 1;
    }

    for (i = 1; i < __n_max_threads; i++) {
        if (flow_I[i].used == 1) {
            if (comp(argv[1], flow_I[i].name) == 1) {
                j = convert_int(argv[2], flow_interp);
                if (j > 0)
                    flow_I[i].pause = 1;
                else
                    flow_I[i].pause = 0;
            }
        }
    }

    pthread_mutex_unlock(&mutex_thread);

    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Command asking a thread to wait until a variable is positive
--------------------------------------------------------------------*/
int
wait_thread(int argc, char *argv[])
{
    int             i,
                    n_used_threads;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    n_used_threads = 0;
    pthread_mutex_lock(&mutex_thread);
    for (i = 0; i < __n_max_threads; i++)
          n_used_threads += flow_I[i].used;
    if (n_used_threads == 1) {
        err_mess(36);
        pthread_mutex_unlock(&mutex_thread);
        return 1;
    }
    if (argv[2][0] != '_') {
        err_mess(35);
        pthread_mutex_unlock(&mutex_thread);
        return 1;
    }

    for (i = 1; i < __n_max_threads; i++) {
        if (flow_I[i].used == 1) {
            if (comp(argv[1], flow_I[i].name) == 1) {
                flow_I[i].pause = 2;
                flow_I[i].var = ch_copy(argv[2]);
            }
        }
    }

    pthread_mutex_unlock(&mutex_thread);

    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Command killing a thread
--------------------------------------------------------------------*/
int
kill_thread(int argc, char *argv[])
{
    int             i,
                    ind;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    if (comp(argv[1], "main") == 1) {
        err_mess(57);
        return 1;
    }
    ind = 0;
    pthread_mutex_lock(&mutex_thread);

    for (i = 1; i < __n_max_threads; i++) {
        if (flow_I[i].used == 1) {
            if (comp(argv[1], flow_I[i].name) == 1) {
                flow_I[i].kill = 1;
                ind = 1;
            }
        }
    }

    pthread_mutex_unlock(&mutex_thread);
    if (ind == 0) {
        err_mess(56);
        return 1;
    }
    return 0;
}
/*------------------------------------------------------------------*/
#endif

