/*
 * Decompiled with CFR 0.152.
 */
package cc.gammasoft.date;

import cc.gammasoft.date.CalendarController;
import cc.gammasoft.date.CalendarControllerEvent;
import cc.gammasoft.date.CalendarControllerListener;
import cc.gammasoft.date.MonthViewCalendarComparator;
import cc.gammasoft.date.ViewEvent;
import cc.gammasoft.date.ViewListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.event.ComponentEvent;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public abstract class AbstractCalendarView
extends JPanel
implements CalendarControllerListener {
    private String[] _$7246;
    private String[] _$7306;
    private String[] _$7386;
    private String[] _$7341;
    private GridBagLayout _$7979 = new GridBagLayout();
    protected EventListenerList listenerList = new EventListenerList();
    protected CalendarController controller;
    protected Calendar date = Calendar.getInstance();
    protected TreeSet selectedDates = new TreeSet(new MonthViewCalendarComparator());
    protected boolean calendarTrackingEnabled = false;
    protected boolean calendarTrackingVisible = false;
    protected boolean selectedDateEnabled = true;
    protected Color trackingColor = Color.red;
    protected int maxMonthLen = 0;
    static Class class$cc$gammasoft$date$ViewListener;

    public AbstractCalendarView(SimpleDateFormat format) {
        this.controller = new CalendarController(format);
        this.init();
    }

    public AbstractCalendarView() {
        this((SimpleDateFormat)null);
    }

    public void init() {
        this._$7147();
        this._$7165();
        this.setLayout(new BorderLayout());
        this.controller.addCalendarControllerListener(this);
    }

    public void panelResized(ComponentEvent e) {
    }

    public void setMonthPrefix(String[] newMonthPrefix) {
        if (newMonthPrefix == null) {
            throw new NullPointerException("Null Array");
        }
        this._$7246 = newMonthPrefix;
    }

    public String[] getMonthPrefix() {
        return this._$7246;
    }

    public void setDayPrefix(String[] newDayPrefix) {
        if (newDayPrefix == null) {
            throw new NullPointerException("Null Array");
        }
        this._$7306 = newDayPrefix;
    }

    public String[] getDayPrefix() {
        return this._$7306;
    }

    public void setMonthNames(String[] newMonthNames) {
        if (newMonthNames == null) {
            throw new NullPointerException("Null Array");
        }
        this._$7341 = newMonthNames;
    }

    public String[] getMonthNames() {
        return this._$7341;
    }

    public void setDayNames(String[] newDayNames) {
        if (newDayNames == null) {
            throw new NullPointerException("Null Array");
        }
        this._$7386 = newDayNames;
    }

    public String[] getDayNames() {
        return this._$7386;
    }

    private void _$7147() {
        this._$7341 = this.controller.getDateFormatSymbols().getMonths();
        this._$7246 = this.controller.getDateFormatSymbols().getShortMonths();
        int len = 0;
        for (int i = 0; i < this._$7341.length; ++i) {
            if (len >= this._$7341[i].length()) continue;
            len = this._$7341[i].length();
        }
        this.maxMonthLen = len;
    }

    private void _$7165() {
        this._$7386 = this.controller.getDateFormatSymbols().getWeekdays();
        this._$7306 = this.controller.getDateFormatSymbols().getShortWeekdays();
    }

    public CalendarController getController() {
        return this.controller;
    }

    public void setController(CalendarController controller) {
        this.controller = controller;
    }

    protected void notifyListenersViewEventPerformed(ViewEvent viewEvent) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$cc$gammasoft$date$ViewListener == null ? AbstractCalendarView.class$("cc.gammasoft.date.ViewListener") : class$cc$gammasoft$date$ViewListener) || viewEvent == null) continue;
            ((ViewListener)listeners[i + 1]).viewEventPerformed(viewEvent);
        }
    }

    public void addViewListener(ViewListener l) {
        this.listenerList.add(class$cc$gammasoft$date$ViewListener == null ? (class$cc$gammasoft$date$ViewListener = AbstractCalendarView.class$("cc.gammasoft.date.ViewListener")) : class$cc$gammasoft$date$ViewListener, l);
    }

    public void setDate(Calendar calendar) {
        if (calendar == null) {
            this.date = null;
        } else {
            this.date = calendar;
            if (this.calendarTrackingEnabled && !this.selectedDates.contains(this.date)) {
                this.selectedDates.add(this.date);
            }
            this.controller.setCurrentDate(calendar);
        }
    }

    public void setDate(String calendar) {
        if (calendar == null) {
            this.date = null;
        } else if (calendar.equals("")) {
            this.date = null;
        } else {
            this.controller.setCurrentDate(calendar);
            this.date = this.controller.getCurrentDate();
            if (this.calendarTrackingEnabled && !this.selectedDates.contains(this.date)) {
                this.selectedDates.add(this.date);
            }
        }
    }

    public void setSQLDate(String calendar) {
        this.setDate(calendar);
    }

    public Calendar getDate() {
        return this.date;
    }

    public String getSQLDate() {
        if (this.date != null) {
            return this.controller.getSQLDate();
        }
        return "";
    }

    public void removeViewListener(ViewListener l) {
        this.listenerList.remove(class$cc$gammasoft$date$ViewListener == null ? (class$cc$gammasoft$date$ViewListener = AbstractCalendarView.class$("cc.gammasoft.date.ViewListener")) : class$cc$gammasoft$date$ViewListener, l);
    }

    public void setCalendarTrackingEnabled(boolean value) {
        this.calendarTrackingEnabled = value;
    }

    public boolean isTrackingEnabled() {
        return this.calendarTrackingEnabled;
    }

    public void setSelectedDateEnabled(boolean value) {
        this.selectedDateEnabled = value;
    }

    public void setCalendarTrackingVisible(boolean value) {
        this.calendarTrackingVisible = value;
    }

    public boolean isCalendarTrackingVisible() {
        return this.calendarTrackingVisible;
    }

    public boolean isSelectedDateEnabled() {
        return this.selectedDateEnabled;
    }

    public void setTrackingColor(Color color) {
        if (color != null) {
            this.trackingColor = color;
        }
    }

    public Color getTrackingColor() {
        return this.trackingColor;
    }

    public TreeSet getSelectedDates() {
        return this.selectedDates;
    }

    public void calendarControllerChanged(CalendarControllerEvent e) {
        if (e.getChangeType() == 3) {
            this._$7165();
            this._$7147();
            this.formatChanged();
        }
        if (e.getChangeType() == 2) {
            this.date = e.getCalendar();
        }
        this.updateView();
        this.repaint();
        this.notifyListenersViewEventPerformed(new ViewEvent(e, this));
    }

    public abstract void updateView();

    public abstract void formatChanged();

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

