
/*
 * Computer Algebra Kit (c) 1993,98 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: cfloat.h,v 1.5 1998/06/14 12:23:55 stes Exp $
 */

#ifndef __CAFLOAT_HEADER__
#define __CAFLOAT_HEADER__

#include "cobject.h"

typedef float float_t;

@interface Float : CAObject
{
  float_t value;
}

+ new;
+ floatValue:(float)floatValue;
+ str:(STR)aString;

- (unsigned) hash;
- (BOOL) isEqual:b;
- (float) floatValue;
- floatValue:(float)f;

- (int) sign;
- (int) compare:b;

- zero;
- (BOOL) isZero;
- (BOOL) isOpposite:b;
- negate;
- double;
- add:b;
- subtract:b;

- one;
- minusOne;
- (BOOL) isOne;
- (BOOL) isMinusOne;
- square;
- multiply:b;
- inverse;
- divide:b;

- (BOOL) printsLeadingSign;
- printOn:(IOD)aFile;
@end

#endif				/* __CAFLOAT_HEADER__ */

