// DialogReal.cpp : implementation file
//

#include "stdafx.h"
#include "OzAPI.h"
#include "DialogReal.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDialogReal dialog


CDialogReal::CDialogReal(CWnd* pParent /*=NULL*/)
	: CDialog(CDialogReal::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDialogReal)
	m_text = _T("");
	m_value = 0.0f;
	//}}AFX_DATA_INIT
}


void CDialogReal::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDialogReal)
	DDX_Text(pDX, IDC_DLG_REAL_TEXT, m_text);
	DDX_Text(pDX, IDC_DLG_REAL_VALUE, m_value);
	DDV_MinMaxFloat(pDX, m_value, m_min, m_max);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDialogReal, CDialog)
	//{{AFX_MSG_MAP(CDialogReal)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDialogReal message handlers




///////////////////  FORTRAN /////////////////////////////////////

extern "C" float ozrealdlg (char* prompt, float* min, float* max, float* initial)
{
	CDialogReal  dlg;
	float result;

	dlg.m_text = prompt;
	dlg.m_value = *initial;
	dlg.m_min = *min;
	dlg.m_max = *max;
	if (*min > *max)
		OzFatalError ("ozrealdlg - illegal range");
	if (*initial < *min || *initial > *max)
		OzFatalError ("ozintdlg - illegal default");
	if (dlg.DoModal() == IDOK)
	{
		result = dlg.m_value;
	}


	return(result);
}

void CDialogReal::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	this->GetDlgItem(IDC_DLG_REAL_VALUE)->SetFocus();

	
	// Do not call CDialog::OnPaint() for painting messages
}
