// OzAPI.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "OzAPI.h"

#include "MainFrm.h"
#include "OzAPIDoc.h"
#include "OzAPIView.h"

#include	"OzFTN.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


// for menus


#define MAX_ITEM	20
#define	MAX_PULLDOWN	10

long	menuID[MAX_PULLDOWN+1][MAX_ITEM+1];
long	popupID[MAX_ITEM+1];
short	numPullDown;
short	numItem[MAX_PULLDOWN+1];
short	numPopup;


CMenu*	pPopupMenu;	



/////////////////////////////////////////////////////////////////////////////
// COzAPIApp

BEGIN_MESSAGE_MAP(COzAPIApp, CWinApp)
	//{{AFX_MSG_MAP(COzAPIApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
	ON_COMMAND_RANGE(IDM_MENUSTART, IDM_MENUSTOP, OnMenu)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COzAPIApp construction

COzAPIApp::COzAPIApp()
{
	InitMenu();
	pPopupMenu = NULL;
}

/////////////////////////////////////////////////////////////////////////////
// The one and only COzAPIApp object

COzAPIApp theApp;

/////////////////////////////////////////////////////////////////////////////
// COzAPIApp initialization

BOOL COzAPIApp::InitInstance()
{
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	CSingleDocTemplate* pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(COzAPIDoc),
		RUNTIME_CLASS(CMainFrame),       // main SDI frame window
		RUNTIME_CLASS(COzAPIView));
	AddDocTemplate(pDocTemplate);

	// Enable DDE Execute open
	EnableShellOpen();
	RegisterShellFileTypes(TRUE);

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// Dispatch commands specified on the command line
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	// Enable drag/drop open
	m_pMainWnd->DragAcceptFiles();

	// Fortran initialisation
	//OZINIT();


	return TRUE;
}
//////////////////////// Exit//////////////////////////

int COzAPIApp::ExitInstance() 
{
	// TODO: Add your specialized code here and/or call the base class

	OZSTOP();
	
	return CWinApp::ExitInstance();
}

/////////////////////////////////////////////////////////////////////////////
//	message handler
void COzAPIApp::OnMenu(UINT nID)
{
	long pd, item, id;
	int	which;

	which = nID - IDM_MENUSTART;

	if (which > 300)  // popup
	{
		pd = 0;
		item = which - 300;
		id = popupID[item-1];
	}
	else
	{
		pd = which / 25;
		item = which - 25*pd;
		id = menuID[pd][item-1];
	}
	OZMENUCB(&pd, &item, &id); // FORTRAN
}


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void COzAPIApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// COzAPIApp commands






/////////////////// MENUS !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

static	void	InitMenu()
{
	int	i;
	int	j;
	for (i=0; i<MAX_PULLDOWN+1; i++)
	{
		numItem[i] = 0;
		for (j=0; j<MAX_ITEM+1; j++)
		{
			menuID[i][j] = 0;
			popupID[j] = 0;
		}
	}
	numPullDown = 0;
	numPopup = 0;
}

extern "C" long ozaddmenuitem (long* pullDown, char* string, long* Id)
{
	CMenu*	pAddinMenu;
	CMenu*	pTopMenu;
	int		pd = *pullDown;
	short	item;
	int		msg;

	if (pd > MAX_PULLDOWN || pd < 1)
		OzFatalError ("ozaddmenuitem - illegal pulldown");
	item = numItem[pd];
	pTopMenu = AfxGetMainWnd()->GetMenu();
	if(!pTopMenu)
		OzFatalError ("ozaddmenuitem - couldnt get top menu");
	pAddinMenu = pTopMenu->GetSubMenu(pd);
	if(!pAddinMenu)
		OzFatalError ("ozaddmenuitem - couldnt get submenu");
	if (strncmp(string, "SEPARATOR", 9) == 0)
		pAddinMenu->AppendMenu(MF_SEPARATOR);
	else
	{
		if (numItem[pd] >= MAX_ITEM)
			OzFatalError ("ozaddmenuitem - illegal pulldown");
		menuID[pd][item] = *Id;
		item++;
		msg = IDM_MENUSTART + 25*pd + item;
		pAddinMenu->AppendMenu(MF_STRING, msg, string);
		numItem[pd] = item;
	}
return (item);
}

extern "C" long ozaddpulldown (char* string)
{
	CMenu*	pAddinMenu;
	CMenu*	pTopMenu;

	pAddinMenu = new CMenu;
	if (numPullDown >= MAX_PULLDOWN)
		OzFatalError ("ozaddpulldown - too many pulldowns");
	numPullDown++;
	pTopMenu = AfxGetMainWnd()->GetMenu();
	if (pAddinMenu->CreatePopupMenu() == 0)
		OzFatalError ("ozaddpulldown - couldnt create popup menu");
	pTopMenu->InsertMenu((UINT)numPullDown, MF_BYPOSITION|MF_STRING|MF_POPUP, 
							UINT(pAddinMenu->m_hMenu), string);
	AfxGetMainWnd()->DrawMenuBar();
	return (numPullDown);
}


extern "C" void ozclearpulldown (long* pullDown)
{
	CMenu*	pAddinMenu;
	CMenu*	pTopMenu;
	int		pd = *pullDown;
	int	item;

	if (pd > numPullDown || pd < 1)
		OzFatalError ("ozclearpulldown - illegal pulldown");
	item = numItem[pd];
	pTopMenu = AfxGetMainWnd()->GetMenu();
	pAddinMenu = pTopMenu->GetSubMenu(pd);
	ASSERT(pAddinMenu != NULL);
	while (item > 0)
	{
		item--;
		pAddinMenu->RemoveMenu(item, MF_BYPOSITION);
	}
	numItem[pd] = 0;
}


extern "C" void ozclearallmenus ()
{
	CMenu*	pTopMenu;
	long		pd;

	pTopMenu = AfxGetMainWnd()->GetMenu();
	for (pd=numPullDown; pd>0; pd--)
	{
		ozclearpulldown(&pd);
		pTopMenu->RemoveMenu(pd, MF_BYPOSITION);
	}
	InitMenu();
	AfxGetMainWnd()->DrawMenuBar();
}


extern "C" long ozaddpopupitem (char* string, long* Id)
{
	int		msg;

	if (pPopupMenu == NULL)
	{
		pPopupMenu = new CMenu;
		pPopupMenu->CreatePopupMenu();
	}
	if (numPopup >= MAX_ITEM)
		OzFatalError ("ozaddpopupitem - too many items");
	popupID[numPopup] = *Id;
	numPopup++;
	msg = IDM_MENUSTART + numPopup + 300;
	pPopupMenu->AppendMenu(MF_STRING, msg, string);
return (numPopup);
}

extern "C" void ozclearpopupmenu ()
{
	int	item;

	if (pPopupMenu)
	{
		item = numPopup;
		while (item > 0)
		{
			item--;
			pPopupMenu->RemoveMenu(item, MF_BYPOSITION);
		}
		numPopup = 0;
		delete (pPopupMenu);
		pPopupMenu = NULL;
	}

}


// note have to keep calling this if menu is to remain
extern "C" void ozdisplaypopup ()

{
	int	x = 200;
	int	y = 200;
	//CRect	rect(0, 0, 10000, 10000);

	if (pPopupMenu)
		pPopupMenu->TrackPopupMenu (TPM_LEFTALIGN|TPM_RIGHTBUTTON, x, y, AfxGetMainWnd());
}


//////////////////////// Message boxes ///////////////////////////////////////////////


// This is not available from FORTRAN!
extern "C" void OzFatalError (char* text)
{
	AfxMessageBox(text, MB_OK|MB_ICONSTOP);
	AfxAbort();
}


extern "C" long ozmessagebox (char* text, long* type, long* icon, long* button)
{
	UINT	nType;
	int		m;
	long	ret;

	if (*type == 1)
		nType = MB_ABORTRETRYIGNORE;
	else if (*type == 2)
		nType = MB_OK;
	else if (*type == 3)
		nType = MB_OKCANCEL;
	else if (*type == 4)
		nType = MB_RETRYCANCEL;
	else if (*type == 5)
		nType = MB_YESNO;
	else if (*type == 6)
		nType = MB_YESNOCANCEL;
	else
		OzFatalError ("ozmessagebox - invalid box type");

	if (*icon == 1)
		nType |= MB_ICONEXCLAMATION;
	else if (*icon == 2)
		nType |= MB_ICONINFORMATION;
	else if (*icon == 3)
		nType |= MB_ICONQUESTION;
	else if (*icon == 4)
		nType |= MB_ICONSTOP;
	else
		OzFatalError ("ozmessagebox - invalid icon type");

	if (*button == 1)
		nType |= MB_DEFBUTTON1;
	else if (*button == 2)
		nType |= MB_DEFBUTTON2;
	else if (*button == 3)
		nType |= MB_DEFBUTTON3;
	else
		OzFatalError ("ozmessagebox - invalid default button");

	m = AfxMessageBox(text, nType);
	if (m == IDABORT)
		ret = 1;
	else if (m == IDCANCEL)
		ret = 2;
	else if (m == IDIGNORE)
		ret = 3;
	else if (m == IDNO)
		ret = 4;
	else if (m == IDOK)
		ret = 5;
	else if (m == IDRETRY)
		ret = 6;
	else if (m == IDYES)
		ret = 7;
	else 
		ret = 0;

	return (ret);
}


//////////////////////  window title /////////////////////

extern "C" void oztitle (char* text)
{
	AfxGetMainWnd()->SetWindowText(text);
}


extern "C" void ozhelpcontents (char* fileName)
{
	DWORD dwData = 0;

	//theApp.WinHelp(dwData, HELP_CONTENTS);

	WinHelp(AfxGetMainWnd()->m_hWnd, fileName, HELP_CONTENTS, 0L);
}


extern "C" void ozhelpindex (char* fileName)
{
	DWORD dwData = 0;

	WinHelp(AfxGetMainWnd()->m_hWnd, fileName, HELP_INDEX, 0L);
}


extern "C" void ozabout ()
{
	theApp.OnAppAbout();
}



/////////////// Common dialogs ////////////////////////////////////////

extern "C" BOOL ozcolourdlg (float* red, float* green, float* blue, DWORD* dwCustColors )
{
	CHOOSECOLOR  cc;
	BYTE	r, b, g;
	BOOL	ret;
	cc.rgbResult = RGB((BYTE)255.5*(*red), (BYTE)255.5*(*green), (BYTE)255.5*(*blue));
	cc.Flags = CC_FULLOPEN | CC_RGBINIT;
	cc.lStructSize = sizeof(CHOOSECOLOR);
	cc.hwndOwner    = AfxGetMainWnd()->m_hWnd;

	cc.lpCustColors = (LPDWORD) dwCustColors ;
	cc.lCustData = 0;
	cc.lpfnHook = NULL;

	if (ret=ChooseColor(&cc))
	{
		r = (BYTE)cc.rgbResult;
		g = (BYTE)(cc.rgbResult >> 8);
		b = (BYTE)(cc.rgbResult >> 16);
		*red = (float)r / 255.0;
		*blue = (float)b / 255.0;
		*green = (float)g / 255.0;
	}

	return (ret);
}


// File common dialogs - hacked from Microsoft example

#define MAXBUF 300

#define MAXFILTERS     10
//#define MAXCUSTFILTER  MAXBUF
#define FILENAMESIZE   MAXBUF
//#define FILETITLESIZE  MAXBUF
#define DLGTITLESIZE   MAXBUF
#define INITDIRSIZE    MAXBUF
#define DEFEXTSIZE     40
//#define TEMPNAMESIZE   30



extern "C" BOOL ozfilename (BOOL* save, char* fileName, long* fileNameSize, 
							char* dlgTitle, char* defExt, char* initialDir,
							long* numPattern, char* filterName, long* nameSize,
							char* filterPattern, long* patternSize )
{
BOOL	ret;
OPENFILENAME ofn ;
//TCHAR szFileTitle[FILETITLESIZE]  ;
TCHAR szDlgTitle[DLGTITLESIZE]    ;
TCHAR szFileName[FILENAMESIZE]    ;
TCHAR szInitialDir[INITDIRSIZE]   ;
TCHAR szDefExt[DEFEXTSIZE]        ;
//TCHAR szTempName[TEMPNAMESIZE]    ;

TCHAR szFilterInits[MAXFILTERS][30] ;
TCHAR szFilterString[MAXBUF] ;
LPTSTR lpszFilterString ;

DWORD dwFlags ;
int i = 0 ;
int nInc = 0 ;
char* nPtr;
char* pPtr;
int f;
LPTSTR lpStr = szFilterString ;
int num;

	if (*numPattern < 1 || *numPattern > MAXFILTERS)
		OzFatalError ("ozfilename - illegal num filters");
	if (*fileNameSize < 256 || *fileNameSize > FILENAMESIZE)
		OzFatalError ("ozfilename - illegal num filters");

   szFileName[0] = 0 ;
   //szFileTitle[0] = 0 ;

   dwFlags = OFN_READONLY | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |OFN_OVERWRITEPROMPT ;

   lstrcpy(szDlgTitle, TEXT(dlgTitle)) ;
   lstrcpy(szDefExt, TEXT(defExt)) ;
   //lstrcpy(szInitialDir, TEXT("c:\\")) ;
   lstrcpy(szInitialDir, TEXT(initialDir)) ;
   //lstrcpy(szTempName, TEXT("opentemp1")) ;
   if (strncmp(fileName, "NONE", 4) == 0)
		szFileName[0] = '\0';
   else
		lstrcpy(szFileName, TEXT(fileName)) ;
	nPtr = filterName;
	pPtr = filterPattern;
	f = 0;
	for (i=0; i<*numPattern; i++)
	{
		lstrcpy(&szFilterInits[f++][0], TEXT(nPtr)) ;
		nPtr += *nameSize;
		lstrcpy(&szFilterInits[f++][0], TEXT(pPtr)) ;
		pPtr += *patternSize;
	}
   szFilterInits[f][0] = (TCHAR) 0 ;




  /* First, zero out this memory just for the sake of sanity */

  for (i=0; i<MAXBUF; i++)
    szFilterString[i] = 0 ;


  /* Now, for each string in the szFilterInits array, concatenate it to
     the last one right after the last one's null terminator */

  i = 0 ;

  while (szFilterInits[i][0] != (TCHAR) 0)
  {
    lstrcpy(lpStr, &szFilterInits[i][0]) ;
    nInc+=lstrlen(&szFilterInits[i][0]) + 1 ;   //1 past null term...
    lpStr = &szFilterString[nInc] ;
    i++ ;
  }

  szFilterString[nInc] = (TCHAR) 0 ;  //double terminator


  /* Set the lpszFilterString to point to the memory we just filled in
     with the filters because lpszFilterString is what is in
     OPENFILENAME->lpstrFilter */

  lpszFilterString = szFilterString ;


   ofn.lStructSize          = sizeof(OPENFILENAME) ;
   ofn.hwndOwner            = AfxGetMainWnd()->m_hWnd ;
   ofn.hInstance            = NULL ;
   ofn.lpstrFilter			= lpszFilterString ;
   ofn.lpstrCustomFilter    = NULL ;
   ofn.nMaxCustFilter       = 0;
   ofn.nFilterIndex         = 1L ;
   ofn.lpstrFile            = szFileName ;
   ofn.nMaxFile             = FILENAMESIZE ;
   ofn.lpstrFileTitle       = NULL ;
   ofn.nMaxFileTitle        = 0 ;
   ofn.lpstrInitialDir      = szInitialDir ;
   ofn.lpstrTitle			= szDlgTitle ;
   ofn.Flags                = dwFlags ;
   ofn.nFileOffset          = 0 ;
   ofn.nFileExtension       = 0 ;
   ofn.lpstrDefExt			 = szDefExt;
   ofn.lCustData            = 0L ;
   ofn.lpfnHook             = 0 ;
   ofn.lpTemplateName		= NULL ;

   if (!(*save))
        ret = GetOpenFileName(&ofn) ;
  else
      ret = GetSaveFileName(&ofn) ;

  if (ret)
  {
		num = strlen(szFileName);
		strcpy(fileName, szFileName);
  }
  else
		num = 0;
	for (i=num; i<*fileNameSize; i++)
		fileName[i] = ' ';

	return (ret);
}

