#define NOCOMM                  // No communication drivers
#define NOMINMAX                // min() and max() macros
#define NOPROFILER              // Profiler related macros
#define NOATOM
#define NODBCS                  // No double byte character set
#define NODEFERWINDOWPOS
#define NOWH                    // No window hooks
#include <windows.h>


static HINSTANCE hInst;
static HWND hwndLogo, hwndParent;
static char classname[] = "panview:logo";

LRESULT CALLBACK _export LogoWndProc(HWND hwnd, UINT message, WPARAM wParam,
                                     LPARAM lParam);

static HPALETTE CreateDIBPalette(LPBITMAPINFO lpbmi)
{
  LPBITMAPINFOHEADER lpbi;
  LPLOGPALETTE lpPal;
  HANDLE hLogPal;
  HPALETTE hPal = NULL;
  int i,iNumColors;

  lpbi = (LPBITMAPINFOHEADER)lpbmi;
  if (lpbi->biBitCount <= 8)
    iNumColors = (1 << lpbi->biBitCount);
  else
    iNumColors = 0;     // No palette needed for RGB DIB (15, 16 or 32 bits)

  if (iNumColors) {
    hLogPal = GlobalAlloc(GHND, sizeof(LOGPALETTE)+sizeof(PALETTEENTRY)*iNumColors);
    lpPal = (LPLOGPALETTE)GlobalLock(hLogPal);
    lpPal->palVersion    = 0x300;
    lpPal->palNumEntries = iNumColors;

    for (i = 0;  i < iNumColors;  i++) {
      lpPal->palPalEntry[i].peRed   = lpbmi->bmiColors[i].rgbRed;
      lpPal->palPalEntry[i].peGreen = lpbmi->bmiColors[i].rgbGreen;
      lpPal->palPalEntry[i].peBlue  = lpbmi->bmiColors[i].rgbBlue;
      lpPal->palPalEntry[i].peFlags = 0;
    } /* for */
    hPal = CreatePalette (lpPal);
    GlobalUnlock (hLogPal);
    GlobalFree   (hLogPal);
  } /* if */
  return hPal;
}

static HBITMAP LoadResourceBitmap(HINSTANCE hInstance, LPSTR lpString,
                                  HPALETTE FAR* lphPalette)
{
  HRSRC hRsrc;
  HGLOBAL hGlobal;
  HBITMAP hBitmapFinal = 0;
  LPBITMAPINFOHEADER lpbi;
  HPALETTE hpalOrg;
  HDC hdc;
  int iNumColors;

  if ((hRsrc=FindResource(hInstance,lpString,RT_BITMAP)) != 0) {
    hGlobal = LoadResource(hInstance, hRsrc);
    lpbi = (LPBITMAPINFOHEADER)LockResource(hGlobal);

    if (lpbi->biBitCount<=8 && lpbi->biClrUsed==0)
      iNumColors = (1 << lpbi->biBitCount);
    else if (lpbi->biClrUsed!=0)
      iNumColors = lpbi->biClrUsed;
    else
      iNumColors = 0;   // No palette needed for RGB DIB (15, 16 or 32 bits)
    hdc = GetDC(NULL);
    if (lphPalette) {
      *lphPalette = CreateDIBPalette((LPBITMAPINFO)lpbi);
      hpalOrg=SelectPalette(hdc,*lphPalette,FALSE);
      RealizePalette(hdc);
    } /* if */

    hBitmapFinal = CreateDIBitmap(hdc, (LPBITMAPINFOHEADER)lpbi, CBM_INIT,
                                  (LPSTR)lpbi + (int)lpbi->biSize + iNumColors*sizeof(RGBQUAD),
                                  (LPBITMAPINFO)lpbi, DIB_RGB_COLORS);
    // clean up
    SelectPalette(hdc,hpalOrg,TRUE);
    ReleaseDC(NULL,hdc);
    #if defined __WIN32__
      UnlockResource(hGlobal);
    #endif
    FreeResource(hGlobal);
  } /* if */
  return hBitmapFinal;
}

HWND CreateLogo(HINSTANCE hInstance, HWND hwnd)
{
static init=FALSE;
  WNDCLASS wc;

  hInst=hInstance;
  hwndParent=hwnd;
  if (!init) {
    wc.style = 0;
    wc.lpfnWndProc = LogoWndProc;
    wc.cbClsExtra = 0;                  // No per-class extra data.
    wc.cbWndExtra = 0;                  // No per-window extra data.
    wc.hInstance = hInstance;           // Application that owns the class.
    wc.hIcon = NULL;
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = NULL;
    wc.lpszMenuName = NULL;
    wc.lpszClassName = classname;       // Name used in call to CreateWindow.
    if (!RegisterClass(&wc))            // Quit on error
      return FALSE;
    init=TRUE;
  } /* if */
  CreateWindow(classname, "", WS_POPUP | WS_VISIBLE,
               CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,
               hwnd, NULL, hInstance, NULL);
  if (IsWindow(hwndLogo))
    UpdateWindow(hwndLogo);
  return hwndLogo;
}

LRESULT CALLBACK _export LogoWndProc(HWND hwnd, UINT message, WPARAM wParam,
                                     LPARAM lParam)
{
static HBITMAP hbm;
  PAINTSTRUCT ps;
  HDC hdc, hdcMem;
  int x, y;
  BITMAP bm;
  RECT rect;

  switch (message) {
  case WM_CHAR:
    DestroyWindow(hwnd);
    break;
  case WM_LBUTTONUP:
    DestroyWindow(hwnd);
    break;

  case WM_CREATE:
    hwndLogo=hwnd;
    hbm=LoadResourceBitmap(hInst,"Logo",NULL);
    // Center the window inside the main window
    GetWindowRect(hwndParent,&rect);
    GetObject(hbm, sizeof(BITMAP), &bm);
    x = (rect.right - rect.left - bm.bmWidth) / 2 + rect.left;
    y = (rect.bottom - rect.top - bm.bmHeight) / 2 + rect.top;
    SetWindowPos(hwnd, 0, x, y, bm.bmWidth, bm.bmHeight, SWP_NOZORDER);
    EnableWindow(hwndParent,FALSE);
    break;

  case WM_DESTROY:
    EnableWindow(hwndParent,TRUE);
    DeleteObject(hbm);
    hwndLogo=0;
    break;

  case WM_PAINT:
    hdc = BeginPaint(hwnd, &ps);
    GetObject(hbm, sizeof(BITMAP), &bm);
    hdcMem = CreateCompatibleDC(hdc);
    hbm = SelectObject(hdcMem, hbm);
    BitBlt(hdc, 0, 0, bm.bmWidth, bm.bmHeight, hdcMem, 0, 0, SRCCOPY);
    hbm = SelectObject(hdcMem, hbm);
    DeleteDC(hdcMem);
    EndPaint(hwnd, &ps);
    break;

  default:
    return DefWindowProc(hwnd, message, wParam, lParam);
  } /* switch */
  return 0;
}

