/*
 * Decompiled with CFR 0.152.
 */
package stec.ss;

import stec.ss.ssBuffer;
import stec.ss.ssException;
import stec.ss.ssProgram;
import stec.ss.ssSystem;
import stec.ss.ssToken;

final class ssTokenizer {
    private static final String _ = "Copyright (c) 1997-1999 Manuel J. Goyenechea. All rights reserved.";
    private ssSystem system;
    private ssBuffer source;
    private int currentTokenOffset;
    private int nextTokenOffset;
    private int mark;
    protected String sValue;
    protected int iValue;

    protected ssTokenizer(ssProgram ssProgram2) {
        this.system = ssProgram2.system;
        this.source = ssProgram2.getSource();
        this.currentTokenOffset = 0;
        this.nextTokenOffset = 0;
        this.mark = 0;
    }

    protected final int mark() {
        this.mark = this.currentTokenOffset;
        return this.mark;
    }

    protected final int reset() {
        this.currentTokenOffset = this.mark;
        this.mark = 0;
        return this.currentTokenOffset;
    }

    protected final int reset(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > this.source.length()) {
            n = this.source.length();
        }
        this.currentTokenOffset = n;
        this.mark = 0;
        return this.currentTokenOffset;
    }

    protected final byte getNextToken() throws ssException {
        byte by = this.peekAtNextToken();
        this.currentTokenOffset = this.nextTokenOffset;
        return by;
    }

    protected final void incrementTokenOffset() {
        this.currentTokenOffset = this.nextTokenOffset;
    }

    protected final byte peekAtNextToken() throws ssException {
        this.nextTokenOffset = this.currentTokenOffset;
        if (this.nextTokenOffset < this.source.length()) {
            if (this.system.gProcessor == 3) {
                return this.peekAtNextStatementToken();
            }
            if (this.system.gInStatement) {
                return this.peekAtNextStatementToken();
            }
            return this.peekAtNextDataBlock();
        }
        return -1;
    }

    private final byte peekAtNextStatementToken() throws ssException {
        byte by;
        int n;
        byte by2 = this.source.getByteAt(this.nextTokenOffset);
        switch (by2) {
            case 13: {
                ++this.nextTokenOffset;
                return 13;
            }
            case 10: {
                ++this.nextTokenOffset;
                return 10;
            }
            case 59: {
                ++this.nextTokenOffset;
                return 59;
            }
            case 46: {
                return this.parseDot();
            }
            case 35: {
                if (this.nextTokenOffset != 0 || this.system.gCurrentLineNumber != 1) break;
                return this.parseCommand();
            }
        }
        char c = (char)by2;
        if (Character.isDigit(c)) {
            return this.parseNumber();
        }
        if (Character.isLetter(c) || "@$_".indexOf(c) != -1) {
            return this.parseSymbol();
        }
        if ("\t ".indexOf(c) != -1) {
            return this.parseDelimiter();
        }
        if ("'\"".indexOf(c) != -1) {
            return this.parseString();
        }
        if (this.system.gProcessor != 3 && by2 == 37 && (n = this.nextTokenOffset + 1) < this.source.length() && (by = this.source.getByteAt(n)) == 62) {
            this.system.gInStatement = false;
            this.nextTokenOffset += 2;
            return 66;
        }
        return this.parseOther();
    }

    private final byte peekAtNextDataBlock() throws ssException {
        int n = 0;
        int n2 = this.nextTokenOffset;
        while (this.nextTokenOffset < this.source.length()) {
            byte by = this.source.getByteAt(this.nextTokenOffset);
            if (by == 10) {
                ++n;
            } else if (by == 60) {
                int n3 = this.nextTokenOffset + 1;
                if (n3 >= this.source.length()) break;
                if (this.source.getByteAt(n3) == 37) {
                    this.nextTokenOffset += 2;
                    this.system.gInStatement = true;
                    int n4 = this.nextTokenOffset - n2 - 2;
                    if (n4 > 0) {
                        this.iValue = n;
                        this.sValue = new String(this.source.getByteArray(), n2, n4);
                        return 48;
                    }
                    return 66;
                }
            } else if (by == 35 && this.nextTokenOffset == 0 && this.system.gCurrentLineNumber == 1) {
                return this.parseCommand();
            }
            ++this.nextTokenOffset;
        }
        if (this.nextTokenOffset == n2) {
            return -1;
        }
        this.iValue = n;
        this.sValue = new String(this.source.getByteArray(), n2, this.nextTokenOffset - n2);
        return 48;
    }

    private final byte parseNumber() throws ssException {
        char c;
        int n = 50;
        int n2 = this.nextTokenOffset;
        while (this.nextTokenOffset < this.source.length()) {
            if (!Character.isDigit((char)this.source.getByteAt(this.nextTokenOffset))) break;
            ++this.nextTokenOffset;
        }
        if (this.source.getByteAt(this.nextTokenOffset) == 46) {
            ++this.nextTokenOffset;
            while (this.nextTokenOffset < this.source.length()) {
                if (!Character.isDigit((char)this.source.getByteAt(this.nextTokenOffset))) break;
                ++this.nextTokenOffset;
            }
            if (this.source.getByteAt(this.nextTokenOffset - 1) != 46) {
                n = 52;
            } else {
                c = (char)this.source.getByteAt(this.nextTokenOffset);
                if (Character.isLetter(c) || "@$_".indexOf(c) != -1) {
                    --this.nextTokenOffset;
                }
            }
        }
        c = this.nextTokenOffset - n2;
        if (n == 50 && this.source.getByteAt(this.nextTokenOffset - 1) == 46) {
            --c;
        }
        this.sValue = new String(this.source.getByteArray(), n2, (int)c);
        return (byte)n;
    }

    private final byte parseDelimiter() {
        ++this.nextTokenOffset;
        while (this.nextTokenOffset < this.source.length()) {
            if ("\t ".indexOf(this.source.getByteAt(this.nextTokenOffset)) == -1) break;
            ++this.nextTokenOffset;
        }
        return 32;
    }

    private final byte parseString() throws ssException {
        byte by = this.source.getByteAt(this.nextTokenOffset);
        ++this.nextTokenOffset;
        int n = this.nextTokenOffset;
        while (this.nextTokenOffset < this.source.length()) {
            if (this.source.getByteAt(this.nextTokenOffset) == by) {
                this.sValue = new String(this.source.getByteArray(), n, this.nextTokenOffset - n);
                ++this.nextTokenOffset;
                return 51;
            }
            ++this.nextTokenOffset;
        }
        throw new ssException(12, "end of file", String.valueOf((char)by));
    }

    private final byte parseSymbol() throws ssException {
        String string;
        byte by;
        int n = this.nextTokenOffset++;
        while (this.nextTokenOffset < this.source.length()) {
            char c = (char)this.source.getByteAt(this.nextTokenOffset);
            if (!Character.isLetterOrDigit(c) && "@$_".indexOf(c) == -1) break;
            ++this.nextTokenOffset;
        }
        if ((by = ssToken.bToken(string = new String(this.source.getByteArray(), n, this.nextTokenOffset - n))) == -1) {
            by = 49;
            this.sValue = string.toLowerCase();
        }
        return (byte)by;
    }

    private final byte parseDot() throws ssException {
        int n = this.nextTokenOffset + 1;
        if (n < this.source.length() && Character.isDigit((char)this.source.getByteAt(n))) {
            return this.parseNumber();
        }
        ++this.nextTokenOffset;
        return 46;
    }

    private final byte parseCommand() throws ssException {
        this.iValue = 0;
        ++this.nextTokenOffset;
        while (this.nextTokenOffset < this.source.length()) {
            if (this.source.getByteAt(this.nextTokenOffset) == 10) {
                ++this.nextTokenOffset;
                this.iValue = 1;
                break;
            }
            ++this.nextTokenOffset;
        }
        if (this.iValue == 1) {
            return 116;
        }
        return 66;
    }

    private final byte parseOther() throws ssException {
        byte by;
        int n;
        int n2 = 0;
        byte by2 = this.source.getByteAt(this.nextTokenOffset);
        if (by2 == 47) {
            int n3 = this.nextTokenOffset + 1;
            if (n3 < this.source.length()) {
                byte by3 = this.source.getByteAt(n3);
                if (by3 == 42) {
                    return this.parseCommentBlock();
                }
                if (by3 == 47) {
                    return this.parseComment();
                }
            }
        } else if (by2 == 60) {
            int n4 = this.nextTokenOffset + 1;
            if (n4 < this.source.length()) {
                byte by4 = this.source.getByteAt(n4);
                if (by4 == 61) {
                    this.nextTokenOffset += 2;
                    n2 = 54;
                } else if (by4 == 62) {
                    this.nextTokenOffset += 2;
                    n2 = 53;
                }
            }
        } else if (by2 == 62 && (n = this.nextTokenOffset + 1) < this.source.length() && (by = this.source.getByteAt(n)) == 61) {
            this.nextTokenOffset += 2;
            n2 = 55;
        }
        if (n2 == 0) {
            n2 = ssToken.bToken(by2);
            if (n2 == -1) {
                throw new ssException(8, "token", String.valueOf((char)by2));
            }
            ++this.nextTokenOffset;
        }
        return (byte)n2;
    }

    private final byte parseCommentBlock() throws ssException {
        int n = 0;
        ++this.nextTokenOffset;
        while (this.nextTokenOffset < this.source.length()) {
            byte by = this.source.getByteAt(this.nextTokenOffset);
            if (by == 10) {
                ++n;
            } else if (by == 42) {
                int n2 = this.nextTokenOffset + 1;
                if (n2 >= this.source.length()) break;
                if (this.source.getByteAt(n2) == 47) {
                    this.nextTokenOffset += 2;
                    if (n == 0) {
                        return 39;
                    }
                    this.iValue = n;
                    return 116;
                }
            }
            ++this.nextTokenOffset;
        }
        throw new ssException(12, "end of file", "*/");
    }

    private final byte parseComment() {
        ++this.nextTokenOffset;
        while (this.nextTokenOffset < this.source.length()) {
            if (this.source.getByteAt(this.nextTokenOffset) == 10) break;
            ++this.nextTokenOffset;
        }
        return 39;
    }
}

