@echo off
rem STLFilt.BAT: Toggle STL Error decryption filtering
rem
rem Part of the STL Error Message Decryptor package
rem Written by Leor Zolman (leor@bdsoft.com)
rem
rem usage:
rem		STLFilt on         - turn on STL filtering
rem		STLFilt off		   - turns off STL filtering
rem		STLFilt			   - displays current status
rem
rem Works in conjuction with CL.CPP: If CL.EXE sees %FILT_FILE% in existence,
rem then output of CL2.EXE is filtered through the Perl script. Else, it is not.

rem The following pathname must match the base name of the FILT_FILE setting in CL.CPP:
rem (E.g., if FILT_FILE in CL.CPP is set to FILTERING.ON, set FILE_BASE to FILTERING)
set TOGGLE_BASE=C:\FILTERING

if "%1" == "" goto prereport
if "%1" == "on" goto turnon
if "%1" == "off" goto turnoff

echo.
echo To change STL filtering mode, use:
echo    stlfilt [on or off]
echo.
:prereport
echo Current setting:
goto report

:turnon
if exist %TOGGLE_BASE%.off del %TOGGLE_BASE%.off > nul:
if not exist %TOGGLE_BASE%.ON echo This file enables STL error decryption. > %TOGGLE_BASE%.ON
goto report

:turnoff
if exist %TOGGLE_BASE%.ON del %TOGGLE_BASE%.ON > nul:
if not exist %TOGGLE_BASE%.OFF echo This file disables STL error decryption. > %TOGGLE_BASE%.OFF
goto report

:report
if exist %TOGGLE_BASE%.ON echo STL Filtering is ON.
if exist %TOGGLE_BASE%.OFF echo STL Filtering is OFF.
if exist %TOGGLE_BASE%.ON goto done
if exist %TOGGLE_BASE%.OFF goto done
echo STL Filtering has never been specified. It is OFF by default.
:done
