#define	VXWORKS	0		/* 1 for VxWorks, 0 for MacOS                            */
#define	MCOS 	0		/* 1 for Mercury MCOS, 0 for MacOS                       */
#define  TWIN 1        /* 1 for MacOS, 0 for Windows */
#define	BIG	0			/* 1 for rotating timing buffers, 0 for static addresses */
#define	STATIC	0		/* 1 for static memory allocation, 0 for run-time malloc */
#define NMAX    16384	/* Largest test vector size allowed                      */
#if BIG
#define	STATIC	0		/* BIG => force dynamic memory allocation	*/
#endif
#if ((VXWORKS)&&(MCOS))
#define	MCOS	0		/* can't have it both ways					*/
#endif

/* USPL Big Wrapper Timer                                                   */
/*                                                                          */
/* Usage:   big_timer [npts]                                                */
/*                                                                          */
/* HISTORY:                                                                 */
/* When         Who                 What									*/
/* Mar 31 1998	Bill Fincke         Created for Mercury SAL under MCOS      */
/* Nov 19 1998  Bill Fincke         Ported to MacOS, VxWorks for USPL       */
/*                                                                          */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#if VXWORKS
#include <ticLib.h>
#include <sysLib.h>
#else
#include <time.h>
#endif
#include "uspl.h"

/* below line added 12/10/98 RDK */
void timer(char *name, float ptime2, float ptime3, void (*funct)(), long npt);

	double align;
#if STATIC
	float b1[NMAX],b2[NMAX],b3[NMAX];
	float cwts[NMAX*2];
	long ib[8192];
#else
	unsigned long alignment;
	float *b1, *b2, *b3;
	float *cwts;
	long *ib;
#if BIG
	float *S[32],*D[32];
#endif
#endif
	float *cs1, *cs2, *cso;
	float rs1, rs2, rs3, rs4, rso;
	double *dv1, *dvo;
	float *rv, *rv1, *rv2, *rv3, *rv4, *rvo, *rvio, *rvt;
	float *cv1, *cv2, *cv3, *cvo, *cvio, *cvt;
	long *iv1, *iv2, *ivo;
	short int *sv1, *svo;
	char *bv1, *bvo;
	long inc=1, inc1=1, inc2=1, inc3=1, inc4=1, inco=1, incio=1;
	long flg=1, flg1=1, flg2=1;
	long no = 1024, ndf = 1;
	float z=0, a=1.0, b=2.0, c=3, d=1, rm1=-1, rp1=1;
	long i1=1,i2=2, idx;
int n1=1, n2=2, n8=8, n16=16, n32=32, n64=64, n128=128, n256=256, n512=512;
int n1k=1024, n2k=2048, n4k=4096, n8k=8192, n16k=16384;
int n100=100, n300=300;
int npts=1024;

/*-- define macros to initialize inputs ---*/
#if BIG
#define INIT_INPUTS(X)						\
for(j=0;j<8;j++)							\
   for(i=0; i<NMAX; i++)S[j][i] = (X);
#else
#define INIT_INPUTS(X)						\
for(i=0; i<NMAX; i++)b1[i]=(X);
#endif

#if BIG
#define INIT_DOUBLE(X)						\
for(j=0;j<8;j++)							\
   {										\
	dv1=(double*)S[j];						\
	for(i=0; i<npts; i++)dv1[i] = (X);		\
	}
#else
#define INIT_DOUBLE(X)						\
for(i=0; i<npts; i++)dv1[i]=(X);
#endif
/* changed to void_big_timre_funcs.h 12/10/98 RDK */
#include "void_big_timer_funcs.h"

main (argc, argv)
int argc;
char *argv[];
{
        static char sccsid[] = "@(#)timer.c	1.60\t7/21/93 USPL";
long i,j;

#if ((!VXWORKS)&&(!MCOS) && (!TWIN))
/* get command line arguments from CodeWarrior */
	argc = ccommand(&argv);
#endif

/*	Get argument (test vector size) if any	*/

if (argc>1)
	{
	i = strtol(argv[1],0,0);
	if ((i>16) && (i<=NMAX)) npts = i;
	}
else
	npts = n1k;		/* default is 1k	*/

#if !STATIC
i = NMAX*2;				/* nominal size of b1	*/
j = 512*512;			/* room required for mxmov(512x512)	*/
i = (i < j) ? j : i;	/* make sure we have enough room for mxmov! */
printf("malloc %d floats for b1\n",i);
b1 = (float *)malloc(i*sizeof(float));
b2 = (float *)malloc(NMAX*2*sizeof(float));
b3 = (float *)malloc(NMAX*2*sizeof(float));
cwts = (float *)malloc(NMAX*2*sizeof(float));
ib = (long *)malloc(8192*sizeof(long));
printf ("Address of b1=%X b2=%X b3=%X cwts=%X ib=%X\n",b1,b2,b3,cwts,ib);
if ((long)b1%4!=0 || (long)b2%4!=0 || (long)b3%4!=0 || (long)cwts%4!=0 || (long)ib%4!=0)
{
   printf("Adress not 4 byte aligned. Exiting.\n");
   exit(-1);
}
   
if ((b1==(float *)0) || (b2==(float *)0) || (b3==(float *)0) ||
    (cwts==(float *)0) || (ib==(long *)0) )
   { printf("can't allocate buffer space - increase heap at runtime!\n"); exit(0);}
#if BIG
printf("\nrunning BIG version\n");
i = 32*(NMAX/2);		/* nominal size of S[i]	*/
j = 512*512;			/* room required for mxmov(512x512)	*/
if (i<j)				/* make sure we have enough room for mxmov! */
   { printf("NMAX = %d not big enough for 512x512 mxmov!\n",NMAX); exit(0);}
S[0] = S[8] = S[16] = S[24] = (float *)malloc(32*(NMAX/2)*sizeof(float));
if ((S[0]==(float *)0) )
		{ printf("can't allocate big S buffer space - increase heap at runtime!\n"); exit(0);}
for (i=1; i<8; i++)
	{
	S[i] = S[i-1] + NMAX*2;
	S[i+8] = S[i+16] = S[i+24] = S[i] ;
/* printf("S[%d],S[%d],S[%d],S[%d] = 0x%08x\n",i,i+8,i+16,i+24,S[i]); */
	}
D[0] = D[8] = D[16] = D[24] = (float *)malloc(32*(NMAX/2)*sizeof(float));
if ((D[0]==(float *)0) )
		{ printf("can't allocate big D buffer space - increase heap at runtime!\n"); exit(0);}
for (i=1; i<8; i++)
	{
	D[i] = D[i-1] + NMAX*2;
	D[i+8] = D[i+16] = D[i+24] = D[i] ;
/* printf("D[%d],D[%d],D[%d],D[%d] = 0x%08x\n",i,i+8,i+16,i+24,D[i]); */
	}
#else
printf("\nrunning SMALL version\n");
#endif
#endif

rv1 = rv2 = rv3 = rv4 = rvio = b1;
rvo = b2;
rvt = b3;
cv1 = cv2 = cv3 = cvio = b1;
cvo = b2;
cvt = b3;
cs1 = cs2 = b1;
cso = b2;
iv1 = iv2 = (long*)b1;
ivo = (long*)b2;
sv1 = (short int *)b1;
svo = (short int *)b2;
bv1 = bvo = (char*)b1;
bvo = (char*)b2;
dv1 = (double*)b1;
dvo = (double*)b2;
printf("\n\n");
printf("           CSPI     CSPI     Sigma    Sigma   Sigma    Sigma     Sigma\n");
printf("           SC 2     SC 3     \n");
printf("           Pub.     Pub.     Meas.    Ovhd.    Time   vs SC 2   vs SC 3\n");
printf("Funct     (ms/1K)  (ms/1K)  (ms/1K) (us/call) (ns/pt)  (%%)       (%%)\n"); 
a = 1.0;
printf("\n \n  USPL routines (%d-pt vectors): \n",npts);


INIT_INPUTS (.00001*i)
#define NOSKIP 1
#if NOSKIP
fftwts(cwts, n16, n16);
timer("CFFTF_16  ", .030, .032,*cfftf_time, n16);
fftwts(cwts, n64, n64);
timer("CFFTF_64  ", .080, .067,*cfftf_time, n64);
fftwts(cwts, n128, n128);
timer("CFFTF_128 ", .135, .113,*cfftf_time, n128);
fftwts(cwts, n256, n256);
timer("CFFTF_256 ", .229, .191,*cfftf_time, n256);
fftwts(cwts, n512, n512);
timer("CFFTF_512 ", .39 , .32 ,*cfftf_time, n512);
fftwts(cwts, n1k, n1k);
timer("CFFTF_1K  ", .80 , .650,*cfftf_time, n1k);
fftwts(cwts, n2k, n2k);
timer("CFFTF_2K  ", 2.9 ,2.300,*cfftf_time,  n2k);
fftwts(cwts, n4k, n4k);
timer("CFFTF_4K  ", 5.6 ,4.500,*cfftf_time,  n4k);
fftwts(cwts, n8k, n8k);
timer("CFFTF_8K  ", 12. ,9.500,*cfftf_time,  n8k);
timer("CFFTSC_1K ", .12 , .011,*cfftsc_time, n1k);
fftwts(cwts, n64, n64);
timer("RFFTF_64  ", .029,  .023,*rfftf_time, n64);
fftwts(cwts, n128, n128);
timer("RFFTF_128 ", .058,  .046,*rfftf_time, n128);
fftwts(cwts, n256, n256);
timer("RFFTF_256 ", .115,  .092,*rfftf_time, n256);
fftwts(cwts, n512, n512);
timer("RFFTF_512 ", .23 ,  .18,*rfftf_time, n512);
fftwts(cwts, n1k, n1k);
timer("RFFTF_1K  ", .49 ,  .39,*rfftf_time, n1k);
fftwts(cwts, n2k, n2k);
timer("RFFTF_2K  ", .95 ,  .81,*rfftf_time,  n2k);
fftwts(cwts, n4k, n4k);
timer("RFFTF_4K  ", 3.9 ,  3.0,*rfftf_time,  n4k);
fftwts(cwts, n8k, n8k);
timer("RFFTF_8K  ", 7.4 ,  5.8,*rfftf_time,  n8k);
timer("RFFTSC_1K ", .064, .057,*rfftsc_time, n1k);
#endif	/* NOSKIP */
fftwts(cwts, 2*npts, 2*npts);
#if NOSKIP
timer("ACORF     ", 2.3 , 1.8 ,*acorf_time, npts);
INIT_INPUTS (.00001*i)
if (npts <= 2048)
    timer("ACORT     ", 27. ,22.0 ,*acort_time, npts);
else
    timer("ACORT 2K  ", 27. ,22.0 ,*acort_time, n2k);
timer("ASPEC     ", .12 , .10 ,*aspec_time, npts);
/* fftwts(cwts, npts, npts); */
timer("BLKMAN    ", 1.7 , 1.3 ,*blkman_time, npts);
timer("CCDOTP    ", .18 , 0.14,*ccdotp_time, npts);
/* removed due to excesive delay 12/10/98 RDK
timer("CCORF     ", 3.4 , 2.7, *ccorf_time, npts);
*/
INIT_INPUTS (.00001*i)
if (npts <= 2048)
    timer("CCORT     ", 27. , 22., *ccort_time, npts);
else
    timer("CCORT 2K  ", 27. , 22., *ccort_time, n2k);
timer("CDOTPR    ", .18 , .14, *cdotpr_time, npts);
timer("CONVD_32  ", .88 , .70, *convd_time, npts);
timer("CPOW      ", .15 , .12, *cpow_time, npts);
INIT_INPUTS (i+1)	/* don't divide 0/0!! */
timer("CRVDIV    ", .34 , .26, *crvdiv_time, npts);
timer("CRVMUL    ", .28 , .22, *crvmul_time, npts);
timer("CSPEC     ", .29 , .24, *cspec_time, npts);
timer("CVABS     ", .35 , .29, *cvabs_time, npts);
timer("CVADD     ", .19 , .15, *cvadd_time, npts);
timer("CVCML     ", .23 , .18, *cvcml_time, npts);
timer("CVCMLA    ", .30 , .24, *cvcmla_time, npts); 
timer("CVCOMB    ", .19 , .15, *cvcomb_time, npts);
timer("CVCONJ    ", .12 , .10, *cvconj_time, npts); 
timer("CVCSML    ", .18 , .14, *cvcsml_time, npts); 
timer("CVDIV     ", .47 , .37, *cvdiv_time, npts);
timer("CVEXP     ", 1.1 , .90, *cvexp_time, npts);
timer("CVFILL    ", .15 , .12, *cvfill_time, npts); 
timer("CVMA      ", .30 , .24, *cvma_time, npts);
timer("CVMAGS    ", .09 , .07, *cvmags_time, npts);
timer("CVMEXP    ", 1.3 , .97, *cvmexp_time, npts);
timer("CVMGSA    ", .13 , .10, *cvmgsa_time, npts);
timer("CVMUL     ", .23 , .18, *cvmul_time, npts);
timer("CVMLA     ", .30 , .24, *cvmla_time, npts);
timer("CVMOV     ", .12 , .10, *cvmov_time, npts); 
timer("CVMUL     ", .23 , .18, *cvmul_time, npts);
timer("CVNEG     ", .12 , .10, *cvneg_time, npts); 
timer("CVPHAS    ", 1.0 , .83, *cvphas_time, npts);
timer("CVRCIP    ", .47 , .38, *cvrcip_time, npts);
timer("CVREAL    ", .20 , .16, *cvreal_time, npts); 
timer("CVSMA     ", .24 , .20, *cvsma_time, npts);
timer("CVSMUL    ", .12 , .10, *cvsmul_time, npts);
timer("CVSQRT    ", 1.3 , 1.1, *cvsqrt_time, npts);
timer("CVSUB     ", .19 , .15, *cvsub_time, npts);
INIT_INPUTS (.00001*i)
timer("DEQ22     ", .24 , .20, *deq22_time, npts);
timer("DOTPR     ", .07 , .05, *dotpr_time, npts); 
/* fftwts(cwts, npts, npts); */
timer("ENVEL     ", 1.7 , 1.3, *envel_time, npts);
timer("FIX4      ", .12 , .09, *fix4_time, npts);
timer("FIX2N     ", .19 , .15, *fix2n_time, npts);
timer("FIX4N     ", .12 , .09, *fix4n_time, npts);
timer("FIXBN     ", .12 , .09, *fixbn_time, npts);
timer("FLT2      ", .14 , .11, *flt2_time, npts);
timer("FLT2IQ    ", .56 , .44, *flt2iq_time, npts);
timer("FLT4      ", .12 , .10, *flt4_time, npts);
timer("FLTB      ", .15 , .12, *fltb_time, npts);
timer("FLTBU     ", .11 , .088, *fltbu_time, npts); 
timer("FXSL2N    ", .33 , .26, *fxsl2n_time, npts);
timer("FXSL4N    ", .25 , .20, *fxsl4n_time, npts);
timer("FXSLBN    ", .32 , .25, *fxslbn_time, npts);
timer("GCOSF     ", .47 , .37, *gcosf_time, npts);
cs1[0]=0.70710671; cs1[1]=0.70710671;
cs2[0]=1.0; cs2[1]=0.0;
timer("GCEXP fast", .054 , .043, *gcexp_time, npts);
cs1[0]=0.92387952; cs1[1]=0.38268344;
timer("GCEXP slow", .108 , .086, *gcexp_time, npts);
fftwts(cwts, npts, npts);
timer("HAMM      ", .95 , .72, *hamm_time, npts);
timer("HANN      ", .95 , .72, *hann_time, npts);
timer("HLBRT     ", 1.2 , .93, *hlbrt_time, npts);
timer("LVEQ      ", .20 , .16, *lveq_time, npts);
timer("LVGE      ", .20 , .16, *lvge_time, npts);
timer("LVGT      ", .20 , .16, *lvgt_time, npts);
timer("LVLE      ", .20 , .16, *lvle_time, npts);
timer("LVLT      ", .20 , .16, *lvlt_time, npts);
timer("LVNE      ", .20 , .16, *lvne_time, npts);
timer("LVNOT     ", .17 , .13, *lvnot_time, npts);
timer("MAXMGV    ", .17 , .14, *maxmgv_time, npts);
timer("MAXV      ", .14 , .10, *maxv_time, npts);
timer("MEAMGV    ", .097 ,.080,*meamgv_time, npts); 
timer("MEANV     ", .042 ,.033,*meanv_time, npts); 
timer("MEASQV    ", .070 ,.056,*measqv_time, npts); 
timer("MINMGV    ", .17  ,.14, *minmgv_time, npts);
timer("MINV      ", .14  ,.11, *minv_time, npts);
#endif	/* NOSKIP */
timer("MVESSQ    ", .10  ,.080,*mvessq_time, npts);
INIT_INPUTS (.00001*i)
#ifdef MATRIX
timer("MXMLA_128 ", 59.  , 47.,*mxmla_time, npts); 
timer("MXMLS_128 ", 59.  , 47.,*mxmls_time, npts); 
timer("MXMOV_512 ", 55.  , 43.,*mxmov_time, npts);
timer("MXMUL_128 ", 59.  , 47.,*mxmul_time, npts);
#endif

#if NOSKIP
timer("POLAR     ", 1.6  ,1.3, *polar_time, npts);
timer("RECT      ", 1.3  ,1.0, *rect_time, npts);
/*
timer("RFZC      ", .09  ,072, *rfzc_time, npts);
*/
INIT_INPUTS (0.0)
rs1 = 1000.0;
timer("REQS      ", .087 ,.071,*reqs_time, npts);
rs1 = 1000.0;
timer("RGES      ", .087 ,.071,*rges_time, npts);
rs1 = 1000.0;
timer("RGTS      ", .087 ,.071,*rgts_time, npts);
rs1 = 0.0;
timer("RNES      ", .087 ,.071,*rnes_time, npts);
rs1 = 1000.0;
timer("REQS      ", .087 ,.071,*reqs_time, npts);
rs1 = -1000.0;
timer("RLTS      ", .089 ,.071,*rlts_time, npts);
timer("RMAX      ", .140 ,.11 ,*rmax_time, npts);
timer("RMAXMG    ", .170 , .14,*rmaxmg_time, npts);
INIT_INPUTS (0.0)
b1[0] = -1;
timer("RMIN      ", .140 , .11,*rmin_time, npts);
timer("RMINMG    ", .170 , .14,*rminmg_time, npts);
timer("RMSQV     ", .071 ,.056,*rmsqv_time, npts);
timer("RSVE 32   ", .13 , .10, *rsve_time, npts);
timer("SHPHU     ", .320 , .26,*shphu_time, npts);
timer("SHPHUF    ", .300 , .24,*shphuf_time, npts);
timer("SN2       ", .120 , .10,*sn2_time, npts);
rs1 = 1.0;
INIT_INPUTS (.00001*(i+1))
timer("SVDIV     ", .250 , .19,*svdiv_time, npts);
timer("SVE       ", .040 ,.032,*sve_time, npts);
timer("SVEMG     ", .096 ,.079,*svemg_time, npts);
timer("SVESQ     ", .069 ,.054,*svesq_time, npts);
timer("SVESSQ    ", .097 ,.080,*svessq_time, npts);
timer("TCONV     ", .890 ,.720,*tconv_time, npts);
timer("TRANS     ", .45 , .350,*trans_time, npts);
timer("VAAM      ", .20 , .16, *vaam_time, npts);
timer("VABS      ", .096, .078,*vabs_time, npts);
timer("VACOS     ", 1.50, 1.1, *vacos_time, npts);
timer("VADD      ", .098, .080,*vadd_time, npts);
timer("VAINT     ", .200, .160,*vaint_time, npts);
timer("VAM       ", .13 , .11, *vam_time, npts); 
timer("VANINT    ", .190, .15, *vanint_time, npts);
timer("VASBM     ", .20 , .16, *vasbm_time, npts);
timer("VASIN     ", 1.50, 1.1, *vasin_time, npts);
timer("VASM      ", .098, .081,*vasm_time, npts);
timer("VATAN     ", 1.00, .80, *vatan_time, npts);
timer("VATAN2    ", 1.0 , .81, *vatan2_time, npts);
timer("VATN2F    ", 1.0 , .81, *vatn2f_time, npts);
timer("VAVEXP    ", .100, .082,*vavexp_time, npts);
timer("VAVLIN    ", .100, .082,*vavlin_time, npts);
timer("VCLIP     ", .200, .160,*vclip_time, npts);
timer("VCLR      ", .048, .038,*vclr_time, npts); 
timer("VCMPRS    ", .150, .120,*vcmprs_time, npts); 
timer("VCOS      ", .650, .52, *vcos_time, npts);
timer("VCOSF     ", .460, .37, *vcosf_time, npts);
timer("VDBPWR    ", .800, .64, *vdbpwr_time, npts);
timer("VDIV      ", .28 , .220,*vdiv_time, npts);
#endif	/* NOSKIP */
INIT_DOUBLE (.00001*i)
timer("VDPSP     ", .091, .073,*vdpsp_time, npts);
INIT_INPUTS (.00001*i)
/*
timer("VEQV      ", .26 , .21, *veqv_time, npts);
*/
timer("VEUCL2    ", .46 , .36, *veucl2_time, npts);
timer("VEUCL3    ", .54 , .43, *veucl3_time, npts); 
INIT_INPUTS (.001*i)
timer("VEXP      ", .650, .52, *vexp_time, npts);
timer("VEXP2     ", .650, .52, *vexp2_time, npts);
timer("VEXP10    ", .640, .52, *vexp10_time, npts);
timer("VFILL     ", .048, .038,*vfill_time, npts);
timer("VFRAC     ", .220, .18, *vfrac_time, npts);
timer("VFRACN    ", .230, .18, *vfracn_time, npts);
for(i=0; i<npts; i++) ib[i] = i;
timer("VGATHR    ", .19 , .16, *vgathr_time, npts);
timer("VGEN      ", .075, .060,*vgen_time, npts);
timer("VIADD     ", .097, .08, *viadd_time, npts);
timer("VIAND     ", .230, .19, *viand_time, npts);
timer("VIARS     ", .180, .14, *viars_time, npts);
INIT_INPUTS (i)
timer("VICLIP    ", .350, .27, *viclip_time, npts);
timer("VILS      ", .180, .14, *vils_time, npts);
timer("VIMAG     ", .095, .076,*vimag_time, npts);
timer("VIMUL     ", .17 , .14, *vimul_time, npts);
INIT_INPUTS (i+1)
timer("VINDEX    ", .23 , .20, *vindex_time, npts);
timer("VINEG     ", .080, .065,*vineg_time, npts);
INIT_INPUTS (i)
timer("VINTB     ", .099, .081,*vintb_time, npts);
timer("VIOR      ", .23 , .19, *vior_time, npts);
timer("VIRS      ", .180, .14, *virs_time, npts);
timer("VISUB     ", .097, .08, *visub_time, npts);
timer("VIXOR     ", .230, .19, *vixor_time, npts);
timer("VLIM      ", .170, .14, *vlim_time, npts);
INIT_INPUTS (i)
timer("VLINT     ", .320, .250,*vlint_time, npts);
timer("VLMERG    ", .21 , .17, *vlmerg_time, npts); 
INIT_INPUTS (i+1)   // added +1 to prevent log 0 RDK
timer("VLOG      ", .800, .64, *vlog_time, npts);
timer("VLOG2     ", .800, .64, *vlog2_time, npts);
timer("VLOG10    ", .800, .64, *vlog10_time, npts);
timer("VMA       ", .13 , .11, *vma_time, npts);
timer("VMAX      ", .18 , .14, *vmax_time, npts);
timer("VMAXMG    ", .23 , .19, *vmaxmg_time, npts);
timer("VMIN      ", .17 , .14, *vmin_time, npts);
timer("VMINMG    ", .23 , .19, *vminmg_time, npts);
timer("VMMA      ", .20 , .16, *vmma_time, npts);
timer("VMMSB     ", .20 , .16, *vmmsb_time, npts);
timer("VMOV      ", .068, .053,*vmov_time, npts);
timer("VMSA      ", .098, .080,*vmsa_time, npts);
timer("VMSB      ", .13 , .11, *vmsb_time, npts);
timer("VMUL      ", .10 , .080,*vmul_time, npts);
timer("VNABS     ", .120, .10, *vnabs_time, npts);
timer("VNEG      ", .067, .053,*vneg_time, npts);
timer("VNMSA     ", .098, .080,*vnmsa_time, npts);
timer("VPMERG    ", .21 , .17, *vpmerg_time, npts);
timer("VPOLY     ", .29 , .23, *vpoly_time, npts);
timer("VQINT     ", .590, .480,*vqint_time, npts);
timer("VRAMP     ", .071, .057,*vramp_time, npts);
timer("VRAND     ", .320, .26, *vrand_time, npts);
timer("VREAL     ", .096, .076,*vreal_time, npts);
INIT_INPUTS (i+1)
timer("VRECIP    ", .240, .190,*vrecip_time, npts);
timer("VRSQRT    ", .310, .24, *vrsqrt_time, npts);
timer("VRVRS     ", .067, .053, *vrvrs_time, npts);
timer("VSADD     ", .067, .053,*vsadd_time, npts);
timer("VSBM      ", .13 , .11, *vsbm_time, npts);
timer("VSBSBM    ", .19 , .16, *vsbsbm_time, npts);
timer("VSBSM     ", .10 , .081,*vsbsm_time, npts);
INIT_INPUTS (i)
timer("VSCATR    ", .19 , .15, *vscatr_time, npts);
timer("VSDIV     ", .069, .054,*vsdiv_time, npts);
timer("VSIMPS    ", .170, .14, *vsimps_time, npts);
timer("VSIN      ", .780, .62, *vsin_time, npts);
timer("VSINF     ", .620, .48, *vsinf_time, npts);
timer("VSINRF    ", .240, .19, *vsinrf_time, npts);
timer("VSM2SA    ", .100, .080,*vsm2sa_time, npts);
timer("VSMA      ", .098, .080,*vsma_time, npts);
timer("VSMA2     ", .099, .080,*vsma2_time, npts);
timer("VSMA3     ", .130, .110,*vsma3_time, npts);
timer("VSMA4     ", .160, .140,*vsma4_time, npts);
timer("VSMSA     ", .068, .053,*vsmsa_time, npts);
timer("VSMSB     ", .098,.080, *vsmsb_time, npts);
timer("VSMUL     ", .068, .053,*vsmul_time, npts);
timer("VSPDP     ", .099, .081, *vspdp_time, npts);
timer("VSQ       ", .070, .053,*vsq_time, npts);
INIT_INPUTS (2.0)
timer("VSQRT     ", .320, .26, *vsqrt_time, npts); 
timer("VSSQ      ", .130, .11, *vssq_time, npts);
timer("VSUB      ", .099, .080,*vsub_time, npts);
timer("VSUM      ", .110, .085,*vsum_time, npts);
timer("VSWAP     ", .130, .10 ,*vswap_time, npts);
timer("VTABI     ", .450, .36, *vtabi_time, npts);
timer("VTAN      ", 1.80, 1.4, *vtan_time, npts);
timer("VTANF     ", 1.10, .84, *vtanf_time, npts);
timer("VTHR      ", .130, .10, *vthr_time, npts);
timer("VTHRES    ", .200, .160,*vthres_time, npts);
/*
timer("VTMERG    ", .200, .16, *vtmerg_time, npts);
*/
timer("VTRAPZ    ", .150, .12, *vtrapz_time, npts);
timer("VXCS      ", 1.20, .92, *vxcs_time, npts);
timer("VXCSF     ", 1.00, .83, *vxcsf_time, npts);
INIT_INPUTS (.001*(i-300/2))
timer("WIENER 100", 2.3, 3.0, *wiener_time, n100);
timer("WIENER 300", 20.70, 27.0, *wiener_time, n300);
printf("\nAll done.\n");fflush(stdout);
}

/* below line added 12/10/98 RDK */
void timer(char *name, float ptime2, float ptime3, void (*funct)(), long npt)
/*
timer(name, ptime2, ptime3, funct, npt)
char *name;
float ptime2, ptime3;
void funct();
long npt;
*/
{
#if MCOS
	float ftime;
#elif VXWORKS
	ULONG	starttime;
	ULONG	endtime;
#else
	clock_t	starttime;
	clock_t	endtime;
#endif
//	clock_t	time1, time2;
//	float	starttime;
//	float	endtime;
	double	overhead, elapsed, nanos;
	float	psc2, psc3;
	long i, iter, n1=1, npt1, ohpt=8;	/* ohpt=128; */
	long esize, osize;

// printf("\nptime2=%f npt=%d\n",ptime2,npt);
	esize = npt; osize = ohpt;
	if (funct==(void(*)())&mxmov_time)
		{
		npt = (npt>512) ? 512 : npt;
		esize = npt*npt; osize = ohpt*ohpt;
		ptime2 *= (float)(esize)/(float)(n512*n512);
		ptime3 *= (float)(esize)/(float)(n512*n512);
		iter = 1000/ptime2;
		}
	else if ((funct==(void(*)())&mxmul_time) ||
		(funct==(void(*)())&mxmla_time) ||
		(funct==(void(*)())&mxmls_time))
		{
		npt = (npt>128) ? 128 : npt;
		esize = npt*npt*npt; osize = ohpt*ohpt*ohpt;
		ptime2 *= (float)(esize)/(float)(n128*n128*n128);
		ptime3 *= (float)(esize)/(float)(n128*n128*n128);
		iter = 10000/ptime2;          
		}
	else if ((funct!=(void(*)())&cfftf_time) &&
		(funct!=(void(*)())&rfftf_time) &&
		(funct!=(void(*)())&rffti_time) &&
		(funct!=(void(*)())&wiener_time))
		{
		ptime2 *= (float)npt/(float)n1k;
		ptime3 *= (float)npt/(float)n1k;
		iter = 2000/ptime2;
		}
	else{
		iter = 2000/ptime2;
		}	
	iter = (iter+31)&(-32);		/* keep #iters a multiple of 32	*/
#if TIME_FFT
if (ptime2<.050) iter *= 100;
else if (ptime2<.300) iter *= 25;
#endif
	if (iter<=0)
		{
		printf("ptime2=%f iter=%d!\n",ptime2,iter);
		iter=32;
/*		exit(0);	*/
		}
	
/*	Measure time for vector */
#if MCOS
	tmr_start_timesec();
	funct(iter, npt);
	tmr_get_timesec(&ftime);
	elapsed = ftime*1000./iter; 
#elif VXWORKS
	starttime = tickGet();
	funct(iter, npt);
	endtime = tickGet();
	elapsed = (float)(endtime-starttime)*1000./iter/(float)sysClkRateGet(); 
#else
	starttime = clock();
	funct(iter, npt);
 	endtime = clock();
	elapsed = (float)(endtime-starttime)*1000./iter/(float)CLOCKS_PER_SEC; 
#endif
//	time1 = clock();
//	funct(iter, npt);
//	time2 = clock();
//	starttime = time1*(1000./CLOCKS_PER_SEC);
//	endtime = time2*(1000./CLOCKS_PER_SEC);
//	elapsed = (endtime-starttime)/iter; 

/*	Measure overhead by timing n/64 (16) point and solving equation */

	iter = iter*npt/ohpt;
#if MCOS
	tmr_start_timesec();
	funct(iter, ohpt);
	tmr_get_timesec(&ftime);
	overhead = ftime*1000./iter; 
#elif VXWORKS
	starttime = tickGet();
	funct(iter, ohpt);
	endtime = tickGet();
	overhead = (float)(endtime-starttime)*1000./iter/(float)sysClkRateGet();
#else
	starttime = clock();
	funct(iter, ohpt);
	endtime = clock();
	overhead = (double)(endtime-starttime)*1000.0/iter/(double)CLOCKS_PER_SEC;
#endif
//	time1 = clock();
//	funct(iter, ohpt);
//	time2 = clock();
//	starttime = time1*(1000./CLOCKS_PER_SEC);
//	endtime = time2*(1000./CLOCKS_PER_SEC);
//	overhead = (endtime-starttime)/iter;
// printf("iter=%d elapsed=%e npt=%d overhead=%e ohpt=%d\n",iter,elapsed,npt,overhead,ohpt);
	overhead = (elapsed-esize*overhead/osize)/(1.0-(double)esize/osize);
   /* added 12/10/98 RDK */
   if (overhead<0.0) overhead=0.0;
	nanos = (elapsed - overhead)/esize *1000000;
	overhead = overhead*1000;
	psc2 = ptime2/elapsed*100;
	psc3 = ptime3/elapsed*100;
	printf("\n%s%6.3f   %6.3f   %6.3f %6.1f    %6.1f   %6.1f   %6.1f",
		name, ptime2, ptime3, elapsed, overhead, nanos, psc2, psc3);
}
