/*  64decode.c
**
**  Decodes mime base-64 encoded attachment
**
**  DOS version. Must link with 64CODER.
**  Microsoft:  cl  64decode.c 64coder.c
**    Borland:  bcc 64decode.c 64coder.c
*/

#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <fcntl.h>
#include <string.h>
#include <ctype.h>

#include "64coder.h"

#define BYTE unsigned char
#define QUOTE 0x22

static int Debug = 0;

static long InBytes = 0;
static long OutBytes = 0;
static BYTE BinaryText[3];
static BYTE CodedText[4];
static int f1;
static int f2;

static char FileName[65];
static int  FileNameLen = 0;

static char Buffer[256];

static char *CTEstring = "Content-Transfer-Encoding:";
static char *CDAstring = "Content-Disposition: attachment;";

int ReadLine(
       char CharBuf[], /* Character buffer */
       int  MaxBytes,  /* Max bytes to read */
       char Mode)      /* 'B' for binary mode, 'T' for text mode */
{int  i;
 int  n;
 int  Count = 0;
 char c;
 while(1)
   {/* skip CRs */
    while(1)
      {n = read(f1,&c,1);
       if(n<0) return n;
       if(n==0) return Count;
       if(c!='\r') break;
      }
    if(c=='\n')
      {CharBuf[Count] = '\0';
       if(Count==0)
         {/* blank line returned in Text mode only */
          if(Mode=='B') continue;
          else return Count;
         }
       else return Count;
      }
    CharBuf[Count++] = (char)c;
    if(Count>=MaxBytes) return Count;
   }
}

int Search(int Start, char *String)
{int  i;
 int  n;
 char c1;
 char c2;
 int  Pos1;
 int  Pos2 = 0;
 Pos1 = Start;

 /* skip past any leading white space in Buffer */
 while(1)
   {c1 = (char) toupper((char)Buffer[Pos1]);
    if(c1=='\0') return 0;         /* no match */
    /* skip white space */
    if((c1!=' ')&&(c1!='\t')) break;
    Pos1++;
   }
 /* compare Buffer to String */
 while(1)
   {/* get next String character to match */
    c2 = String[Pos2++];
    if(c2=='\0') return Pos1;   /* reached end of string -> matched */
    /* get next buffer character */
    c1 = Buffer[Pos1++];
    //if(Debug)printf("(%c:%c)", c1,c2);
    if(c1=='\0') return 0;      /* no match */
    if(c1=='\t') c1 = ' ';
    /* compare chars */
    if(c1!=c2) return 0;        /* no match */
   } /* end-while */
}

void main(int argc, char *argv[])
{int i, n;
 int FoundBase64 = 0;       /* set TRUE when 'base64' found */
 int FoundFilename = 0;     /* set TRUE when 'filename' found */
 int BlankCnt = 0;
 int SlashPos = 0;
 char c;
 if((argc!=2)&&(argc!=3))
   {printf("Usage: 64decode <infile> [<outfile>]\n");
    exit(1);
   }
 f1 = open(argv[1],O_RDONLY|O_TEXT);
 if(f1==-1)
   {printf("Cannot open %c%s%c\n", QUOTE,argv[1],QUOTE );
    perror("Dos error");
    exit(1);
   }
 if(argc==3)
   {f2 = open(argv[2],O_RDWR|O_CREAT|O_TRUNC|O_BINARY);
    if(f2==-1)
      {printf("Cannot create %c%s%c\n", QUOTE,argv[2],QUOTE );
       perror("Dos error");
       exit(1);
      }
   }

 while(1)
   {n = ReadLine(Buffer, 256, 'T');
    //printf("[%s]\n",Buffer);
    if(n<0)
      {/* end of file */
       printf("EOF.\n");
       exit(1); //break;
      }
    if(n==0)
      {BlankCnt++;
       //printf("<Blank Line %d>\n",BlankCnt);
       /* found blank line */
       if(BlankCnt==7) break;
       else continue;
      }
    if(FoundBase64)
      {/* looking for filename */
       n = Search(0,CDAstring);
       //printf("(%d)",n);
       if(n>0)
         {n = Search(n,"filename=");
          //printf("(%d)",n);
          if(n>0)
            {/* found filename. locate last backslash if present */
             for(i=n;;i++)
               {c = Buffer[i];
                if(c=='\0') break;
                if(c=='\\') SlashPos = i;
               }
             /* adjust start position of filename */
             if(SlashPos>0) n = SlashPos;
             /* copy filename */
             n += 1;
             for(i=0;;i++)
               {c = Buffer[n+i];
                if(c=='\0') break;
                if(c=='"')
                  {FileName[FileNameLen] = '\0';
                   //printf("Extracting filename %c%s%c\n", QUOTE,FileName,QUOTE);
                   break;
                  }
                else FileName[FileNameLen++] = c;
               }
             break;
            }
         }
       else
         {printf("Missing filename.\n");
          exit(1);
         }
      }

    if(FoundFilename) break;

    /* still looking for "base64" */

    n = Search(0,CTEstring);
    //printf("(%d)",n);
    if(n>0)
      {/* found "Content-Transfer-Encoding" */
       n = Search(n,"base64");
       //printf("(%d)",n);
       if(n==0)
         {printf("Error: 'base64' not found\n");
          exit(1);
         }
       //printf("base64 found\n");
       FoundBase64 = 1;
       continue;
      }
   } /* end while */

 if(FoundBase64==0)
   {printf("%cBase64%c not found, cannot decode.\n",QUOTE,QUOTE);
    exit(1);
   }

 /* prepare output file */

 if(argc==3)
   {/* output filename specified on command line */
    strcpy(FileName,argv[2]);
   }
 else
   {/* filename not on command line */
    if(FileNameLen==0)
      {printf("Filename not found, using %cNONAME.BIN%c.\n",QUOTE,QUOTE);
       strcpy(FileName,"NONAME.BIN");
      }
    //printf("Opening %c%s%c for write\n", QUOTE,FileName,QUOTE);
    f2 = open(FileName,O_RDWR|O_CREAT|O_TRUNC|O_BINARY);
    if(f2==-1)
      {printf("Cannot create %c%s%c\n", QUOTE,FileName,QUOTE);
       perror("Dos error");
       exit(1);
      }
   }

 printf("Decoding to %c%s%c\n", QUOTE,FileName,QUOTE);

 /* decode */
 for(i=0;;i++)
   {/* read 4 bytes */
    BinaryText[1] = 0;
    BinaryText[2] = 0;
    BinaryText[3] = 0;
    n = ReadLine(CodedText,4,'B');
    if(CodedText[0]=='=') break;
    //printf(" [%d]\n",n);
    if(n<=0) break;
    InBytes += (long)n;
    OutBytes += 3L;
    //printf("[%c%c%c%c] --> ", CodedText[0], CodedText[1], CodedText[2], CodedText[3] );
    Decode64(&CodedText[0],&BinaryText[0]);
    //printf("[%x %x %x] \n", BinaryText[0], BinaryText[1], BinaryText[2] );
    n = write(f2,&BinaryText[0],3);
    if(n!=3)
      {printf("ERROR: write() returns %d\n",n);
       perror("Dos Error");
       exit(1);
      }
    /* display dot each 1024 bytes read (1024/4 = 256) */
    if((i%256)==0)printf(".");
    /* at end of coded text ? */
    if((CodedText[1]=='=')||
       (CodedText[2]=='=')||
       (CodedText[3]=='=')) break;
   }
 //printf("[%c%c%c%c]\n", CodedText[0], CodedText[1], CodedText[2], CodedText[3] );
 printf("\n%ld bytes read, %ld bytes written\n", InBytes, OutBytes);
 close(f1);
 close(f2);
 exit(0);
}

