#include <windows.h>
#include "commctrl.h"
#include "winzilla.h"

#include "resource.h"

void Regen(HWND hwnd);
void DrawGrid(HWND hwnd, int spacing);

//--- let's keep handles to our most important windows
HWND    app;
HWND    client;
HWND    toolbar;
HWND    iconbar;
HWND    status;

//--- in WinZilla, WinMain is treated just like main() in a DOS app
int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{
    HWND about_box;

    //--- the icon menu
    WZ_MENUMAP(icon_bar_menu)
    WZ_MAP("sketch.bmp",    ID_DRAW_SKETCH)
    WZ_MAP("line.bmp",      ID_DRAW_LINES)      
    WZ_MAP("circle.bmp",    ID_DRAW_CIRCLES)
    WZ_MAP("rect.bmp",      ID_DRAW_RECTANGLES)
    WZ_MAP("spline.bmp",    ID_DRAW_SPLINES)
    WZ_MAP("spray.bmp",     ID_DRAW_SPRAYPAINT)
    WZ_MAP("poly.bmp",      ID_DRAW_POLYGONS)
    WZ_MAP("text.bmp",      ID_DRAW_TEXT)
    WZ_MAP("bitmap.bmp",    ID_DRAW_BITMAP)
    WZ_MAP("brush.bmp",     ID_DRAW_BITMAPBRUSH)
    WZ_MAP("pen.bmp",       ID_SETTINGS_FILLCOLOR)
    WZ_MAP("fill.bmp",      ID_SETTINGS_PENSETTINGS)
    WZ_MAP("load.bmp",      ID_FILE_LOADDRAWING)
    WZ_MAP("save.bmp",      ID_FILE_SAVEDRAWING)
    WZ_ENDMAP

    WZ_MENUMAP(tool_bar_menu)
    WZ_MAP("tblayer.bmp",   ID_SETTINGS_LAYERS)
    WZ_MAP("tbpen.bmp",     ID_SETTINGS_PENSETTINGS)      
    WZ_MAP("tbfont.bmp",    ID_SETTINGS_SETFONT)
    WZ_MAP("~",             1)
    WZ_MAP("tbrev2.bmp",    ID_ANIMATION_REWIND)
    WZ_MAP("tbrev1.bmp",    ID_ANIMATION_BACKONE) 
    WZ_MAP("tbstop.bmp",    ID_ANIMATION_STOP)     
    WZ_MAP("tbplay.bmp",    ID_ANIMATION_PLAY)     
    WZ_MAP("tbff.bmp",      ID_ANIMATION_LASTFRAME)
    WZ_MAP("~",             1)
    WZ_MAP("tbhelp.bmp",    1)
    WZ_MAP("tbquit.bmp",    ID_FILE_QUIT)
    WZ_ENDMAP

    //--- initialize WinZilla
    WZ_Init(hInstance, "IDI_MEGADRAW");     

    //--- open the main window, uses no refresh function of it's own
    app = WZ_OpenWindow(WZ_DEFAULT, "MegaDraw: A WinZilla Template", NULL, WZ_NullFunc, FALSE);

    //--- use a menu bar we've designed in the resource editor
    WZ_SetMenubarFromResource(app, "MEGAMENU");

    //--- add a status bar
    status = WZ_CreateStatusBar(app, "MegaDraw is READY!");

    //--- add the top toolbar (100 columns, i.e. 1 row since there's only 10 icons)
    toolbar = WZ_AddIconBar(tool_bar_menu, 100, app);

    //--- make the toolbar autostretch (makes it unmovable)
    WZ_SetWindowState(toolbar, WZ_SIZE_PARENT_WIDTH);

    //--- add the left icon bar, 2 columns, owned by app
    iconbar = WZ_AddIconBar(icon_bar_menu, 2, app);

    //--- make it always fit precisely below the toolbar and above the status bar
    WZ_PositionWindow(iconbar, WZ_EXACTLY_AT(0), WZ_BELOW(toolbar), 
        WZ_EXACTLY_AT(WZ_GetWindowWidth(iconbar)), WZ_ABOVE(status));

    //--- lastly, make a client area
    WZ_Style = WZ_STYLE_SIMPLE;
    client = WZ_OpenWindow(WZ_DEFAULT, "", app, Regen, TRUE);

    //--- set up scroll bars for it
    WZ_SetAutoScroll(client, TRUE);

    //--- establish the client window position relative to the other windows
    WZ_PositionWindow(client, WZ_RIGHT_OF(iconbar), WZ_BELOW(toolbar), 
        WZ_RIGHT_OF(app), WZ_ABOVE(status));

    //--- display our about box before we get started
    about_box = WZ_OpenDialog("IDD_ABOUT", WZ_MODAL_DLG);
    do WZ_GetMenu(); while(WZ_LastCommand != IDOK);
    WZ_CloseDialog(about_box);

    //--- this is a local function I just wrote to draw the grid quickly
    DrawGrid(client, 10);

    //--- initialize the standard file types for file open/save dialogs
    WZ_FileFilter = "MegaDraw Project Files (*.MPF)\0*.mpf\0"  \
                    "MegaDraw Object Files (*.MOF)\0*.mof\0"   \
                    "All Files (*.*)\0*.*\0\0" ;

    WZ_InitFileTypes();

    
    //--- enter our main loop, loop until quit or close the app window
    do
    {
        WZ_GetMenu();   

        //--- to do: add your own code to deal with command selection
        //--- i.e:
        //--- switch(WZ_LastCommand)
        //--- {
        //---   case ID_FILE_LOADDRAWING:
        //---   ...

    }
    while ( (WZ_LastCommand != ID_FILE_QUIT) && (!WZ_AppDone));

    //--- close the main application window (automatically closes all others)
    WZ_CloseWindow(app);

    return WZ_WMsg.wParam;
}


//--- WinZilla will call this whenever the app window needs re-painted
void Regen(HWND hwnd)
{
    static int regen_count = 1;

    //--- note: you CANNOT user WZ_StartDrawing/WZ_StopDrawing in a
    //---       regen function.

    //--- clear a rectangle to draw text in (so text doesn't jumble up)
    WZ_SetFillColor(hwnd, rand());
    WZ_Rectangle(hwnd, 40, 15, 500, 45);

    //--- set a random color
    WZ_SetPenColor(hwnd, rand());

    //--- print some text to let you know we were here
    WZ_Print(hwnd, 50, 20, 
        "You've regenerated this window %d times.", regen_count);

    //--- keep track of the count
    regen_count++;
}

//--- simple function to draw a grid in a window at high speed
void DrawGrid(HWND hwnd, int spacing)
{
    int x, y;
    int w, h;

    //--- draw a grid
    //--- (note: WZ_StartDrawing/WZ_StopDrawing are not required, but it greatly
    //---        reduces the amount of time it takes to draw the grid)
    
    //--- set the pen to gray
    WZ_SetPenColor(hwnd, RGB(64,64,64));

    //--- draw the grid
    WZ_StartDrawing(hwnd);

    w = GetSystemMetrics(SM_CXSCREEN);
    h = GetSystemMetrics(SM_CYSCREEN);

    for (x = 0; x < w; x += spacing)
        for (y = 0; y < h; y += spacing)
            WZ_PutPixel(hwnd, x, y);

    //--- finished drawing, draw the results
    WZ_StopDrawing(hwnd);   
}