
/*  io.h

    Definitions for low level I/O functions.

*/

#ifndef __IO_H
#define __IO_H

#ifndef __DEFS_H__
#include <defs.h>
#endif

#ifndef __TIME_H
#include <time.h>
#endif

#define _NFILE_ 40 /* SHOULD BE SAME AS IN STDIO.H */

#define FILENAME_MAX 265

extern  unsigned    RTL_NORM  _nfile;

#define HANDLE_MAX   (_NFILE_)

struct  ftime   {
    unsigned    ft_tsec  : 5;   /* Two second interval */
    unsigned    ft_min   : 6;   /* Minutes */
    unsigned    ft_hour  : 5;   /* Hours */
    unsigned    ft_day   : 5;   /* Days */
    unsigned    ft_month : 4;   /* Months */
    unsigned    ft_year  : 7;   /* Year */
};

struct _finddata_t
{
 unsigned attrib;  /* Attributes, see constants above. */
 time_t  time_create;
 time_t  time_access; /* always midnight local time */
 time_t  time_write;
 unsigned long size;
 char  name[FILENAME_MAX]; /* may include spaces. */
};


#define SEEK_CUR    1
#define SEEK_END    2
#define SEEK_SET    0

#ifdef __cplusplus
extern "C" {
#endif
int  RTL_NORM  access  (const char *path, int amode);
int  RTL_NORM   chmod   (const char *__path, int __amode);
int  RTL_NORM   chsize  (int __handle, long __size);
int  RTL_NORM  close   (int __handle);
int  RTL_NORM  creat   (const char *__path, int __amode);
int  RTL_NORM   dup   (int __handle);
int  RTL_NORM   dup2  (int __oldhandle, int __newhandle);
int  RTL_NORM  eof     (int __handle);
long RTL_NORM  filelength(int __handle);
int  RTL_NORM   getftime(int __handle, struct ftime *__ftimep);

int  RTL_NORM   isatty(int __handle);
int  RTL_NORM     lock  (int __handle, long __offset, long __length);
int  RTL_NORM     locking(int __handle, int __mode, long __length);
long RTL_NORM  lseek (int __handle, long __offset, int __fromwhere);
char * RTL_NORM  mktemp( char *__template );
#ifdef __IN_OPEN
int  RTL_NORM     open  ();
#else
int  RTL_NORM     open  (const char *__path, int __access,... /*unsigned mode*/);
#endif
int  RTL_NORM    read  (int __handle, void *__buf, unsigned __len);
int  RTL_NORM  remove(const char *__path);
int  RTL_NORM    rename(const char *__oldname,const char *__newname);
int  RTL_NORM   setftime(int __handle, struct ftime *__ftimep);
int  RTL_NORM     setmode(int __handle, int __amode);

#ifdef __IN_SOPEN
int  RTL_NORM   sopen ();
#else
int  RTL_NORM   sopen (const char *__path, int __access, int __shflag,
                      ... /* unsigned mode */);
#endif
long RTL_NORM   tell  (int __handle);
unsigned RTL_NORM         umask (unsigned __cmask);
int  RTL_NORM  unlink(const char *__path);
int  RTL_NORM     unlock(int __handle, long __offset, long __length);
int  RTL_NORM    write (int __handle, const void *__buf, unsigned __len);

int RTL_NORM _findfirst (const char* szFilespec, struct _finddata_t* find);
int RTL_NORM _findnext (int nHandle, struct _finddata_t* find);
int RTL_NORM _findclose (int nHandle);

#ifdef __cplusplus
}
#endif


#if !defined(RC_INVOKED)

/* Obsolete functions */
#pragma obsolete _chmod
#pragma obsolete _close
#pragma obsolete _creat
#pragma obsolete _open
#pragma obsolete _read
#pragma obsolete _write

#endif  /* !RC_INVOKED */


#endif  /* __IO_H */