/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <io.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <Errno.h>
#include <libp.h>
#include <sys/stat.h>
extern char _uidrives[HANDLE_MAX] ;
extern int _uiflags[HANDLE_MAX] ;

int _fstat(int handle, struct _stat *__statbuf)
{
   int hand ;
   
   hand = _uiohandle(handle) ;
   if (hand < 0)
      return -1 ;

   memset (__statbuf,0,sizeof (*__statbuf)) ;

   __statbuf->st_mode = 0 ;

   if (isatty(handle)) {
      __statbuf->st_mode |= S_IFCHR ;
      __statbuf->st_rdev = __statbuf->st_dev = handle ;
   } else {
      __statbuf->st_mode = S_IREAD ;
      if (_uiflags[handle] & UIF_WRITEABLE)
         __statbuf->st_mode |= S_IWRITE ;
      __statbuf->st_mode |= S_IFREG ;
      __statbuf->st_rdev = __statbuf->st_dev = _uidrives[handle] ;
      if ((__statbuf->st_size = filelength(handle)) == -1) {
         errno = EBADF ;
         return -1 ;
      }
   }
   __statbuf->st_nlink = 1 ;

   /* llstat will return times */
   return _ll_stat(hand, __statbuf) ;
}
int fstat(int handle, struct stat *__statbuf)
{
   return _fstat(handle, (struct _stat *)__statbuf) ;
}
int _stat(char *path, struct _stat *__statbuf)
{
   int fd = open(path,O_RDONLY,0) ;
   if (fd >= 0) {
      int rv = _fstat(fd, __statbuf) ;
      close(fd) ;
      return rv ;
   } else {
      errno = EBADF ;
      return -1 ;
   }
   
}
int stat(char *path, struct stat *__statbuf)
{
   return _stat(path, (struct _stat *)__statbuf) ;
}