# KEHOME/src/ke.mk
# Apr/25/2003

EXT	 = .exe
KEHOME	 = ..

ICONT	 = icont # -q
WICONT	 = wicont.exe

IVERSION = $(KEHOME)/bin/iversion
KE	 = $(KEHOME)/bin/ke
KSC	 = $(KEHOME)/bin/ksc
HTMLONE	 = $(KEHOME)/bin/htmlone

TAP2MKR	 = $(KEHOME)/bin/tap2mkr

WKE	 = $(KEHOME)/bin/wke$(EXE)
WKSC	 = $(KEHOME)/bin/wksc$(EXE)

OBJECT = \
ExtractLetter.u \
stub_fattrib.u \
action.u aka.u alias.u assignment.u \
begin.u believe.u birth.u bselist.u \
cache.u child.u char.u check.u chit.u \
command.u concept.u context.u convert.u \
database.u definition.u delete.u dewey.u dir.u dollar.u \
entropy.u event.u everydo.u \
fparam.u \
ged.u google.u group.u \
help.u hfun.u hier.u hop.u html.u hwalk.u \
ifthen.u init.u integrate.u \
knit.u \
marry.u menu.u method.u \
mgeneral.u mlist.u mount.u mword.u myio.u \
name.u newid.u newword.u nvlist.u nvstack.u \
param.u part.u pplist.u \
question.u \
reduce.u relation.u replace.u reqseq.u role.u \
search.u sentence.u shell.u statement.u symbol.u systype.u \
tap.u token.u \
unparse.u utility.u \
wildcard.u window.u word.u \
xml.u

# Unicon rules for MKS make & Linux make
#%.u:	%.icn
#	$(ICONT) -c $^

# Unicon rules for SFU Interix make
.SUFFIXES: .icn .u
.icn.u:
	$(ICONT) -c $<

#==================================================#

all: $(KE) $(KSC) $(IVERSION)

object:
	$(ICONT) -c *.icn

clean:
	rm -f *.u? $(IVERSION) $(KE) $(KSC)


$(KE): kelink.icn ke.u $(OBJECT)
	$(ICONT) -o $(KE) kelink.icn

$(KSC): ksclink.icn ksc.u $(OBJECT)
	$(ICONT) -o $(KSC) ksclink.icn

$(IVERSION): iversion.icn
	$(ICONT) -o $(IVERSION) iversion.icn


#==================================================#

SemanticWeb: $(HTMLONE)

$(HTMLONE): htmlone.icn
	$(ICONT) -o $(HTMLONE) htmlone.icn

$(TAP2MKR): tap2mkrlink.icn tap2mkr.u $(OBJECT)
	$(ICONT) -o $(TAP2MKR) tap2mkrlink.icn


#==================================================#
# obsolete

wke: wobject $(WKE) $(WKSC)

wobject:
	$(WICONT) -c *.icn

$(WKE): kelink.icn ke.u $(OBJECT)
	$(WICONT) -o $(WKE) kelink.icn

$(WKSC): ksclink.icn ksc.u $(OBJECT)
	$(WICONT) -o $(WKSC) ksclink.icn
