// KEHOME/java/mkrPutData.java
// Aug/26/2003
// usage: java -DKBFILE=kbfile mkrPutData subject predicate object

import edu.stanford.TAP.Abbrev;
import edu.stanford.TAP.Client;
import edu.stanford.TAP.Resource;
import edu.stanford.TAP.XML;
import edu.stanford.TAP.KB;

import edu.stanford.TAP.KB_MemHash;
import edu.stanford.TAP.Import_Guess;
import edu.stanford.TAP.Export_RDF;
import edu.stanford.TAP.Export_MCF;
import java.io.*;

public class mkrPutData
{

    // put the path to the kb you want to modify here. or pass it in.
    public static final String kbFile = System.getProperty("KBFILE");

/**
*	assert statement to TAP kbFile
*/
    public static void main(String argv[])
    {
	String info  = "# INFO: mkrPutData: ";
	String debug = "no";
	String flags = "";

	String subject   = argv[0];
	String predicate = argv[1];
	String object    = argv[2];

	if (debug == "yes") {
	  System.out.println(info + "subject = "   + subject);
	  System.out.println(info + "predicate = " + predicate);
	  System.out.println(info + "object = "    + object);
	}

	put_data(subject,predicate,object);

    } // end main()


/**
*	MKE interface to TAP PutData()
*/
    public static void put_data(
	String subject,
	String predicate,
	String object
    )
    {
	String info  = "# INFO: put_data: ";
	String debug = "no";
	String flags = "";
	
	String uriSubject = Qname.GetNameURI(subject);
	String uriPredicate = Qname.GetNameURI(predicate);
	String uriObject = Qname.GetNameURI(object);

	if (debug == "yes") {
	  System.out.println("# INFO: PutData: kbFile = "       + kbFile);
	  System.out.println("# INFO: PutData: uriSubject = "   + uriSubject);
	  System.out.println("# INFO: PutData: uriPredicate = " + uriPredicate);
	  System.out.println("# INFO: PutData: uriObject = "    + uriObject);
	}

	KB kb = new KB_MemHash();
	Import_Guess.LoadFile(kb, kbFile);
	kb.Assert(uriSubject,uriPredicate,uriObject);
	FileOutputStream out = null;
	try {
            out = new FileOutputStream(kbFile);
	}
	catch(FileNotFoundException e) {
            System.out.println("Couldn't open output file " + kbFile);
            return;
	}
	if(kbFile.endsWith(".rdf")) {
            Export_RDF.DoSerialize(out, kb);
	}
	else if(kbFile.endsWith(".mcf")) {
            Export_MCF.DoSerialize(out, kb);
	}
	return;
    } // end put_data()

} // end class
