//<html><pre>
// KEHOME/java/getdata.java
// Sep/8/2003

// usage:
//	java getdata kbdata
//	subject predicate object
//	...
//	CONTROL-Z
//
// example:
//	java getdata http://tap.stanford.edu/data/
//	Person type ?
//	? subClassOf Person
//	CONTROL-Z

import java.io.*;
import java.util.*;
import java.util.regex.*;

import edu.stanford.TAP.Abbrev;
import edu.stanford.TAP.Client;
import edu.stanford.TAP.Resource;
import edu.stanford.TAP.XML;

/**
*	read TAP KB location from command line
*	create TAP KB client
*	read sentence(s) from standard input
*	parse to subject predicate object
*	get answer(s) from TAP KB
*	sort answer(s)
*	print answer(s)
*/
public class getdata
{
    public static void main(String argv[])
    //----------------------------------//
    throws IOException
    {
	String info      = "# INFO: getdata: ";
	String error     = "# ERROR: getdata: ";
	String debug     = "no";

	String Subflag   = "includeSubClasses=yes";
	String Superflag = "includeSuperClasses=yes";
	String flags     = "";

	//String kbdata = System.getProperty("KBDATA");
	String kbdata = argv[0];
	Client tap = new Client(kbdata);

	BufferedReader in = new BufferedReader(
		new InputStreamReader(System.in));
	String line = "";
for (
	int linenumber = 0;
	line != null;
	++linenumber
) {
	System.err.print("gd$ ");
	try {
		line = in.readLine();
	} catch(IOException e) {
		return;
	}
	if (line == null) return;
	if (debug == "yes") {
	  System.err.println(info + "line = " + line);
	}
	String[] sentence = Pattern.compile(" ").split(line);
	String subject   = sentence[0];
	String predicate = sentence[1];
	String object    = sentence[2];

	if (debug == "yes") {
	  System.err.println(info + "kbdata = "    + kbdata);
	  System.err.println(info + "subject = "   + subject);
	  System.err.println(info + "predicate = " + predicate);
	  System.err.println(info + "object = "    + object);
	}
	if (subject.equals("?")) {
		if (debug == "yes") System.err.println("# qtype = qsubject");
		flags = "inverse=yes";
		subject = object;
	} else if (predicate.equals("?")) {
		if (debug == "yes") System.err.println("# qtype = qverb");
		predicate = "arcs";
		flags = "inverse=no";
	} else if (object.equals("?")) {
		if (debug == "yes") System.err.println("# qtype = qobject");
		flags = "inverse=no";
	} else {
		if (debug == "yes") System.err.println("# qtype = unknown");
		System.err.println(error +
			"subject <"   + subject   + "> " +
			"predicate <" + predicate + "> " +
			"object <"    + object    + "> ");

		System.err.println("# usage: subject predicate ?");
		System.err.println("# usage: subject ? ?");
		System.err.println("# usage: ? predicate object");
		System.err.println("# usage: ? ? object");
		//return;
	}
	if (debug == "yes") {
	  System.err.println(info + "flags = "     + flags);
	}

	String[] answer = get_data(tap,subject,predicate,flags);
	int n = answer.length;
	if (n == 0) {
		System.err.println("  " + info + "count = " + n);
	} else if (predicate.equals("arcs")) {
		if (flags.equals("inverse=no")) {
			get_property_values(tap,subject,answer);
		} else {
			print_column(answer);
		}
	} else {
		print_column(answer);
	}
} // end for
	return;
    } // end main()

/**
*	print one answer per line
*/
    public static void print_column(String[] answer)
    //--------------------------------------------//
    {
	int n = answer.length;
	for(int x = 0; x < n; ++x) {
	    System.out.println("  " + answer[x]);
	}
	return;
    }
/**
*	print one line with comma separators
*/
    public static void print_line(String[] answer)
    //------------------------------------------//
    {
	int n = answer.length;
	for(int x = 0; x < n-1; ++x) {
	System.out.print(answer[x] + ", ");
	}
	System.out.println(answer[n-1]);
	return;
    }

/**
*	get all property values of subject
*/
    public static void get_property_values(
    //-----------------------------------//
	Client tap,
	String subject,
	String[] proplist
    )
    {
	String info  = "  # INFO: get_property_values: ";
	String debug = "no";
	String flags = "inverse=no";

	int n = proplist.length;
	for(int x = 0; x < n; ++x) {
	    String property = proplist[x];
	    if (debug == "yes") {
		System.out.println(info + "property = " + property);
	    }
	    if (property.equals("arcs")) continue;

	    String[] answer = get_data(tap,subject,property,flags);
	    System.out.print("  " + property + " = ");
	    print_line(answer);
	}
	return;
    } // end get_property_values()


/**
*	translate Qname to URIs
*	get data from TAP KB
*	sort data
*/
    public static String[] get_data(
    //----------------------------//
	Client tap,
	String subject,
	String predicate,
	String flags
    )
    {
	String tapuri = "http://tap.stanford.edu/data/";
	String info   = "  # INFO: get_data: ";
	String debug  = "no";

	if (debug == "yes") {
	  System.out.println(info + "subject = "   + subject);
	  System.out.println(info + "predicate = " + predicate);
	  System.out.println(info + "flags = "     + flags);
	}

	String uriSubject = Qname.GetNameURI(subject);
	String uriPredicate = Qname.GetNameURI(predicate);

	if (debug == "yes") {
	  System.out.println(info + "tapuri = "       + tapuri);
	  System.out.println(info + "uriSubject = "   + uriSubject);
	  System.out.println(info + "uriPredicate = " + uriPredicate);
	}
	Resource answer = tap.GetData(uriSubject,uriPredicate,flags);
	int n = answer.count();
	String[] mkrAnswer = new String[n];
	for(int x = 0; x < n; ++x) {
	        String tapAnswer = answer.item(x).value;
	        mkrAnswer[x] = XML.SplitNamespace(tapAnswer).tag;
	}
	Arrays.sort(mkrAnswer); // new AlphabeticComparator());
	return mkrAnswer;
    } // end get_data()

} // end class

//</pre></html>
