{***************************************************************}
{ FIBPlus - component library for direct access to Firebird and }
{ Interbase databases                                           }
{                                                               }
{    FIBPlus is based in part on the product                    }
{    Free IB Components, written by Gregory H. Deatz for        }
{    Hoagland, Longo, Moran, Dunst & Doukas Company.            }
{    mailto:gdeatz@hlmdd.com                                    }
{                                                               }
{    Copyright (c) 1998-2001 Serge Buzadzhy                     }
{    Contact: buzz@devrace.com                                  }
{                                                               }
{ ------------------------------------------------------------- }
{    FIBPlus home page      : http://www.fibplus.net/           }
{    FIBPlus support e-mail : fibplus@devrace.com               }
{ ------------------------------------------------------------- }
{                                                               }
{  Please see the file License.txt for full license information }
{***************************************************************}

unit EdFieldInfo;
{$i FIBPlus.inc}

interface

uses
 {$IFDEF MSWINDOWS}
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  FIBDatabase, pFIBDatabase, Db, FIBDataSet, pFIBDataSet, Grids,
  DBGrids, ExtCtrls, StdCtrls, DBCtrls, Buttons, Menus
   {$IFDEF D6+}, Variants {$ENDIF}
;
 {$ENDIF}
 {$IFDEF LINUX}
  Types, SysUtils, Classes, QGraphics, QControls, QForms, QDialogs,
  FIBDatabase, pFIBDatabase, Db, FIBDataSet, pFIBDataSet, QGrids,
  QDBGrids, ExtCtrls, StdCtrls, QDBCtrls, Buttons, Menus
,
  Variants;
 {$ENDIF}


type
  TfrmFields = class(TForm)
    pFIBTransaction1: TpFIBTransaction;
    qryFL: TpFIBDataSet;
    DataSource1: TDataSource;
    sbDBGrid1: TDBGrid;
    Panel1: TPanel;
    qryTabs: TpFIBDataSet;
    DataSource2: TDataSource;
    Panel2: TPanel;
    Panel3: TPanel;
    sbDBGrid2: TDBGrid;
    EdFilter: TEdit;
    btnCopyFields: TButton;
    qryTabFields: TpFIBDataSet;
    chFilt: TCheckBox;
    qryTabsRDBRELATION_NAME: TStringField;
    qrySPs: TpFIBDataSet;
    PopupMenu1: TPopupMenu;
    miTables1: TMenuItem;
    miProcedures1: TMenuItem;
    qrySPFields: TpFIBDataSet;
    miUserForms: TMenuItem;
    qrdBuffer: TpFIBDataSet;
    cmbKindObjs: TComboBox;
    procedure qryTabFieldsBeforeOpen(DataSet: TDataSet);
    procedure btnCopyFieldsClick(Sender: TObject);
    procedure chFiltClick(Sender: TObject);
    procedure qryFLFilterRecord(DataSet: TDataSet; var Accept: Boolean);
    procedure DataSource2DataChange(Sender: TObject; Field: TField);
    procedure miProcedures1Click(Sender: TObject);
    procedure qrySPFieldsBeforeOpen(DataSet: TDataSet);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure EdFilterChange(Sender: TObject);
    procedure qryFLAfterPost(DataSet: TDataSet);
    procedure qrySPsFilterRecord(DataSet: TDataSet; var Accept: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure cmbKindObjsChange(Sender: TObject);
    procedure qryFLAfterOpen(DataSet: TDataSet);
    procedure qryFLNewRecord(DataSet: TDataSet);
    procedure Panel3Resize(Sender: TObject);
  private
   procedure CopyTableFields;
  public
    { Public declarations }
  end;

var
  frmFields: TfrmFields;

procedure ShowFieldInfo( aDataBase:TFIBDatabase);

implementation

uses pFIBDataInfo, FIBConsts, StrUtil;

{$R *.dfm}


procedure ShowFieldInfo( aDataBase:TFIBDatabase);
begin
 frmFields:= TfrmFields.Create(Application);
 with frmFields do
 try
  qrySPs.DataBase:=aDataBase;
  qrySPFields.DataBase:=aDataBase;
  qryTabFields.DataBase:=aDataBase;
  qryTabs.DataBase:=aDataBase;
  qrdBuffer.DataBase:=aDataBase;
  qryFL.DataBase:=aDataBase;
  pFIBTransaction1.DefaultDataBase:=aDataBase;
  pFIBTransaction1.StartTransaction;
  qryTabFields.Open;
  qryTabs.Open;
  qrySPs.Open;
  qryFL.Open;
  Caption := SFieldInfoCaption + ' .' + aDataBase.DBName + ': FIB$FIELDS_INFO';
  ShowModal;
  ListTableInfo.ClearForDataBase(aDataBase)
 finally
  frmFields.Free
 end;
end;

procedure TfrmFields.qryTabFieldsBeforeOpen(DataSet: TDataSet);
begin
 with qryTabFields do begin
  if    DataSource2.DataSet=qryTabs then
   Params[0].asString:=qryTabs.Fields[0].asString
  else
   Params[0].asString:=qrySPs.Fields[0].asString
 end;
end;

procedure TfrmFields.CopyTableFields;
var Q:TFIBDataSet;
begin
 qryFL.DisableControls;
 if    DataSource2.DataSet=qryTabs then  Q:=qryTabFields
 else
   Q:=qrySPFields;
 with Q do try
   Close;Open; FetchAll; First;
   while not eof do begin
     if not qryFL.Locate
     ('TABLE_NAME;FIELD_NAME',
      VarArrayOf([DataSource2.DataSet.Fields[0].asString,Trim(Fields[0].asString)]),[loCaseInsensitive])
     then begin
      qryFL.Insert;
      qryFL.FieldByName('TABLE_NAME').asString:=DataSource2.DataSet.Fields[0].asString;
      qryFL.FieldByName('FIELD_NAME').asString:=Trim(Fields[0].asString);
      qryFL.FieldByName('VISIBLE').asInteger:=1;
      qryFL.FieldByName('TRIGGERED').asInteger:=0;            
      qryFL.Post;
     end;
     Next
   end;
 finally
  qryFL.EnableControls;
 end;
end;


procedure TfrmFields.btnCopyFieldsClick(Sender: TObject);
begin
 CopyTableFields
end;

procedure TfrmFields.chFiltClick(Sender: TObject);
begin
 qryFL.Filtered:=chFilt.Checked;
 qryFL.FN('TABLE_NAME').Visible:=not chFilt.Checked;
end;

procedure TfrmFields.qryFLFilterRecord(DataSet: TDataSet; var Accept: Boolean);
begin
 if chFilt.Checked then
   Accept:=AnsiUpperCase(DataSet.FieldByName('TABLE_NAME').asString)=
    AnsiUpperCase(sbDBGrid2.dataSource.DataSet.Fields[0].asString)
end;

procedure TfrmFields.DataSource2DataChange(Sender: TObject; Field: TField);
begin
 if chFilt.Checked then qryFL.RefreshFilters
end;

procedure TfrmFields.miProcedures1Click(Sender: TObject);
begin
 TMenuItem(Sender).Checked:= not TMenuItem(Sender).Checked;
 if Sender=miTables1  then begin
  miProcedures1.Checked:=not miTables1.Checked;
  miUserForms.Checked  :=false;
 end
 else
 if Sender=miProcedures1  then begin
    miTables1.Checked    :=not miProcedures1.Checked;
    miUserForms.Checked  :=false;
 end
 else
 if Sender=miUserForms  then begin
    miTables1.Checked      :=not miUserForms.Checked;
    miProcedures1.Checked  :=false;
 end ;
 if miTables1.Checked then
   DataSource2.DataSet:=qryTabs
 else
 if miProcedures1.Checked then
   DataSource2.DataSet:=qrySPs

end;

procedure TfrmFields.qrySPFieldsBeforeOpen(DataSet: TDataSet);
begin
 with qrySPFields do begin
   Params[0].asString:=qrySPs.Fields[0].asString
 end;
end;

procedure TfrmFields.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 qryFL.Transaction.Commit;
 qryFL.Filtered:=false;
 Action:=caFree; frmFields:=nil
end;

procedure TfrmFields.EdFilterChange(Sender: TObject);
begin
 with TPFibDataSet(sbDBGrid2.DataSource.DataSet) do begin
  Filtered:=not IsBlank(EdFilter.Text);
  RefreshFilters
 end;
end;

procedure TfrmFields.qryFLAfterPost(DataSet: TDataSet);
begin
 qryFL.Transaction.CommitRetaining;
end;

procedure TfrmFields.qrySPsFilterRecord(DataSet: TDataSet;
  var Accept: Boolean);
begin
  with DataSet do
   Accept:=Pos(Trim(EdFilter.text),
            AnsiUpperCase(FieldByName('RDB$RELATION_NAME').asString)
           )>0
end;

procedure TfrmFields.FormCreate(Sender: TObject);
begin
 cmbKindObjs.ItemIndex:=0;
  btnCopyFields.Hint := SFieldInfoCopyFieldsHint;
  btnCopyFields.Caption := SFieldInfoCopyFields;
  chFilt.Caption := SFieldInfoFilter;
  cmbKindObjs.Items.Add(SFieldInfoKindTables);
  cmbKindObjs.Items.Add(SFieldInfoProcedures);

  EdFilter.Hint := SFieldInfoFilterHint;
  sbDBGrid2.Hint := SFieldInfoGridHint;

  miTables1.Caption := SFieldInfoTablesItem;
  miProcedures1.Caption :=  SFieldInfoProcedureItem;
  miUserForms.Caption := SFieldInfoUserFormsItem;
end;

procedure TfrmFields.cmbKindObjsChange(Sender: TObject);
begin
 if qrySPFields.Database<>nil then
 with cmbKindObjs do
 case ItemIndex of
  1:
  begin
   miTables1.Checked:=False;
   miProcedures1.Checked:=True;
   DataSource2.DataSet:=qrySPs
  end;
 else
  DataSource2.DataSet:=qryTabs;
  miTables1.Checked:=True;
  miProcedures1.Checked:=False;
 end
end;

procedure TfrmFields.qryFLAfterOpen(DataSet: TDataSet);
var tf:TField;
begin
  tf:=qryFL.FN('FIB$VERSION');
  if tf<>nil then tf.Visible:=False;
end;

procedure TfrmFields.qryFLNewRecord(DataSet: TDataSet);
begin
 if chFilt.Checked then
  qryFL.FN('TABLE_NAME').asString:=sbDBGrid2.DataSource.DataSet.Fields[0].asString;
end;

procedure TfrmFields.Panel3Resize(Sender: TObject);
begin
  EdFilter.Width := Panel3.Width - 16;
  cmbKindObjs.Width := Panel3.Width - 16;
end;
end.
