static bool CanCopyFrame(LPDIRECT3DRMFRAME Idst,
                         LPDIRECT3DRMFRAME Isrc)
{
  //   :
  if (!Idst || !Isrc) return false;
  if (Idst == Isrc)   return false;

  LPDIRECT3DRMFRAME Iparent = NULL;
  Idst->GetParent(&Iparent);
  do {
     if (Iparent == Isrc) {
        RELEASE(Iparent);
        //   !
        return false;
     }
     LPDIRECT3DRMFRAME Iparent2 = NULL;
     Iparent->GetParent(&Iparent2);
     RELEASE(Iparent);
     Iparent = Iparent2;
  } while(Iparent);
  return true;
}//---------------------------------------------------------
static void CopyFrameRecursion(LPDIRECT3DRMFRAME Idst,
  LPDIRECT3DRMFRAME Isrc, bool clone)
{
  AnsiString name;
  if (!Idst || !Isrc) return;

  LPDIRECT3DRMVISUALARRAY IVisuals = NULL;
  Isrc->GetVisuals(&IVisuals);
  if (IVisuals) {
     DWORD size = IVisuals->GetSize();
     for (DWORD i = 0; i < size; i++) {
        LPDIRECT3DRMVISUAL Ivisual = NULL;
        IVisuals->GetElement(i, &Ivisual);
        //      
        //  :
        if (clone && IsBuilder(Ivisual)) {
           LPDIRECT3DRMVISUAL Ivnew = NULL;
           Ivisual->Clone(0, IID_IDirect3DRMVisual,
                                          (void **) &Ivnew);
           Idst->AddVisual(Ivnew);
           name = RMName(Ivisual);
           name += "_clone";
           Ivnew->SetName(name.c_str());
           Ivnew->Release();
        }
        //       , 
        //       
        //     :
        else
           if (!IsLight(Ivisual)) Idst->AddVisual(Ivisual);
        Ivisual->Release();
     }  IVisuals->Release();
  }

  //     :
  LPDIRECT3DRMFRAMEARRAY IFrames = NULL;
  Isrc->GetChildren(&IFrames);
  if (IFrames) {
     DWORD size = IFrames->GetSize();
     for (DWORD i = 0; i < size; i++) {
        LPDIRECT3DRMFRAME Iframe = NULL;
        LPDIRECT3DRMFRAME Ifnew  = NULL;
        IFrames->GetElement(i, &Iframe);

        Iframe->Clone(0, IID_IDirect3DRMFrame,
                                          (void **) &Ifnew);
        name = RMName(Iframe);
        name += "_clone";
        Ifnew->SetName(name.c_str());
        Idst->AddChild(Ifnew);
        CopyFrame(Ifnew, Iframe, clone);

        Iframe->Release();
        Ifnew->Release();
     }  IFrames->Release();
  }
}//---------------------------------------------------------
void CopyFrame(LPDIRECT3DRMFRAME Idst,
               LPDIRECT3DRMFRAME Isrc, bool clone)
{
  if (CanCopyFrame(Idst, Isrc)) {
     //   :
     D3DRMMATRIX4D m;
     Isrc->GetTransform(m);
     Idst->AddTransform(D3DRMCOMBINE_REPLACE, m);
     //   :
     AnsiString name = RMName(Isrc);
     name += "_clone";
     Idst->SetName(name.c_str());
     //  :
     CopyFrameRecursion(Idst, Isrc, clone);
  }
}//---------------------------------------------------------