/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import main.AudioFileFilter;
import main.LikeCDFrame;

public class MultiFileDialog
extends JDialog {
    private JPanel contentPane;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JButton upButton = new JButton();
    private JButton addButton = new JButton();
    private JButton downButton = new JButton();
    private JFileChooser fileChooser = new JFileChooser();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JList fileList = new JList();
    private JButton removeButton = new JButton();
    private JLabel jLabel1 = new JLabel();
    private JLabel jLabel2 = new JLabel();
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private boolean wasCancelled;
    private JButton removeAllButton = new JButton();
    private JButton addAllButton = new JButton();
    private JButton resetButton = new JButton();

    public MultiFileDialog(LikeCDFrame likeCDFrame) {
        super((Frame)likeCDFrame, true);
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.contentPane = (JPanel)this.getContentPane();
        this.upButton.setText("Move Up");
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiFileDialog.this.upButton_actionPerformed(actionEvent);
            }
        });
        this.contentPane.setLayout(this.gridBagLayout1);
        this.setSize(new Dimension(850, 400));
        this.setTitle("Choose file(s) for one of the audio streams to compare. Multiple files allowed in the professional version.");
        this.addButton.setMaximumSize(new Dimension(105, 27));
        this.addButton.setMinimumSize(new Dimension(85, 27));
        this.addButton.setPreferredSize(new Dimension(85, 27));
        this.addButton.setText("> Add >");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiFileDialog.this.addButton_actionPerformed(actionEvent);
            }
        });
        this.downButton.setText("Move Down");
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiFileDialog.this.downButton_actionPerformed(actionEvent);
            }
        });
        this.fileChooser.setMinimumSize(new Dimension(450, 250));
        this.fileChooser.setPreferredSize(new Dimension(500, 250));
        this.fileChooser.setMultiSelectionEnabled(true);
        this.fileChooser.setControlButtonsAreShown(false);
        this.fileChooser.setFileFilter(new AudioFileFilter());
        this.fileChooser.setFileSelectionMode(0);
        this.removeButton.setMaximumSize(new Dimension(105, 27));
        this.removeButton.setMinimumSize(new Dimension(85, 27));
        this.removeButton.setPreferredSize(new Dimension(85, 27));
        this.removeButton.setText("Remove");
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiFileDialog.this.removeButton_actionPerformed(actionEvent);
            }
        });
        this.jScrollPane1.setMinimumSize(new Dimension(350, 24));
        this.jScrollPane1.setPreferredSize(new Dimension(300, 132));
        this.okButton.setMaximumSize(new Dimension(80, 27));
        this.okButton.setMinimumSize(new Dimension(80, 27));
        this.okButton.setPreferredSize(new Dimension(80, 27));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiFileDialog.this.okButton_actionPerformed(actionEvent);
            }
        });
        this.cancelButton.setMaximumSize(new Dimension(80, 27));
        this.cancelButton.setMinimumSize(new Dimension(80, 27));
        this.cancelButton.setPreferredSize(new Dimension(80, 27));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiFileDialog.this.cancelButton_actionPerformed(actionEvent);
            }
        });
        this.removeAllButton.setText("Remove All");
        this.removeAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiFileDialog.this.removeAllButton_actionPerformed(actionEvent);
            }
        });
        this.addAllButton.setText("> Add All >");
        this.addAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiFileDialog.this.addAllButton_actionPerformed(actionEvent);
            }
        });
        this.resetButton.setText("Reset");
        this.resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiFileDialog.this.resetButton_actionPerformed(actionEvent);
            }
        });
        this.contentPane.add((Component)this.fileChooser, new GridBagConstraints(0, 0, 1, 8, 1.0, 0.0, 10, 1, new Insets(4, 12, 0, 0), 0, 0));
        this.contentPane.add((Component)this.jScrollPane1, new GridBagConstraints(4, 1, 2, 6, 10.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.fileList, null);
        this.contentPane.add((Component)this.addButton, new GridBagConstraints(1, 3, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 4, 2, 4), 0, 0));
        this.contentPane.add((Component)this.jLabel1, new GridBagConstraints(1, 1, 2, 1, 0.0, 1.0, 10, 0, new Insets(12, 0, 0, 0), 0, 0));
        this.contentPane.add((Component)this.jLabel2, new GridBagConstraints(1, 5, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.contentPane.add((Component)this.removeButton, new GridBagConstraints(1, 4, 3, 1, 0.0, 0.0, 10, 2, new Insets(2, 4, 0, 4), 0, 0));
        this.contentPane.add((Component)this.okButton, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(12, 6, 4, 6), 0, 0));
        this.contentPane.add((Component)this.cancelButton, new GridBagConstraints(6, 1, 1, 2, 0.0, 0.0, 11, 0, new Insets(0, 5, 0, 7), 0, 0));
        this.contentPane.add((Component)this.upButton, new GridBagConstraints(4, 0, 1, 1, 0.5, 0.0, 10, 0, new Insets(12, 0, 4, 0), 0, 0));
        this.contentPane.add((Component)this.downButton, new GridBagConstraints(4, 7, 1, 1, 0.5, 0.0, 10, 0, new Insets(4, 0, 12, 0), 0, 0));
        this.contentPane.add((Component)this.removeAllButton, new GridBagConstraints(2, 5, 2, 1, 0.0, 0.0, 11, 2, new Insets(4, 4, 23, 4), 0, 0));
        this.contentPane.add((Component)this.addAllButton, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 15, 2, new Insets(1, 4, 4, 4), 0, 0));
        this.contentPane.add((Component)this.resetButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 4, 0, 4), 0, 0));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.dispose();
        }
    }

    void addButton_actionPerformed(ActionEvent actionEvent) {
        File[] fileArray = this.fileChooser.getSelectedFiles();
        ArrayList arrayList = new ArrayList();
        ListModel listModel = this.fileList.getModel();
        int n = 0;
        while (n < listModel.getSize()) {
            arrayList.add(listModel.getElementAt(n));
            ++n;
        }
        int n2 = 0;
        while (n2 < fileArray.length) {
            if (!fileArray[n2].isDirectory()) {
                arrayList.add(fileArray[n2]);
            }
            ++n2;
        }
        Object[] objectArray = new Object[arrayList.size()];
        arrayList.toArray(objectArray);
        this.fileList.setListData(objectArray);
    }

    void removeButton_actionPerformed(ActionEvent actionEvent) {
        ListModel listModel = this.fileList.getModel();
        int[] nArray = this.fileList.getSelectedIndices();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n = 0;
        while (n < nArray.length) {
            hashSet.add(new Integer(nArray[n]));
            ++n;
        }
        ArrayList arrayList = new ArrayList();
        int n2 = 0;
        while (n2 < listModel.getSize()) {
            if (!hashSet.contains(new Integer(n2))) {
                arrayList.add(listModel.getElementAt(n2));
            }
            ++n2;
        }
        Object[] objectArray = new Object[arrayList.size()];
        arrayList.toArray(objectArray);
        this.fileList.setListData(objectArray);
    }

    void upButton_actionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.fileList.getSelectedIndices();
        if (nArray.length != 1) {
            return;
        }
        int n = nArray[0];
        if (n == 0) {
            return;
        }
        ListModel listModel = this.fileList.getModel();
        ArrayList arrayList = new ArrayList();
        int n2 = 0;
        while (n2 < n - 1) {
            arrayList.add(listModel.getElementAt(n2));
            ++n2;
        }
        arrayList.add(listModel.getElementAt(n));
        arrayList.add(listModel.getElementAt(n - 1));
        int n3 = n + 1;
        while (n3 < listModel.getSize()) {
            arrayList.add(listModel.getElementAt(n3));
            ++n3;
        }
        Object[] objectArray = new Object[arrayList.size()];
        arrayList.toArray(objectArray);
        this.fileList.setListData(objectArray);
        this.fileList.setSelectedIndex(n - 1);
    }

    void downButton_actionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.fileList.getSelectedIndices();
        if (nArray.length != 1) {
            return;
        }
        int n = nArray[0];
        ListModel listModel = this.fileList.getModel();
        if (n == listModel.getSize() - 1) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(listModel.getElementAt(n2));
            ++n2;
        }
        arrayList.add(listModel.getElementAt(n + 1));
        arrayList.add(listModel.getElementAt(n));
        int n3 = n + 2;
        while (n3 < listModel.getSize()) {
            arrayList.add(listModel.getElementAt(n3));
            ++n3;
        }
        Object[] objectArray = new Object[arrayList.size()];
        arrayList.toArray(objectArray);
        this.fileList.setListData(objectArray);
        this.fileList.setSelectedIndex(n + 1);
    }

    void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.wasCancelled = true;
        this.dispose();
    }

    void okButton_actionPerformed(ActionEvent actionEvent) {
        this.wasCancelled = false;
        this.dispose();
    }

    public void setDirectory(File file) {
        this.fileChooser.setCurrentDirectory(file);
    }

    public File getDirectory() {
        return this.fileChooser.getCurrentDirectory();
    }

    public String getSelectedFilesAsString() {
        String string = "";
        ListModel listModel = this.fileList.getModel();
        int n = 0;
        while (n < listModel.getSize()) {
            if (n != 0) {
                string = string + ";";
            }
            string = string + listModel.getElementAt(n);
            ++n;
        }
        return string;
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    void removeAllButton_actionPerformed(ActionEvent actionEvent) {
        ListModel listModel = this.fileList.getModel();
        this.fileList.setListData(new Object[0]);
    }

    void addAllButton_actionPerformed(ActionEvent actionEvent) {
        File file = this.fileChooser.getCurrentDirectory();
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile();
            }
        });
        ListModel listModel = this.fileList.getModel();
        this.fileList.setListData(fileArray);
    }

    void resetButton_actionPerformed(ActionEvent actionEvent) {
        this.removeAllButton_actionPerformed(actionEvent);
        this.fileChooser.rescanCurrentDirectory();
    }
}

