// ------------------------------------------------------------------------
// System       : WIN9X/NT
// Program      : sub.c
// Description  : A filter that replaces one string with another.
// Written by   : Bill Buckels
// Date Written : March 2000
// Revision     : 1.1 First Release
// ------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define BUF_MAX  4096
#define BUF_SIZE (BUF_MAX + 1)

char cbuf[BUF_SIZE] = "\0",
         find[128] = "\0",
         replace[128] = "\0",
         filename[_MAX_PATH] = "\0";

int NOCASE = 0;

void main(int argc, char **argv)
{
    int c, cnt = 0, idx, jdx, findlen, status;
    FILE *fp = NULL;

    if (argc > 3) {
      for (idx = 3; idx < argc; idx++) {
        if (argv[idx][0] != '-') {
          if (filename[0] == 0) {
            strcpy(filename, argv[idx]);
            fp = fopen(filename, "r");
          }
        }
        else {
          for (jdx = 0; (c = tolower(argv[idx][jdx])) != 0; jdx++) {
            switch(c) {
              case 'i':
                NOCASE = 1; break;
            }
          }
        }
      }
    }

    // if we don't have at least a [find] [replace] pair
    // just print usage and exit...

    if ( argc < 3 || (NULL == fp && filename[0] != 0)) {
       puts("SUB(C) CopyLeft Bill Buckels 2000. All Rights Reversed.");
       if (NULL == fp && filename[0] != 0)
         perror(filename);
       puts("Usage is : \"sub [find] [replace] -i (filename - optional)\"");
       puts("Purpose  : find and replace literal strings in streams.");
       puts("Switches : -i (ignore case)");
       exit(1);
    }
    strcpy(find, argv[1]);
    strcpy(replace, argv[2]);
    findlen = strlen(find);

    for (;;) {
      if (NULL == fp)
        c = getchar();
      else
        c = fgetc(fp);

      if (c==EOF)break;
      if (c=='\r')continue;

      // walk through  memory and substitute any strings
      // that need substitution...

      if (c == '\n' || cnt >= BUF_MAX) {
        for (idx = 0; cbuf[idx] != 0; idx++) {
          if (NOCASE)
            status = _memicmp(&cbuf[idx], find, findlen);
          else
            status = memcmp(&cbuf[idx], find, findlen);

          if (!status) {
             for (jdx = 0; replace[jdx] != 0; jdx++) putchar(replace[jdx]);
             idx += (findlen - 1);
          }
          else {
            putchar(cbuf[idx]);
          }
        }
        if (c == '\n') {
          putchar('\n');
          cbuf[0] = cnt = 0;
        }
        else {
          cbuf[0] = c;
          cbuf[1] = 0;
          cnt = 1;
        }
        continue;
      }
      cbuf[cnt] = c;
      cnt++;
      cbuf[cnt] = 0;
    }
    if (cbuf[0] != 0) {
      for (idx = 0; cbuf[idx] != 0; idx++) {
        if (NOCASE)
          status = _memicmp(&cbuf[idx], find, findlen);
        else
          status = memcmp(&cbuf[idx], find, findlen);

        if (!status) {
          for (jdx = 0; replace[jdx] != 0; jdx++) putchar(replace[jdx]);
          idx += (findlen-1);
        }
        else {
          putchar(cbuf[idx]);
        }
      }
      putchar('\n');
    }

    if (NULL != fp) {
      fclose(fp);
      exit(0);
    }
}
