#include "conf.h"
#include "adb.h"
#include "reg.h"

const int DEFAULT_LISTEN_PORT = 8080;
const int DEFAULT_CONNECTION_TRIES = 10;

char block_filename[256] = "adb.cfg";
bool block_filename_used = false;
bool auto_save = false;
bool do_wnd_abort = false;
bool show_log = false;
bool show_all = false;
bool use_proxy = false;
int proxy_port = 3128;
char proxy_hostname[256] = "proxy";
bool allow_nonlocal = false;
int listen_port = DEFAULT_LISTEN_PORT;
int auto_update = 0;
bool stealth_mode = true;
int max_connection_tries = DEFAULT_CONNECTION_TRIES;

const char reg_subtree_key[] = "Software\\miri\\adbuster";
const char auto_save_key[] = "adbuster_autosave";
const char block_filename_key[] = "adbuster_filename";
const char show_log_key[] = "adbuster_showlog";
const char proxy_use_key[] = "adbuster_use_proxy";
const char proxy_host_key[] = "adbuster_proxy_host";
const char proxy_port_key[] = "adbuster_proxy_port";
const char allow_nonlocal_key[] = "adbuster_allow_nonlocal";
const char listen_port_key[] = "adbuster_listen_port";
const char auto_update_key[] = "adbuster_auto_update";
const char stealth_mode_key[] = "adbuster_stealth_mode";
const char max_connection_tries_key[] = "adbuster_max_connection_tries";

void LoadConf()
{
   auto_save = get_bool_key(reg_subtree_key, auto_save_key);
   show_log = get_bool_key(reg_subtree_key, show_log_key);
   get_string_key(reg_subtree_key, block_filename_key, block_filename, sizeof(block_filename));
   use_proxy = get_bool_key(reg_subtree_key, proxy_use_key);
   get_string_key(reg_subtree_key, proxy_host_key, proxy_hostname, sizeof(proxy_hostname));
   proxy_port = get_int_key(reg_subtree_key, proxy_port_key);
   allow_nonlocal = get_bool_key(reg_subtree_key, allow_nonlocal_key);
   listen_port = get_int_key(reg_subtree_key, listen_port_key);
   if (!listen_port)
     listen_port = DEFAULT_LISTEN_PORT;
   auto_update = get_int_key(reg_subtree_key, auto_update_key);
   stealth_mode = get_bool_key(reg_subtree_key, stealth_mode_key);
   max_connection_tries = get_int_key(reg_subtree_key, max_connection_tries_key);
   if (!max_connection_tries)
     max_connection_tries = DEFAULT_CONNECTION_TRIES;
}

void SaveConf()
{
   set_bool_key(reg_subtree_key, auto_save_key, auto_save);
   set_bool_key(reg_subtree_key, show_log_key, show_log);
   set_string_key(reg_subtree_key, block_filename_key, block_filename);		    
   set_bool_key(reg_subtree_key, proxy_use_key, use_proxy);
   set_string_key(reg_subtree_key, proxy_host_key, proxy_hostname);
   set_int_key(reg_subtree_key, proxy_port_key, proxy_port);
   set_bool_key(reg_subtree_key, allow_nonlocal_key, allow_nonlocal);
   set_int_key(reg_subtree_key, listen_port_key, listen_port);
   set_int_key(reg_subtree_key, auto_update_key, auto_update);
   set_bool_key(reg_subtree_key, stealth_mode_key, stealth_mode);
   set_int_key(reg_subtree_key, max_connection_tries_key, max_connection_tries);
}
