-- WEBEASY: create tables script


DROP TABLE MEMBER;

CREATE TABLE MEMBER
  (
    USER_ID         VARCHAR(15)    PRIMARY KEY NOT NULL,
    PASSWORD        VARCHAR(15),
    FIRSTNAME       VARCHAR(20),
    LASTNAME        VARCHAR(20),
    BIRTH_YEAR      CHAR(4),
    GENDER          SMALLINT,
    LANGUAGE        SMALLINT,
    COUNTRY         SMALLINT,
    OCCUPATION      SMALLINT,
    INCOME          SMALLINT,
    EDUCATION       SMALLINT,
    HOUSEHOLD       SMALLINT,
    EMAIL           VARCHAR(50),
    PHONE           VARCHAR(20),
    ADDRESS         VARCHAR(150),
    HINT_QUESTION   VARCHAR(50),
    HINT_ANSWER     VARCHAR(50)
  );



DROP TABLE LANGUAGE;

CREATE TABLE LANGUAGE
  (
    LANGUAGE        SMALLINT       PRIMARY KEY NOT NULL,
    LANG_DES        VARCHAR(30),
    ENCODING        VARCHAR(20)
  );



DROP TABLE ATTR_VALUE;

CREATE TABLE ATTR_VALUE
  (
    ATTR_ID         VARCHAR(20)    NOT NULL,
    VALUE_ID        SMALLINT       NOT NULL,
    LANGUAGE        SMALLINT       NOT NULL,
    VALUE_DES       VARCHAR(50),
    CONSTRAINT ATTR_VALUE_PKEY PRIMARY KEY (ATTR_ID, VALUE_ID, LANGUAGE)
--    PRIMARY KEY (ATTR_ID, VALUE_ID, LANGUAGE)
  );



DROP TABLE MESSAGE;

CREATE TABLE MESSAGE
  (
    BOARD_ID       SMALLINT,
    MESSAGE_ID     INTEGER        PRIMARY KEY NOT NULL,
    THREAD_ID      INTEGER,
    PARENT_ID      INTEGER,
    NUM_CHILDREN   SMALLINT,
    SORT_CODE      VARCHAR(50),
    USER_ID        VARCHAR(15),
    POST_DATE      DATETIME,
--    POST_DATE      TIMESTAMP,
--    POST_DATE      DATE,
    SUBJECT        VARCHAR(150),
    CONTENT        TEXT
--    CONTENT        LONG VARCHAR
--    CONTENT        LONG
  );



DROP TABLE BOARD;

CREATE TABLE BOARD
  (
    BOARD_ID       SMALLINT      NOT NULL,
    LANGUAGE       SMALLINT      NOT NULL,
    BOARD_DES      VARCHAR(20),
    CONSTRAINT BOARD_PKEY PRIMARY KEY (BOARD_ID, LANGUAGE)
--    PRIMARY KEY (BOARD_ID, LANGUAGE)
  );



DROP TABLE CATEGORY;

CREATE TABLE CATEGORY
  (
    CAT_ID         INTEGER        PRIMARY KEY NOT NULL,
    PARENT_ID      INTEGER,
    CAT_IMAGE1     VARCHAR(20),
    CAT_IMAGE2     VARCHAR(20),
    CAT_TEMPLATE   VARCHAR(20),
    LEAF_CAT       VARCHAR(1)
  );



DROP TABLE CATEGORY_DESCRIPTION;

CREATE TABLE CATEGORY_DESCRIPTION
  (
    CAT_ID         INTEGER        NOT NULL,
    LANGUAGE       SMALLINT       NOT NULL,
    CAT_NAME       VARCHAR(100),
    CAT_DES        TEXT,
--    CAT_DES        LONG VARCHAR,
--    CAT_DES        LONG,
    CONSTRAINT CAT_DES_PKEY PRIMARY KEY (CAT_ID, LANGUAGE)
--    PRIMARY KEY (CAT_ID, LANGUAGE)
  );



DROP TABLE ITEM;

CREATE TABLE ITEM
  (
    ITEM_ID        INTEGER        PRIMARY KEY NOT NULL,
    CAT_ID         INTEGER,
    ITEM_IMAGE1    VARCHAR(20),
    ITEM_IMAGE2    VARCHAR(20),
    ITEM_TEMPLATE  VARCHAR(20),
    ITEM_PRICE     DECIMAL(10,2)
  );



DROP TABLE ITEM_DESCRIPTION;

CREATE TABLE ITEM_DESCRIPTION
  (
    ITEM_ID        INTEGER        NOT NULL,
    LANGUAGE       SMALLINT       NOT NULL,
    ITEM_NAME      VARCHAR(100),
    ITEM_DES       TEXT,
--    ITEM_DES       LONG VARCHAR,
--    ITEM_DES       LONG,
    CONSTRAINT ITEM_DES_PKEY PRIMARY KEY (ITEM_ID, LANGUAGE)
--    PRIMARY KEY (ITEM_ID, LANGUAGE)
  );



DROP TABLE ORDER_INFO;

CREATE TABLE ORDER_INFO
  (
    ORDER_ID             INTEGER      PRIMARY KEY NOT NULL,
    LANGUAGE             SMALLINT,
    ORDER_TIME           DATETIME,
--    ORDER_TIME           TIMESTAMP,
--    ORDER_TIME           DATE,
    CUSTOMER_ID          VARCHAR(15),
    CUSTOMER_LAST_NAME   VARCHAR(20),
    CUSTOMER_FIRST_NAME  VARCHAR(20),
    PAYMENT_METHOD       VARCHAR(20),
    CARDHOLDER_NAME      VARCHAR(50),
    CARD_NUMBER          VARCHAR(50),
    EXPIRY_MONTH         SMALLINT,
    EXPIRY_YEAR          SMALLINT,
    RECIPIENT_LAST_NAME  VARCHAR(20),
    RECIPIENT_FIRST_NAME VARCHAR(20),
    RECIPIENT_PHONE      VARCHAR(20),
    RECIPIENT_ADDRESS    VARCHAR(150)
  );



DROP TABLE ORDER_ITEM;

CREATE TABLE ORDER_ITEM
  (
    ORDER_ID             INTEGER        NOT NULL,
    ITEM_ID              INTEGER        NOT NULL,
    ITEM_NAME            VARCHAR(100),
    QTY                  INTEGER,
    ITEM_PRICE           DECIMAL(10,2),
    CONSTRAINT ORDER_ITEM_PKEY PRIMARY KEY (ORDER_ID, ITEM_ID)
--    PRIMARY KEY (ORDER_ID, ITEM_ID)
  );


