/* RESOLV.C - This file is part of
Resolver for Windows, copyright (C) Fabrizio Gennari, 2000

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  */

#include <winsock.h>
#include <stdio.h>
#include <memory.h>

int already_read;
unsigned char *query_rep;

unsigned short int GetShortInt(SOCKET sock){
	unsigned short int lunghezza;
	int bytes=recv(sock,((char*)(&lunghezza))+1,1,0);
	bytes=recv(sock,((char*)(&lunghezza))+0,1,0);
	already_read+=2;
	return lunghezza;
}

unsigned long int GetLongInt(SOCKET sock){
	unsigned long int lunghezza;
	int bytes;
	bytes=recv(sock,((char*)(&lunghezza))+3,1,0);
	bytes=recv(sock,((char*)(&lunghezza))+2,1,0);
	bytes=recv(sock,((char*)(&lunghezza))+1,1,0);
	bytes=recv(sock,((char*)(&lunghezza))+0,1,0);
	already_read+=4;
	return lunghezza;
}

unsigned char GetByte(SOCKET sock){
	char byte;
	int bytes=recv(sock,&byte,1,0);
	already_read++;
	return (unsigned char)byte;
}

unsigned char GetNewByte(SOCKET sock, int partenza){
	if (partenza==already_read) {
		query_rep[partenza]=GetByte(sock);
	}
	return query_rep[partenza];
}

void GetLabel(SOCKET sock, char nomehost[], int partenza);

unsigned char GetSegment(SOCKET sock, char nomehost[], int partenza){
	unsigned char byte=GetNewByte(sock, partenza);
	int i;
	if ((byte&192)==192){
		unsigned char byte2=GetNewByte(sock,partenza+1);
		int npartenza=(byte&63)*256+byte2;
		GetLabel(sock, nomehost, npartenza);
		return 192;
	}
	else{
		for(i=0;i<byte;i++){
			unsigned char byte2=GetNewByte(sock,partenza+1+i);
			nomehost[i]=byte2;
		}
		return byte;
	}
}

void GetLabel(SOCKET sock, char nomehost[], int partenza){
	unsigned char length;
	int read_now=0;
	for(;;){
		length=GetSegment(sock,nomehost+read_now,partenza+read_now);
		if (length==192) break;
		if (length==0){
			nomehost[strlen(nomehost)-1]=0;
			break;
		}
		read_now+=length;
		nomehost[read_now++]='.';
		nomehost[read_now]=0;
	}
}

void GetAnswer(SOCKET sock, unsigned short int type, char nomehost[]){
	unsigned short int anslength;
	char soa_label_1[256],soa_label_2[256];
	int i;
	unsigned char len;
	unsigned long int lungo[5];
	anslength=GetShortInt(sock);
	anslength=GetShortInt(sock);
	anslength=GetShortInt(sock);
	switch(type){
	case 1:
		{unsigned char byte1=GetByte(sock);
		unsigned char byte2=GetByte(sock);
		unsigned char byte3=GetByte(sock);
		unsigned char byte4=GetByte(sock);
		sprintf(nomehost,"%u.%u.%u.%u",byte1,byte2,byte3,byte4);
		break;}
	case 2:
		GetLabel(sock, nomehost, already_read);
		break;
	case 5:
		GetLabel(sock, nomehost, already_read);
		break;
	case 6:
		GetLabel(sock, soa_label_1, already_read);
		GetLabel(sock, soa_label_2, already_read);
		for(i=0; i<5; i++)
			lungo[i]=GetLongInt(sock);
		sprintf(nomehost,"Domain name %s, mailbox %s, serial %u, refresh %u, retry %u, expire %u, minimum %u",
			soa_label_1,soa_label_2,lungo[0],lungo[1],lungo[2],lungo[3],lungo[4]);
		break;
	case 12:
		GetLabel(sock, nomehost, already_read);
		break;
	case 13:
		nomehost[0]=GetByte(sock);
		len=1;
		for(i=0;i<nomehost[0];i++)
			nomehost[len++]=GetByte(sock);
		nomehost[len++]=GetByte(sock);
		for(i=0;i<nomehost[nomehost[0]+1];i++)
			nomehost[len++]=GetByte(sock);
		break;
	case 15:
		nomehost[0]=GetByte(sock);
		nomehost[1]=GetByte(sock);
		GetLabel(sock, nomehost+2, already_read);
		break;
	default:
		for(i=0; i<anslength; i++) GetByte(sock);
//		sprintf(nomehost,"Non so che farci col tipo %u",type);
	}
}

unsigned short int GetTypeAndClass(SOCKET sock){
	unsigned short int byte=GetShortInt(sock);//type
	unsigned short int byte2;//class
	byte2=GetShortInt(sock);
	return byte;
}

int res_mkquery(int query_type, char* domain_name, int class, int type,
				char* data, int data_length, int inutile, char* buffer,
				int buf_length){
	int lunghezza,i,l;
	unsigned char count;
	struct {
		char id[2];
		unsigned char control[2];
		unsigned short int qdcount;
		unsigned short int ancount;
		unsigned short int nscount;
		unsigned short int arcount;
	}query;
	unsigned short qtype[2];
	lunghezza=sizeof(query)+sizeof(qtype)+strlen(domain_name)+2;
	if (buf_length<lunghezza) return -1;
	query.id[0]=query.id[1]='F';
	query.control[0]=1+((query_type&15)<<3);//recursion desired
	query.control[1]=0;//no error
	query.qdcount=htons(1);
	query.ancount=0;
	query.nscount=0;
	query.arcount=0;
	qtype[0]=htons((unsigned short)type);
	qtype[1]=htons((unsigned short)class);
	memcpy(buffer,&query,sizeof(query));
	l=strlen(domain_name);
	count=0;
	for(i=0;i<=l;i++){
		if ((domain_name[i]!='.')&&(domain_name[i]!=0))
			count++;
		else{
			buffer[sizeof(query)+i-count]=count;
			memcpy(buffer+sizeof(query)+i-count+1,domain_name+i-count,count);
			count=0;
		}
	}
	buffer[sizeof(query)+l+1]=0;
	memcpy(buffer+sizeof(query)+l+2,(char*)&qtype,sizeof(qtype));
	return lunghezza;
}

int process_errors(int errors,char* message, char* host){
	switch(errors&15){
	case 0:
		break;
	case 1:
		strcpy(message,"Format error");
		break;
	case 2:
		strcpy(message,"Server failure");
		break;
	case 3:
		sprintf(message,"The host or domain %s does not exist",host);
		break;
	case 4:
	strcpy(message,"Not implemented");
		break;
	case 5:
		strcpy(message,"Refused");
		break;
	default:
		strcpy(message,"Unknown error");
	}
	return (errors&15);
}
