/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.xerces.impl.xs.SchemaGrammar;

public class XSGrammarBucket {
    private Hashtable fGrammarRegistry = new Hashtable();
    private SchemaGrammar fNoNSGrammar = null;

    public SchemaGrammar getGrammar(String namespace) {
        if (namespace == null) {
            return this.fNoNSGrammar;
        }
        return (SchemaGrammar)this.fGrammarRegistry.get(namespace);
    }

    public void putGrammar(SchemaGrammar grammar) {
        if (grammar.getTargetNamespace() == null) {
            this.fNoNSGrammar = grammar;
        } else {
            this.fGrammarRegistry.put(grammar.getTargetNamespace(), grammar);
        }
    }

    public void putGrammar(String namespace, SchemaGrammar grammar) {
        if (namespace == null) {
            this.fNoNSGrammar = grammar;
        } else {
            this.fGrammarRegistry.put(namespace, grammar);
        }
    }

    public SchemaGrammar[] getGrammars() {
        int count = this.fGrammarRegistry.size() + (this.fNoNSGrammar == null ? 0 : 1);
        SchemaGrammar[] grammars = new SchemaGrammar[count];
        Enumeration enumeration = this.fGrammarRegistry.elements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            grammars[i++] = (SchemaGrammar)enumeration.nextElement();
        }
        if (this.fNoNSGrammar != null) {
            grammars[count - 1] = this.fNoNSGrammar;
        }
        return grammars;
    }

    public void reset() {
        this.fNoNSGrammar = null;
        this.fGrammarRegistry.clear();
    }
}

