{*******************************************************}
{                     PHP4Delphi                        }
{               PHP - Delphi interface                  }
{                       v.5.0                           }
{ Author:                                               }
{ Serhiy Perevoznyk                                     }
{ serge_perevoznyk@hotmail.com                          }
{ http://users.chello.be/ws36637                        }
{*******************************************************}
{$I PHP.INC}

unit phpAbout;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,
  {$IFDEF VERSION6}
  DesignIntf,
  DesignEditors,
  {$ELSE}
  dsgnintf,
  {$ENDIF}
  math;

type
  TdlgAbout = class(TForm)
    pnlLeft: TPanel;
    pnlImage: TPanel;
    imgAbout: TImage;
    pnlBody: TPanel;
    bvlSpit: TBevel;
    labTitleShadow: TLabel;
    labTitle: TLabel;
    labDelphiShadow: TLabel;
    lblAuthor: TLabel;
    labDelphi: TLabel;
    labVersion: TLabel;
    btnOK: TButton;
    protected
  end;

  TphpVersionEditor = class(TPropertyEditor)
    function AllEqual: boolean; override;
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
    procedure SetValue(const Value: string); override;
  end;

implementation

{$R *.DFM}

function TphpVersionEditor.AllEqual: boolean;
var
  componentIndex: integer;
  currentValue: string;
begin
  Result := False;
  if (PropCount > 1) then
   begin
    currentValue := GetStrValue;
    for componentIndex := 1 to PropCount - 1 do
     begin
        if (GetStrValueAt(componentIndex) <> currentValue) then
          exit;
     end;
    end;
   Result := True;
end;

procedure TphpVersionEditor.Edit;
begin
  with TdlgAbout.Create(NIL) do
  begin
    try
      ShowModal;
    finally
      Free;  { Free dialog. }
    end;
  end;
end;

function TphpVersionEditor.GetAttributes: TPropertyAttributes;
begin
  Result := [paMultiSelect, paDialog, paRevertable];
end;

function TphpVersionEditor.GetValue: string;
begin
  Result := 'PHP4Delphi 5.0';
end;

procedure TphpVersionEditor.SetValue(const Value: string);
begin
end;

end.
