{*******************************************************}
{                     PHP4Delphi                        }
{               ZEND - Delphi interface                 }
{                       v.5.0                           }
{ Author:                                               }
{ Serhiy Perevoznyk                                     }
{ serge_perevoznyk@hotmail.com                          }
{ http://users.chello.be/ws36637                        }
{*******************************************************}
{$I PHP.INC}
unit zendAPI;

interface

uses
 Windows, SysUtils;

type
 zend_uint = uint;

//zend_compile.h
const
  ZEND_NOP = 0;
  ZEND_ADD = 1;
  ZEND_SUB = 2;
  ZEND_MUL = 3;
  ZEND_DIV = 4;
  ZEND_MOD = 5;
  ZEND_SL = 6;
  ZEND_SR = 7;
  ZEND_CONCAT = 8;
  ZEND_BW_OR = 9;
  ZEND_BW_AND = 10;
  ZEND_BW_XOR = 11;
  ZEND_BW_NOT = 12;
  ZEND_BOOL_NOT = 13;
  ZEND_BOOL_XOR = 14;
  ZEND_IS_IDENTICAL = 15;
  ZEND_IS_NOT_IDENTICAL = 16;
  ZEND_IS_EQUAL = 17;
  ZEND_IS_NOT_EQUAL = 18;
  ZEND_IS_SMALLER = 19;
  ZEND_IS_SMALLER_OR_EQUAL = 20;
  ZEND_CAST = 21;
  ZEND_QM_ASSIGN = 22;
  ZEND_ASSIGN_ADD = 23;
  ZEND_ASSIGN_SUB = 24;
  ZEND_ASSIGN_MUL = 25;
  ZEND_ASSIGN_DIV = 26;
  ZEND_ASSIGN_MOD = 27;
  ZEND_ASSIGN_SL = 28;
  ZEND_ASSIGN_SR = 29;
  ZEND_ASSIGN_CONCAT = 30;
  ZEND_ASSIGN_BW_OR = 31;
  ZEND_ASSIGN_BW_AND = 32;
  ZEND_ASSIGN_BW_XOR = 33;
  ZEND_PRE_INC = 34;
  ZEND_PRE_DEC = 35;
  ZEND_POST_INC = 36;
  ZEND_POST_DEC = 37;
  ZEND_ASSIGN = 38;
  ZEND_ASSIGN_REF = 39;
  ZEND_ECHO = 40;
  ZEND_PRINT = 41;
  ZEND_JMP = 42;
  ZEND_JMPZ = 43;
  ZEND_JMPNZ = 44;
  ZEND_JMPZNZ = 45;
  ZEND_JMPZ_EX = 46;
  ZEND_JMPNZ_EX = 47;
  ZEND_CASE = 48;
  ZEND_SWITCH_FREE = 49;
  ZEND_BRK = 50;
  ZEND_CONT = 51;
  ZEND_BOOL = 52;
  ZEND_INIT_STRING = 53;
  ZEND_ADD_CHAR = 54;
  ZEND_ADD_STRING = 55;
  ZEND_ADD_VAR = 56;
  ZEND_BEGIN_SILENCE = 57;
  ZEND_END_SILENCE = 58;
  ZEND_INIT_FCALL_BY_NAME = 59;
  ZEND_DO_FCALL = 60;
  ZEND_DO_FCALL_BY_NAME = 61;
  ZEND_RETURN = 62;
  ZEND_RECV = 63;
  ZEND_RECV_INIT = 64;
  ZEND_SEND_VAL = 65;
  ZEND_SEND_VAR = 66;
  ZEND_SEND_REF = 67;
  ZEND_NEW = 68;
  ZEND_JMP_NO_CTOR = 69;
  ZEND_FREE = 70;
  ZEND_INIT_ARRAY = 71;
  ZEND_ADD_ARRAY_ELEMENT = 72;
  ZEND_INCLUDE_OR_EVAL = 73;
  ZEND_UNSET_VAR = 74;
  ZEND_UNSET_DIM_OBJ = 75;
  ZEND_ISSET_ISEMPTY = 76;
  ZEND_FE_RESET = 77;
  ZEND_FE_FETCH = 78;
  ZEND_EXIT = 79;

{ the following 18 opcodes are 6 groups of 3 opcodes each, and must
 * remain in that order!
 }

const
  ZEND_FETCH_R = 80;
  ZEND_FETCH_DIM_R = 81;
  ZEND_FETCH_OBJ_R = 82;
  ZEND_FETCH_W = 83;
  ZEND_FETCH_DIM_W = 84;
  ZEND_FETCH_OBJ_W = 85;
  ZEND_FETCH_RW = 86;
  ZEND_FETCH_DIM_RW = 87;
  ZEND_FETCH_OBJ_RW = 88;
  ZEND_FETCH_IS = 89;
  ZEND_FETCH_DIM_IS = 90;
  ZEND_FETCH_OBJ_IS = 91;
  ZEND_FETCH_FUNC_ARG = 92;
  ZEND_FETCH_DIM_FUNC_ARG = 93;
  ZEND_FETCH_OBJ_FUNC_ARG = 94;
  ZEND_FETCH_UNSET = 95;
  ZEND_FETCH_DIM_UNSET = 96;
  ZEND_FETCH_OBJ_UNSET = 97;
  ZEND_FETCH_DIM_TMP_VAR = 98;
  ZEND_FETCH_CONSTANT = 99;
  ZEND_DECLARE_FUNCTION_OR_CLASS = 100;
  ZEND_EXT_STMT = 101;
  ZEND_EXT_FCALL_BEGIN = 102;
  ZEND_EXT_FCALL_END = 103;
  ZEND_EXT_NOP = 104;
  ZEND_TICKS = 105;
  ZEND_SEND_VAR_NO_REF = 106;

{ end of block }

{ global/local fetches }

const
  ZEND_FETCH_GLOBAL = 0;
  ZEND_FETCH_LOCAL = 1;
  ZEND_FETCH_STATIC = 2;

{ var status for backpatching }

const
  BP_VAR_R = 0;
  BP_VAR_W = 1;
  BP_VAR_RW = 2;
  BP_VAR_IS = 3;
  BP_VAR_NA = 4                        { if not applicable }
  ;
  BP_VAR_FUNC_ARG = 5;
  BP_VAR_UNSET = 6;
  ZEND_INTERNAL_FUNCTION = 1;
  ZEND_USER_FUNCTION = 2;
  ZEND_OVERLOADED_FUNCTION = 3;
  ZEND_EVAL_CODE = 4;
  ZEND_INTERNAL_CLASS = 1;
  ZEND_USER_CLASS = 2;
  ZEND_EVAL = (1 shl 0);
  ZEND_INCLUDE = (1 shl 1);
  ZEND_INCLUDE_ONCE = (1 shl 2);
  ZEND_REQUIRE = (1 shl 3);
  ZEND_REQUIRE_ONCE = (1 shl 4);
  ZEND_ISSET = (1 shl 0);
  ZEND_ISEMPTY = (1 shl 1);
  ZEND_CT = (1 shl 0);
  ZEND_RT = (1 shl 1);
  ZEND_HANDLE_FILENAME = 0;
  ZEND_HANDLE_FD = 1;
  ZEND_HANDLE_FP = 2;
  ZEND_HANDLE_STDIOSTREAM = 3;
  ZEND_HANDLE_FSTREAM = 4;
  ZEND_DECLARE_CLASS = 1;
  ZEND_DECLARE_FUNCTION = 2;
  ZEND_DECLARE_INHERITED_CLASS = 3;
  ZEND_FETCH_STANDARD = 0;
  ZEND_FETCH_ADD_LOCK = 1;
  ZEND_MEMBER_FUNC_CALL = 1 shl 0;
  ZEND_CTOR_CALL = 1 shl 1;
  ZEND_ARG_SEND_BY_REF = (1 shl 0);
  ZEND_ARG_COMPILE_TIME_BOUND = (1 shl 1);
  ZEND_RETURN_VAL = 0;
  ZEND_RETURN_REF = 1;

//zend_errors.h
const
  E_ERROR = (1 shl 0);
  E_WARNING = (1 shl 1);
  E_PARSE = (1 shl 2);
  E_NOTICE = (1 shl 3);
  E_CORE_ERROR = (1 shl 4);
  E_CORE_WARNING = (1 shl 5);
  E_COMPILE_ERROR = (1 shl 6);
  E_COMPILE_WARNING = (1 shl 7);
  E_USER_ERROR = (1 shl 8);
  E_USER_WARNING = (1 shl 9);
  E_USER_NOTICE = (1 shl 10);
  E_ALL = (E_ERROR or E_WARNING or E_PARSE or E_NOTICE or E_CORE_ERROR or E_CORE_WARNING or E_COMPILE_ERROR or E_COMPILE_WARNING or E_USER_ERROR or E_USER_WARNING or E_USER_NOTICE);
  E_CORE = (E_CORE_ERROR or E_CORE_WARNING);

//zend.h
//data types
const
  IS_NULL = 0;
  IS_LONG = 1;
  IS_DOUBLE = 2;
  IS_STRING = 3;
  IS_ARRAY = 4;
  IS_OBJECT = 5;
  IS_BOOL = 6;
  IS_RESOURCE = 7;
  IS_CONSTANT = 8;
  IS_CONSTANT_ARRAY = 9;

  ZEND_PATHS_SEPARATOR = ';';
  SUCCESS = 0;
  FAILURE = -1; { this MUST stay a negative number, or it may affect functions! }



//zend_modules.h
const
  ZEND_MODULE_API_NO = 20020429;

{$IFDEF ZTS}
const
  USING_ZTS = 1;
{$ELSE}
const
  USING_ZTS = 0;
{$ENDIF}

const
  NO_VERSION_YET = nil;
  MODULE_PERSISTENT = 1;
  MODULE_TEMPORARY = 2;


//zend_alloc.h
const
  MEM_BLOCK_START_MAGIC = $7312F8DC;
  MEM_BLOCK_END_MAGIC = $2A8FCC84;
  MEM_BLOCK_FREED_MAGIC = $99954317;
  MEM_BLOCK_CACHED_MAGIC = $FB8277DC;

type
  size_t = cardinal;
  ppointer = ^pointer;
  pppointer = ^ppointer;

  PStat = ^TStat;
  TStat = record
    st_dev: Word;
    st_ino: Word;
    st_mode: Word;
    st_nlink: SmallInt;
    st_uid: SmallInt;
    st_gid: SmallInt;
    st_rdev: Word;
    st_size: Longint;
    st_atime: Longint;
    st_mtime: Longint;
    st_ctime: Longint;
  end;
  Stat = TStat;

  Pzend_mem_header = ^Tzend_mem_header;
  _zend_mem_header = record
      pNext : Pzend_mem_header;
      pLast : Pzend_mem_header;
      size_cached : integer;
    end;
  Tzend_mem_header = _zend_mem_header;

  align_test = record
    case Integer of
      1 : (ptr : Pointer;);
      2 : (dbl : Double; );
      3 : (lng : Longint;);
    end;

const
  MAX_CACHED_MEMORY = 11;
  MAX_CACHED_ENTRIES = 256;
  PRE_INIT_CACHE_ENTRIES = 32;

const
  PLATFORM_ALIGNMENT = (SizeOf(align_test));

function zend_strndup (s : PChar; length : Integer) : PChar; cdecl; external 'php4ts.dll';

function _emalloc(size: size_t; __zend_filename : PChar; __zend_lineno : uint; __zend_orig_filename : PChar; __zend_orig_line_no : uint) : pointer; cdecl; external 'php4ts.dll';
procedure _efree(ptr : pointer; __zend_filename : PChar; __zend_lineno : uint; __zend_orig_filename : PChar; __zend_orig_line_no : uint); cdecl; external 'php4ts.dll';
function _ecalloc(nmemb : size_t; size: size_t; __zend_filename : PChar; __zend_lineno : uint; __zend_orig_filename : PChar; __zend_orig_line_no : uint) : pointer; cdecl; external 'php4ts.dll';
function _erealloc(ptr : pointer; size: size_t; allow_failure: integer; __zend_filename : PChar; __zend_lineno : uint; __zend_orig_filename : PChar; __zend_orig_line_no : uint) : pointer; cdecl; external 'php4ts.dll';
function _estrdup(const s :PChar; __zend_filename : PChar; __zend_lineno : uint; __zend_orig_filename : PChar; __zend_orig_line_no : uint) : pointer; cdecl; external 'php4ts.dll';
function _estrndup(s: PChar; Len : Cardinal; __zend_filename : PChar; __zend_lineno : uint; __zend_orig_filename : PChar; __zend_orig_line_no : uint) : PChar; cdecl; external 'php4ts.dll';

function  emalloc(size : size_t) : pointer;
procedure efree(ptr : pointer);
function  ecalloc(nmemb : size_t; size: size_t) : pointer;
function  erealloc(ptr : pointer; size: size_t; allow_failure: integer) : pointer;
function  estrdup(const s :PChar) : PChar;
function  estrndup(s : PChar; len : Cardinal) : PChar;

function  zend_set_memory_limit(memory_limit : uint) : integer; cdecl; external 'php4ts.dll';
procedure start_memory_manager(TSRMLS_D : pointer); cdecl; external 'php4ts.dll';
procedure shutdown_memory_manager(silent : integer; clean_cache: integer; TSRMLS_DC : pointer); cdecl; external 'php4ts.dll';

//zend_hash.h
const
  HASH_KEY_IS_STRING = 1;
  HASH_KEY_IS_LONG = 2;
  HASH_KEY_NON_EXISTANT = 3;
  HASH_UPDATE = (1 shl 0);
  HASH_ADD = (1 shl 1);
  HASH_NEXT_INSERT = (1 shl 2);
  HASH_DEL_KEY = 0;
  HASH_DEL_INDEX = 1;

type

  hash_func_t = function (arKey : PChar; nKeyLength : uint) : ulong;
  
  compare_func_t = function (_noname1 : Pointer; _noname2 : Pointer; 
    TSRMLS_DC : Pointer) : integer; 
  
  
  dtor_func_t = procedure (pDest : Pointer);
  
  copy_ctor_func_t = procedure (pElement : Pointer);

  PBucket = ^TBucket;
  TBucket =
    record
      h : ulong;
      nKeyLength : uint;
      pData : Pointer;
      pDataPtr : Pointer;
      pListNext : PBucket;
      pListLast : PBucket;
      pNext : PBucket;
      pLast : PBucket;
      arKey : array[0..0] of char;
    end;

  PHashTable = ^THashTable;
  THashTable =
    record
      nTableSize : uint;
      nTableMask : uint;
      nNumOfElements : uint;
      nNextFreeElement : ulong;
      pInternalPointer : PBucket;
      pListHead : PBucket;
      pListTail : PBucket;
      arBuckets : ^PBucket;
      pDestructor : pointer;
      persistent : boolean;
      nApplyCount : Byte;
      bApplyProtection : boolean;
    end;

  HashPosition = PBucket;


  Pzend_class_entry = ^Tzend_class_entry;
  Tzend_class_entry =
  record
    _type : Char;
    name : PChar;
    name_length : uint;
    parent : pointer;
    refcount : pointer;
    constants_updated : boolean;
    function_table : THashTable;
    default_properties : THashTable;
    builtin_functions : pointer;
    handle_function_call : pointer;
    handle_property_get  : pointer;
    handle_property_set  : pointer;
  end;

  _zend_object  = record
     ce : Pzend_class_entry;
     properties : PHashTable;
  end;

  Tzend_Object = _zend_object;
  Pzend_Object = ^Tzend_object;

  Pzvalue_value = ^zvalue_value;
  zvalue_value = record
         case longint of
            0 : ( lval : longint );
            1 : ( dval : double );
            2 : ( str : record
                 val : PChar;
                 len : longint;
              end );
            3 : ( ht  : PHashTable );
            4 : ( obj : Pzend_Object );
         end;

  ppzval = ^pzval;
  Pzval = ^zval;
  zval = record
      value : zvalue_value;
      _type : Byte;
      is_ref : Byte;
      refcount : Smallint;
 end;

 ppzval_array = ^pzval_array;
 pzval_array = array of pzval;

{ startup/shutdown }

function zend_hash_init (ht : PHashTable; nSize : uint;
    pHashFunction : pointer; pDestructor : pointer;
    persistent : Integer) : Integer; cdecl; external 'php4ts.dll';

function zend_hash_init_ex(ht : PHashTable; nSize : uint;
    pHashFunction : pointer; pDestructor : pointer; 
    persistent    : Integer; bApplyProtection : boolean) : Integer; cdecl; external 'php4ts.dll';

procedure zend_hash_destroy (ht : PHashTable); cdecl; external 'php4ts.dll';
procedure zend_hash_clean (ht : PHashTable); cdecl; external 'php4ts.dll';

{ additions/updates/changes }

function zend_hash_add_or_update (ht : PHashTable; arKey : PChar; 
  nKeyLength : uint; pData : Pointer; nDataSize : uint; pDest : Pointer; 
  flag : Integer) : Integer; cdecl; external 'php4ts.dll';

function zend_hash_quick_add_or_update (ht : PHashTable; arKey : PChar; 
  nKeyLength : uint; h : ulong; pData : Pointer; nDataSize : uint;
  pDest : Pointer; flag : Integer) : Integer; cdecl; external 'php4ts.dll';

function zend_hash_index_update_or_next_insert (ht : PHashTable; h : ulong; 
 pData : Pointer; nDataSize : uint; pDest : Pointer; flag : Integer) : Integer; cdecl; external 'php4ts.dll';

function zend_hash_add_empty_element (ht : PHashTable; arKey : PChar; 
  nKeyLength : uint) : Integer; cdecl; external 'php4ts.dll';

const
  ZEND_HASH_APPLY_KEEP = 0;
  ZEND_HASH_APPLY_REMOVE = 1 shl 0;
  ZEND_HASH_APPLY_STOP = 1 shl 1;
  
type
  zend_hash_key = record
    arKey : PChar;
    nKeyLength : uint;
    h : ulong;
  end;
    
procedure zend_hash_graceful_destroy (ht : PHashTable); cdecl; external 'php4ts.dll';
procedure zend_hash_graceful_reverse_destroy (ht : PHashTable); cdecl; external 'php4ts.dll';


procedure zend_hash_apply (ht : PHashTable; apply_func : pointer; TSRMLS_DC : Pointer); cdecl; external 'php4ts.dll';

procedure zend_hash_apply_with_argument (ht : PHashTable;
  apply_func : pointer; _noname1 : Pointer; TSRMLS_DC : Pointer); cdecl; external 'php4ts.dll';

{ This function should be used with special care (in other words,
 * it should usually not be used).  When used with the ZEND_HASH_APPLY_STOP
 * return value, it assumes things about the order of the elements in the hash.
 * Also, it does not provide the same kind of reentrancy protection that
 * the standard apply functions do.
 }

procedure zend_hash_reverse_apply (ht : PHashTable; 
  apply_func : pointer; TSRMLS_DC : Pointer); cdecl; external 'php4ts.dll';

{ Deletes }

function zend_hash_del_key_or_index (ht : PHashTable; arKey : PChar; 
  nKeyLength : uint; h : ulong; flag : Integer) : Integer; cdecl; external 'php4ts.dll';

function zend_get_hash_value (ht : PHashTable; arKey : PChar; 
  nKeyLength : uint) : Longint; cdecl; external 'php4ts.dll';

{ Data retreival }

function zend_hash_find (ht : PHashTable; arKey : PChar; nKeyLength : uint; 
  pData : Pointer) : Integer; cdecl; external 'php4ts.dll';

function zend_hash_quick_find (ht : PHashTable; arKey : PChar; 
  nKeyLength : uint; h : ulong; pData : Pointer) : Integer; cdecl; external 'php4ts.dll';

function zend_hash_index_find (ht : PHashTable; h : ulong; pData : Pointer) : Integer; cdecl; external 'php4ts.dll';

{ Misc }

function zend_hash_exists (ht : PHashTable; arKey : PChar; nKeyLength : uint) : Integer; cdecl; external 'php4ts.dll';

function zend_hash_index_exists (ht : PHashTable; h : ulong) : Integer; cdecl; external 'php4ts.dll';

function zend_hash_next_free_element (ht : PHashTable) : Longint; cdecl; external 'php4ts.dll';

{ traversing }

function zend_hash_move_forward_ex (ht : PHashTable; pos : HashPosition) : Integer; cdecl; external 'php4ts.dll';

function zend_hash_move_backwards_ex (ht : PHashTable; pos : HashPosition) : Integer; cdecl; external 'php4ts.dll';

function zend_hash_get_current_key_ex (ht : PHashTable; 
    var str_index : PChar; var str_length : uint; var num_index : ulong; 
    duplicate : boolean; pos : HashPosition) : Integer; cdecl; external 'php4ts.dll';

function zend_hash_get_current_key_type_ex (ht : PHashTable; pos : HashPosition) : Integer; cdecl; external 'php4ts.dll';

function zend_hash_get_current_data_ex (ht : PHashTable; pData : Pointer; pos : HashPosition) : Integer; cdecl; external 'php4ts.dll';

procedure zend_hash_internal_pointer_reset_ex (ht : PHashTable; pos : HashPosition); cdecl; external 'php4ts.dll';

procedure zend_hash_internal_pointer_end_ex (ht : PHashTable; pos : HashPosition); cdecl; external 'php4ts.dll';

{ Copying, merging and sorting }

procedure zend_hash_copy (target : PHashTable; source : PHashTable; 
  pCopyConstructor : pointer; tmp : Pointer; size : uint); cdecl; external 'php4ts.dll';

procedure zend_hash_merge (target : PHashTable; source : PHashTable; 
  pCopyConstructor : pointer; tmp : Pointer; size : uint;  overwrite : Integer); cdecl; external 'php4ts.dll';


function zend_hash_sort (ht : PHashTable; sort_func : pointer; 
 compare_func : pointer; renumber : Integer; TSRMLS_DC : Pointer) : Integer; cdecl; external 'php4ts.dll';

function zend_hash_compare (ht1 : PHashTable; ht2 : PHashTable; 
  compar : pointer; ordered : boolean; TSRMLS_DC : Pointer) : Integer; cdecl; external 'php4ts.dll';

function zend_hash_minmax (ht : PHashTable; compar : pointer; 
  flag : Integer; pData : Pointer; TSRMLS_DC : Pointer) : Integer; cdecl; external 'php4ts.dll';

function zend_hash_num_elements (ht : PHashTable) : Integer; cdecl; external 'php4ts.dll';

function zend_hash_rehash (ht : PHashTable) : Integer; cdecl; external 'php4ts.dll';

function zend_hash_func (arKey : PChar; nKeyLength : uint) : Longint; cdecl; external 'php4ts.dll';

//zend_constants.h
const
  CONST_CS = (1 shl 0)                 { Case Sensitive }
  ;
  CONST_PERSISTENT = (1 shl 1)         { Persistent }
  ;

type
  zend_constant = 
    record
      value : zval;
      flags : Integer;
      name  : PChar;
      name_len : uint;
      module_number : Integer;
    end;

function zend_get_constant (name : PChar; name_len : uint; var result : zval; 
  TSRMLS_DC : Pointer) : Integer; cdecl; external 'php4ts.dll';

procedure zend_register_long_constant (name : PChar; name_len : uint; 
    lval : Longint; flags : Integer; module_number : Integer; TSRMLS_DC : Pointer); cdecl; external 'php4ts.dll';

procedure zend_register_double_constant (name : PChar; name_len : uint;  dval : Double; flags : Integer; module_number : Integer; 
  TSRMLS_DC : Pointer); cdecl; external 'php4ts.dll';

procedure zend_register_string_constant (name : PChar; name_len : uint; strval : PChar; flags : Integer; module_number : Integer; 
  TSRMLS_DC : Pointer); cdecl; external 'php4ts.dll';

procedure zend_register_stringl_constant (name : PChar; name_len : uint; 
    strval : PChar; strlen : uint; flags : Integer; module_number : Integer; 
    TSRMLS_DC : Pointer); cdecl; external 'php4ts.dll';

function zend_register_constant (var c : zend_constant; TSRMLS_DC : Pointer) : Integer; cdecl; external 'php4ts.dll';

procedure REGISTER_MAIN_LONG_CONSTANT(name : PChar; lval : longint; flags: integer; TSRMLS_DC : Pointer);
procedure REGISTER_MAIN_DOUBLE_CONSTANT(name : PChar; dval : double; flags : integer; TSRMLS_DC : Pointer);
procedure REGISTER_MAIN_STRING_CONSTANT(name : PChar; str : PChar; flags : integer; TSRMLS_DC : Pointer);
procedure REGISTER_MAIN_STRINGL_CONSTANT(name : PChar; str : PChar; len: uint; flags : integer; TSRMLS_DC : Pointer);

type
  zend_file_handle =
    record
      _type : uchar;
      filename : PChar;
      opened_path : PChar;
      handle :
        record
          case Integer of
            1 :
              (
                fd : Integer;
              );
            2 :
              (
                fp : pointer;
              );
      end;
      free_filename : short;
    end;

//TSRM.h

// Debug support
const
TSRM_ERROR_LEVEL_ERROR =1;
TSRM_ERROR_LEVEL_CORE  =2;
TSRM_ERROR_LEVEL_INFO  =3;

type
 ts_rsrc_id = integer;
 pts_rsrc_id = ^ts_rsrc_id;

function tsrm_startup(expected_threads : integer;
   expected_resources : integer; debug_level : integer; debug_filename : pchar) : integer; cdecl; external 'php4ts.dll';

function ts_allocate_id(rsrc_id : pts_rsrc_id; size : size_t; ctor : pointer; dtor : pointer) : ts_rsrc_id; cdecl; external 'php4ts.dll';
// deallocates all occurrences of a given id
procedure ts_free_id(id : ts_rsrc_id); cdecl; external 'php4ts.dll';

procedure tsrm_shutdown(void : pointer); cdecl; external 'php4ts.dll';
function ts_resource_ex(id : integer; p : pointer) : pointer; cdecl; external 'php4ts.dll';
procedure ts_free_thread; cdecl; external 'php4ts.dll';

procedure zend_error; cdecl; external 'php4ts.dll'; overload;
procedure zend_error(ErrType : integer; ErrText : PChar); cdecl; external 'php4ts.dll'; overload;
procedure zend_error_cb; cdecl; external 'php4ts.dll';

function zend_eval_string(str : pchar; val : pointer; strname : pchar; tsrm : pointer) : integer; cdecl; external 'php4ts.dll';
function zend_make_compiled_string_description(a : Pchar; tsrm: pointer) : PChar;  cdecl; external 'php4ts.dll';
procedure _zval_dtor(val : pzval; __zend_filename : PChar; __zend_lineno : uint); cdecl; external 'php4ts.dll';
function  _zval_copy_ctor(val : pzval; __zend_filename : PChar; __zend_lineno : uint): integer; cdecl; external 'php4ts.dll';
function zend_print_variable(val : pzval) : integer; cdecl; external 'php4ts.dll';

//zend_stack.h
type
  pzend_stack = ^Tzend_stack;
  zend_stack = 
    record
      top : Integer;
      max : Integer;
      elements : PPointer;
    end;
   Tzend_stack = zend_stack;
    
const
  STACK_BLOCK_SIZE = 64;

function zend_stack_init (stack : Pzend_stack) : Integer; cdecl; external 'php4ts.dll';

function zend_stack_push (stack : Pzend_stack; element : Pointer;
  size : Integer) : Integer; cdecl; external 'php4ts.dll';

function zend_stack_top (stack : Pzend_stack; element : Pointer) : Integer; cdecl; external 'php4ts.dll';

function zend_stack_del_top (stack : Pzend_stack) : Integer; cdecl; external 'php4ts.dll';

function zend_stack_int_top (stack : Pzend_stack) : Integer; cdecl; external 'php4ts.dll';

function zend_stack_is_empty (stack : Pzend_stack) : Integer; cdecl; external 'php4ts.dll';

function zend_stack_destroy (stack : Pzend_stack) : Integer; cdecl; external 'php4ts.dll';

function zend_stack_base (stack : Pzend_stack) : Pointer; cdecl; external 'php4ts.dll';

function zend_stack_count (stack : Pzend_stack) : Integer; cdecl; external 'php4ts.dll';

procedure zend_stack_apply (stack : Pzend_stack; _type : Integer; apply_function : Integer); cdecl; external 'php4ts.dll';

procedure zend_stack_apply_with_argument (stack : Pzend_stack;
  _type : Integer; apply_function : Integer; arg : Pointer); cdecl; external 'php4ts.dll';

const
  ZEND_STACK_APPLY_TOPDOWN = 1;
  ZEND_STACK_APPLY_BOTTOMUP = 2;

//zend_operators.h

procedure  _convert_to_string(op : pzval;  __zend_filename : PChar; __zend_lineno : uint); cdecl; external 'php4ts.dll'; 

procedure convert_to_string(op : pzval);

function add_function (_result : Pzval; op1 : Pzval; op2 : Pzval; 
  TSRMLS_DC : Pointer) : Integer; cdecl; external 'php4ts.dll';

function sub_function (_result : Pzval; op1 : Pzval; op2 : Pzval; 
  TSRMLS_DC : Pointer) : Integer; cdecl; external 'php4ts.dll';

function mul_function (_result : Pzval; op1 : Pzval; op2 : Pzval; 
  TSRMLS_DC : Pointer) : Integer; cdecl; external 'php4ts.dll';

function div_function (_result : Pzval; op1 : Pzval; op2 : Pzval; 
  TSRMLS_DC : Pointer) : Integer; cdecl; external 'php4ts.dll';

function mod_function (_result : Pzval; op1 : Pzval; op2 : Pzval; 
  TSRMLS_DC : Pointer) : Integer; cdecl; external 'php4ts.dll';

function boolean_xor_function (_result : Pzval;  op1 : Pzval; 
   op2 : Pzval; TSRMLS_DC : Pointer) : Integer; cdecl; external 'php4ts.dll';

function boolean_not_function (_result : Pzval; op1 : Pzval) : Integer; cdecl; external 'php4ts.dll';

function bitwise_not_function (_result : Pzval; op1 : Pzval) : Integer; cdecl; external 'php4ts.dll';

function bitwise_or_function (_result : Pzval;  op1 : Pzval;  op2 : Pzval;
  TSRMLS_DC : Pointer) : Integer; cdecl; external 'php4ts.dll';

function bitwise_and_function (_result : Pzval; op1 : Pzval; 
   op2 : Pzval; TSRMLS_DC : Pointer) : Integer; cdecl; external 'php4ts.dll';

function bitwise_xor_function (_result : Pzval; op1 : Pzval; 
  op2 : Pzval; TSRMLS_DC : Pointer) : Integer; cdecl; external 'php4ts.dll';

function shift_left_function (_result : Pzval;  op1 : Pzval;  op2 : Pzval; 
  TSRMLS_DC : Pointer) : Integer; cdecl; external 'php4ts.dll';

function shift_right_function (_result : Pzval;  op1 : Pzval; 
   op2 : Pzval; TSRMLS_DC : Pointer) : Integer; cdecl; external 'php4ts.dll';

function concat_function (_result : Pzval;  op1 : Pzval;  op2 : Pzval; 
  TSRMLS_DC : Pointer) : Integer; cdecl; external 'php4ts.dll';

function is_equal_function (_result : Pzval; op1 : Pzval;  op2 : Pzval;
  TSRMLS_DC : Pointer) : Integer; cdecl; external 'php4ts.dll';

function is_identical_function (_result : Pzval;  op1 : Pzval; 
  op2 : Pzval; TSRMLS_DC : Pointer) : Integer; cdecl; external 'php4ts.dll';

function is_not_identical_function (_result : Pzval;  op1 : Pzval; 
  op2 : Pzval; TSRMLS_DC : Pointer) : Integer; cdecl; external 'php4ts.dll';

function is_not_equal_function (_result : Pzval;  op1 : Pzval; 
  op2 : Pzval; TSRMLS_DC : Pointer) : Integer; cdecl; external 'php4ts.dll';

function is_smaller_function (_result : Pzval;  op1 : Pzval; op2 : Pzval; 
  TSRMLS_DC : Pointer) : Integer; cdecl; external 'php4ts.dll';

function is_smaller_or_equal_function (_result : Pzval;  op1 : Pzval; 
  var op2 : zval; TSRMLS_DC : Pointer) : Integer; cdecl; external 'php4ts.dll';

function increment_function (op1 : Pzval) : Integer; cdecl; external 'php4ts.dll';

function decrement_function (op2 : Pzval) : Integer; cdecl; external 'php4ts.dll';

procedure convert_scalar_to_number (op : Pzval; TSRMLS_DC : Pointer); cdecl; external 'php4ts.dll';

procedure convert_to_long (op : Pzval); cdecl; external 'php4ts.dll';

procedure convert_to_double (op : Pzval); cdecl; external 'php4ts.dll';

procedure convert_to_long_base (op : Pzval; base : Integer); cdecl; external 'php4ts.dll';

procedure convert_to_null (op : Pzval); cdecl; external 'php4ts.dll';

procedure convert_to_boolean (op : Pzval); cdecl; external 'php4ts.dll';

procedure convert_to_array (op : Pzval); cdecl; external 'php4ts.dll';

procedure convert_to_object (op : Pzval); cdecl; external 'php4ts.dll';

function add_char_to_string (_result : Pzval; op1 : Pzval; op2 : Pzval) : Integer; cdecl; external 'php4ts.dll';

function add_string_to_string (_result : Pzval; op1 : Pzval; 
  op2 : Pzval) : Integer; cdecl; external 'php4ts.dll';

function zend_string_to_double (number : PChar; length : zend_uint) : Double; cdecl; external 'php4ts.dll';

function zval_is_true (op : Pzval) : Integer; cdecl; external 'php4ts.dll';

function compare_function (_result : Pzval;  op1 : Pzval;  op2 : Pzval; 
  TSRMLS_DC : Pointer) : Integer; cdecl; external 'php4ts.dll';

function numeric_compare_function (_result : Pzval; op1 : Pzval; 
   op2 : Pzval; TSRMLS_DC : Pointer) : Integer; cdecl; external 'php4ts.dll';

function string_compare_function (_result : Pzval;  op1 : Pzval; 
  op2 : Pzval; TSRMLS_DC : Pointer) : Integer; cdecl; external 'php4ts.dll';

procedure zend_str_tolower (str : PChar; length : Integer); cdecl; external 'php4ts.dll';

function zend_binary_zval_strcmp (s1 : Pzval; s2 : Pzval) : Integer; cdecl; external 'php4ts.dll';

function zend_binary_zval_strncmp (s1 : Pzval; s2 : Pzval;  s3 : Pzval) : Integer; cdecl; external 'php4ts.dll';

function zend_binary_zval_strcasecmp (s1 : Pzval; s2 : Pzval) : Integer; cdecl; external 'php4ts.dll';

function zend_binary_zval_strncasecmp (s1 : Pzval; s2 : Pzval; 
  s3 : Pzval) : Integer; cdecl; external 'php4ts.dll';

function zend_binary_strcmp (s1 : PChar; len1 : uint; s2 : PChar; len2 : uint) : Integer; cdecl; external 'php4ts.dll';

function zend_binary_strncmp (s1 : PChar; len1 : uint; s2 : PChar; len2 : uint; 
  length : uint) : Integer; cdecl; external 'php4ts.dll';

function zend_binary_strcasecmp (s1 : PChar; len1 : uint; s2 : PChar; 
  len2 : uint) : Integer; cdecl; external 'php4ts.dll';

function zend_binary_strncasecmp (s1 : PChar; len1 : uint; s2 : PChar; 
  len2 : uint; length : uint) : Integer; cdecl; external 'php4ts.dll';

procedure zendi_smart_strcmp (_result : zval;  s1 : Pzval; s2 : Pzval);  cdecl; external 'php4ts.dll';

procedure zend_compare_symbol_tables (_result : Pzval;  ht1 : PHashTable;
   ht2 : PHashTable; TSRMLS_DC : Pointer); cdecl; external 'php4ts.dll';

procedure zend_compare_arrays (_result : zval;  a1 : Pzval;  a2 : Pzval; 
  TSRMLS_DC : Pointer); cdecl; external 'php4ts.dll';

procedure zend_compare_objects (_result : Pzval;  o1 : Pzval;  o2 : Pzval;
  TSRMLS_DC : Pointer); cdecl; external 'php4ts.dll';

function zend_atoi (str : PChar; str_len : Integer) : Integer; cdecl; external 'php4ts.dll';

//zend_execute.h
function get_active_function_name (TSRMLS_D : pointer) : PChar; cdecl; external 'php4ts.dll';

function zend_get_executed_filename (TSRMLS_D : pointer) : PChar; cdecl; external 'php4ts.dll';

procedure zend_set_timeout (seconds : Longint); cdecl; external 'php4ts.dll';

procedure zend_unset_timeout (TSRMLS_D : pointer); cdecl; external 'php4ts.dll';

procedure zend_timeout (dummy : Integer); cdecl; external 'php4ts.dll';

//zend_highlight.h
const
  HL_COMMENT_COLOR = '#FF8000'         { orange }
  ;
  HL_DEFAULT_COLOR = '#0000BB'         { blue }
  ;
  HL_HTML_COLOR = '#000000'            { black }
  ;
  HL_STRING_COLOR = '#DD0000'          { red }
  ;
  HL_BG_COLOR = '#FFFFFF'              { white }
  ;
  HL_KEYWORD_COLOR = '#007700'         { green }
  ;

type
  Pzend_syntax_highlighter_ini = ^Tzend_syntax_highlighter_ini;
  zend_syntax_highlighter_ini =
    record
      highlight_html : PChar;
      highlight_comment : PChar;
      highlight_default : PChar;
      highlight_string : PChar;
      highlight_keyword : PChar;
    end;
  Tzend_syntax_highlighter_ini = zend_syntax_highlighter_ini;

procedure zend_highlight (syntax_highlighter_ini : Pzend_syntax_highlighter_ini;
  TSRMLS_DC : Pointer); cdecl; external 'php4ts.dll';

procedure zend_strip (TSRMLS_D : pointer); cdecl; external 'php4ts.dll';

function highlight_file (filename : PChar;
     syntax_highlighter_ini : Pzend_syntax_highlighter_ini;
     TSRMLS_DC : Pointer) : Integer; cdecl; external 'php4ts.dll';

function highlight_string (str : Pzval;
     syntax_highlighter_ini : Pzend_syntax_highlighter_ini; str_name : PChar;
     TSRMLS_DC : Pointer) : Integer; cdecl; external 'php4ts.dll';

procedure zend_html_putc (c : Char); cdecl; external 'php4ts.dll';

procedure zend_html_puts (s : PChar; len : uint; TSRMLS_DC : Pointer); cdecl; external 'php4ts.dll';

procedure zend_indent; cdecl; external 'php4ts.dll';

function zend_get_parameters_ex(number : integer; AValue : pointer) : integer; cdecl; external 'php4ts.dll';

function _zend_get_parameters_array_ex(param_count: integer; argument_array: ppzval_array; TSRMLS_CC: pointer) : integer; cdecl; external 'php4ts.dll';


procedure zend_ini_refresh_caches (stage : Integer; TSRMLS_DC : Pointer); cdecl; external 'php4ts.dll';

const
  ZEND_INI_USER = (1 shl 0);
  ZEND_INI_PERDIR = (1 shl 1);
  ZEND_INI_SYSTEM = (1 shl 2);
  ZEND_INI_ALL = (ZEND_INI_USER or ZEND_INI_PERDIR or ZEND_INI_SYSTEM);

  ZEND_INI_DISPLAY_ORIG = 1;
  ZEND_INI_DISPLAY_ACTIVE = 2;
  ZEND_INI_STAGE_STARTUP = (1 shl 0);
  ZEND_INI_STAGE_SHUTDOWN = (1 shl 1);
  ZEND_INI_STAGE_ACTIVATE = (1 shl 2);
  ZEND_INI_STAGE_DEACTIVATE = (1 shl 3);
  ZEND_INI_STAGE_RUNTIME = (1 shl 4);
  
function zend_alter_ini_entry (name : PChar; name_length : uint;
  new_value : PChar; new_value_length : uint; modify_type : Integer; 
  stage : Integer) : Integer; cdecl; external 'php4ts.dll';

function zend_restore_ini_entry (name : PChar; name_length : uint; 
  stage : Integer) : Integer; cdecl; external 'php4ts.dll';

function zend_ini_long (name : PChar; name_length : uint; orig : Integer) : Longint; cdecl; external 'php4ts.dll';

function zend_ini_double (name : PChar; name_length : uint; orig : Integer) : Double; cdecl; external 'php4ts.dll';

function zend_ini_string (name : PChar; name_length : uint; orig : Integer) : PChar; cdecl; external 'php4ts.dll';

function compile_string(source_string : pzval; filename : PChar; TSRMLS_DC : Pointer) : pointer; cdecl; external 'php4ts.dll';

procedure execute(op_array : pointer; TSRMLS_DC : Pointer); cdecl; external 'php4ts.dll';

procedure zend_wrong_param_count(TSRMLS_D : pointer); cdecl; external 'php4ts.dll';


function add_property_long_ex(arg : pzval; key : PChar; key_len : uint; l : longint) : integer; cdecl; external 'php4ts.dll';
function add_property_null_ex(arg : pzval; key : PChar; key_len : uint): integer; cdecl; external 'php4ts.dll';
function add_property_bool_ex(arg : pzval; key : PChar; key_len : uint; b : integer) : integer; cdecl; external 'php4ts.dll';
function add_property_resource_ex(arg : pzval; key : PChar; key_len : uint; r : integer) : integer; cdecl; external 'php4ts.dll';
function add_property_double_ex(arg : pzval; key : PChar; key_len : uint;  d : double) : integer; cdecl; external 'php4ts.dll';
function add_property_string_ex(arg : pzval; key : PChar; key_len : uint; str : PChar; duplicate : integer) : integer; cdecl; external 'php4ts.dll';
function add_property_stringl_ex(arg : pzval; key : PChar; key_len : uint;  str : PChar; len: uint; duplicate : integer) : integer; cdecl; external 'php4ts.dll';
function add_property_zval_ex(arg : pzval; key : PChar; key_len : uint; value : pzval) : integer; cdecl; external 'php4ts.dll';


function add_assoc_long_ex(arg : pzval; key : PChar; key_len : uint; n : longint) : integer; cdecl; external 'php4ts.dll';
function add_assoc_null_ex(arg : pzval; key : PChar; key_len : uint) : integer; cdecl; external 'php4ts.dll';
function add_assoc_bool_ex(arg : pzval; key : PChar; key_len : uint;  b : integer) : integer; cdecl; external 'php4ts.dll';
function add_assoc_resource_ex(arg : pzval; key : PChar; key_len : uint;  r : integer) : integer; cdecl; external 'php4ts.dll';
function add_assoc_double_ex(arg : pzval; key : PChar; key_len : uint; d : double) : integer; cdecl; external 'php4ts.dll';
function add_assoc_string_ex(arg : pzval; key : PChar; key_len : uint; str : PChar; duplicate : integer) : integer; cdecl; external 'php4ts.dll';
function add_assoc_stringl_ex(arg : pzval; key : PChar; key_len : uint; str : PChar; len : uint; duplicate : integer) : integer; cdecl; external 'php4ts.dll';
function add_assoc_zval_ex(arg : pzval; key : PChar; key_len : uint; value : pzval) : integer; cdecl; external 'php4ts.dll';


function add_index_long(arg : pzval; idx : uint; n : longint) : integer; cdecl; external 'php4ts.dll';
function add_index_null(arg : pzval; idx : uint) : integer; cdecl; external 'php4ts.dll';
function add_index_bool(arg : pzval; idx : uint;  b : integer) : integer; cdecl; external 'php4ts.dll';
function add_index_resource(arg : pzval; idx : uint;  r : integer) : integer; cdecl; external 'php4ts.dll';
function add_index_double(arg : pzval; idx : uint; d : double) : integer; cdecl; external 'php4ts.dll';
function add_index_string(arg : pzval; idx : uint; str : PChar; duplicate : integer) : integer; cdecl; external 'php4ts.dll';
function add_index_stringl(arg : pzval; idx: uint; str : PChar; len : uint; duplicate : integer) : integer; cdecl; external 'php4ts.dll';
function add_index_zval(arg : pzval; index : uint; value : pzval) : integer; cdecl; external 'php4ts.dll';

function add_next_index_long(arg : pzval; n : longint) : integer; cdecl; external 'php4ts.dll';
function add_next_index_null(arg : pzval) : integer; cdecl; external 'php4ts.dll';
function add_next_index_bool(arg : pzval;  b : integer) : integer; cdecl; external 'php4ts.dll';
function add_next_index_resource(arg : pzval;  r : integer) : integer; cdecl; external 'php4ts.dll';
function add_next_index_double(arg : pzval; d : double) : integer; cdecl; external 'php4ts.dll';
function add_next_index_string(arg : pzval; str : PChar; duplicate : integer) : integer; cdecl; external 'php4ts.dll';
function add_next_index_stringl(arg : pzval; str : PChar; len : uint; duplicate : integer) : integer; cdecl; external 'php4ts.dll';
function add_next_index_zval(arg : pzval; value : pzval) : integer; cdecl; external 'php4ts.dll';


function add_get_assoc_string_ex(arg : pzval; key : PChar; key_len : uint; str : PChar; dest : pointer; duplicate : integer) : integer; cdecl; external 'php4ts.dll';
function add_get_assoc_stringl_ex(arg : pzval;key : PChar; key_len : uint; str : PChar; len: uint; dest: pointer; duplicate : integer) : integer; cdecl; external 'php4ts.dll';


function add_get_index_long(arg : pzval;  idx : uint;  l : longint; dest : pointer) : integer; cdecl; external 'php4ts.dll';
function add_get_index_double(arg : pzval; idx : uint;  d : double; dest : pointer) : integer; cdecl; external 'php4ts.dll';
function add_get_index_string(arg : pzval; idx : uint; str : PChar; dest : pointer;  duplicate : integer) : integer; cdecl; external 'php4ts.dll';
function add_get_index_stringl(arg : pzval; idx : uint; str : PChar; len : uint; dest : pointer; duplicate : integer) : integer; cdecl; external 'php4ts.dll';

function _array_init(arg : pzval; __zend_filename : pchar; __zend_lineno : uint) : integer; cdecl; external 'php4ts.dll';
function _object_init(arg : pzval; __zend_filename : PChar; __zend_lineno : uint; TSRMLS_DC : pointer) : integer; cdecl; external 'php4ts.dll';
function _object_init_ex(arg : pzval; ce : pointer; __zend_filename : pchar;  __zend_lineno : uint; TSRMLS_DC : pointer) : integer; cdecl; external 'php4ts.dll';
function _object_and_properties_init(arg : pzval; ce : pointer; properties : phashtable; __zend_filename : pchar; __zend_lineno : uint; TSRMLS_DC : pointer) : integer; cdecl; external 'php4ts.dll';


type
  Pdynamic_array = ^Tdynamic_array;
  Tdynamic_array =
    record
      arr : PChar;
      element_size : Integer;
      last_used : Integer;
      allocated : Integer;
    end;

function zend_dynamic_array_init (da : pdynamic_array) : Integer; cdecl; external 'php4ts.dll';
function zend_dynamic_array_push (da : pdynamic_array) : Pointer; cdecl; external 'php4ts.dll';
function zend_dynamic_array_pop (da  : pdynamic_array) : Pointer; cdecl; external 'php4ts.dll';
function zend_dynamic_array_get_element (da : pdynamic_array;
  index : Integer) : Pointer; cdecl; external 'php4ts.dll';

type
  zend_write_t = function (str : PChar; str_length : integer) : integer; cdecl;

var
  zend_write : zend_write_t;

procedure ZEND_PUTS(str : PChar);

type

 Pzend_function_entry = ^Tzend_function_entry;
 zend_function_entry = record
    fname : Pchar;
    handler : pointer;
    func_arg_types : Pbyte;
 end;
 Tzend_function_entry = zend_function_entry;

 Pzend_module_entry = ^Tzend_module_entry;
 Tzend_module_entry = record
  size : word;
  zend_api : dword;
  zend_debug : byte;
  zts : byte;
  name : pchar;
  functions : pointer;
  module_startup_func   : pointer;
  module_shutdown_func  : pointer;
  request_startup_func  : pointer;
  request_shutdown_func : pointer;
  info_func : pointer;
  version : pchar;
  global_startup_func  : pointer;
  global_shutdown_func : pointer;
  global_id : integer;
  module_started : integer;
  _type : byte;
  handle : pointer;
  module_number : longint;
 end;


function zend_register_internal_class(class_entry: pzend_class_entry; TSRMLS_DC : pointer) : Pzend_class_entry; cdecl; external 'php4ts.dll';
function zend_register_internal_class_ex(class_entry : pzend_class_entry; parent_ce : pzend_class_entry; parent_name: Pchar; TSRMLS_DC : pointer) : Pzend_class_entry; cdecl; external 'php4ts.dll';

procedure ZVAL_RESOURCE(value : pzval; l : longint);
procedure ZVAL_BOOL(z : pzval; b : boolean);
procedure ZVAL_NULL(z : pzval);
procedure ZVAL_LONG(z : pzval; l : longint);
procedure ZVAL_DOUBLE(z : pzval; d : double);
procedure ZVAL_STRING(z : pzval; s : pchar; duplicate : boolean);
procedure ZVAL_STRINGL(z : pzval; s : pchar; l : integer; duplicate : boolean);
procedure ZVAL_EMPTY_STRING(z : pzval);
procedure ZVAL_TRUE(z : pzval);
procedure ZVAL_FALSE(z : pzval);


type
  pzend_list_element = ^zend_list_element;
  zend_list_element = record
    prev : pzend_list_element;
    next : pzend_list_element;
    data : char;
  end;
  
  pzend_llist = ^zend_llist;
  zend_llist = record
     head : pzend_list_element;
     tail : pzend_list_element;
     size : size_t;
     count : size_t;
     dtor : pointer;
     persistent : byte;
     traverse_ptr : pzend_list_element;
  end;

procedure INIT_CLASS_ENTRY(var class_container : Tzend_class_entry; class_name : pchar; functions : pointer);


type
  _zend_property_reference = record
    _type : integer;
    _object : pzval;
    elements_list: pzend_llist;
  end;

  Tzend_property_reference = _zend_property_reference;
  Pzend_property_reference = ^Tzend_property_reference;

function  get_zend_version() : PChar; cdecl; external 'php4ts.dll';
procedure zend_make_printable_zval(expr : pzval; expr_copy: pzval; use_copy : pint); cdecl; external 'php4ts.dll';
function  zend_print_zval(expr : pzval; indent : integer) : integer; cdecl; external 'php4ts.dll';
procedure zend_print_zval_r(expr : pzval; indent : integer); cdecl; external 'php4ts.dll';
procedure zend_output_debug_string(trigger_break : boolean; Msg : PChar); cdecl; external 'php4ts.dll';


type
  //Zend internal function
  TInternalFunction = procedure (ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer); cdecl;

  PInitFunction = ^TInitFunction;
  TInitFunction = function(_type : integer; module_number : integer; TSRMLS_DC : pointer) : integer; cdecl;

  PShutdownFunction = ^TShutdownFunction;
  TShutdownFunction = function(_type : integer; module_number : integer; TSRMLS_DC : pointer) : integer; cdecl;

  PZendModuleInfoFunction = ^TZendModuleInfoFunction;
  TZendModuleInfoFunction = procedure ( zend_module : Pzend_module_entry; TSRMLS_DC : pointer); cdecl;

  //global startup and shutdown function
  TZendGlobalFunction = procedure(); cdecl;

  TZendModuleType = (mtPersistent, mtTemporary);

const
 ZVAL_CACHE_LIST = 0;

function ZEND_FAST_ALLOC : pzval;
function ALLOC_ZVAL : pzval;
procedure INIT_PZVAL(p : pzval);
function MAKE_STD_ZVAL : pzval;

function PHPLoaded : boolean;

var
 PHPLib : THandle = 0;

implementation


function estrndup(s : PChar; len : Cardinal) : PChar;
begin
   Result := _estrndup(s, len, nil, 0, nil, 0);
end;

function  emalloc(size : size_t) : pointer;
begin
  Result := _emalloc(size, nil, 0, nil, 0);
end;

procedure efree(ptr : pointer);
begin
  _efree(ptr, nil, 0, nil, 0);
end;

function  ecalloc(nmemb : size_t; size: size_t) : pointer;
begin
  Result := _ecalloc(nmemb, size, nil, 0, nil, 0);
end;

function  erealloc(ptr : pointer; size: size_t; allow_failure: integer) : pointer;
begin
  Result :=  _erealloc(ptr, size, allow_failure, nil, 0, nil, 0);
end;

function  estrdup(const s :PChar) : PChar;
begin
  Result := _estrdup(s, nil, 0, nil, 0);
end;

procedure REGISTER_MAIN_LONG_CONSTANT(name : PChar; lval : longint; flags: integer; TSRMLS_DC : Pointer);
begin
  zend_register_long_constant(name, length(name) +1, lval, flags, 0, TSRMLS_DC);
end;

procedure REGISTER_MAIN_DOUBLE_CONSTANT(name : PChar; dval : double; flags : integer; TSRMLS_DC : Pointer);
begin
  zend_register_double_constant(name, length(name) +1, dval, flags, 0, TSRMLS_DC);
end;

procedure REGISTER_MAIN_STRING_CONSTANT(name : PChar; str : PChar; flags : integer; TSRMLS_DC : Pointer);
begin
  zend_register_string_constant(name, length(name) +1, str, flags, 0, TSRMLS_DC);
end;

procedure REGISTER_MAIN_STRINGL_CONSTANT(name : PChar; str : PChar; len: uint; flags : integer; TSRMLS_DC : Pointer);
begin
  zend_register_stringl_constant(name, length(name) +1, str, len, flags, 0, TSRMLS_DC);
end;


procedure ZVAL_RESOURCE(value : pzval; l : longint);
begin
  value^._type := IS_RESOURCE;
  value^.value.lval := l;
end;

procedure ZVAL_BOOL(z : pzval; b : boolean);
begin
  z^._type := IS_BOOL;
  z^.value.lval := integer(b);
end;


procedure ZVAL_NULL(z : pzval);
begin
  z^._type := IS_NULL;
end;


procedure ZVAL_LONG(z : pzval; l : longint);
begin
  z^._type := IS_LONG;
  z^.value.lval := l;
end;

procedure ZVAL_DOUBLE(z : pzval; d : double);
begin
 z^._type := IS_DOUBLE;
 z^.value.dval := d;
end;

procedure ZVAL_STRING(z : pzval; s : pchar; duplicate : boolean);
var
 __s : pchar;
begin
 __s := s;
 z^.value.str.len := strlen(__s);
 if duplicate then
    z^.value.str.val := estrndup(__s, z^.value.str.len)
     else
      z^.value.str.val := __s;
 z^._type := IS_STRING;
end;

procedure ZVAL_STRINGL(z : pzval; s : pchar; l : integer; duplicate : boolean);
var
 __s : pchar;
 __l : integer;
begin
  __s := s;
  __l := l;
 z^.value.str.len := __l;
 if duplicate then
   z^.value.str.val := estrndup(__s, __l)
    else
      z^.value.str.val := __s;
  z^._type := IS_STRING;		    
end;

procedure ZVAL_EMPTY_STRING(z : pzval);
begin
  z^.value.str.len := 0;
  z^.value.str.val := '';
  z^._type := IS_STRING;
end;

procedure ZVAL_TRUE(z : pzval);
begin
  z^._type := IS_BOOL;
  z^.value.lval := 1;
end;

procedure ZVAL_FALSE(z : pzval);
begin
  z^._type := IS_BOOL;
  z^.value.lval := 0;
end;

function PHPLoaded : boolean;
begin
  Result := PHPLib <> 0;
end;

procedure UnloadPHP;
begin
  if PHPLoaded then
   begin
     FreeLibrary(PHPLib);
     PHPLib := 0;
   end;
end;

procedure LoadPHP;
var
 WriteFuncPtr : pointer;
begin
  PHPLib := LoadLibrary('php4ts.dll');
  {$IFNDEF QUET_LOAD}
  if PHPLib = 0 then
   raise Exception.Create('php4ts.dll not found');
  {$ENDIF}
  WriteFuncPtr := GetProcAddress(PHPLib, 'zend_write');
  if Assigned(WriteFuncPtr) then
   @zend_write := pointer(WriteFuncPtr^);
end;


procedure ZEND_PUTS(str : PChar);
begin
   zend_write(str, strlen(str));
end;

procedure convert_to_string(op : pzval);
begin
  _convert_to_string(op, nil, 0);
end;


procedure INIT_CLASS_ENTRY(var class_container : Tzend_class_entry; class_name : pchar; functions : pointer);
begin
  class_container.name := estrdup(class_name);
  class_container.name_length := strlen(class_name);
  class_container.builtin_functions := functions;
  class_container.handle_function_call := nil;
  class_container.handle_property_get := nil;
  class_container.handle_property_set := nil;
end;

function ZEND_FAST_ALLOC : pzval;
begin
  Result := emalloc(sizeof(zval));
end;

function ALLOC_ZVAL : pzval;
begin
  Result := emalloc(sizeof(zval));
end;

procedure INIT_PZVAL(p : pzval);
begin
  p^.refcount := 1;
  p^.is_ref := 0;
end;

function MAKE_STD_ZVAL : pzval;
begin
  Result := ALLOC_ZVAL;
  INIT_PZVAL(Result);
end;

initialization
  LoadPHP;
finalization
  UnloadPHP;
end.