    ' This file is provided as part of ASP Power Widgets Samples
    '
    ' THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT
    ' WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED,
    ' INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
    ' OF MERCHANTABILITY AND/OR FITNESS FOR A  PARTICULAR
    ' PURPOSE.

    ' Copyright 1998-2002. All rights reserved.
    ' Dalun Software Inc. ASP Power Widgets
    ' http://dalun.com 
    ' mail: sales@dalun.com
    ' mail: techsupport@dalun.com
    ' if you have any suggestions or requirements, please write to us.
    ' Revisions:
    ' 2.0.0   Initial release

    Option explicit
    
    Dim strTicket
    Dim strXMLMailList
    Dim objPOP3
    Dim objMailListXMLDOM
    
    Dim strServer
    Dim strUserId
    Dim strPassword
    Dim oNodes
    Dim item
    Dim objMailXMLDOM
    
    Set objPOP3 = CreateObject("ASPPW.POP3.1")

    If WScript.Arguments.Count <> 3 Then
        WScript.Echo "Usage: cscript POP3Demo.vbs <POP3 Server> <UserId> <Password>"
        WScript.Quit(0)
    End If

    strServer = WScript.Arguments(0)
    strUserId = WScript.Arguments(1)
    strPassword = WScript.Arguments(2)
    
    strTicket =  objPOP3.logon(strServer, "110", strUserId, strPassword)

    'SegSize=100,000, SegNum=0, Assuming you won't have mails more than 100,000.
    Set objMailListXMLDOM = objPOP3.getmaillist(strTicket, 100000, 0)  

    Set oNodes = objMailListXMLDOM.selectNodes("//MailList/*")

    WScript.Echo "You have " & oNodes.Length & " mail(s)." & vbCRLF
    WSCRIPT.ECHO strXMLMailList 

    'Refresh your session ticket, so the connection manager will keep your connection. 
    'It is important for Web application.
    strTicket = objPOP3.refreshticket(strTicket)

    For Each item in oNodes
        Dim id, strRaw
        Set id = item.selectSingleNode("@Id")
        strRaw = objPOP3.GetRawMailData(strTicket, CLng(id.text))
        WScript.Echo "Mail: " & id.text 
        WScript.Echo strRaw
    Next

    'Refresh your session ticket, so the connection manager will keep your connection. 
    'It is important for Web application.
    strTicket = objPOP3.refreshticket(strTicket)

    'Read a mail wrapped in XML with id = 1, save attachments at c:\
    Set objMailXMLDOM = objPOP3.getmail(strTicket, 1, "c:\") 
    WSCRIPT.ECHO objMailXMLDOM.xml

    CALL objPOP3.deletemail(strTicket, 1)
    WSCRIPT.ECHO "A mail was deleted."

    'To commit the above deletion, you need to uncomment below to call commitdelete.
    'CALL objPOP3.commitdelete
    'WSCRIPT.ECHO "A mail was truly deleted."


