# **********************************************#
# DAPINGSTER-v0.5 []				#
# by: dapingster@mindless.com			#
# Release Date: 5th February 2003		#		
# **********************************************#

#################### Get Configuration Parameters ####################

open (F, "config") || die "Can't open config file, error = $!\n";;
while(<F>) 
{
	@Fields = split(/=/);
	
	if ( $Fields[0] eq "IP_ONE" )
	{
		$ip_one = $Fields[1];
	}

	elsif ( $Fields[0] eq "IP_TWO" )
	{
		$ip_two = $Fields[1];
	}

	elsif ( $Fields[0] eq "IP_THREE" )
	{
		$ip_three = $Fields[1];
	}

	elsif ( $Fields[0] eq "SMTP_SERVER" )
	{
		$smtp_server = $Fields[1];
	}

	elsif ( $Fields[0] eq "SENDER" )
	{
		$sender = $Fields[1];
	}
	
	elsif ( $Fields[0] eq "RECEIVER" )
	{
		$receiver = $Fields[1];
	}

	elsif ( $Fields[0] eq "LINE_DOWN_MESSAGE" )
	{
		$line_down_message = $Fields[1];
	}
	
}
close(F);

#################### Create Batch File ####################

open(OUT, ">pingster.bat") || die "Can't create new file, error = $!\n";
print OUT "\@echo off\n";
print OUT "attrib +h pingster.bat\n";
print OUT "set ip_one=" . $ip_one;
print OUT "set ip_two=" . $ip_two;
print OUT "set ip_three=" . $ip_three;
print OUT "echo Date: %date% > ipone\n";
print OUT "attrib +h ipone\n";
print OUT "echo Time: %time% >> ipone\n";
print OUT "ping -n 10 -w 1000 %ip_one% >> ipone\n";
print OUT "echo Date: %date% > iptwo\n";
print OUT "attrib +h iptwo\n";
print OUT "echo Time: %time% >> iptwo\n";
print OUT "ping -n 10 -w 1000 %ip_two% >> iptwo\n";
print OUT "echo Date: %date% > ipthree\n";
print OUT "attrib +h ipthree\n";
print OUT "echo Time: %time% >> ipthree\n";
print OUT "ping -n 10 -w 1000 %ip_three% >> ipthree\n";
print OUT "find /c \"TTL\" < ipone | more > countone\n";
print OUT "attrib +h countone\n";
print OUT "find /c \"TTL\" < iptwo | more > counttwo\n";
print OUT "attrib +h counttwo\n";
print OUT "find /c \"TTL\" < ipthree | more > countthree\n";
print OUT "attrib +h countthree\n";

close(OUT);

#################### Execute Batch File ####################

$BATCH = "pingster.bat";
system($BATCH);

#################### Calculate Line QUality ####################

$file = 'countone';
open(INFO, $file);
$count1 = <INFO>;
close(INFO);

$file = 'counttwo';
open(INFO, $file);
$count2 = <INFO>;
close(INFO);

$file = 'countthree';
open(INFO, $file);
$count3 = <INFO>;
close(INFO);

$average =  ($count1 + $count2 + $count3) / 30;
$percentage = $average * 100;

#################### Ping Logging ####################

$file = 'ipone';
open(IPONE, $file) || die "Can't open file, error = $!\n";;
@pingone = <IPONE>;
close(IPONE);

$file = 'iptwo';
open(IPTWO, $file) || die "Can't open file, error = $!\n";;
@pingtwo = <IPTWO>;
close(IPTWO);

$file = 'ipthree';
open(IPTHREE, $file) || die "Can't open file, error = $!\n";;
@pingthree = <IPTHREE>;
close(IPTHREE);

open(LOG, ">pinglog.txt") || die "Can't create log file, error = $!\n";
print LOG "\n******************** DAPINGSTER v0.5 LOGGER *****************\n\n";
print LOG "FIRST IP: $ip_one\n\n";
print LOG @pingone;
print LOG "\n************************************************************\n\n";
print LOG "SECOND IP: $ip_two\n\n";
print LOG @pingtwo;
print LOG "\n************************************************************\n\n";
print LOG "THIRD IP: $ip_three\n\n";
print LOG @pingthree;
print LOG "\n************************ END OF LOG ************************\n\n";
close(LOG);

if( $percentage < 30)
{
	open(IN, "pinglog.txt") || die "can't open file, error = $!\n";
	open(OUT, ">>failure_log.txt") || die "Can't create new file, error = $!\n";
	while (<IN>) {
	    print OUT $_;
	}
	close(IN);
	close(OUT);
}


#################### Send Email ####################

open(INFO, "pinglog.txt");
@lines = <INFO>;
close(INFO);

if( $percentage < 30)
{
	use Net::SMTP;
 
        $smtp = Net::SMTP->new($smtp_server);
        $smtp->mail($sender);
        $smtp->to($receiver);
        $smtp->data();
 
        # Send the header.
        $smtp->datasend("To: $receiver");
        $smtp->datasend("From: $sender");
        $smtp->datasend("Subject: DAPINGSTER Line Quality Alert!\n");
	$smtp->datasend("Mime-Version: 1.0\n");
	$smtp->datasend("Content-Type: text/plain; charset=\"us-ascii\"; format=flowed\n\n");
 
        # Send the body.
        $smtp->datasend("************************* DAPINGSTER v0.5 LINE QUALITY ALERT *************************\n\n");
        $smtp->datasend("LINE QUALITY: $percentage %\n\n");
        $smtp->datasend("STATISTICS:\n");
        $smtp->datasend(@lines);
        $smtp->datasend("\nMESSAGE:\n");
        $smtp->datasend($line_down_message);
	$smtp->datasend("\n\n\n");
        $smtp->datasend("******************** This message is generated by DAPINGSTER v0.5 ********************\n");
        $smtp->dataend();
        $smtp->quit;
 
}


#################### Delete Temporary Files ####################

system("del /a h ipone");
system("del /a h iptwo");
system("del /a h ipthree");
system("del /a h countone");
system("del /a h counttwo");
system("del /a h countthree");
system("del /a h pingster.bat");
