/*
 * Decompiled with CFR 0.152.
 */
package com.standbysoft.datepicker;

import com.standbysoft.datepicker.DefaultMonthModel;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import junit.framework.Assert;
import junit.framework.TestCase;

public class DefaultMonthModelTest
extends TestCase {
    public void testDefaultDateModel() {
        DefaultMonthModel defaultMonthModel = new DefaultMonthModel();
        Assert.assertEquals((int)defaultMonthModel.getDowNamesFormat(), (int)0);
        Assert.assertEquals((int)defaultMonthModel.getMonthNamesFormat(), (int)4);
        Assert.assertEquals((int)defaultMonthModel.getDowFirst(), (int)Calendar.getInstance(Locale.getDefault()).getFirstDayOfWeek());
        DefaultMonthModel defaultMonthModel2 = new DefaultMonthModel(Locale.US);
        Assert.assertEquals((int)defaultMonthModel2.getDowNamesFormat(), (int)0);
        Assert.assertEquals((int)defaultMonthModel2.getMonthNamesFormat(), (int)4);
        Assert.assertEquals((int)defaultMonthModel2.getDowFirst(), (int)Calendar.getInstance(Locale.US).getFirstDayOfWeek());
        DefaultMonthModel defaultMonthModel3 = new DefaultMonthModel(Locale.UK, 0, 4);
        Assert.assertEquals((int)defaultMonthModel3.getDowNamesFormat(), (int)0);
        Assert.assertEquals((int)defaultMonthModel3.getMonthNamesFormat(), (int)4);
        Assert.assertEquals((int)defaultMonthModel3.getDowFirst(), (int)Calendar.getInstance(Locale.UK).getFirstDayOfWeek());
        DefaultMonthModel defaultMonthModel4 = new DefaultMonthModel(Locale.ITALY, 5, 1, 4);
        Assert.assertEquals((int)defaultMonthModel4.getDowNamesFormat(), (int)1);
        Assert.assertEquals((int)defaultMonthModel4.getMonthNamesFormat(), (int)4);
        Assert.assertEquals((int)defaultMonthModel4.getDowFirst(), (int)5);
    }

    public void testSetDowFirst() {
        DefaultMonthModel defaultMonthModel = new DefaultMonthModel(Locale.US, 1, 4);
        Assert.assertEquals((int)defaultMonthModel.getDowFirst(), (int)1);
        defaultMonthModel.setDowFirst(2);
        int[] nArray = defaultMonthModel.getDows();
        Assert.assertEquals((int)nArray[0], (int)2);
        Assert.assertEquals((int)nArray[1], (int)3);
        Assert.assertEquals((int)nArray[2], (int)4);
        Assert.assertEquals((int)nArray[3], (int)5);
        Assert.assertEquals((int)nArray[4], (int)6);
        Assert.assertEquals((int)nArray[5], (int)7);
        Assert.assertEquals((int)nArray[6], (int)1);
        defaultMonthModel.setDowFirst(3);
        nArray = defaultMonthModel.getDows();
        Assert.assertEquals((int)nArray[0], (int)3);
        Assert.assertEquals((int)nArray[1], (int)4);
        Assert.assertEquals((int)nArray[2], (int)5);
        Assert.assertEquals((int)nArray[3], (int)6);
        Assert.assertEquals((int)nArray[4], (int)7);
        Assert.assertEquals((int)nArray[5], (int)1);
        Assert.assertEquals((int)nArray[6], (int)2);
    }

    public void testSetDowFormat() {
        DefaultMonthModel defaultMonthModel = new DefaultMonthModel(Locale.US);
        defaultMonthModel.setDowFormat(1);
        defaultMonthModel.setDowFormat(0);
    }

    public void testSetMonthFormat() {
        DefaultMonthModel defaultMonthModel = new DefaultMonthModel(Locale.US);
        defaultMonthModel.setMonthFormat(4);
        defaultMonthModel.setMonthFormat(3);
    }

    public void testDowFirst() {
        DefaultMonthModel defaultMonthModel = new DefaultMonthModel();
        Assert.assertEquals((int)defaultMonthModel.getDowFirst(), (int)Calendar.getInstance(Locale.getDefault()).getFirstDayOfWeek());
        Assert.assertEquals((int)defaultMonthModel.getDowFirst(), (int)2);
        Assert.assertEquals((int)defaultMonthModel.getDowIndex(2), (int)0);
        defaultMonthModel.setDowFirst(5);
        Assert.assertEquals((int)defaultMonthModel.getDowFirst(), (int)5);
    }

    public void testDowNames() {
        DefaultMonthModel defaultMonthModel = new DefaultMonthModel(Locale.US);
        defaultMonthModel.setDowFormat(1);
        defaultMonthModel.setDowFirst(4);
        defaultMonthModel.setDowFormat(0);
    }

    public void testDows() {
        DefaultMonthModel defaultMonthModel = new DefaultMonthModel(Locale.US);
        int[] nArray = defaultMonthModel.getDows();
        Assert.assertEquals((int)nArray[0], (int)1);
        Assert.assertEquals((int)nArray[1], (int)2);
        Assert.assertEquals((int)nArray[2], (int)3);
        Assert.assertEquals((int)nArray[3], (int)4);
        Assert.assertEquals((int)nArray[4], (int)5);
        Assert.assertEquals((int)nArray[5], (int)6);
        Assert.assertEquals((int)nArray[6], (int)7);
        defaultMonthModel.setDowFirst(7);
        nArray = defaultMonthModel.getDows();
        Assert.assertEquals((int)nArray[0], (int)7);
        Assert.assertEquals((int)nArray[1], (int)1);
        Assert.assertEquals((int)nArray[2], (int)2);
        Assert.assertEquals((int)nArray[3], (int)3);
        Assert.assertEquals((int)nArray[4], (int)4);
        Assert.assertEquals((int)nArray[5], (int)5);
        Assert.assertEquals((int)nArray[6], (int)6);
    }

    public void testAllowedInterval() {
        DefaultMonthModel defaultMonthModel = new DefaultMonthModel();
        Assert.assertEquals((Object)defaultMonthModel.getMinimumAllowed(), null);
        Assert.assertEquals((Object)defaultMonthModel.getMaximumAllowed(), null);
        defaultMonthModel.setMonth(0);
        defaultMonthModel.setYear(1980);
        Assert.assertEquals((int)defaultMonthModel.getMonth(), (int)0);
        Assert.assertEquals((int)defaultMonthModel.getYear(), (int)1980);
        defaultMonthModel = new DefaultMonthModel();
        defaultMonthModel.setMonth(5);
        defaultMonthModel.setYear(1999);
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1996, 7, 23);
        Date date = calendar.getTime();
        defaultMonthModel.setMinimumAllowed(date);
        calendar.set(1998, 0, 28);
        Date date2 = calendar.getTime();
        defaultMonthModel.setMaximumAllowed(date2);
        defaultMonthModel.setYear(1997);
        Assert.assertEquals((int)defaultMonthModel.getYear(), (int)1997);
        defaultMonthModel.setMonth(11);
        Assert.assertEquals((int)defaultMonthModel.getMonth(), (int)11);
        defaultMonthModel.setYear(1998);
        Assert.assertEquals((int)defaultMonthModel.getYear(), (int)1997);
        defaultMonthModel.setYear(1996);
        Assert.assertEquals((int)defaultMonthModel.getYear(), (int)1996);
        defaultMonthModel.setMonth(4);
        Assert.assertEquals((int)defaultMonthModel.getMonth(), (int)11);
        defaultMonthModel.setMonth(7);
        Assert.assertEquals((int)defaultMonthModel.getMonth(), (int)7);
        defaultMonthModel.setYear(1997);
        defaultMonthModel.setMonth(0);
        defaultMonthModel.setYear(1998);
        Assert.assertEquals((int)defaultMonthModel.getYear(), (int)1998);
        Assert.assertEquals((int)defaultMonthModel.getMonth(), (int)0);
        defaultMonthModel.setMonth(1);
        Assert.assertEquals((int)defaultMonthModel.getMonth(), (int)0);
    }

    public void testRollMonth() {
        DefaultMonthModel defaultMonthModel = new DefaultMonthModel();
        defaultMonthModel.setMonth(11);
        defaultMonthModel.setYear(2002);
        Assert.assertEquals((int)defaultMonthModel.getMonth(), (int)11);
        Assert.assertEquals((int)defaultMonthModel.getYear(), (int)2002);
        defaultMonthModel.rollMonth(true);
        Assert.assertEquals((int)defaultMonthModel.getMonth(), (int)0);
        Assert.assertEquals((int)defaultMonthModel.getYear(), (int)2003);
        defaultMonthModel.rollMonth(false);
        Assert.assertEquals((int)defaultMonthModel.getMonth(), (int)11);
        Assert.assertEquals((int)defaultMonthModel.getYear(), (int)2002);
        defaultMonthModel.rollMonth(false);
        Assert.assertEquals((int)defaultMonthModel.getMonth(), (int)10);
        Assert.assertEquals((int)defaultMonthModel.getYear(), (int)2002);
        defaultMonthModel.setMonth(5);
        defaultMonthModel.setYear(2004);
        defaultMonthModel.rollMonth(true);
        Assert.assertEquals((int)defaultMonthModel.getMonth(), (int)6);
        Assert.assertEquals((int)defaultMonthModel.getYear(), (int)2004);
    }

    public void testRollYear() {
        DefaultMonthModel defaultMonthModel = new DefaultMonthModel();
        defaultMonthModel.setMonth(11);
        defaultMonthModel.setYear(2002);
        Assert.assertEquals((int)defaultMonthModel.getMonth(), (int)11);
        Assert.assertEquals((int)defaultMonthModel.getYear(), (int)2002);
        defaultMonthModel.rollYear(true);
        Assert.assertEquals((int)defaultMonthModel.getMonth(), (int)11);
        Assert.assertEquals((int)defaultMonthModel.getYear(), (int)2003);
        defaultMonthModel.rollYear(true);
        Assert.assertEquals((int)defaultMonthModel.getMonth(), (int)11);
        Assert.assertEquals((int)defaultMonthModel.getYear(), (int)2004);
        defaultMonthModel.rollYear(false);
        Assert.assertEquals((int)defaultMonthModel.getMonth(), (int)11);
        Assert.assertEquals((int)defaultMonthModel.getYear(), (int)2003);
    }
}

