// ==============================================================
//
//  Copyright (c) 2003 by Alex Vinokur.
//
//  For conditions of distribution and use, see
//  copyright notice in version.h
//
// ==============================================================


// ##############################################################
//
//  SOFTWARE : Turing Machine with faults, failures and recovery
//             C++ Simulator
//
//  FILE     : t-xstate.cpp
//
//  DESCRIPTION :				    
//         Class TuringMachine : extended state class methodes (Implementation)
//
// ##############################################################


// =================
#include "turing-s.h"
// =================


// =========
// =========
// Constructor-0
ExtendedState::ExtendedState (
		const state_t&	program_state_i,
		const state_t&	program_substate1_i,
		const state_t&	program_substate2_i,
		const state_t&	daemon_state_on_tact1_i,
		const state_t&	daemon_state_on_tact2_i,
		const state_t&	tester_state_i,
		const state_t&	apparatus_state_i
		)
		:
		program_state_ (program_state_i),
		program_substate1_ (program_substate1_i),
		program_substate2_ (program_substate2_i),
		daemon_state_on_tact1_ (daemon_state_on_tact1_i),
		daemon_state_on_tact2_ (daemon_state_on_tact2_i),
		tester_state_ (tester_state_i),
		apparatus_state_ (apparatus_state_i)
{

}

// =========
// Destructor-0
ExtendedState::~ExtendedState ()
{
}


// =========
void ExtendedState::show_extended_state (const string& msg1_i, const string& pref_i) const
{
const string text_program_state ("Program Triple-State");
const string text_program_substate1 ("Program SubState1");
const string text_program_substate2 ("Program SubState2");
const string text_daemon_state ("Daemon State (Tact1/Tact2)");
const string text_tester_state ("Tester State");
const string text_apparatus_state ("Apparatus State");
size_t	max_len = 0;

  max_len = MAX_VALUE (max_len, text_program_state.size());
  max_len = MAX_VALUE (max_len, text_program_substate1.size());
  max_len = MAX_VALUE (max_len, text_program_substate2.size());
  max_len = MAX_VALUE (max_len, text_daemon_state.size());
  max_len = MAX_VALUE (max_len, text_tester_state.size());
  max_len = MAX_VALUE (max_len, text_apparatus_state.size());
  assert (max_len);

  assert (!(program_state_ == state_t()));
  assert (!(program_substate1_ == state_t()));
  assert (!(program_substate2_ == state_t()));
  cout << pref_i 
       << setw (max_len)
       << left
       << text_program_state.c_str() 
       << " : " 
       << program_state_ 
       << " "
       << program_substate1_ 
       << " "
       << program_substate2_ 
       << "\t\t"
       << "---> ("
       << msg1_i
       << ")"
       << endl;

  cout << pref_i
       << setw (max_len)
       << left
       << text_daemon_state.c_str() 
       << " : " 
       << daemon_state_on_tact1_
       << "/" 
       << daemon_state_on_tact2_ 
       << endl;

  cout << pref_i 
       << setw (max_len)
       << left
       << text_tester_state.c_str() 
       << " : " 
       << tester_state_ 
       << endl;

  cout << pref_i 
       << setw (max_len)
       << left
       << text_apparatus_state.c_str() 
       << " : " 
       << apparatus_state_ 
       << endl;

}

