/*
 * Decompiled with CFR 0.152.
 */
package com.rathedg.cachalot.tru;

import com.rathedg.cachalot.Constants;
import com.rathedg.cachalot.tru.DB;
import com.rathedg.cachalot.tru.PacketHandler;
import com.rathedg.cachalot.tru.TrafficInfo;
import com.rathedg.cachalot.tru.TrafficProcessor;
import com.rathedg.util.PropertyExtractor;
import com.rathedg.util.SingleEventListener;
import com.rathedg.util.exception.InitializationException;
import com.rathedg.util.exception.InvalidConfigurationException;
import com.rathedg.util.exception.InvalidValueException;
import com.rathedg.util.log.LoggerInterface;
import com.rathedg.util.log.PrefixLogger;
import com.rathedg.util.log.PropertiesLoggerConfig;
import com.rathedg.util.log.StreamLogger;
import com.rathedg.util.net.TCPShutdownListener;
import com.rathedg.util.snt.Queue;
import java.io.IOException;
import java.net.InetAddress;

public class TRUStarter
implements SingleEventListener,
Constants {
    private static final String OUTPUT_BANNER = "\nRatheDG Cachalot System 1.2.0. Traffic Registration Unit.\n";
    private static final String OUTPUT_USAGE = "Usage: TRUStarter <configuration file>";
    public static final boolean DEBUG = false;
    private Queue packetsQueue = new Queue();
    private Queue trafficQueue = new Queue();
    private LoggerInterface logger;
    private PacketHandler handler;
    private TrafficProcessor trafficProcessor;
    private DB db;
    private TCPShutdownListener shutdownListener;
    private boolean shutdown = false;

    public static void main(String[] stringArray) {
        System.exit(new TRUStarter().start(stringArray));
    }

    public int start(String[] stringArray) {
        Object object;
        System.out.println(OUTPUT_BANNER);
        if (stringArray.length != 1) {
            System.out.println(OUTPUT_USAGE);
            return 1;
        }
        try {
            this.logger = new StreamLogger(System.out);
            object = null;
            try {
                object = new PropertyExtractor(stringArray[0]);
            }
            catch (IOException iOException) {
                System.out.println("Error reading configuration file.");
                return 1;
            }
            this.logger = PropertiesLoggerConfig.create((PropertyExtractor)object);
            this.handler = new PacketHandler((PropertyExtractor)object, this.packetsQueue, this, this.logger);
            this.trafficProcessor = new TrafficProcessor((PropertyExtractor)object, this.packetsQueue, this.trafficQueue, this.logger);
            this.db = new DB((PropertyExtractor)object, this.trafficQueue, this.logger);
            TrafficInfo.hosts = this.db.getHosts();
            InetAddress inetAddress = null;
            String string = ((PropertyExtractor)object).getStringNotEmpty("shutdown.address", null, true);
            try {
                inetAddress = string == null ? InetAddress.getLocalHost() : InetAddress.getByName(string);
            }
            catch (IOException iOException) {
                throw new InvalidConfigurationException("can't resolve host to bind for listening for shutdown: " + iOException.toString());
            }
            try {
                this.shutdownListener = new TCPShutdownListener(inetAddress, ((PropertyExtractor)object).getIntervalIntegerNotNullNotEmpty("shutdown.port", 0, 65535, true), ((PropertyExtractor)object).getStringNotNull("shutdown.password", true), this, new PrefixLogger("shutdown request listener: ", this.logger));
            }
            catch (IOException iOException) {
                throw new InitializationException("error initializing shutdown listener: " + iOException.toString());
            }
        }
        catch (InvalidValueException invalidValueException) {
            this.logger.log("Invalid configuration: " + invalidValueException.getMessage());
            return 1;
        }
        catch (InvalidConfigurationException invalidConfigurationException) {
            this.logger.log("Invalid configuration: " + invalidConfigurationException.getMessage());
            return 1;
        }
        catch (InitializationException initializationException) {
            this.logger.log("Error during initialization: " + initializationException.getMessage());
            return 1;
        }
        object = this;
        synchronized (object) {
            this.handler.start();
            this.trafficProcessor.start();
            this.db.start();
            this.shutdownListener.start();
            this.logger.log("Started.");
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.logger.log("Shutted down.");
        return 1;
    }

    synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        this.logger.log("Shutting down");
        this.handler.shutdown();
        this.trafficProcessor.shutdown();
        this.db.shutdown();
        this.notify();
    }

    public void hear() {
        this.shutdown();
    }
}

