/*
 * Decompiled with CFR 0.152.
 */
package com.rathedg.cachalot.eru;

import com.rathedg.cachalot.ERUConstants;
import com.rathedg.cachalot.eru.Event;
import com.rathedg.util.db.DBConnectionSource;
import com.rathedg.util.db.DBUtils;
import com.rathedg.util.log.LoggerInterface;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;

final class EventProcessor
extends Thread
implements ERUConstants {
    DBConnectionSource dbsource;
    LoggerInterface logger;
    private Map coefs;
    private float hourPrice;
    private float inTrafficPrice;
    private float outTrafficPrice;
    ArrayList eventstorage = new ArrayList();
    boolean shuttingdown = false;
    Connection connection;

    EventProcessor(DBConnectionSource dBConnectionSource, LoggerInterface loggerInterface, float f, float f2, float f3, Map map) {
        this.dbsource = dBConnectionSource;
        this.logger = loggerInterface;
        this.hourPrice = f;
        this.inTrafficPrice = f2;
        this.outTrafficPrice = f3;
        this.coefs = map;
        this.start();
    }

    public void run() {
        PreparedStatement preparedStatement = null;
        while (true) {
            Event event = this.getNextEvent();
            try {
                this.connection = this.dbsource.getConnection();
                this.finishSession(event.host, event.time);
                if (event.code == 3) {
                    preparedStatement = this.connection.prepareStatement("INSERT INTO t_sessions (f_host,f_useruin,f_logon) VALUES (?,?,?)");
                    preparedStatement.setShort(1, (short)(event.host & 0x7F | event.host & 0x80));
                    preparedStatement.setShort(2, event.user);
                    preparedStatement.setTimestamp(3, new Timestamp(event.time));
                    preparedStatement.executeUpdate();
                }
            }
            catch (Throwable throwable) {
                DBUtils.safeCloseStatement(preparedStatement);
                this.returnEvent(event);
                this.logger.log("error during processing event " + event + " (event put back queue, size of queue is " + this.getSize() + "): " + throwable);
                this.dbsource.releaseConnectionSafe(this.connection);
                this.connection = null;
                EventProcessor eventProcessor = this;
                synchronized (eventProcessor) {
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            DBUtils.safeCloseStatement(preparedStatement);
            this.dbsource.releaseConnectionSafe(this.connection);
            this.connection = null;
            EventProcessor eventProcessor = this;
            synchronized (eventProcessor) {
                if (this.shuttingdown) {
                    this.notify();
                }
            }
        }
    }

    private void finishSession(byte by, long l) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT f_logon,f_useruin FROM t_sessions WHERE f_host=? AND f_logoff IS NULL");
        short s = (short)(by & 0xFF);
        preparedStatement.setShort(1, s);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (!resultSet.next()) {
            resultSet.close();
            preparedStatement.close();
            return;
        }
        Timestamp timestamp = resultSet.getTimestamp(1);
        long l2 = ((Date)timestamp).getTime() / 1000L * 1000L + (long)(timestamp.getNanos() / 1000000);
        short s2 = resultSet.getShort(2);
        resultSet.close();
        preparedStatement.close();
        Timestamp timestamp2 = new Timestamp(l);
        preparedStatement = this.connection.prepareStatement("SELECT SUM(f_bytes) FROM t_intraffic WHERE f_host=? AND f_moment>=? AND f_moment<=?");
        preparedStatement.setShort(1, s);
        preparedStatement.setTimestamp(2, timestamp);
        preparedStatement.setTimestamp(3, timestamp2);
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        int n = resultSet.getInt(1);
        resultSet.close();
        preparedStatement.close();
        preparedStatement = this.connection.prepareStatement("SELECT SUM(f_bytes) FROM t_outtraffic WHERE f_host=? AND f_moment>=? AND f_moment<=?");
        preparedStatement.setShort(1, s);
        preparedStatement.setTimestamp(2, timestamp);
        preparedStatement.setTimestamp(3, timestamp2);
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        int n2 = resultSet.getInt(1);
        resultSet.close();
        preparedStatement.close();
        preparedStatement = this.connection.prepareStatement("UPDATE t_sessions SET f_logoff=?, f_intraffic=?, f_outtraffic=?, f_calculated=? WHERE f_logon=? AND f_host=?");
        preparedStatement.setTimestamp(1, timestamp2);
        preparedStatement.setInt(2, n);
        preparedStatement.setInt(3, n2);
        preparedStatement.setInt(4, this.calculateSessionBill(s2, ((Date)timestamp2).getTime() * 1000L / 1000L + (long)(timestamp2.getNanos() / 1000000) - l2, n, n2));
        preparedStatement.setTimestamp(5, timestamp);
        preparedStatement.setShort(6, s);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    private int calculateSessionBill(short s, long l, int n, int n2) {
        float[] fArray = (float[])this.coefs.get(new Short(s));
        return Math.round(100.0f * (fArray[0] * this.hourPrice * (float)l / 1000.0f / 60.0f / 60.0f + fArray[1] * this.inTrafficPrice * (float)n / 1024.0f / 1024.0f + fArray[2] * this.outTrafficPrice * (float)n2 / 1024.0f / 1024.0f));
    }

    synchronized void addEvent(Event event) {
        this.eventstorage.add(event);
        this.notify();
    }

    private synchronized Event getNextEvent() {
        if (this.eventstorage.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return (Event)this.eventstorage.remove(0);
    }

    synchronized void returnEvent(Event event) {
        this.eventstorage.add(0, event);
    }

    private synchronized int getSize() {
        return this.eventstorage.size();
    }

    synchronized void shutdown() {
        this.shuttingdown = true;
        while (this.eventstorage.size() != 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return;
    }
}

