/*
 * Decompiled with CFR 0.152.
 */
package com.rathedg.util.db;

import com.rathedg.util.db.ConnectionTuner;
import com.rathedg.util.db.DBConnectionSource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;

public class DBConnectionPool
extends DBConnectionSource {
    private static final boolean DEBUG = false;
    private ArrayList pool;
    private ArrayList times;
    private String url;
    private ConnectionTuner tuner;
    private int capacity;
    private String pingquery;
    private Properties properties;

    public DBConnectionPool(String string, Properties properties, ConnectionTuner connectionTuner, int n, String string2) throws SQLException {
        if (n < 0) {
            throw new SQLException("invalid capacity for db connection pool");
        }
        this.url = string;
        this.properties = properties;
        this.capacity = n;
        this.tuner = connectionTuner;
        this.pingquery = string2 == null ? "SELECT 1" : string2;
        this.pool = new ArrayList(n);
        this.times = new ArrayList(n);
        Long l = new Long(System.currentTimeMillis());
        int n2 = 0;
        while (n2 < n) {
            Connection connection = DriverManager.getConnection(string, properties);
            if (connectionTuner != null) {
                connectionTuner.tune(connection);
            }
            this.pool.add(connection);
            this.times.add(l);
            ++n2;
        }
    }

    public Connection getConnection() throws SQLException {
        ArrayList arrayList = this.pool;
        synchronized (arrayList) {
            AutoCloseable autoCloseable;
            if (this.pool.size() == 0) {
                Connection connection;
                this.log("DB connections pool is out of connections, additional connection will be created.");
                Connection connection2 = connection = DriverManager.getConnection(this.url, this.properties);
                return connection2;
            }
            Connection connection = (Connection)this.pool.remove(0);
            Long l = (Long)this.times.remove(0);
            if (System.currentTimeMillis() - l > 1000L) {
                autoCloseable = null;
                try {
                    autoCloseable = connection.createStatement();
                    autoCloseable.executeQuery(this.pingquery).close();
                    autoCloseable.close();
                }
                catch (Throwable throwable) {
                    if (autoCloseable != null) {
                        try {
                            autoCloseable.close();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                    }
                    this.log("DBCP: connection broken: " + throwable.toString());
                    Connection connection3 = null;
                    try {
                        connection3 = DriverManager.getConnection(this.url, this.properties);
                        if (this.tuner != null) {
                            this.tuner.tune(connection3);
                        }
                        this.log("Restored broken connection.");
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable3) {
                            // empty catch block
                        }
                        connection = connection3;
                    }
                    catch (Throwable throwable4) {
                        this.log("Could not restore broken connection: " + throwable4.toString());
                        this.times.add(l);
                        this.pool.add(connection);
                        if (connection3 != null) {
                            try {
                                connection3.close();
                            }
                            catch (Throwable throwable5) {
                                // empty catch block
                            }
                        }
                        throw new SQLException("Could not restore broken connection: " + throwable4.toString());
                    }
                }
            }
            autoCloseable = connection;
            return autoCloseable;
        }
    }

    public void releaseConnection(Connection connection) throws SQLException {
        ArrayList arrayList = this.pool;
        synchronized (arrayList) {
            if (this.pool.size() == this.capacity) {
                connection.close();
            } else {
                this.times.add(new Long(System.currentTimeMillis()));
                this.pool.add(connection);
            }
        }
    }

    public void releaseResources() {
        try {
            int n = 0;
            while (n < this.capacity) {
                ((Connection)this.pool.remove(0)).close();
                ++n;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.pool = null;
    }

    public String toString() {
        return "DBConnectionPool(url='" + this.url + "', properties='" + this.properties + "', capacity=" + this.capacity + ")";
    }
}

