#!/bin/bash
#
# RatheDG Cachalot System 1.2.0. ERU java command line client, running script.
#
# Note:
#    1) System parameters marked as (!) MUST be configured by deployer.
#       System will not work if these parameters are not defined properly.
#
#    2) System parameters marked as (S) are important for system security.
#       It is recommended to configure them after initial system installation
#       and configuration.
#

#
# (!) $SERVER is host where ERU server is running.
# See 'address' parameter in erus.conf.
#
SERVER=MyERUServer

#
# $PORT is port which ERU server is listening to.
# See 'port' parameter in erus.conf.
#
PORT=9008

#
# (S) $PASSWORD is password to authenticate in ERU server.
# See 'password' parameter in erus.conf.
#
PASSWORD=MyERUPassword

#
# $TIMEOUT is connection timeout.
#
TIMEOUT=1000

#
# $ATTEMPTS is number of attempts to send an event.
#
ATTEMPTS=1


# if $CACHALOT_HOME not defined
if [ -z "$CACHALOT_HOME" ]; then
    PRG=$0
    # Resolve symlinks.
    while [ -L "$PRG" ]; do
        ls=`ls -ld "$PRG"`
        link=`expr "$ls" : '.*-> \(.*\)$'`
        if expr "$link" : '/' > /dev/null; then
            PRG="$link"
        else
            PRG="`dirname $PRG`/$link"
        fi
    done
    # define $CACHALOT_HOME
    CACHALOT_HOME=`dirname "$PRG"`/..
fi

ERU="$CACHALOT_HOME"/system/server/eru.jar
if [ ! -r "$ERU" ]; then
    echo "Can't find file: $CACHALOT_HOME/system/server/eru.jar"
    echo "This is essential part of the system and is needed to run this program."
    echo
    exit 1
fi

#
# $JAVA_HOME contains full path to Java Runtime Environment.
#
if [ -z "$JAVA_HOME" ]; then
    JAVA_HOME="$EXT"/java
fi

#
# $JAVA_HOME/bin/java must exist and be readable, this is java runtime
# executable file.
#
if [ ! -r "$JAVA_HOME"/bin/java ]; then
    echo "The JAVA_HOME environment variable is not defined correctly."
    echo "This environment variable is needed to run this program."
    echo
    exit 1
fi

JAVA="$JAVA_HOME"/bin/java -cp "$ERU"

#
# Run ERU client.
#
$JAVA com.rathedg.cachalot.eru.Client \
    $SERVER $PORT $PASSWORD $TIMEOUT $ATTEMPTS $*

