CREATE TABLE t_operations
(
    f_name          %VARCHAR%(32)     NOT NULL,
    f_uin           %BYTE%        NOT NULL,
    f_price         %FLOAT%            %ALLOWSNULL%,
    f_description   %VARCHAR%(255)    %ALLOWSNULL%
);

CREATE TABLE t_doneoperations
(
    f_cashier     %SHORT%     NOT NULL,
    f_operation   %BYTE%     NOT NULL,
    f_numberof    %SHORT%     %ALLOWSNULL%,
    f_moment      %DATETIME%    %ALLOWSNULL%,
    f_paid        %INTEGER%      %ALLOWSNULL%
);

CREATE TABLE t_operationspresets
(
    f_useruin       %SHORT%       NOT NULL,
    f_uin           %BYTE%       NOT NULL,
    f_name          %VARCHAR%(64)    NOT NULL,
    f_fromdate      %VARCHAR%(32)    %ALLOWSNULL%,
    f_todate        %VARCHAR%(32)    %ALLOWSNULL%,
    f_cashier       %VARCHAR%(255)   %ALLOWSNULL%,
    f_cashieron     %BOOLEAN%,
    f_operationon   %BOOLEAN%,
    f_dateon        %BOOLEAN%,
    f_counton       %BOOLEAN%,
    f_amounton      %BOOLEAN%,
    f_periodon      %BOOLEAN%,
    f_periodtime    %SHORT%       %ALLOWSNULL%,
    f_periodtype    %BYTE%       %ALLOWSNULL%
);

CREATE TABLE t_operationspresetoperations
(
    f_useruin        %SHORT%        NOT NULL,
    f_presetuin      %BYTE%        NOT NULL,
    f_operationuin   %BYTE%        NOT NULL
);

ALTER TABLE t_operationspresets ADD CONSTRAINT c_operationspresets_pk
    PRIMARY KEY (f_useruin,f_uin);
ALTER TABLE t_operationspresets ADD CONSTRAINT c_operationspresets_u
    UNIQUE (f_useruin,f_uin,f_name);
ALTER TABLE t_operationspresets ADD CONSTRAINT c_operationspresets_user_fk
    FOREIGN KEY (f_useruin) REFERENCES t_users(f_uin);

ALTER TABLE t_operations ADD CONSTRAINT c_operations_uin_pk PRIMARY KEY (f_uin);
ALTER TABLE t_operations ADD CONSTRAINT c_operations_nick_u UNIQUE (f_name);

ALTER TABLE t_doneoperations ADD CONSTRAINT c_doneoperations_operation_fk
    FOREIGN KEY (f_operation) REFERENCES t_operations(f_uin);
ALTER TABLE t_doneoperations ADD CONSTRAINT c_doneoperations_user_fk
    FOREIGN KEY (f_cashier) REFERENCES t_users(f_uin);

ALTER TABLE t_operationspresetoperations ADD CONSTRAINT c_opspresetops_pk
    PRIMARY KEY (f_useruin, f_presetuin, f_operationuin);
ALTER TABLE t_operationspresetoperations ADD CONSTRAINT
    c_opspresetops_preset_fk FOREIGN KEY (f_useruin,f_presetuin)
    REFERENCES t_operationspresets(f_useruin,f_uin);
ALTER TABLE t_operationspresetoperations ADD CONSTRAINT
    c_opspresetops_operation_fk FOREIGN KEY (f_operationuin)
    REFERENCES t_operations(f_uin);

INSERT INTO t_menu (f_id, f_parent, f_sortorder, f_role, f_islist, f_title,
    f_url) VALUES (12, 1, 2, 2, %FALSE%, 'ro', 'operation.jsp');
INSERT INTO t_menu (f_id, f_parent, f_sortorder, f_role, f_islist, f_title,
    f_url) VALUES
    (23, 2, 2, 2, %FALSE%, 'op', 'stat.operations.jsp');
INSERT INTO t_menu (f_id, f_parent, f_sortorder, f_role, f_islist, f_title,
    f_url) VALUES
    (34, 3, 4, 3, %FALSE%, 'o', 'card.operation.jsp');

INSERT INTO t_plugins VALUES ('operation', 'OperationChangePerformer');
