/*
 * MsgBox.java
 *
 * Created on November 14, 2002, 1:14 PM
 */

package demo;

/**
 *
 * @author  Cyril
 */
public class MsgBox extends javax.swing.JDialog {
    /** A return status code - returned if Cancel button has been pressed */
    public static final int RET_CANCEL = 0;
    /** A return status code - returned if OK button has been pressed */
    public static final int RET_OK = 1;
    
    /** Creates new form MsgBox */
    public MsgBox(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
    }
    
    /** @return the return status of this dialog - one of RET_OK or RET_CANCEL */
    public int getReturnStatus() {
        return returnStatus;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        buttonPanel = new javax.swing.JPanel();
        okButton = new javax.swing.JButton();
        msgPanel = new javax.swing.JPanel();
        msgText = new javax.swing.JTextPane();

        setTitle("Error");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        okButton.setText("OK");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        buttonPanel.add(okButton);

        getContentPane().add(buttonPanel, java.awt.BorderLayout.SOUTH);

        msgPanel.setLayout(null);

        msgPanel.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(1, 1, 1, 1)));
        msgPanel.setPreferredSize(new java.awt.Dimension(17, 150));
        msgText.setBackground(java.awt.SystemColor.control);
        msgText.setEnabled(false);
        msgPanel.add(msgText);
        msgText.setBounds(0, 0, 310, 70);

        getContentPane().add(msgPanel, java.awt.BorderLayout.CENTER);

        pack();
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setSize(new java.awt.Dimension(309, 134));
        setLocation((screenSize.width-309)/2,(screenSize.height-134)/2);
    }//GEN-END:initComponents
    
    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        doClose(RET_OK);
    }//GEN-LAST:event_okButtonActionPerformed
        
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        doClose(RET_CANCEL);
    }//GEN-LAST:event_closeDialog
    
    private void doClose(int retStatus) {
        returnStatus = retStatus;
        setVisible(false);
        dispose();
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new MsgBox(new javax.swing.JFrame(), true).show();
    }
    
    public void setText(java.lang.String msg) {
        msgText.setText(msg);
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JTextPane msgText;
    private javax.swing.JButton okButton;
    private javax.swing.JPanel msgPanel;
    // End of variables declaration//GEN-END:variables
    
    private int returnStatus = RET_CANCEL;
}
