// ==============================================================
//
//  Copyright (c) 2002-2003 by Alex Vinokur.
//
//  For conditions of distribution and use, see
//  copyright notice in version.h
//
// ==============================================================


// ##############################################################
//
//  SOFTWARE : C/C++ Program Perfometer
//  FILE     : t_demo2.cpp
//
//  DESCRIPTION :
//         Implementation of measured/compared functions
//
// ##############################################################


// ===============
#include "tests.h"
// ===============

// #########################################
// #
// #  Functions To Be Measured (Compared)
// #  Prototypes are in file demo.h
// #
// #########################################

#define	STRING_SIZE_1	5
#define	STRING_SIZE_2	25
#define	STRING_SIZE_3	125

// ----------------------------
void demo_13 (void)
{
string sstr1 (STRING_SIZE_1, 'a');
string sstr2 (STRING_SIZE_2, 'b');
string sstr3 (STRING_SIZE_3, 'c');

char cstr1 [STRING_SIZE_1 + 1];
char cstr2 [STRING_SIZE_2 + 1];
char cstr3 [STRING_SIZE_3 + 1];

  strcpy (cstr1, sstr1.c_str());
  strcpy (cstr2, sstr2.c_str());
  strcpy (cstr3, sstr3.c_str());


const string text_string_size ("string.size()");
const string text_strlen ("strlen");

  // ---------------------------------------------------------
  {
    TURN_ON_THE_CLOCK_USER_TIME (text_string_size, sstr1.size()) 
    {
      sstr1.size();
    }
  }


  // ---------------------------------------------------------
  {
    TURN_ON_THE_CLOCK_USER_TIME (text_string_size, sstr2.size()) 
    {
      sstr2.size();
    }
  }


  // ---------------------------------------------------------
  {
    TURN_ON_THE_CLOCK_USER_TIME (text_string_size, sstr3.size()) 
    {
      sstr3.size();
    }
  }

  // ---------------------------------------------------------
  {
    TURN_ON_THE_CLOCK_USER_TIME (text_strlen, strlen (cstr1)) 
    {
      strlen (cstr1);
    }
  }

  // ---------------------------------------------------------
  {
    TURN_ON_THE_CLOCK_USER_TIME (text_strlen, strlen (cstr2)) 
    {
      strlen (cstr2);
    }
  }

//////////////////////
#if (defined UNIX_ENV)
//////////////////////
  // ---------------------------------------------------------
  {
    TURN_ON_THE_RUSAGE_USER_TIME (ulonglong, text_strlen, strlen (cstr2)) 
    {
      strlen (cstr2);
    }
  }
//////
#endif
//////

  // ---------------------------------------------------------
  {
    TURN_ON_THE_CLOCK_USER_TIME (text_strlen, strlen (cstr3)) 
    {
      strlen (cstr3);
    }
  }


//////////////////////
#if (defined UNIX_ENV)
//////////////////////
  // ---------------------------------------------------------
  {
    TURN_ON_THE_RUSAGE_USER_TIME (ulonglong, text_strlen, strlen (cstr3)) 
    {
      strlen (cstr3);
    }
  }
//////
#endif
//////


} // demo_13


///////////////
// End-Of-File
///////////////

