#include <winsock2.h>
#include <stdio.h>
#include <imagehlp.h>
#include "SockSpy.h"

static HOOK_PLUG_IN_ENTRY _Hook;

void WINAPI Hook_recv_EndProc(LPVOID param, void* pParent, LRESULT rc, SOCKET s, char* buf, int len, int flags);
void WINAPI Hook_WSARecv_EndProc(LPVOID param, void* pParent, LRESULT rc, SOCKET s, LPWSABUF lpBuffers, DWORD dwBufferCount,LPDWORD lpNumberOfBytesRecvd,LPDWORD lpFlags,LPWSAOVERLAPPED lpOverlapped, LPWSAOVERLAPPED_COMPLETION_ROUTINE lpCompletionROUTINE);
void WINAPI Hook_WSASend_BeginProc(LPVOID param, void* pParent, SOCKET s, LPWSABUF lpBuffers, DWORD dwBufferCount,LPDWORD lpNumberOfBytesSent, LPDWORD lpFlags,LPWSAOVERLAPPED lpOverlapped, LPWSAOVERLAPPED_COMPLETION_ROUTINE lpCompletionROUTINE);
void WINAPI Hook_send_BeginProc(LPVOID param, void* pParent, SOCKET s, char* buf, int len, int flags);
void WINAPI Hook_connect_BeginProc(LPVOID param, void* pParent, SOCKET s, const struct sockaddr FAR *name, int namelen);
void WINAPI Hook_accept_EndProc(LPVOID param, void* pParent, LRESULT rc, SOCKET s, struct sockaddr FAR *addr, int* namelen);
void WINAPI Hook_recvfrom_EndProc(LPVOID param, void* pParent, LRESULT rc, SOCKET s, char FAR* buf, int len, int flags, struct sockaddr FAR *from, int FAR *fromlen);


static DLL_FUN_HOOK_PROC _ws2_32[] = { {"send", (FARPROC)Hook_send_BeginProc, NULL, 4},
                                {"recv", NULL, (FARPROC)Hook_recv_EndProc, 4},
                                {"WSARecv", NULL, (FARPROC)Hook_WSARecv_EndProc, 7},
                                {"WSASend", (FARPROC)Hook_WSASend_BeginProc, NULL, 7}
								,{"connect", (FARPROC)Hook_connect_BeginProc, NULL, 3}
								,{"accept", NULL, (FARPROC)Hook_accept_EndProc, 3}
								,{"recvfrom", NULL, (FARPROC)Hook_recvfrom_EndProc, 6}
                                };

static DLL_FUN_HOOK_PROC _wsock32[] = { {"send", (FARPROC)Hook_send_BeginProc, NULL, 4},
                                {"recv", NULL, (FARPROC)Hook_recv_EndProc, 4}
								,{"connect", (FARPROC)Hook_connect_BeginProc, NULL, 3}
								,{"accept", NULL, (FARPROC)Hook_accept_EndProc, 3}
								,{"recvfrom", NULL, (FARPROC)Hook_recvfrom_EndProc, 6}
                                };


void WINAPI GetStringFromWideChar(char* p1, char* p2, int nLen)
{
	WideCharToMultiByte(CP_ACP, 0, (LPCWSTR)p1, -1, p2, nLen, NULL, NULL);
}


void WINAPI GetPlugInFunction_Entry(HANDLE param, LPHOOK_PLUG_IN_ENTRY pHook)
{
	HANDLE hDll;
	int i;

	_Hook = *pHook;
	hDll = _Hook.pHook_AddDll(param, "ws2_32.dll");
	    
    for(i = 0; i<sizeof(_ws2_32)/sizeof(_ws2_32[0]); i++)
        _Hook.pHook_AddFunction(hDll, &_ws2_32[i]);

    hDll = _Hook.pHook_AddDll(param, "wsock32.DLL");

    for(i = 0; i<sizeof(_wsock32)/sizeof(_wsock32[0]); i++)
        _Hook.pHook_AddFunction(hDll, &_wsock32[i]);

}

void WINAPI Hook_recv_EndProc(LPVOID param, void* pParent, LRESULT rc, SOCKET s, char* buf, int len, int flags)
{
    char temp[256];

    sprintf(temp, "SOCKET s = %d rc = %d", s, rc);

    _Hook.pAddShortItemToOutput(param, pParent, temp);

    if(rc > 0)
    {
        char* sp = (char*)malloc(rc + 4);
        _Hook.pGetDesProcessMemory(param, (void*)buf, sp, rc);
        sp[rc] = 0;
        _Hook.pAddItemToOutput(param, pParent, "buf - [data]", (LPBYTE)sp, rc);
        free(sp);
    }
}

void WINAPI Hook_WSARecv_EndProc(LPVOID param, void* pParent, LRESULT rc, SOCKET s, LPWSABUF lpBuffers, DWORD dwBufferCount,LPDWORD lpNumberOfBytesRecvd,LPDWORD lpFlags,LPWSAOVERLAPPED lpOverlapped, LPWSAOVERLAPPED_COMPLETION_ROUTINE lpCompletionROUTINE)
{
    char temp[256];

    sprintf(temp, "SOCKET s = %d rc = %d", s, rc);

    _Hook.pAddShortItemToOutput(param, pParent, temp);

    if(rc == 0)
    {
        void* hItem = _Hook.pAddShortItemToOutput(param, pParent, "LPWSABUF lpBuffers");

        DWORD dwRecv = 0;
        WSABUF pBuf;

        if(lpNumberOfBytesRecvd)
            _Hook.pGetDesProcessMemory(param, (void*)lpNumberOfBytesRecvd, (LPBYTE)&dwRecv, sizeof(dwRecv));
        sprintf(temp, "lpNumberOfBytesRecvd = %d", dwRecv);
        _Hook.pAddShortItemToOutput(param, hItem, temp);

        if(lpBuffers)
        {
            _Hook.pGetDesProcessMemory(param, (void*)lpBuffers, (LPBYTE)&pBuf, sizeof(pBuf));

            if(dwRecv > 0)
            {
                char* sp = (char*)malloc(dwRecv);
                _Hook.pGetDesProcessMemory(param, (void*)pBuf.buf, sp, dwRecv);
                _Hook.pAddItemToOutput(param, hItem, "buf - [data]", (LPBYTE)sp, dwRecv);
                free(sp);
            }
        }
    }
}

void WINAPI Hook_send_BeginProc(LPVOID param, void* pParent, SOCKET s, char* buf, int len, int flags)
{
    char temp[256];

    sprintf(temp, "SOCKET s = %d len = %d", s, len);

    _Hook.pAddShortItemToOutput(param, pParent, temp);

    if(len > 0)
    {
        char* sp = (char*)malloc(len);
        _Hook.pGetDesProcessMemory(param, (void*)buf, sp, len);
        _Hook.pAddItemToOutput(param, pParent, "buf - [data]", (LPBYTE)sp, len);
        free(sp);
    }
}

void WINAPI Hook_WSASend_BeginProc(LPVOID param, void* pParent, SOCKET s, LPWSABUF lpBuffers, DWORD dwBufferCount,LPDWORD lpNumberOfBytesSent,LPDWORD lpFlags,LPWSAOVERLAPPED lpOverlapped, LPWSAOVERLAPPED_COMPLETION_ROUTINE lpCompletionROUTINE)
{
    char temp[256];
	void* hItem;
	WSABUF pBuf;

    sprintf(temp, "SOCKET s = %d", s);

    _Hook.pAddShortItemToOutput(param, pParent, temp);

    hItem = _Hook.pAddShortItemToOutput(param, pParent, "LPWSABUF lpBuffers");
    
    if(lpBuffers)
    {
        _Hook.pGetDesProcessMemory(param, (void*)lpBuffers, (LPBYTE)&pBuf, sizeof(pBuf));

        sprintf(temp, " Len = %d", pBuf.len);
        _Hook.pAddShortItemToOutput(param, hItem, temp);
        if(pBuf.len > 0)
        {
            char* sp = (char*)malloc(pBuf.len);
            _Hook.pGetDesProcessMemory(param, (void*)pBuf.buf, sp, pBuf.len);
            _Hook.pAddItemToOutput(param, hItem, "buf - [data]", (LPBYTE)sp, pBuf.len);
            free(sp);
        }
    }
}

void WINAPI Hook_connect_BeginProc(LPVOID param, void* pParent, SOCKET s, const struct sockaddr FAR *name, int namelen)
{
	char temp[256];
	SOCKADDR_IN	sd;
	
	sprintf(temp, "SOCKET s = %d len = %d", s, namelen);
	
	_Hook.pAddShortItemToOutput(param, pParent, temp);
	if(name)
	{
		_Hook.pGetDesProcessMemory(param, (void*)name, (LPBYTE)&sd, sizeof(sd));
		sprintf(temp, "name = %d.%d.%d.%d:%d", sd.sin_addr.S_un.S_un_b.s_b1,
									  sd.sin_addr.S_un.S_un_b.s_b2,
									  sd.sin_addr.S_un.S_un_b.s_b3,
									  sd.sin_addr.S_un.S_un_b.s_b4,
									  ntohs(sd.sin_port));
		_Hook.pAddShortItemToOutput(param, pParent, temp);
	}
}

void WINAPI Hook_accept_EndProc(LPVOID param, void* pParent, LRESULT rc, SOCKET s, struct sockaddr FAR *addr, int* namelen)
{
	char temp[256];
	SOCKADDR_IN	sd;
	int len = 0;

	if(namelen)
		_Hook.pGetDesProcessMemory(param, (void*)namelen, (LPBYTE)&len, sizeof(len));
	
	sprintf(temp, "SOCKET s = %d rc s= %d len = %d", s, rc, len);
	
	_Hook.pAddShortItemToOutput(param, pParent, temp);
	if(addr)
	{
		_Hook.pGetDesProcessMemory(param, (void*)addr, (LPBYTE)&sd, sizeof(sd));
		sprintf(temp, "addr = %d.%d.%d.%d:%d", sd.sin_addr.S_un.S_un_b.s_b1,
									  sd.sin_addr.S_un.S_un_b.s_b2,
									  sd.sin_addr.S_un.S_un_b.s_b3,
									  sd.sin_addr.S_un.S_un_b.s_b4,
									  ntohs(sd.sin_port));
		_Hook.pAddShortItemToOutput(param, pParent, temp);
	}
}

void WINAPI Hook_recvfrom_EndProc(LPVOID param, void* pParent, LRESULT rc, SOCKET s, char FAR* buf, int len, int flags, struct sockaddr FAR *from, int FAR *fromlen)
{
    char temp[256];
	struct sockaddr_in  sd;

    sprintf(temp, "SOCKET s = %d rc = %d", s, rc);

    _Hook.pAddShortItemToOutput(param, pParent, temp);

    if(rc > 0)
    {
		char* sp = (char*)malloc(rc + 4);
        _Hook.pGetDesProcessMemory(param, (void*)from, (unsigned char*)&sd, sizeof(sd));

		sprintf(temp, "from =%d.%d.%d.%d:%d", sd.sin_addr.S_un.S_un_b.s_b1,
			sd.sin_addr.S_un.S_un_b.s_b2, sd.sin_addr.S_un.S_un_b.s_b3,
			sd.sin_addr.S_un.S_un_b.s_b4, sd.sin_port);

	    _Hook.pAddShortItemToOutput(param, pParent, temp);

        _Hook.pGetDesProcessMemory(param, (void*)buf, sp, rc);
        sp[rc] = 0;
        _Hook.pAddItemToOutput(param, pParent, "buf - [data]", (LPBYTE)sp, rc);
        free(sp);
   }
}


