// =================================================================
//
//  Copyright (C) 2001 Maciej Sobczak
//  Copyright (C) 2003 Alex Vinokur
//
//  ----------------------------------------------------------------
//  This software is provided 'as-is', without any express 
//  or implied warranty. This work and all works derived from it 
//  may be copied and modified without any restrictions other 
//  than that a copy of this copyright notice must be included 
//  in any copy of this work or any derived work.
//
//  You can use this code for any purpose without limitations
//  (and for your own risk) as long as this notice remains
//
//  Note. On Windows the program that uses this utility
//        should be linked with Ws2_32.lib
//
//  ----------------------------------------------------------------
// 
//  mailto:alexvn@connect.to, mailto:alexv@hitechclub.com
//  http://up.to/alexv
//
// =================================================================


// #################################################################
// /////////////////////////////////////////////////////////////////
//
//  SOFTWARE : C++ Stream-Compatible TCP/IP Sockets Demo Application
// 
//  VERSIONS  
//
//
//  --------   ----------   ------------   -------------   --------
//  Version       Date        Hardware          OS         Compiler
//  --------   ----------   ------------   -------------   --------
//  1.0-Beta   2003-07-31   Windows 2000   CYGWIN_NT-5.0   g++ 3.2
//  1.1-Beta   2003-08-03   Windows 2000   CYGWIN_NT-5.0   g++ 3.2
//
//
// /////////////////////////////////////////////////////////////////
// #################################################################



// #################################################################
//
//  SOFTWARE : C++ Stream-Compatible TCP/IP Sockets Demo Application
//  FILE     : common.h
//
//  DESCRIPTION :
//         Common function and variables
//
// #################################################################


/////////////////////////
#ifndef INCLUDED_COMMON_H
#define INCLUDED_COMMON_H
/////////////////////////


// ================
#include <string>
#include <vector>
#include <map>
#include <sstream>
#include <fstream>
#include <iostream>
#include <iomanip>
#include <algorithm>
#include <iterator>
#include <typeinfo>
#include <assert.h>
using namespace std;

#include "macro.h"
// ================


extern const char product_name[];
extern const char demo_app_name[];
extern const char ms_author_name[];
extern const char ms_author_url[];
extern const char av_author_name[];
extern const char av_author_url[];

extern const char sw_version[];



// --------------------------
typedef unsigned long ulong;

// --------------------------
extern ostringstream sout;
extern ostringstream mout;
extern ostringstream tout;

// --------------------------
template <typename T>
string to_string (const T& t)
{
ostringstream oss;
  oss << t;
  return oss.str();
}

// --------------------------
template <typename T>
bool is_type (const string& typename_i)
{
  return (typename_i == typeid(T).name());
}

//////
#endif
//////
