// =================================================================
//
//  Copyright (C) 2003 Alex Vinokur
//
//  For conditions of distribution and use, see
//  copyright notice in common.h
//
// =================================================================


// #################################################################
//
//  SOFTWARE : C++ Stream-Compatible TCP/IP Sockets Demo Application
//  FILE     : demotype.cpp
//
//  DESCRIPTION :
//         Demo2 application related class implementation
//
// #################################################################



// ==================
#include "demotype.h"
// ==================


// ---------------------
#define GET_TYPE_NAME(t) template <> string GetTypeName<t> () { return #t; }
// ---------------
// GetTypeName<T>() declaration is in packet.h
GET_TYPE_NAME(int)
GET_TYPE_NAME(string)
GET_TYPE_NAME(Too)


// ---------------------
#define RETURN_TYPE_NAME(t) \
		ret_string = AuxGetTypeName<t> (typeid_name_i); \
		if (!ret_string.empty()) return ret_string
// ---------------

// GetTypeName(const string& typeid_name_i) declaration is in packet.h
string GetTypeName (const string& typeid_name_i)
{
string ret_string;
  RETURN_TYPE_NAME(int);
  RETURN_TYPE_NAME(string);
  RETURN_TYPE_NAME(Too);
  return ("Can't recognize typeid().name() = " + typeid_name_i);
}

// ---------------------
// Constructor-1
Too::Too (
		const string&	var1_i,
		int		var2_i, 
		const string&	var3_i,
       		const string&	var4_i,
		const string&	var5_i
		)
		:
		var1_ (var1_i),
		var2_ (var2_i),
		var3_ (var3_i),
		var4_ (var4_i),
		var5_ (var5_i)
{
  assert (var1_.find (Too_IO_DELIM) == string::npos);
  assert (var3_.find (Too_IO_DELIM) == string::npos);
  assert (var4_.find (Too_IO_DELIM) == string::npos);
  assert (var5_.find (Too_IO_DELIM) == string::npos);

  assert (var1_.find (Too_IO_SPACE) == string::npos);
  assert (var3_.find (Too_IO_SPACE) == string::npos);
  assert (var4_.find (Too_IO_SPACE) == string::npos);
  assert (var5_.find (Too_IO_SPACE) == string::npos);

  assert (var1_.find (Too_IO_TAB) == string::npos);
  assert (var3_.find (Too_IO_TAB) == string::npos);
  assert (var4_.find (Too_IO_TAB) == string::npos);
  assert (var5_.find (Too_IO_TAB) == string::npos);

}


// ---------------------
// Destructor
Too::~Too()
{
}


string Too::get_var1 () const
{
  return var1_;
}

int    Too::get_var2 () const
{
  return var2_;
}

string Too::get_var3 () const
{
  return var3_;
}

string Too::get_var4 () const
{
  return var4_;
}

string Too::get_var5 () const
{
  return var5_;
}


// --------------------
// ---------------------
ostream& operator<< (ostream& os, const Too& inst_i)
{
  assert (inst_i.var1_.find (Too_IO_DELIM) == string::npos);
  assert (inst_i.var3_.find (Too_IO_DELIM) == string::npos);
  assert (inst_i.var4_.find (Too_IO_DELIM) == string::npos);
  assert (inst_i.var5_.find (Too_IO_DELIM) == string::npos);

  assert (inst_i.var1_.find (Too_IO_SPACE) == string::npos);
  assert (inst_i.var3_.find (Too_IO_SPACE) == string::npos);
  assert (inst_i.var4_.find (Too_IO_SPACE) == string::npos);
  assert (inst_i.var5_.find (Too_IO_SPACE) == string::npos);

  assert (inst_i.var1_.find (Too_IO_TAB) == string::npos);
  assert (inst_i.var3_.find (Too_IO_TAB) == string::npos);
  assert (inst_i.var4_.find (Too_IO_TAB) == string::npos);
  assert (inst_i.var5_.find (Too_IO_TAB) == string::npos);

  return os << Too_IO_PREFIX 
            << inst_i.var1_  // string
            << Too_IO_DELIM 
            << inst_i.var2_  // int
            << Too_IO_DELIM 
            << inst_i.var3_  // string
            << Too_IO_DELIM 
            << inst_i.var4_  // string
            << Too_IO_DELIM 
            << inst_i.var5_  // string
            << Too_IO_SUFFIX;
}

// ---------------------
istream& operator>> (istream& is, Too& inst_o)
{
string	tmp_str;

string::size_type tmp_index = 0;

istringstream iss;


  is >> tmp_str;


  // --- var1 ---
  assert (tmp_str.size() > tmp_index);
  tmp_str = tmp_str.substr(tmp_index + 1); // Remove Too_IO_PREFIX
  tmp_index = tmp_str.find (Too_IO_DELIM);
  assert (tmp_index != string::npos);

  iss.clear();
  iss.str(tmp_str.substr (0, tmp_index).c_str());
  iss >> inst_o.var1_; // string


  // --- var2 ---
  assert (tmp_str.size() > tmp_index);
  tmp_str = tmp_str.substr(tmp_index + 1); // Remove Too_IO_DELIM
  tmp_index = tmp_str.find (Too_IO_DELIM);
  assert (tmp_index != string::npos);

  iss.clear();
  iss.str(tmp_str.substr (0, tmp_index).c_str());
  iss >> inst_o.var2_; // int


  // --- var3 ---
  assert (tmp_str.size() > tmp_index);
  tmp_str = tmp_str.substr(tmp_index + 1); // Remove Too_IO_DELIM
  tmp_index = tmp_str.find (Too_IO_DELIM);
  assert (tmp_index != string::npos);

  iss.clear();
  iss.str(tmp_str.substr (0, tmp_index).c_str());
  iss >> inst_o.var3_; // string


  // --- var4 ---
  assert (tmp_str.size() > tmp_index);
  tmp_str = tmp_str.substr(tmp_index + 1); // Remove Too_IO_DELIM
  tmp_index = tmp_str.find (Too_IO_DELIM);
  assert (tmp_index != string::npos);

  iss.clear();
  iss.str(tmp_str.substr (0, tmp_index).c_str());
  iss >> inst_o.var4_; // string


  // --- var5 ---
  assert (tmp_str.size() > tmp_index);
  tmp_str = tmp_str.substr(tmp_index + 1); // Remove Too_IO_DELIM
  tmp_index = tmp_str.find (Too_IO_SUFFIX);
  assert (tmp_index != string::npos);

  iss.clear();
  iss.str(tmp_str.substr (0, tmp_index).c_str());
  iss >> inst_o.var5_; // string

  // -------------------
  assert (tmp_str.size() > tmp_index);
  tmp_str = tmp_str.substr(tmp_index + 1); // Remove Too_IO_SUFFIX

  assert (tmp_str.empty());

  return is;
}



