// =================================================================
//
//  Copyright (C) 2003 Alex Vinokur
//
//  For conditions of distribution and use, see
//  copyright notice in common.h
//
// =================================================================


// #################################################################
//
//  SOFTWARE : C++ Stream-Compatible TCP/IP Sockets Demo Application
//  FILE     : partner2.h
//
//  DESCRIPTION :
//         Partner related class implementation (template methods)
//
// #################################################################


///////////////////////////
#ifndef INCLUDED_PARTNER2_H
#define INCLUDED_PARTNER2_H
///////////////////////////


// =================
#include "partner.h"
// =================


// ------------------------------
#define TYPE_NAME_SETW_SIZE	6

// ------------------------------
// ------------------------------
template <typename T>
TemplateCallAction<T>::TemplateCallAction()
{
SET_CTOR_TRACE;
}

template <typename T>
TemplateCallAction<T>::~TemplateCallAction()
{
SET_DTOR_TRACE;
}


// ------------------------------
template <typename T>
bool TemplateCallAction<T>::call_send_templated_packet(
		BasicPartner* const 	ptr_partner_io,
		const BasicDataType*&	ptr_packet_i
		)
{
const PacketType<T>* ptr_packet = dynamic_cast<const PacketType<T> * > (ptr_packet_i);
  assert (!(ptr_packet == NULL)); 
  ptr_partner_io->template send_templated_packet<T> (*ptr_packet);

  return true;	// TBD ??? 
}

// ------------------------------
template <typename T>
bool TemplateCallAction<T>::call_recv_templated_packet(
		BasicPartner* const	ptr_partner_io,
		ulong			request_id_i,
		const string&		packet_typename_i, 
		size_t			packet_size_i,
		BasicDataType*&		ptr_recv_packet_o
		)
{

  assert (ptr_recv_packet_o == NULL);

vector<T> recv_data;

bool ret_bool = ptr_partner_io->recv_templated_packet (
					recv_data, 
					request_id_i,
					packet_typename_i, 
					packet_size_i
					);


  if (ret_bool)
  {
    ptr_recv_packet_o = new PacketType<T> (recv_data, __FILE__, __LINE__);
  }

  assert (ptr_recv_packet_o != NULL);
  return ret_bool;
}


// ------------------------------
// ------------------------------
template <typename T>
bool BasicPartner::read_via_broker_from_stream(T& data_o, const string& msg_i)
{
SET_TRACE;
bool ret_bool = true;

  assert ((get_partner_name() == CLIENT_NAME) || (get_partner_name() == SERVER_NAME));

string data;
  // ---------------------------
  read_from_stream (data);
  // ---------------------------
  if (data.empty())
  {
    ret_bool = false;
    assert (!msg_i.empty());
    MOUT (  get_partner_name() 
         << " * " 
         << msg_i 
         << " ---> End of incoming data" 
         << endl
         );
  }
  else
  {
    istringstream iss (data.c_str());
    iss >> data_o;
  }

  return ret_bool;
}


// ------------------------------
template <typename T>
bool BasicPartner::write_via_broker_to_stream(const T& data_i, const string& msg_i)
{
SET_TRACE;
bool ret_bool = true;

  assert ((get_partner_name() == CLIENT_NAME) || (get_partner_name() == SERVER_NAME));

  try
  {
    ostringstream oss;
    oss << data_i << endl;

    // ------------------------------
    ret_bool = write_to_stream (oss.str(), msg_i);
    // ------------------------------

  }
  catch (const SocketRunTimeException &e)
  {
    ret_bool = false;
    MOUT (  get_partner_name() 
         << " * " 
         << msg_i 
         << " ---> Sending exception : " 
         << e.what() 
         << endl
         );
  }

  return ret_bool;
}


// ----------------------------------
// ----------------------------------
template <typename T>
void BasicPartner::send_templated_data (const vector<T>& send_data_i)
{
SET_TRACE;
  assert (!send_data_i.empty());

  assert ((get_partner_name() == CLIENT_NAME) || (get_partner_name() == SERVER_NAME));
  
  MOUT (  get_partner_name() 
       << " : BEFORE sending data " 
       << GetTypeName<T> ()
       << endl
       );

bool ret_bool = true;
  for (size_t i = 0; i < send_data_i.size(); i++)
  {
    ret_bool = write_via_broker_to_stream (send_data_i[i], string ("[Item-" + to_string(i) + "]"));

    if (ret_bool)
    {
      MOUT (  get_partner_name() 
           << "   ["
           << "Id-" 
           << get_request_id ()
           << "; SentPacket-" 
           << get_total_sent_packets()
           << ", " 
           << setw (TYPE_NAME_SETW_SIZE)
           << std::left
           << GetTypeName<T>().c_str()
           << "; Item-" 
           << i 
           << "] " 
           << "Sent data : " 
           << send_data_i[i] 
           << endl
           );
    }
    else
    {
      MOUT (  get_partner_name() 
           << "   [Item-" 
           << i 
           << "] " 
           << "Unable to sent data" 
           << endl
          );

    }
  }

  MOUT (  get_partner_name() 
       << " : AFTER  sending data " 
       << GetTypeName<T> ()
       << endl
       );

} // send_templated_data



// ----------------------------------
template <typename T>
void BasicPartner::send_templated_packet (const PacketType<T>& send_packet_i)
{
SET_TRACE;

  assert ((get_partner_name() == CLIENT_NAME) || (get_partner_name() == SERVER_NAME));

  assert (!send_packet_i.get_typeid_data_type().empty());
  assert (send_packet_i.get_typeid_data_type() == typeid(T).name());

  assert (send_packet_i.get_typeid_data_type() == typeid(T).name());
  assert (typeid(send_packet_i.get_data_items()).name() == typeid(vector<T>).name());

vector<T> send_data (send_packet_i.get_data_items());
  
  assert (!send_data.empty());
  
  MOUT (  get_partner_name() 
       << " : BEFORE sending packet " 
       << GetTypeName<T> ()
       << "  (RequestId = "
       << get_request_id()
       << ")"
       << endl
       );

bool ret_bool = true;
  ret_bool = ret_bool && write_via_broker_to_stream (get_request_id(), "[Request-Id]");
  ret_bool = ret_bool && write_via_broker_to_stream (typeid(T).name(), "[Packet Typename]");
  ret_bool = ret_bool && write_via_broker_to_stream (send_data.size(), "[Packet Size]");

  if (ret_bool)
  {
    MOUT (  get_partner_name() 
         << " : RequestId = "
         << get_request_id()
         << "; Sent packet type - " 
         << GetTypeName<T> ()
         << ", items - "
         << send_data.size() 
         << endl
         );

    send_templated_data (send_data);
  }
  else
  {
    MOUT (  get_partner_name() 
         << " : RequestId = "
         << get_request_id()
         << "; No packet type -" 
         << GetTypeName<T> ()
         << "- has been sent" 
         << endl
         );
  }

  MOUT (  get_partner_name() 
       << " : AFTER  sending packet " 
       << GetTypeName<T> ()
       << "  (RequestId = "
       << get_request_id()
       << ")"
       << endl
       );


} // send_templated_packet



// ----------------------------------
template <typename T>
void BasicPartner::recv_templated_data (size_t data_size_i, vector<T>& recv_data_o)
{
SET_TRACE;
  assert (recv_data_o.empty());

  assert ((get_partner_name() == CLIENT_NAME) || (get_partner_name() == SERVER_NAME));
  
  MOUT (  get_partner_name() 
       << " : BEFORE receiving data " 
       << GetTypeName<T> ()
       << endl
       );

bool ret_bool = true;
T data;
  for (size_t i = 0; i < data_size_i; i++)
  {
    ret_bool = read_via_broker_from_stream (data, string("[Item-" + to_string(i) + "]"));

    if (ret_bool)
    {
      MOUT (  get_partner_name() 
           << "   [" 
           << "Id-" 
           << get_request_id ()
           << "; RecvPacket-" 
           << get_total_recv_packets()
           << ", " 
           << setw (TYPE_NAME_SETW_SIZE)
           << std::left
           << GetTypeName<T>().c_str()
           << "; Item-" 
           << i 
           << "] " 
           << "Received data : " 
           << data 
           << endl
           );

      recv_data_o.push_back (data);
    }
    else
    {
      MOUT (  get_partner_name() 
           << "   [Item-" 
           << i 
           << "] " 
           << "Unable to receive data" 
           << endl
           );

    }
  } // for (size_t i = 0

  MOUT (  get_partner_name() 
       << " : AFTER  receiving data " 
       << GetTypeName<T> ()
       << endl
       );

} // recv_templated_data


// ----------------------------------
template <typename T>
bool BasicPartner::recv_templated_packet (
			vector<T>&	recv_data_o, 
			ulong		request_id_i,
			const string&	packet_typename_i, 
			size_t		packet_size_i
			)
{
SET_TRACE;
  assert (recv_data_o.empty());

  assert (is_type<T> (packet_typename_i));

  assert ((get_partner_name() == CLIENT_NAME) || (get_partner_name() == SERVER_NAME));

  assert (request_id_i);

  MOUT (  get_partner_name() 
       << " : BEFORE receiving packet " 
       << GetTypeName<T> ()
       << "  (RequestId = "
       << request_id_i
       << ")"
       << endl
       );

bool ret_bool = (packet_size_i != 0);

  if (ret_bool)
  {
    MOUT (  get_partner_name() 
         << " : RequestId = " 
         << request_id_i
         << " , Received packet type - " 
         << GetTypeName<T> ()
         << ", items - "
         << packet_size_i 
         << endl
         );

    recv_templated_data (packet_size_i, recv_data_o);

    assert (packet_size_i = recv_data_o.size());
  }
  else
  {
    MOUT (  get_partner_name() 
         << " : RequestId = " 
         << request_id_i
         << " --> No packet type -" 
         << GetTypeName<T> ()
         << "- has been received (packet is empty)" 
         << endl
         );
  }

  MOUT (  get_partner_name() 
       << " : AFTER  receiving packet " 
       << GetTypeName<T> ()
       << "  (RequestId = "
       << request_id_i
       << ")"
       << endl
       );

  return ret_bool;

} // recv_templated_packet

//////
#endif
//////
