#!/usr/bin/perl

###############################################################################
#
# _AFLayout.cgi - Change the frameset layout of the forum
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/08/21 17:50:52 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: _AFLayout.cgi,v 1.15.2.3 2001/08/21 17:50:52 stepper Exp $';
$Version = '1.4.0';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

require "F_Init.pl";

$adminpass = $CGIQuery->cookie('panForaAdmin');
$forumadmin = &checkAdminPass($adminpass);

$Class = $CGIQuery->param('fid');

&lookupClass;
&lookupUser($CGIEnvUser);

# Load up color variables
&loadColors($ColorQueryString);

if (!$forumadmin) {
	&checkCookieGuest($CGIEnvUser, $C_authtype);
}

# Kick the user out if they have the wrong permissions
if (!&IS_ADMIN($U_Perms) && !$forumadmin) {
	&showErrorBackHTML("You do not have permission to access this resource, or have not logged on properly.", 0);
	exit();
}

$what = $CGIQuery->param('what');
$func = $CGIQuery->param('func');

if ($func eq "menu") {
	$BodyTag = &makeBodyTag("Threads");
} else {
	$BodyTag = &makeBodyTag("Content");
}

# process frame data in database
if ($C_FrameDefs_1 ne "") {
	($C_Frame_1, $Width_1, $Height_1, $Resizable_1) = 
												split(/\t/, $C_FrameDefs_1);
}
if ($C_FrameDefs_2 ne "") {
	($C_Frame_2, $Width_2, $Height_2, $Resizable_2) = 
												split(/\t/, $C_FrameDefs_2);
}
if ($C_FrameDefs_3 ne "") {
	($C_Frame_3, $Width_3, $Height_3, $Resizable_3) = 
												split(/\t/, $C_FrameDefs_3);
}
if ($C_FrameDefs_4 ne "") {
	($C_Frame_4, $Width_4, $Height_4, $Resizable_4) = 
												split(/\t/, $C_FrameDefs_4);
}

####### Check for Lite Version
$isLite = `$checkLite`;
chomp($isLite);

###############################################################################
#
# Process submitted data

if ($func eq "save") {
	if ($Demo) {
		print $CGIQuery->redirect("Demo.html");
		exit();
	}
	&saveLayout;
} elsif ($func eq "menu") {
	# Start html output
	$helplink = "file=ForumLayoutCORP_Admin.html";
	$helplink .= "&anchor=ModifyFramesetTskFSummary";
	$helplink .= "&helptitle=Modify%20Frameset%20Layout";
	
	&showHeaderBackHTML("Modify Frameset Layout for $Class", 
		"", 0, 1, 0, $helplink);
	
	# Javascript for clicking on an image
	print "<script language=javascript>\n";
	print "<!--\n";
	print "function selectLayout(which) {\n";
	print "	for (var i=0; i < document.forms[0].C_FrameLayout.length; i++) {\n";
	print "		if (document.forms[0].C_FrameLayout[i].value == which) {\n";
	print "			document.forms[0].C_FrameLayout[i].checked = true;\n";
	print "		}\n";
	print "	}\n";
	print "	document.forms[0].submit();\n";
	print "}\n";
	print " // -->\n";
	print "</script>\n\n";
	
	# Start form table
	print "<form action=$CGIEnvScript method=GET target=sources>\n";
	
	print "<table border=0 cellpadding=0 cellspacing=2>\n";
	print "<tr>";
	print "<td valign=top rowspan=3>",$FontFace, $FontSize;
	print "<input type=radio name=C_FrameLayout value=0";
	if ($C_FrameLayout eq "" || $C_FrameLayout == 0) {
		print " checked";
	}
	print ">";
	print "<img src=images/FrameLayout/FrameLayout0.gif width=33 height=37 align=top>";
	print "&nbsp;&nbsp;</td>\n";

	for ($i=1; $i <= 15; $i += 3) {
		print "<td valign=top>", $FontFace, $FontSize;
		print "<input type=radio name=C_FrameLayout value=$i";
		if ($C_FrameLayout == $i) {
			print " checked";
		}
		print ">";
		print "<a href='#' onClick=\"selectLayout($i)\">";
		print "<img src=images/FrameLayout/FrameLayout", $i;
		print ".gif width=33 height=37 align=top border=0></a>"; 
		print "&nbsp;&nbsp;<br>&nbsp;</td>\n";
	}
	print "</tr>\n\n";
	
	print "<tr>";
	for ($i=2; $i <= 15; $i += 3) {
		print "<td valign=top>", $FontFace, $FontSize;
		print "<input type=radio name=C_FrameLayout value=$i";
		if ($C_FrameLayout == $i) {
			print " checked";
		}
		print ">";
		print "<a href='#' onClick=\"selectLayout($i)\">";
		print "<img src=images/FrameLayout/FrameLayout", $i;
		print ".gif width=33 height=37 align=top border=0></a>"; 
		print "&nbsp;&nbsp;<br>&nbsp;</td>\n";
	}
	print "</tr>\n\n";
	
	print "<tr>";
	for ($i=3; $i <= 15; $i += 3) {
		print "<td valign=top>", $FontFace, $FontSize;
		print "<input type=radio name=C_FrameLayout value=$i";
		if ($C_FrameLayout == $i) {
			print " checked";
		}
		print ">";
		print "<a href='#' onClick=\"selectLayout($i)\">";
		print "<img src=images/FrameLayout/FrameLayout", $i;
		print ".gif width=33 height=37 align=top border=0></a>"; 
		print "&nbsp;&nbsp;</td>\n";
	}
	print "</tr>\n\n";
	
	
	# submit button
	print "<tr><td bgcolor=$FTheaderback colspan=6>";
	print "<img src=$ImgSrcClearDot width=20 height=2>";
	print "</td></tr>\n";
	
	print "<tr>";
	print "<td valign=top colspan=6>",$FontFace, $FontSize;
	print $BtnFormSubmit;
	print "</td>\n";
	print "</tr>\n";
	
	print "</table>\n\n";

	print "<input type=hidden name=fid value=$Class>\n";
	print "<input type=hidden name=func value=sources>\n";
	print "</form>\n\n";

} elsif ($func eq "sources") {
	
	$C_FL = $CGIQuery->param('C_FrameLayout');
	
	# Default widths and heights
	if ($Width_1 eq "") { $Width_1 = "100"; }
	if ($Height_1 eq "") { $Height_1 = "100"; }
	if ($Width_2 eq "") { $Width_2 = "100"; }
	if ($Height_2 eq "") { $Height_2 = "100"; }
	if ($Width_3 eq "") { $Width_3 = "100"; }
	if ($Height_3 eq "") { $Height_3 = "100"; }
	if ($Width_4 eq "") { $Width_4 = "100"; }
	if ($Height_4 eq "") { $Height_4 = "100"; }
	
	# Start html output
	$helplink = "file=ForumLayoutCORP_Admin.html";
	$helplink .= "&anchor=ModifyFramesetEdtFSummary";
	$helplink .= "&helptitle=Editing%20New%20Frames";
	
	&showHeaderBackHTML("Enter Frame Sources", "", 0, 0, 0, $helplink);
	
	if ($C_FrameLayout eq "" && $C_FL eq "") {
		print "Choose a frame layout above.";
		exit();
	}
	
	if ($C_FL ne "") {
		$C_FrameLayout = $C_FL;
	}
	
	# Preview funtion
	&printJavascript;
	
	print "<script language=javascript>\n";
	print "<!--\n";
	print "function layoutPreview() {\n";
	print "	var f = document.forms[0];\n";
	print "	var url = \"$CGI_Forum\";\n";
	print "	url += \"?fid=$Class&func=preview\";\n";
	print "	for (var i=0; i < f.elements.length; i++) {\n";
	print "		var el = f.elements[i];\n";
	print "		if (el.type == 'text' || el.type == 'hidden') {\n";
	print "			if (el.name != 'func' && el.name != 'fid') {\n";
	print "				url += '&' + el.name + '=' + escape(el.value);\n";
	print "			}\n";
	print "		} else if (el.type.indexOf('select') != -1) {\n";
	print "			url += '&' + el.name + '=' + el.options[el.selectedIndex].value;\n";
	print "		} else if (el.type.indexOf('radio') != -1) {\n";
	print "			if (el.checked) {\n";
	print "				url += '&' + el.name + '=' + el.value;\n";
	print "			}\n";
	print "		}\n";
	print "	}\n";
	print "	openwin(url,640,480,'PreviewLayout');\n";
	print "}\n";
	print "function nada() {\n";
	print "}\n";
	print "// -->\n";
	print "</script>\n\n";
	
	# Lite Version - Warn that changes have no effect
	if ($isLite) {
		print "<p><center><table border=1 cellpadding=2 cellspacing=0>\n";
		print "<tr><td bgcolor=#CCCCCC>", $FontFace, $FontSize;
		print $FontRed, "Note:</font> ";
		print "The frame configuration can not be changed in the Lite ";
		print "version of panFora. To customize the frame layout, upgrade ";
		print "your license at <a href=http://www.withinc.com target=_blank>";
		print "http://www.withinc.com</a>.</td></tr></table>\n</center><p>";
	}

	print "<form action=$CGIEnvScript method=POST>\n";
	
	print "<table border=0 cellpadding=0 cellspacing=0>\n";
	print "<tr><td valign=top>";

	print "<table border=0 cellpadding=0 cellspacing=3>\n";
		
	# Title bar
	print "<tr><td bgcolor=$FTheaderback>";
	print "<img src=$ImgSrcClearDot width=20 height=2>";
	print "</td></tr>\n";
	print "<tr><td>";
	print $FontFace, $FontSize, "<b>Layout";
	print "</b><br><br></td></tr>\n";
	
	# LAyout Image
	print "<tr><td valign=top>", $FontFace, $FontSize;
	print "<img src=images/FrameLayout/FrameLayoutLarge", $C_FrameLayout;
	print ".gif width=93 height=107 border=0>\n";
	print "</td></tr></table>\n";
	
	print "</td>\n";
	print "<td valign=top>", $FontFace, $FontSize, $ImgClear88;
	print "</td>\n";
	print "<td valign=top>", $FontFace, $FontSize;
	
	print "<table border=0 cellpadding=0 cellspacing=3>\n";
	
	print "<tr><td bgcolor=$FTheaderback colspan=2>";
	print "<img src=$ImgSrcClearDot width=20 height=2>";
	print "</td></tr>\n";
	print "<tr><td colspan=2 nowrap>";
	print $FontFace, $FontSize, "<b>Frame Options</b>";
	print " Enter full (e.g. http://...) or relative (e.g. /$Class/Forum/...) URLs.";
	print "<br>&nbsp;</td></tr>\n";
	
	if ($C_FrameLayout > 0) {
		print "<tr><td colspan=2>";
		print $FontFace, $FontSize;
		print $FontRed, "Note:</font> Width and Height can be entered as ";
		print "absolute numerical values (e.g. 120), percentages (e.g. 20%) ";
		print "or \"*\", meaning the frame will take all available space.";
		print "<br>&nbsp;</td></tr>\n\n";
	} else {
		print "<tr><td colspan=2>";
		print $FontFace, $FontSize;
		print "There are no options for this layout.";
		print "<br>&nbsp;</td></tr>\n\n";
	}
	
	print "<tr><td align=left valign=top>";
	
	print "<table border=0 cellpadding=0 cellspacing=3>\n";
	
	# First frame contents
	if ($C_FrameLayout > 0) {
		print "<tr><td bgcolor=$FTheaderback colspan=2>";
		print "<img src=$ImgSrcClearDot width=20 height=1>";
		print "</td></tr>\n";
		
		print "<tr><td nowrap>", $FontFace, $FontSize;
		print "<img src='images/FrameLayout/1.gif' width=15 height=15>&nbsp;</td>";
		print "<td>", $FontFace, $FontSize;
		print "URL: <input type=text size=40 name=C_Frame_1 value=\"";
		if ($C_Frame_1 ne "") {
			print $C_Frame_1;
		} else {
			print $C_rooturl, "/", "home.html";
		}
		print "\"><br>\n";
		# Width of Frame
		if ($C_FrameLayout == 2 || $C_FrameLayout == 5 || 
				($C_FrameLayout >= 10 && $C_FrameLayout <= 12)) {
			print "Width: <input type=text size=4 maxlength=4 name=Width_1 ";
			print "value=$Width_1>\n";
		} else {
			print "Width cannot be changed.&nbsp;&nbsp;";
			print "<input type=hidden name=Width_1 value=\"$Width_1\">\n";
		}
		if ($C_FrameLayout >= 1) {
			print "Height: <input type=text size=4 maxlength=4 name=Height_1 ";
			print "value=$Height_1>\n";
		} else {
			print "<input type=hidden name=Height_1 value=\"$Height_1\">\n";
		}
		print "Resizable: <input type=radio name=Resizable_1 value=1";
		if ($Resizable_1 eq "" || $Resizable_1 eq "1") {
			print " checked";
		}
		if ($C_FrameLayout == 2 || $C_FrameLayout == 5 ||
				 ($C_FrameLayout >= 10 && $C_FrameLayout <= 12)) {
			print " onClick='document.forms[0].Resizable_2[0].checked=true'";
		}
		print "> Yes\n";
		print "<input type=radio name=Resizable_1 value=0";
		if ($Resizable_1 ne "" && $Resizable_1 eq "0") {
			print " checked";
		}
		if ($C_FrameLayout == 2 || $C_FrameLayout == 5 || $C_FrameLayout == 8 ||
				 ($C_FrameLayout >= 10 && $C_FrameLayout <= 12)) {
			print " onClick='document.forms[0].Resizable_2[1].checked=true'";
		}
		print "> No\n";
	
		print "</td></tr>\n";
	} else {
		print "<input type=hidden name=C_Frame_1 value=\"$C_Frame_1\">\n";
		print "<input type=hidden name=Width_1 value=\"$Width_1\">\n";
		print "<input type=hidden name=Height_1 value=\"$Height_1\">\n";
		print "<input type=hidden name=Resizable_1 value=\"$Resizable_1\">\n";
	}
	
	# Second frame contents
	if ($C_FrameLayout == 2 || $C_FrameLayout == 5 || $C_FrameLayout >= 7) {
		print "<tr><td bgcolor=$FTheaderback colspan=2>";
		print "<img src=$ImgSrcClearDot width=20 height=1>";
		print "</td></tr>\n";
	
		print "<tr><td nowrap>", $FontFace, $FontSize;
		print "<img src='images/FrameLayout/2.gif' width=15 height=15>&nbsp;</td>";
		print "<td>", $FontFace, $FontSize;
		print "URL: <input type=text size=40 name=C_Frame_2 value=\"";
		if ($C_Frame_2 ne "") {
			print $C_Frame_2;
		} else {
			print $C_rooturl, "/", "home.html";
		}
		print "\"><br>\n";
		# Width of Frame
		if ($C_FrameLayout == 2 || $C_FrameLayout == 5 || $C_FrameLayout == 8 ||
				 ($C_FrameLayout >= 10 && $C_FrameLayout <= 12) ||
				 $C_FrameLayout == 14) {
			print "Width: <input type=text size=4 maxlength=4 name=Width_2 ";
			print "value=$Width_2>\n";
		} else {
			print "Width cannot be changed.&nbsp;&nbsp;";
			print "<input type=hidden name=Width_2 value=\"$Width_2\">\n";
		}
		if (($C_FrameLayout >= 7 && $C_FrameLayout <= 9) || 
				($C_FrameLayout >= 13 && $C_FrameLayout <= 15)) {
			print "Height: <input type=text size=4 maxlength=4 name=Height_2 ";
			print "value=$Height_2>\n";
		} else {
			print "Height is same as Frame 1&nbsp;&nbsp;";
			print "<input type=hidden name=Height_2 value=\"$Height_2\">\n";
		}
		print "Resizable: <input type=radio name=Resizable_2 value=1";
		if ($Resizable_2 eq "" || $Resizable_2 eq "1") {
			print " checked";
		}
		if ($C_FrameLayout == 2 || $C_FrameLayout == 5 ||
				 ($C_FrameLayout >= 10 && $C_FrameLayout <= 12)) {
			print " onClick='document.forms[0].Resizable_1[0].checked=true'";
		} elsif ($C_FrameLayout == 8 || $C_FrameLayout == 14) {
			print " onClick='document.forms[0].Resizable_3[0].checked=true'";
		}
		print "> Yes\n";
		print "<input type=radio name=Resizable_2 value=0";
		if ($Resizable_2 ne "" && $Resizable_2 eq "0") {
			print " checked";
		}
		if ($C_FrameLayout == 2 || $C_FrameLayout == 5 ||
				 ($C_FrameLayout >= 10 && $C_FrameLayout <= 12)) {
			print " onClick='document.forms[0].Resizable_1[1].checked=true'";
		} elsif ($C_FrameLayout == 8 || $C_FrameLayout == 14) {
			print " onClick='document.forms[0].Resizable_3[1].checked=true'";
		}
		print "> No\n";
		print "</td></tr>\n";
	} else {
		print "<input type=hidden name=C_Frame_2 value=\"$C_Frame_2\">\n";
		print "<input type=hidden name=Width_2 value=\"$Width_2\">\n";
		print "<input type=hidden name=Height_2 value=\"$Height_2\">\n";
		print "<input type=hidden name=Resizable_2 value=\"$Resizable_2\">\n";
	}
	
	# Third frame contents
	if ($C_FrameLayout == 8 || $C_FrameLayout == 10 || $C_FrameLayout == 11 ||
			$C_FrameLayout == 12 || $C_FrameLayout == 14) {
		print "<tr><td bgcolor=$FTheaderback colspan=2>";
		print "<img src=$ImgSrcClearDot width=20 height=1>";
		print "</td></tr>\n";
			
		print "<tr><td nowrap>", $FontFace, $FontSize;
		print "<img src='images/FrameLayout/3.gif' width=15 height=15>&nbsp;</td>";
		print "<td>", $FontFace, $FontSize;
		print "URL: <input type=text size=40 name=C_Frame_3 value=\"";
		if ($C_Frame_3 ne "") {
			print $C_Frame_3;
		} else {
			print $C_rooturl, "/", "home.html";
		}
		print "\"><br>\n";
		# Width of Frame
		if ($C_FrameLayout == 8 || $C_FrameLayout == 11 || $C_FrameLayout == 14) {
			print "Width: <input type=text size=4 maxlength=4 name=Width_3 ";
			print "value=$Width_3>\n";
		} else {
			print "Width cannot be changed.&nbsp;&nbsp;";
			print "<input type=hidden name=Width_3 value=\"$Width_3\">\n";
		}
		if ($C_FrameLayout >= 10 && $C_FrameLayout <= 12) {
			print "Height: <input type=text size=4 maxlength=4 name=Height_3 ";
			print "value=$Height_3>\n";
		} else {
			print "Height is same as Frame 2&nbsp;&nbsp;";
			print "<input type=hidden name=Height_3 value=\"$Height_3\">\n";
		}
		print "Resizable: <input type=radio name=Resizable_3 value=1";
		if ($Resizable_3 eq "" || $Resizable_3 eq "1") {
			print " checked";
		}
		if ($C_FrameLayout == 8 || $C_FrameLayout == 14) {
			print " onClick='document.forms[0].Resizable_2[0].checked=true'";
		} elsif ($C_FrameLayout == 11) {
			print " onClick='document.forms[0].Resizable_4[0].checked=true'";
		}
		print "> Yes\n";
		print "<input type=radio name=Resizable_3 value=0";
		if ($Resizable_3 ne "" && $Resizable_3 eq "0") {
			print " checked";
		}
		if ($C_FrameLayout == 8 || $C_FrameLayout == 14) {
			print " onClick='document.forms[0].Resizable_2[1].checked=true'";
		} elsif ($C_FrameLayout == 11) {
			print " onClick='document.forms[0].Resizable_4[1].checked=true'";
		}
		print "> No\n";
		print "</td></tr>\n";
	} else {
		print "<input type=hidden name=C_Frame_3 value=\"$C_Frame_3\">\n";
		print "<input type=hidden name=Width_3 value=\"$Width_3\">\n";
		print "<input type=hidden name=Height_3 value=\"$Height_3\">\n";
		print "<input type=hidden name=Resizable_3 value=\"$Resizable_3\">\n";
	}
	
	# Fourth frame contents
	if ($C_FrameLayout == 11) {
		print "<tr><td bgcolor=$FTheaderback colspan=2>";
		print "<img src=$ImgSrcClearDot width=20 height=1>";
		print "</td></tr>\n";
	
		print "<tr><td nowrap>", $FontFace, $FontSize;
		print "<img src='images/FrameLayout/4.gif' width=15 height=15>&nbsp;</td>";
		print "<td>", $FontFace, $FontSize;
		print "URL: <input type=text size=40 name=C_Frame_4 value=\"";
		if ($C_Frame_4 ne "") {
			print $C_Frame_4;
		} else {
			print $C_rooturl, "/", "home.html";
		}
		print "\"><br>\n";
		# Width of Frame
		if ($C_FrameLayout == 11) {
			print "Width: <input type=text size=4 maxlength=4 name=Width_4 ";
			print "value=$Width_4>\n";
		} else {
			print "<input type=hidden name=Width_4 value=\"$Width_4\">\n";
		}
		print "Height is same as Frame 3&nbsp;&nbsp;";
		print "<input type=hidden name=Height_4 value=\"$Height_4\">\n";
		print "Resizable: <input type=radio name=Resizable_4 value=1";
		if ($Resizable_4 eq "" || $Resizable_4 eq "1") {
			print " checked";
		}
		print " onClick='document.forms[0].Resizable_3[0].checked=true'";
		print "> Yes\n";
		print "<input type=radio name=Resizable_4 value=0";
		if ($Resizable_4 ne "" && $Resizable_4 eq "0") {
			print " checked";
		}
		print " onClick='document.forms[0].Resizable_3[1].checked=true'";
		print "> No\n";
		print "</td></tr>\n";
	} else {
		print "<input type=hidden name=C_Frame_4 value=\"$C_Frame_4\">\n";
		print "<input type=hidden name=Width_4 value=\"$Width_4\">\n";
		print "<input type=hidden name=Height_4 value=\"$Height_4\">\n";
		print "<input type=hidden name=Resizable_4 value=\"$Resizable_4\">\n";
	}
	
	print "<tr><td bgcolor=$FTheaderback colspan=2>";
	print "<img src=$ImgSrcClearDot width=20 height=1>";
	print "</td></tr>\n";
	
	print "</table>\n</td></tr>\n\n";
	
	if ($C_FrameLayout > 0) {
		print "<tr><td colspan=2 nowrap>", $FontFace, $FontSize;
		print "<table border=0 cellpadding=0 cellspacing=2>\n";
		print "<tr><td nowrap>", $FontFace, $FontSize;
		print "Frame Border (applies to all frames)&nbsp;</td>\n";
		print "<td nowrap>", $FontFace, $FontSize;
		print "<select name=C_FrameBorder>\n";
		for ($i=1; $i <= 5; $i++) {
			print "<option value=$i";
			if ($C_FrameBorder ne "" && $C_FrameBorder eq $i) {
				print " selected";
			} elsif ($C_FrameBorder eq "" && $i == 3) {
				print " selected";
			}
			print "> $i\n";
		}
		print "</select>";
		print "</td></tr>\n";
		
		print "<tr><td nowrap>", $FontFace, $FontSize;
		print "Frame Border Color (applies to all frames)&nbsp;</td>\n";
		print "<td nowrap>", $FontFace, $FontSize;
		print "<input type=text name=C_BorderColor size=8 maxlength=7 ";
		print "value=\"";
		if ($C_BorderColor ne "") {
			print $C_BorderColor;
		} else {
			print "#FFFFFF";
		}
		print "\">";
		print "</td></tr>\n";
		print "</table>\n";
		
		print "</td></tr>\n\n";
		
		print "<tr><td colspan=2 nowrap>", $FontFace, $FontSize, $FontRed;
		print $ImgClear88, $ImgClear88;
		print "Note:</font> A border of at least 1 is required to make ";
		print "the Forum frames resizable.\n";
		print "</td></tr>\n";
		
		print "<tr><td colspan=2 nowrap>", $FontFace, $FontSize, $FontRed;
		print $ImgClear88, $ImgClear88;
		print "Note: </font>";
		print "Border must be 5 for border color to work in Internet Explorer.";
		print "</td></tr>\n";
	}
	
	print "<tr><td bgcolor=$FTheaderback colspan=2>";
	print "<img src=$ImgSrcClearDot width=20 height=2>";
	print "</td></tr>\n";
	
	print "<tr><td colspan=2>", $FontFace, $FontSize;
	if ($Demo) {
		print $BtnFormSubmitDemo;
	} else {
		print $BtnFormSubmit;
	}
	print "<a href=\"javascript:nada()\" onClick=layoutPreview()>";
	print $BtnFormPreview;
	print "</a>";
	print "</td></tr>\n";
	
	print "</table>\n";
	
	print "</td></tr>\n";
	print "</table>\n";
	
	print "<input type=hidden name=fid value=$Class>\n";
	print "<input type=hidden name=func value=save>\n";
	print "<input type=hidden name=C_FrameLayout value=$C_FrameLayout>";
	
	print "</form>\n";
	print "</body></html>\n";

} else {
	# Print a Frameset

	# print $CGIQuery->header(-expires=>'-1d');
	print $CGIQuery->header;
	print "<html><head><title>$Class Forum Layout Options</title>\n";
	&printJavascript;
	print "</head>\n";
	print "<frameset rows='210,*' border=2>\n";
	print "	<frame name=layouts src=$CGIEnvScript?fid=$Class&func=menu ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "	<frame name=sources src=$CGIEnvScript?fid=$Class&func=sources ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "</frameset>\n";
}

sub saveLayout {
	if (!$isLite) {
		$C_FrameLayout = $CGIQuery->param('C_FrameLayout');
		$C_FrameBorder = $CGIQuery->param('C_FrameBorder');
		$C_BorderColor = $CGIQuery->param('C_BorderColor');
	
		$C_Frame_1 = $CGIQuery->param('C_Frame_1');
		$C_Frame_2 = $CGIQuery->param('C_Frame_2');
		$C_Frame_3 = $CGIQuery->param('C_Frame_3');
		$C_Frame_4 = $CGIQuery->param('C_Frame_4');
	
		$Resizable_1 = $CGIQuery->param('Resizable_1');
		$Resizable_2 = $CGIQuery->param('Resizable_2');
		$Resizable_3 = $CGIQuery->param('Resizable_3');
		$Resizable_4 = $CGIQuery->param('Resizable_4');
	
		$Width_1 = $CGIQuery->param('Width_1');
		$Height_1 = $CGIQuery->param('Height_1');
		$Width_2 = $CGIQuery->param('Width_2');
		$Height_2 = $CGIQuery->param('Height_2');
		$Width_3 = $CGIQuery->param('Width_3');
		$Height_3 = $CGIQuery->param('Height_3');
		$Width_4 = $CGIQuery->param('Width_4');
		$Height_4 = $CGIQuery->param('Height_4');
	
		# Create tab delimited fields
		$F1 = $C_Frame_1 . "\\t" . $Width_1 . "\\t" . $Height_1 . "\\t" . $Resizable_1;
		$F2 = $C_Frame_2 . "\\t" . $Width_2 . "\\t" . $Height_2 . "\\t" . $Resizable_2;
		$F3 = $C_Frame_3 . "\\t" . $Width_3 . "\\t" . $Height_3 . "\\t" . $Resizable_3;
		$F4 = $C_Frame_4 . "\\t" . $Width_4 . "\\t" . $Height_4 . "\\t" . $Resizable_4;
	
		# Create a big string to put in the class database
		$putstring = "C_FrameLayout\t" . $C_FrameLayout . "\n";
		$putstring .= "C_FrameBorder\t" . $C_FrameBorder . "\n";
		$putstring .= "C_BorderColor\t" . $C_BorderColor . "\n";
		$putstring .= "C_FrameDefs_1\t" . $F1 . "\n";
		$putstring .= "C_FrameDefs_2\t" . $F2 . "\n";
		$putstring .= "C_FrameDefs_3\t" . $F3 . "\n";
		$putstring .= "C_FrameDefs_4\t" . $F4 . "\n";
	
		# Turn on signal Handling
		$trapSignals = 1;
	
		# Commit changes to the database.
		$dbfile = $C_rootpath . "/" . $DIR_CONFIG . "/" . $DBFILE_CLASSINFO;
		if (! open (p, "| $setDB $dbfile -thash -q -a")) {
			&showErrorBackHTML("$status<p>Unable to write to $dbfile. Check file permissions and try again.", 1);
			exit();
		}
		print p $putstring;
		close(p);
	
		# If we got a signal, exit here.
		if ($gotSignal) {
			close(DEVNULL);
			exit(0);
		}
	
		# Show success page
		&showHeaderBackHTML("$CorF modification successful");
		
		print "Your new layout will now appear in the Forum.";

	} else {
		&showHeaderBackHTML("No changes made");
		
		print "<p><center><table border=1 cellpadding=2 cellspacing=0>\n";
		print "<tr><td bgcolor=#CCCCCC>", $FontFace, $FontSize;
		print $FontRed, "Note:</font> ";
		print "The frame configuration can not be changed in the Lite ";
		print "version of panFora. To customize the frame layout, upgrade ";
		print "your license at <a href=http://www.withinc.com target=_blank>";
		print "http://www.withinc.com</a>.</td></tr></table>\n</center><p>";
		
		print "Your configuration was not saved.";
	}
	print "</body></html>";
}
