<?xml version='1.0' encoding='UTF-8' ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" indent="yes" encoding="UTF-8"/>
<xsl:template match="/">
    <html>
    <head>
    <title><xsl:value-of select="/index/metaData/field[@name='movieIndex']/@label"/></title>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <link rel="stylesheet" type="text/css" href="{/movies/settings/paths/css}movieInfo.css" title="none" />
    </head>
    <body>        
        <xsl:call-template name="movieList"/>
    </body>
    </html>
</xsl:template>




<xsl:template name="movieList" match="index">
        <table class="" cellpadding="0" cellspacing="2" border="0">
        <tbody>
			<tr>
    			<td class="tableTitleIndex">					
					<xsl:value-of select="/index/metaData/field[@name='originalTitle']/@label"/>
					<xsl:text>&#160;&#160;&#160;</xsl:text>					
    	    	</td>	    	
	    		<td class="tableTitleIndex">
					<xsl:text>&#160;&#160;&#160;</xsl:text>
					<xsl:value-of select="/index/metaData/field[@name='releaseYear']/@label"/>
					<xsl:text>&#160;&#160;&#160;</xsl:text>
				</td>
				<td class="tableTitleIndex">
					<xsl:text>&#160;&#160;&#160;</xsl:text>
					<xsl:value-of select="/index/metaData/field[@name='IMDbURL']/@label"/>
					<xsl:text>&#160;&#160;&#160;</xsl:text>
    	    	</td>
			</tr>
			<xsl:for-each select="/index/movie">
				<xsl:sort select="title"/>
				<tr>
					<xsl:call-template name="title"/>
					<xsl:call-template name="year"/>
					<xsl:call-template name="imdbNo"/>
				</tr>
			</xsl:for-each>            
        </tbody>
        </table>
        <br />
</xsl:template>

<xsl:template name="imdbNo" match="imdbNo">
	<xsl:choose>    
		<xsl:when test="imdbNo!=''">
	    	<td class="label" style="text-align:center;">    	        
				<a target="_blank" href="{../metaData/field[@name='IMDbUrlBeg']/@label}{imdbNo}"><xsl:value-of select="../metaData/field[@name='IMDbURL']/@label"/></a>
        	</td>
		</xsl:when>			
		<xsl:otherwise>
    		<td class="label">            
        	</td>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="title" match="title">
	<xsl:choose>    
		<xsl:when test="title!=''">
    	<td class="label">
				<xsl:text>&#160;&#160;</xsl:text>
            	<a href="./files/{linkFile}"><xsl:value-of select="title"/></a>
				<xsl:text>&#160;&#160;&#160;</xsl:text>
        	</td>
		</xsl:when>
		<xsl:otherwise>
    		<td class="label">            
        	</td>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="year" match="releaseYear">
	<xsl:choose>    
		<xsl:when test="releaseYear!=''">
	    	<td class="label" style="text-align:center;">
    	        <xsl:value-of select="releaseYear"/>
        	</td>
		</xsl:when>
		<xsl:otherwise>
    		<td class="label">            
        	</td>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

</xsl:stylesheet>
