/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//	NODE.H						(c)	YoY'99						WEB: www.aestesis.org
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef							_NODE_H_
#define							_NODE_H_
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include						<windows.h>
#include						"types.h"
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//	If you use directly the variables in the class API, it's at your own risks. Prefer the methods...   

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

ADLL extern char				*Alasterror;

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class Aproperties
{
public:
	qword						guid;
	int							offset;
	char						*name;
	char						*design;
};

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class ACI
{
public:
	class ACI					*inherited;
	char						*name;
	qword						guid;
	int							nproperties;
	class Aproperties			*properties;
	class ACI					*next;

	ADLL 						ACI(char *name, qword guid, ACI *inherited, int np, class Aproperties *p);
	ADLL virtual				~ACI();
};

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

ADLL extern ACI					*aciList;

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class Anode
{
public:

	enum
	{
								stateTOP						= (1<<00),
								stateENABLE						= (1<<01),
								stateCOLAPSED					= (1<<02),
								stateLAST						= (1<<03) 
	};


	ADLL static ACI				CI;
	virtual ACI					*getCI							()						{ return &CI; }

	char						*name;

	Anode						*father;
	Anode						*next;
	Anode						*prev;
	Anode						*fchild;
	Anode						*lchild;

	dword						state;

	ADLL						Anode							(char *name=NULL, Anode *father=NULL);
	ADLL virtual				~Anode							();

	virtual bool				notify							(Anode *o, int event, dword p=0);
	ADLL void					asyncNotify						(Anode *o, int event, dword p=0);

	ADLL bool					is								(char *name);
	ADLL bool					isCI							(ACI *CI);
	ADLL bool					isGUID							(qword guid);

	ADLL int					count							();

	// private

	ADLL virtual void			add								(Anode *o);
	ADLL virtual void			del								(Anode *o);

};

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

__inline bool Anode::notify(Anode *o, int event, dword p)
{
	if(father)
		return ((event&0xf000)==0xa000)?father->notify(o, event, p):FALSE;
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// notify

enum
{
								nyNOTHING						=0x0000,
								nyNOTIFY,

								nyCLICK							=0x0010,
								nyDBLCKICK,
								nyCHECK,
								nyCLOSE,
								nyCHANGE,
								nyOK,
								nyCANCEL,
								nyRESET,
								nySELECT,
								nyPRESS,
								nyRELEASE,

								nyUSER1							=0x1000,
								nyUSER2							=0x2000,
								nyUSER3							=0x3000,
								nyUSER4							=0x4000,
								nyUSER5							=0x5000,
								nyUSER6							=0x6000,
								nyUSER7							=0x7000,
								nyUSER8							=0x8000,
								nyUSER9							=0x9000,

								nyTHRUMESSAGE					=0xA000,
								nySTATUS						=0xA500,	// send message to status bar 
								nyTOOLTIPS,									// send message to help bar or tooltips
								nyALERT,									// idem (just different level)
								nyWARNING,									// idem (just different level)
								nyERROR,									// idem (just different level)
								nyCONTEXT									// context menu
};

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif							//_NODE_H_
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
